/*
    filename :  ioputbuf.c

COPYRIGHT (c) 1989, 1990, 1991  Matrox Electronic Systems Ltd.
All Rights Reserved

*/

#include "imseries.h"
#include "imbind.h"
#include "proto.h"

extern  I_IMGLOB    i_glob;

/*/     Function:   ioputbuf()
*       Synopsis:   This routine writes a buffer to the FIFO.
*       Date:       January 23rd 1990
*       param:      --- none ---
*                                               
*       returns:    no return value
**/

#ifdef  ANSI
void FTYPE ioputbuf( short _I_PTYPE *buffer, unsigned short nwords )
#else
FTYPE ioputbuf( buffer, nwords )
short _I_PTYPE *buffer, nwords;
#endif
{
#ifdef  I_UNIX

    I_IOBUF iobuf;

    iobuf.buffer = buffer;
    iobuf.nwords = nwords;

    ioctl(i_glob.board, IMG_WRITE, &iobuf);

#endif

#ifdef  I_MS_DOS

    register unsigned short free_space;

#ifdef PHAR_LAP
    _far short *fifobase;
#else
    short far *fifobase;
#endif

    fifobase = i_glob.imghra -> wrfifo;

    do
        {

        /* Evaluate the amount that can readily be send.   */

        free_space = WRITE_FIFO_SIZE - IOwrite_count;

/*      if ( free_space < 0 ) free_space = 0; */ 


        /* Put as many as possible, up to a maximum of nwords. */

        free_space = ( free_space < nwords ) ? free_space : nwords;


        /* Keep track of the amount being send. */

        nwords -= free_space;


        /* Transmit words to FIFO.   */

        while ( free_space-- )
            *fifobase = *buffer++;

        }
    while ( nwords );   /* Loop until all done.   */

#endif

#ifdef  I_OS2

  unsigned short num;
  PUSHORT pnum = &num;
  num = nwords;

  DosDevIOCtl( (PUSHORT) buffer,
               (PUSHORT) pnum,
               (USHORT)  I_WRITE_BUF_FIFO,
               (USHORT)  0x80,
               (HFILE)   i_glob.board );
#endif

}   /* ioputbuf()   */
