/*/  Function name:   sctxbstring
*
*    Note:  Values returned in the read fifo depend on the selected string
*           drawing mode.
*
*    Author:   Jean Dupre
*    Date:     March 15, 1988
*
*    Modification history:
*M      PG,   90.10.25, char should be unsigned.
*
*    Calls:  ioputbuf:  send a buffer of words to the board.
*            ioputtxt:  send a text string to the board.
*
*    Uses:  None
*
*    Return value:   None
*/

#include <string.h>
#include <stdio.h>
#include "imseries.h"
#include "imbind.h"
#include "proto.h"

IMPORT  short  buff[];
IMPORT  short  *ptrbuff;

#ifdef ANSI
void FTYPE sctxbstring(short x, short y, unsigned char _I_PTYPE *strptr)
#else
FTYPE sctxbstring(x, y, strptr)
short  x, y;
unsigned char  _I_PTYPE *strptr;
#endif

{
	unsigned short n, length = strlen((char _I_PTYPE *)strptr);

	/* set buffer for parameters */
	ptrbuff = buff;

	*ptrbuff++ = 0x0072;
	*ptrbuff++ = x;
	*ptrbuff++ = y;
	*ptrbuff++ = length;

	if (length > ( CBUFFLENGTH - 4 ))
		{
#ifndef  I_NOPRINTF
# ifdef I_INTEL		/* fprintf buggy under INTEL Vr4 */
		printf("sctxbstr error : string too long.\n");
# else
		fprintf( stderr, "sctxbstr error : string too long.\n");
# endif /* I_INTEL    */
#else	  /* !I_NOPRINTF */
		  ;
#endif  /* I_NOPRINTF */
		return;
		}

	n = length + 4;

	while (length--)
		{
		*ptrbuff++ = (unsigned char) *strptr++;
		}

	ioputbuf(buff, n);
	return;

} /* sctxbstring() */
