/*****************************************************************************
*
*  REGTYPE.H
*
*  Copyright (C) 1989 Matrox Electronic Systems, Ltd.
*  All rights reserved.
*
*  Register map define by VG_STRUCTREG structure type. This map is very
*  usefull to access register and field without bit handling.
*  VG_REGACCESS is an union for multiple register access according to direct
*  VG_STRUCTREG structure access or by using a VG_UBYTE, VG_UWORD or VG_ULONG array.
*
*****************************************************************************/

/* Note: The following structure MUST be PACKED.. */

/*****************************************************************************
*
*     Register map define by VG_STRUCTREG structure type.
*
*****************************************************************************/

typedef struct
   {

   VG_APIXEL in_vdo_mask;              /* Video input mask */
   VG_APIXEL out_vdo_mask;             /* Video output mask */
   VG_APIXEL cpu_wr_mask;              /* CPU write mask (memory protect) */
   VG_APIXEL grab_mask;                /* Grab mask (memory protect) */
   VG_APIXEL cpu_rd_mask;              /* CPU read mask */
   VG_APIXEL key_mask;                 /* Compare mask for keying */
   VG_APIXEL key_color;                /* Compare color for keying */
   VG_APIXEL preset_color;             /* Preset color */
   VG_APIXEL border_color;             /* Border color */

   union                            /* Special for TURBO C */
      {
      struct
         {
         VG_BFIELD key_type:2;         /* Compare type selection for keying */
         VG_BFIELD key_out:1;          /* Output selection for keying */
         VG_BFIELD key_comp:1;         /* Source compare selection for keying */
         VG_BFIELD disp_mode:2;        /* Display mode selection */
         VG_BFIELD border_en:1;        /* Border enable */
         VG_BFIELD tg_disp_en:1;       /* TARGA enable for display */
         VG_UBYTE byte_1;              /* Not used byte 1 */
         VG_UBYTE byte_2;              /* Not used byte 2 */
         VG_UBYTE byte_3;              /* Not used byte 3 */
         } field;
      struct
         {
         VG_UBYTE byte_0;              /* byte 0 */
         VG_UBYTE byte_1;              /* Not used byte 1 */
         VG_UBYTE byte_2;              /* Not used byte 2 */
         VG_UBYTE byte_3;              /* Not used byte 3 */
         } reg;
      } ctrl_1;                     /* VSDP control 1 */

   struct
      {
      VG_BFIELD mono_mode_en:1;        /* Monochrome mode enable */
      VG_BFIELD n_u_1:1;               /* Not used bit 1 */
      VG_BFIELD vsdp_version:2;        /* VSDP chip version */
      VG_BFIELD vsdp_IP_type:2;      /* IP type (8, 16, 24, 32) */
      VG_BFIELD vsdp_pos:2;            /* VSDP position on IP board */
      VG_UBYTE n_u_byte_1;             /* Not used byte 1 */
      VG_UBYTE n_u_byte_2;             /* Not used byte 2 */
      VG_UBYTE n_u_byte_3;             /* Not used byte 3 */
      } ctrl_2;                     /* VSDP control 2 */

   struct
      {
      VG_BFIELD test_plane_sel:4;      /* Test plane selection */
      VG_BFIELD test_crc_sel:2;        /* Test register part selection */
      VG_BFIELD test_corr_en:1;        /* Correction for test bit */
      VG_BFIELD test_str:1;            /* Test starter */
      VG_UBYTE n_u_byte_1;             /* Not used byte 1 */
      VG_UBYTE n_u_byte_2;             /* Not used byte 2 */
      VG_UBYTE n_u_byte_3;             /* Not used byte 3 */
      } test;                       /* CRC test register */

   struct
      {
      VG_BFIELD n_u_0_3:4;             /* Not used bit 0 to 3 */
      VG_BFIELD vsdp_tg_disp_mode:2;   /* Duplicate value in VSDP for TARGA
                                     * display mode */
      VG_BFIELD n_u_6_7:2;             /* Not used bit 6 and 7 */
      VG_UBYTE n_u_byte_1;             /* Not used byte 1 */
      VG_UBYTE n_u_byte_2;             /* Not used byte 2 */
      VG_UBYTE n_u_byte_3;             /* Not used byte 3 */
      } vsdp_tg_mode_2;             /* Duplicate value of TG_MODE_2 */

   struct
      {
      VG_BFIELD delay_ctrl:4;          /* Delay control line */
      VG_BFIELD n_u_4_7:4;             /* Not used bit 4 to 7 */
      VG_UBYTE n_u_byte_1;             /* Not used byte 1 */
      VG_UBYTE n_u_byte_2;             /* Not used byte 2 */
      VG_UBYTE n_u_byte_3;             /* Not used byte 3 */
      } delay;                      /* Delay register for VSDP */

   VG_UBYTE vsdp_n_u_1[5];             /* Not use */
   VG_UBYTE bios_res;                  /* BIOS CRT resolution mode */
   VG_UBYTE vsdp_n_u_2[2];             /* Not use */

   VG_UBYTE ramdac_0_ram_wr;           /* RAMDAC 0 address register RAM write */
   VG_UBYTE ramdac_0_ram;              /* RAMDAC 0 color palette RAM */
   VG_UBYTE ramdac_0_rd_mask;          /* RAMDAC 0 pixel read mask register */
   VG_UBYTE ramdac_0_ram_rd;           /* RAMDAC 0 address register RAM read */
   VG_UBYTE ramdac_0_overlay_wr;       /* RAMDAC 0 address register OVERLAY
                                     * write */
   VG_UBYTE ramdac_0_overlay;          /* RAMDAC 0 OVERLAY register */
   VG_UBYTE ramdac_0_n_u;              /* Not use */
   VG_UBYTE ramdac_0_overlay_rd;       /* RAMDAC 0 address register OVERLAY
                                     * read */
   VG_UBYTE ramdac_1_ram_wr;           /* RAMDAC 1 address register RAM write */
   VG_UBYTE ramdac_1_ram;              /* RAMDAC 1 color palette RAM */
   VG_UBYTE ramdac_1_rd_mask;          /* RAMDAC 1 pixel read mask register */
   VG_UBYTE ramdac_1_ram_rd;           /* RAMDAC 1 address register RAM read */
   VG_UBYTE ramdac_1_overlay_wr;       /* RAMDAC 1 address register OVERLAY
                                     * write */
   VG_UBYTE ramdac_1_overlay;          /* RAMDAC 1 OVERLAY register */
   VG_UBYTE ramdac_1_n_u;              /* Not use */
   VG_UBYTE ramdac_1_overlay_rd;       /* RAMDAC 1 address register OVERLAY
                                     * read */

#ifdef IP
   VG_UBYTE adc_1_add;                 /* Video digitizer (one channel)
                                     * address register */
#endif

#ifdef ILUM
   struct
      {
      VG_BFIELD n_u_0_1:2;             /* Not used bit 0 and 1 */
      VG_BFIELD colmode:2;             /* Color mode */
      VG_BFIELD n_u_4_6:3;             /* Not used bit 4 to 6 */
      VG_BFIELD inpsel:1;              /* Input select */
      } adc_3_command;              /* Video digitizer (triple channel)
                                     * address register */
#endif

#ifdef IP
   VG_UBYTE adc_1_ram;                 /* Video digitizer (one channel) ram
                                     * register */
#endif

#ifdef ILUM
   VG_UBYTE offset_16;                 /* Video digitiser offset for
                                     * ILUM 16 */
#endif

#ifdef IP

   union
      {
      struct
         {
         VG_BFIELD n_u_0_3:4;          /* Not used bit 0 to 3 */
         VG_BFIELD sync_source:2;      /* Sync source select */
         VG_BFIELD video_source:2;     /* Video source select */
         } adc_1_command;           /* Video digitizer (one channel)
                                     * command register */
      struct
         {
         VG_BFIELD n_u_0_1:2;          /* Not used bit 0 and 1 */
         VG_BFIELD offset_8:6;         /* Video digitizer offset for IP */
         } adc_1_offset;            /* Video digitizer (one channel)
                                     * offset register */
      struct
         {
         VG_BFIELD n_u_0_1:2;          /* Not used bit 0 and 1 */
         VG_BFIELD gain_8:6;           /* Video digitizer gain for IP */
         } adc_1_gain;              /* Video digitizer (one channel) gain
                                     * register */
   } adc_2;

#endif

#ifdef ILUM
   VG_UBYTE gain_16;                   /* Video digitizer gain for
                                     * ILUM 16 */
#endif

   VG_UBYTE adc_3_green_pos;           /* Video digitizer (triple channel)
                                     * green REF+ data register */
   VG_UBYTE adc_3_green_neg;           /* Video digitizer (triple channel)
                                     * green REF- data register */
   VG_UBYTE adc_3_blue_pos;            /* Video digitizer (triple channel)
                                     * blue REF+ data register */
   VG_UBYTE fade_16;                   /* Video digitizer fade to black for
                                     * ILUM 16 */
   VG_UBYTE adc_n_u;                   /* Not use */

   struct
      {
      VG_BFIELD n_u_0:1;               /* Not used bit 0 */
      VG_BFIELD contrast:5;            /* Contrast adjustement value */
      VG_BFIELD in_format:1;           /* Select composite or RGB input */
      VG_BFIELD n_u_7:1;               /* Not used bit 7 */
      } vdo_ctrl;                   /* Video control register (TARGA
                                     * compatible) */
#ifdef ILUM
   VG_UBYTE tg_dr_wr;                  /* Write value in TARGA DR register */

   struct
      {
      VG_BFIELD hue:5;                 /* Hue adjustement value */
      VG_BFIELD sat:3;                 /* Saturation adjustement value */
      } hue_sat;                    /* Hue and saturation adjustment */
#endif

#ifdef IP
   struct
      {
      VG_BFIELD n_u_0:1;               /* Not used bit 0 */
      VG_BFIELD vga_clk_inv:1;         /* VGA clock inverse */
      VG_BFIELD n_u_2:1;               /* Not used bit 2 */
      VG_BFIELD overscan:1;            /* Overscan requested */
      VG_BFIELD n_u_4:1;               /* Not used bit 4 */
      VG_BFIELD genlock:1;             /* Genlock requested */
      VG_BFIELD sgle_screen:1;         /* Single screen solution flag */
      VG_BFIELD n_u_7:1;               /* Not used bit 7 */
      } mr_ip_flags;                /* Memory register for ip_flags */

   VG_UBYTE   mr_video_mode;           /* Memory register for video_mode */
#endif

   VG_UBYTE tg_disp_pos_y;             /* TARGA vertical memory display
                                     * position */
   union
      {
      struct
         {
         VG_BFIELD tg_acs_buf_en:1;    /* TARGA frame buffer enable */
         VG_BFIELD n_u_1:1;            /* Not used bit 1 */
         VG_BFIELD tg_field_sel:1;     /* TARGA field select bit */
         VG_BFIELD screen_sel:3;       /* TARGA screen select */
         VG_BFIELD tg_dr_wr_mode:1;    /* Write mode select for DR TARGA
                                     * register */
         VG_BFIELD tg_dr_high_bit:1;   /* Bit 9 value */
         } tg_mode_1;               /* TARGA mode 1 register */
      VG_UBYTE line_count;             /* Line counter */
      } tg_c00;                     /* TARGA offset 0C00 register */

   struct
      {
      VG_BFIELD tg_tap_bit:2;          /* TARGA tap bit for horizontal
                                     * display position */
      VG_BFIELD tg_zoom:2;             /* TARGA zoom factor */
      VG_BFIELD tg_disp_mode:2;        /* TARGA display mode (repeat value in
                                     * VSDP) */
      VG_BFIELD tg_grab:1;             /* TARGA grab activation */
      VG_BFIELD genlock:1;             /* TARGA genlock selection */
      } tg_mode_2;                  /* TARGA mode 2 register */

   struct
      {
      VG_BFIELD field_st:1;            /* Field status (odd or even) */
      VG_BFIELD src_st:1;              /* Video source status */
      VG_BFIELD h_blank_st:1;          /* Horizontal BLANK status */
      VG_BFIELD v_blank_st:1;          /* Vertical BLANK status */
      VG_BFIELD v_sync_st:1;           /* Vertical SYNC status */
      VG_BFIELD v_count:3;             /* Vertical counter */
      } tg_status;                  /* TARGA status register */

   VG_UBYTE tg_n_u;                    /* Not use */

   VG_UWORD   IP_pos_id;             /* POS identification for IP product */

   struct
      {
      VG_BFIELD card_en:1;             /* Card enable */
      VG_BFIELD bios_base:3;           /* BIOS base address */
      VG_BFIELD io_base:4;             /* I/O register base address */
      } IP_base;                  /* IP base address register */

#ifdef ILUM
   struct
      {
      VG_BFIELD io_reg_en:1;           /* I/O register enable */
      VG_BFIELD acs_buf_en:1;          /* Frame buffer enable */
      VG_BFIELD ramdac_0_en:1;         /* RAMDAC 0 enable */
      VG_BFIELD tg_rd_en:1;            /* TARGA read access enable */
      VG_BFIELD y_axle_dir:1;          /* Y axle direction */
      VG_BFIELD rom_wr_protect_dis:1;  /* ROM BIOS write protect disable */
      VG_BFIELD int_sel:2;             /* Interrupt select */
      } IP_access;                /* IP access register */
#endif

#ifdef IP
   struct
      {
      VG_BFIELD io_reg_en:1;           /* I/O register enable */
      VG_BFIELD acs_buf_en:1;          /* Frame buffer enable */
      VG_BFIELD ramdac_0_en:1;         /* RAMDAC 0 enable */
      VG_BFIELD tg_rd_en:1;            /* TARGA read access enable */
      VG_BFIELD y_axle_dir:1;          /* Y axle direction */
      VG_BFIELD rom_wr_protect_dis:1;  /* ROM BIOS write protect disable */
      VG_BFIELD mr_int_sel:2;          /* Memory register for interrupt select */
      } IP_access;                /* IP access register */
#endif

   struct
      {
      VG_BFIELD acs_buf_size:2;        /* Frame buffer size */
      VG_BFIELD acs_buf_add:5;         /* Frame buffer address */
      VG_BFIELD acs_buf_map:1;         /* Frame buffer map */
      } acs_buf_def;                /* Frame buffer definition register */

   struct
      {
      VG_BFIELD mem_16l_en:1;          /* Memory 16 bit access enable */
      VG_BFIELD mem_16h_en:1;          /* Memory 16 bit access enable over
                                     * than 1 Mb */
      VG_BFIELD n_u_2_7:6;             /* Not used bit 2 to 7 */
      } bus_ctrl;                   /* Bus control register */

   struct
      {
      VG_BFIELD frm_buf_size:3;        /* Memory size */
      VG_BFIELD IP_type:2;           /* IP product type */
      VG_BFIELD vic_version:2;         /* VIC release version */
      VG_BFIELD vsdp_sel:1;            /* VSDP selection (IP 32 only) */
      } IP_desc;                  /* IP description register */

   struct
      {
      VG_BFIELD int_v_blank_st:1;      /* Vertical BLANK interrupt status bit */
      VG_BFIELD int_tg_reg_st:1;       /* TARGA register interrupt status bit */
      VG_BFIELD int_tg_low_st:1;       /* TARGA register (low byte) interrupt
                                     * status bit */
      VG_BFIELD int_tg_high_st:1;      /* TARGA register (high byte)
                                     * interrupt status bit */
      VG_BFIELD grab_st:1;             /* Grab status */
      VG_BFIELD cont_grab_st:1;        /* Continous grab status */
      VG_BFIELD n_u_6_7:2;             /* Not used bit 6 and 7 */
      } status;                     /* VIC status register */

   VG_UBYTE int_tg_data_0;             /* TARGA register (low byte) value
                                     * catch by interrupt */
   VG_UBYTE int_tg_data_1;             /* TARGA register (high byte) value
                                     * catch by interrupt */
   struct
      {
      VG_BFIELD int_tg_add:7;          /* TARGA address interrupt source */
      VG_BFIELD int_tg_rd_wr:1;        /* TARGA R/W status interrupt source */
      } int_src;                    /* TARGA interrupt source register */

   struct
      {
      VG_BFIELD int_v_blank_en:1;      /* Vertical blank interrupt enable */
      VG_BFIELD int_tg_dr_en:1;        /* TARGA display register enable */
      VG_BFIELD int_tg_reg_0_en:1;     /* TARGA register 000H to 003H
                                     * interrupt enable */
      VG_BFIELD int_tg_reg_4_en:1;     /* TARGA register 400H to 403H
                                     * interrupt enable */
      VG_BFIELD int_tg_reg_8_en:1;     /* TARGA register 800H to 803H
                                     * interrupt enable */
      VG_BFIELD int_tg_reg_c_en:1;     /* TARGA register C00H to C03H
                                     * interrupt enable */
      VG_BFIELD n_u_6_7:2;             /* Not used bit 6 and 7 */
      } int_ctrl;                   /* Interrupt control register */

   VG_UBYTE int_n_u[4];                /* Not use */

#ifdef IP
   struct
      {
      VG_BFIELD interlace_conv_dis:1;  /* Interlace conversion disable */
      VG_BFIELD vga_master_dis:1;      /* VGA master disable */
      VG_BFIELD video_source:2;        /* Video source select */
      VG_BFIELD vic_clk_sel:1;         /* VIC clock select */
      VG_BFIELD vga_black:1;           /* VGA output black */
      VG_BFIELD vga_fade_en:1;         /* VGA fade enable */
      VG_BFIELD hi_res:1;              /* Bloc signal disable */
      } IP_ctrl_0;                /* IP board control 0 */
#endif

#ifdef ILUM
   struct
      {
      VG_BFIELD interlace_conv_dis:1;  /* Interlace conversion disable */
      VG_BFIELD vga_master_dis:1;      /* VGA master disable */
      VG_BFIELD grab_back:1;           /* Grab output back */
      VG_BFIELD in_key_dis:1;          /* Input keying disable */
      VG_BFIELD vic_clk_sel:1;         /* VIC clock select */
      VG_BFIELD vga_black:1;           /* VGA output black */
      VG_BFIELD vga_fade_en:1;         /* VGA fade enable */
      VG_BFIELD hi_res:1;              /* Bloc signal disable */
      } IP_ctrl_0;                /* IP board control 0 */
#endif

#ifdef IP
   struct
      {
      VG_BFIELD eeprom_data_in:1;      /* EEPROM input data */
      VG_BFIELD eeprom_clk:1;          /* EEPROM clock */
      VG_BFIELD eeprom_sel:1;          /* EEPROM access enable */
      VG_BFIELD vga_clk_inv:1;         /* VGA clock inverse enable */
      VG_BFIELD v_wrap:1;              /* Vertical wrap enable */
      VG_BFIELD n_u_5_6:2;             /* Not used bit 5 to 6 */
      VG_BFIELD vcr_sync:1;            /* VCR sync select */
      } IP_ctrl_1;                /* IP board control 1 */
#endif

#ifdef ILUM
   struct
      {
      VG_BFIELD eeprom_data_in:1;      /* EEPROM input data */
      VG_BFIELD eeprom_clk:1;          /* EEPROM clock */
      VG_BFIELD eeprom_sel:1;          /* EEPROM access enable */
      VG_BFIELD vga_clk_inv:1;         /* VGA clock inverse enable */
      VG_BFIELD v_wrap:1;              /* Vertical wrap enable */
      VG_BFIELD n_u_5_6:2;             /* Not used bit 5 to 6 */
      VG_BFIELD tg_grab_en:1;          /* Enable Targa grab */
      } IP_ctrl_1;                /* IP board control 1 */
#endif

#ifdef IP
   struct
      {
      VG_BFIELD IP_key_sel:4;        /* IP input/output keying select */
      VG_BFIELD vga_clk_sel:2;         /* VGA clock select */
      VG_BFIELD color_trap:1;          /* Color trap for IP */
      VG_BFIELD int_en:1;              /* Interrupt enable */
      } IP_ctrl_2;                /* IP board control 2 */
#endif

#ifdef ILUM
   struct
      {
      VG_BFIELD IP_key_sel:4;        /* IP input/output keying select */
      VG_BFIELD vga_clk_sel:2;         /* VGA clock select */
      VG_BFIELD sat_lsb:1;             /* Saturation LSB adjustment */
      VG_BFIELD int_en:1;              /* Interrupt enable */
      } IP_ctrl_2;                /* IP board control 2 */
#endif

#ifdef IP
   union
      {
      struct
         {
         VG_BFIELD rw_bank_sel:1;      /* CPU and grab bank select */
         VG_BFIELD disp_bank_sel:1;    /* Display bank select */
         VG_BFIELD mod_in_0:1;         /* Slow scan camera input 0 */
         VG_BFIELD mod_in_1:1;         /* Slow scan camera input 1 */
         VG_BFIELD n_u_4:1;            /* Not used bit 4 */
         VG_BFIELD sync_dir:1;         /* Composite sync direction control */
         VG_BFIELD grab_clk_dir:1;     /* Grab clock direction control */
         VG_BFIELD s_s_grab_en:1;      /* Slow scan camera grab enable */
         } camera_wr;

      struct
         {
         VG_BFIELD mod_out_0:1;        /* Slow scan camera output 0 */
         VG_BFIELD mod_out_1:1;        /* Slow scan camera output 1 */
         VG_BFIELD n_u_2:1;            /* Not used bit 2 */
         VG_BFIELD vga_clk_inv_rd:1;   /* Read back for VGA clock inverse
                                        * enable */
         VG_BFIELD n_u_4_6:3;          /* Not used bit 4 and 6 */
         VG_BFIELD mod_st:1;           /* Slow scan camera state */
         } camera_rd;
      } IP_ctrl_3;                /* IP board control 3 */
#endif

#ifdef ILUM
      struct
         {
         VG_BFIELD n_u_0:1;            /* not used bit 0 */
         VG_BFIELD vs_st:1;            /* video stablizer state */
         VG_BFIELD mux_sel:1;          /* Multiplexer selector channel 1 or 2 */
         VG_BFIELD still_cam:1;        /* Still video camera */
			VG_BFIELD ire_level:1;        /* Setup level 0 or 7.5 IRE */
         VG_BFIELD n_u_5_7:3;          /* not used bit 5 to 7 */
      } IP_ctrl_3;            		/* IP board control 3 */

#endif

   struct
      {
      VG_BFIELD monitor_type:3;        /* Monitor type identification */
      VG_BFIELD vga_st:1;              /* VGA status */
      VG_BFIELD hi_res_grab_st:1;      /* High resolution grab state */
      VG_BFIELD mem_bank:1;            /* Number of memory bank */
      VG_BFIELD n_u_6:1;               /* Not used bit 6 */
      VG_BFIELD eeprom_data_out:1;     /* EEPROM output data */
      } IP_status_0;              /* IP status register 0 */

   VG_UBYTE IP_status_1;             /* IP status register 1 */
   VG_UBYTE IP_status_2;             /* IP status register 2 */
   VG_UBYTE IP_status_3;             /* IP status register 3 */
   VG_UBYTE IP_n_u_0[2];             /* Not use */

#ifdef IP
   struct
      {
      VG_BFIELD int_sel:2;             /* Interrupt select */
      VG_BFIELD fade_8:6;              /* Video digitizer fade to black for
                                     * IP */
      } fade_ctrl_8;

   VG_UBYTE IP_n_u_1[1];             /* Not use */
#endif

#ifdef ILUM
   VG_UBYTE IP_n_u_1[2];             /* Not use */
#endif

   VG_UBYTE tg_cpu_mask;               /* TARGA CPU mask */
   VG_UBYTE vic_n_u;                   /* Not use */
   VG_UBYTE tg_page_sel_low;           /* TARGA lower page select */
   VG_UBYTE tg_page_sel_up;            /* TARGA upper page select */

   VG_UBYTE IP_ext_area[128];        /* IP extended control area */

   struct
      {
      VG_WFIELD v_sync_str:11;         /* Vertical SYNC start */
      VG_WFIELD n_u_11_15:5;           /* Not use */
      } v_sync_str_16;

   struct
      {
      VG_WFIELD v_sync_end:11;         /* Vertical SYNC end */
      VG_WFIELD n_u_11_15:5;           /* Not use */
      } v_sync_end_16;

   struct
      {
      VG_WFIELD v_blank_str:11;        /* Vertical BLANK start */
      VG_WFIELD n_u_11_15:5;           /* Not use */
      } v_blank_str_16;

   struct
      {
      VG_WFIELD v_blank_end:11;        /* Vertical BLANK end */
      VG_WFIELD n_u_11_15:5;           /* Not use */
      } v_blank_end_16;

   struct
      {
      VG_WFIELD v_act_str:11;          /* Vertical active window start */
      VG_WFIELD n_u_11_15:5;           /* Not use */
      } v_act_str_16;

   struct
      {
      VG_WFIELD v_act_end:11;          /* Vertical active window end */
      VG_WFIELD n_u_11_15:5;           /* Not use */
      } v_act_end_16;

   struct
      {
      VG_WFIELD v_burst_str:11;        /* Vertical BURST start */
      VG_WFIELD n_u_11_15:5;           /* Not use */
      } v_burst_str_16;

   struct
      {
      VG_WFIELD v_burst_end:11;        /* Vertical BURST end */
      VG_WFIELD n_u_11_15:5;           /* Not use */
      } v_burst_end_16;

   struct
      {
      VG_WFIELD u_v_ser_blank:10;      /* Underscan vertical serration BLANK */
      VG_WFIELD n_u_10_15:6;           /* Not use */
      } u_v_ser_blank_16;

   struct
      {
      VG_WFIELD u_v_ser_sync:10;       /* Underscan vertical serration SYNC */
      VG_WFIELD n_u_10_15:6;           /* Not use */
      } u_v_ser_sync_16;

   struct
      {
      VG_WFIELD v_total:11;            /* Vertical total */
      VG_WFIELD n_u_11_15:5;           /* Not use */
      } v_total_16;

   struct
      {
      VG_WFIELD u_h_total:11;          /* Underscan horizontal total */
      VG_WFIELD n_u_11_15:5;           /* Not use */
      } u_h_total_16;

   struct
      {
      VG_WFIELD u_h_sync_str:11;       /* Underscan horizontal SYNC start */
      VG_WFIELD n_u_11_15:5;           /* Not use */
      } u_h_sync_str_16;

   struct
      {
      VG_WFIELD u_h_sync_end:11;       /* Underscan horizontal SYNC end */
      VG_WFIELD n_u_11_15:5;           /* Not use */
      } u_h_sync_end_16;

   struct
      {
      VG_WFIELD u_h_blank_str:11;      /* Underscan horizontal BLANK start */
      VG_WFIELD n_u_11_15:5;           /* Not use */
      } u_h_blank_str_16;

   struct
      {
      VG_WFIELD u_h_blank_end:11;      /* Underscan horizontal BLANK end */
      VG_WFIELD n_u_11_15:5;           /* Not use */
      } u_h_blank_end_16;

   struct
      {
      VG_WFIELD u_h_act_str:11;        /* Underscan horizontal active window
                                     * start */
      VG_WFIELD n_u_11_15:5;           /* Not use */
      } u_h_act_str_16;

   struct
      {                             
      VG_WFIELD u_h_act_end:11;        /* Underscan horizontal active window
                                     * end */
      VG_WFIELD n_u_11_15:5;           /* Not use */
      } u_h_act_end_16;

   struct                           
      {                             
      VG_WFIELD u_h_burst_str:11;      /* Underscan horizontal BURST start */
      VG_WFIELD n_u_11_15:5;           /* Not use */
      } u_h_burst_str_16;

   struct
      {
      VG_WFIELD u_h_burst_end:11;      /* Underscan horizontal BURST end */
      VG_WFIELD n_u_11_15:5;           /* Not use */
      } u_h_burst_end_16;

   VG_UWORD u_n_u[8];                  /* Not use */

   struct
      {
      VG_WFIELD vdo_v_win_str:11;      /* Vertical video keying window start */
      VG_WFIELD n_u_11_15:5;           /* Not use */
      } vdo_v_win_str_16;

   struct
      {
      VG_WFIELD vdo_v_win_end:11;      /* Vertical video keying window end */
      VG_WFIELD n_u_11_15:5;           /* Not use */
      } vdo_v_win_end_16;

   struct
      {
      VG_WFIELD vdo_h_win_str:11;      /* Horizontal video keying window
                                     * start */
      VG_WFIELD n_u_11_15:5;           /* Not use */
      } vdo_h_win_str_16;

   struct
      {
      VG_WFIELD vdo_h_win_end:11;      /* Horizontal video keying window end */
      VG_WFIELD n_u_11_15:5;           /* Not use */
      } vdo_h_win_end_16;

   struct
      {
      VG_WFIELD o_v_ser_blank:10;      /* Overscan vertical serration BLANK */
      VG_WFIELD n_u_10_15:6;           /* Not use */
      } o_v_ser_blank_16;

   struct
      {
      VG_WFIELD o_v_ser_sync:10;       /* Overscan vertical serration SYNC */
      VG_WFIELD n_u_10_15:6;           /* Not use */
      } o_v_ser_sync_16;

   VG_UWORD o_n_u_0;                   /* Not use */

   struct
      {
      VG_WFIELD o_h_total:11;          /* Overscan horizontal total */
      VG_WFIELD n_u_11_15:5;           /* Not use */
      } o_h_total_16;

   struct
      {
      VG_WFIELD o_h_sync_str:11;       /* Overscan horizontal SYNC start */
      VG_WFIELD n_u_11_15:5;           /* Not use */
      } o_h_sync_str_16;

   struct
      {
      VG_WFIELD o_h_sync_end:11;       /* Overscan horizontal SYNC end */
      VG_WFIELD n_u_11_15:5;           /* Not use */
      } o_h_sync_end_16;

   struct
      {
      VG_WFIELD o_h_blank_str:11;      /* Overscan horizontal BLANK start */
      VG_WFIELD n_u_11_15:5;           /* Not use */
      } o_h_blank_str_16;

   struct
      {
      VG_WFIELD o_h_blank_end:11;      /* Overscan horizontal BLANK end */
      VG_WFIELD n_u_11_15:5;           /* Not use */
      } o_h_blank_end_16;

   struct
      {
      VG_WFIELD o_h_act_str:11;        /* Overscan horizontal active window
                                     * start */
      VG_WFIELD n_u_11_15:5;           /* Not use */
      } o_h_act_str_16;

   struct
      {
      VG_WFIELD o_h_act_end:11;        /* Overscan horizontal active window
                                     * end */
      VG_WFIELD n_u_11_15:5;           /* Not use */
      } o_h_act_end_16;

   struct
      {
      VG_WFIELD o_h_burst_str:11;      /* Overscan horizontal BURST start */
      VG_WFIELD n_u_11_15:5;           /* Not use */
      } o_h_burst_str_16;

   struct
      {
      VG_WFIELD o_h_burst_end:11;      /* Overscan horizontal BURST end */
      VG_WFIELD n_u_11_15:5;           /* Not use */
      } o_h_burst_end_16;

   VG_UWORD o_n_u_1[4];                /* Not use */

   struct
      {
      VG_WFIELD h_preset:11;           /* Horizontal preset */
      VG_WFIELD n_u_11_15:5;           /* Not use */
      } h_preset_16;

   struct
      {
      VG_WFIELD v_preset:11;           /* Vertical preset */
      VG_WFIELD n_u_11_15:5;           /* Not use */
      } v_preset_16;


   struct
      {
      VG_WFIELD h_preset_en:1;         /* External horizontal reset selection */
      VG_WFIELD v_preset_en:1;         /* External vertical reset selection */
      VG_WFIELD pclk_div_2:1;          /* Select PCLK or PCLK/2 for CRTC
                                     * section */
      VG_WFIELD interlace_en:1;        /* Set interlace output mode for
                                     * display */
      VG_WFIELD sync_mode:1;           /* Select SYNC mode */
      VG_WFIELD v_sync_pol:1;          /* Vertical SYNC polarity */
      VG_WFIELD h_sync_pol:1;          /* Horizontal SYNC polarity */
      VG_WFIELD composite_sync_pol:1;  /* Composite SYNC polarity */
      VG_WFIELD tg_dr_win_en:1;        /* Enable TARGA DR0 to 3 registers
                                     * instead of U VERT/HORI WIN STR/END */
      VG_WFIELD scan_mode:2;           /* Scan mode selection for memory
                                     * display */
      VG_WFIELD ccir_en:1;             /* CCIR or RS-170A select bit */
      VG_WFIELD serration_en:1;        /* Enable serration pulse */
      VG_WFIELD grab_ni:1;             /* Grab signal select for non-interlace */
      VG_WFIELD sync_dis:1;            /* SYNC disable */
      VG_WFIELD v_sync_sel:1;          /* Vertical SYNC select */
      } crt_ctrl;                   /* CRT control register */

   struct
      {
      VG_BFIELD clk_sel:2;             /* External clock select */
      VG_BFIELD crt_reg_sel:2;         /* CRTC register select */
      VG_BFIELD n_u_4:1;               /* Not use bit 4 */
      VG_BFIELD refresh_sel:1;         /* RAM refresh select */
      VG_BFIELD fast_ram_en:1;         /* Speed access enable for RAM */
      VG_BFIELD n_u_7:1;               /* Not use bit 7 */
      } master_ctrl;                /* Master control register */

   VG_UBYTE crt_n_u[9];                /* Not use */

   VG_UWORD grab_str_x;                /* Horizontal grab start */
   VG_UWORD grab_str_y;                /* Vertical grab start */
   VG_UWORD grab_end_x;                /* Horizontal grab end */
   VG_UWORD grab_end_y;                /* Vertical grab end */

   union
      {
      struct
         {
         VG_WFIELD grab_pos_x:10;      /* Horizontal grab position */
         VG_WFIELD grab_frm_buf_x:1;   /* Horizontal grab position bit 10 */
         VG_WFIELD n_u_11_15:5;        /* Not use */
         } field;
      VG_UWORD reg;
      } grab_pos_x_16;

   union
      {
      struct
         {
         VG_WFIELD grab_pos_y:10;      /* Vertical grab position */
         VG_WFIELD grab_frm_buf_y:1;   /* Vertical grab position bit 10 */
         VG_WFIELD n_u_11_15:5;        /* Not use */
         } field;
      VG_UWORD reg;
      } grab_pos_y_16;

   struct
      {
      VG_WFIELD single_grab:1;         /* Single grab enable */
      VG_WFIELD cont_grab:1;           /* Continuous grab enable */
      VG_WFIELD tg_dr_grab_en:1;       /* Enable TARGA display register for
                                     * grab */
      VG_WFIELD grab_reg_upd:2;        /* Grab register update mode */
      VG_WFIELD jvc_grab_en:1;         /* JVC camera grab enable */
      VG_WFIELD grab_field_mode:2;     /* Grab field mode */
      VG_WFIELD pipe_tg_grab:3;        /* IP pipelining for TARGA grab
                                     * parameter */
      VG_WFIELD internal_grab_inv:1;   /* Internal grab inverter */
      VG_WFIELD n_u_12_15:4;           /* Not use bit 12 to 15 */
      } grab_ctrl;                  /* Grab control register */

   struct
      {
      VG_WFIELD mini_x:3;              /* Horizontal minification factor */
      VG_WFIELD mini_y:3;              /* Vertical minification factor */
      VG_WFIELD grab_color_en:1;       /* Grab fixed color enable */
      VG_WFIELD cpu_color_en:1;        /* CPU fixed color enable */
      VG_WFIELD n_u_8_15:8;            /* Not use bit 8 to 15 */
      } mini;                       /* Minification register */

   struct
      {
      union
         {
         struct
            {
            VG_WFIELD str_x:10;        /* Horizontal window start */
            VG_WFIELD cpu_frm_buf_x:1; /* Horizontal window start bit 10 */
            VG_WFIELD inc_x_extra:3;   /* Extra bit for increment value */
            VG_WFIELD n_u_14_15:2;     /* Not use */
            } field;
         VG_UWORD reg;
         } str_x_16;

      union
         {
         struct
            {
            VG_WFIELD str_y:10;        /* Vertical window start */
            VG_WFIELD cpu_frm_buf_y:1; /* Vartical window start bit 10 */
            VG_WFIELD inc_y_extra:3;   /* Extra bit for increment value */
            VG_WFIELD n_u_14_15:2;     /* Not use */
            } field;
         VG_UWORD reg;
         } str_y_16;

      union
         {
         struct
            {
            VG_WFIELD width:11;        /* Horizontal window width */
            VG_WFIELD inc_rd:1;        /* Increment on read pixel access */
            VG_WFIELD n_u_12_15:4;     /* Not use */
            } field;
         VG_UWORD reg;
         } x;

      union
         {
         struct
            {
            VG_WFIELD height:11;       /* Vertical window width */
            VG_WFIELD inc_wr:1;        /* Increment on write pixel access */
            VG_WFIELD n_u_12_15:4;     /* Not use */
            } field;
         VG_UWORD reg;
         } y;

      VG_UWORD win_n_u[4];             /* Not use */
      } win[2];

   union
      {
      struct
         {
         VG_BFIELD step_x:2;           /* Horizontal step increment select
                                     * (1, 2, 4, 8) */
         VG_BFIELD step_y:2;           /* Vertical step increment select (1,
                                     * 2, 4, 8) */
         VG_BFIELD n_u_4:1;            /* Not use bit 4 */
         VG_BFIELD sign_x:1;           /* Horizontal increment sign select */
         VG_BFIELD sign_y:1;           /* Vertical increment sign select */
         VG_BFIELD master_y:1;         /* Y master on X for increment */
         } field[2];
      VG_UBYTE reg[2];
      } win_ctrl;                   /* Window control register */

   struct
      {
      VG_BFIELD line_buf_width_0:2;    /* Line buffer width */
      VG_BFIELD line_buf_width_1:2;    /* Line buffer width */
      VG_BFIELD acs_buf_type_0:2;      /* Window type select */
      VG_BFIELD acs_buf_type_1:2;      /* Window type select */
      } acs_buf_ctrl;               /* Line buffer control */

   struct
      {
      VG_BFIELD n_u_0:1;               /* Not use bit 0 */
      VG_BFIELD inc_load:1;            /* Enable access for window increment
                                     * register */
      VG_BFIELD vic_test:6;            /* VIC test bits */
      } misc_ctrl;                  /* Miscellaneous control */

   VG_UWORD inc_data;                  /* Window increment write value */

   VG_UBYTE ctrl_n_u[10];              /* Not use */

   VG_UWORD disp_pos_x;                /* Horizontal memory display position */
   VG_UWORD disp_pos_y;                /* Vertical memory display position */

   struct
      {
      VG_WFIELD zoom_x:3;              /* Horizontal zoom factor */
      VG_WFIELD zoom_y:3;              /* Vertical zoom factor */
      VG_WFIELD mosaic_x:2;            /* Horizontal mosaic factor */
      VG_WFIELD mosaic_y:2;            /* Vertical mosaic factor */
      VG_WFIELD zoom_pan_x:3;          /* Horizontal fraction of visible
                                     * pixel when zoom enable */
      VG_WFIELD zoom_pan_y:3;          /* Vertical fraction of visible pixel
                                     * when zoom enable */
      } disp_ctrl;                  /* Display control register */

   struct
      {
      VG_WFIELD tg_mem_disp_en:1;      /* Enable TARGA memory display
                                     * register (zoom, pan, scroll) */
      VG_WFIELD frm_buf_config:2;      /* Frame buffer configuration */
      VG_WFIELD frm_buf_visible:2;     /* Visible frame buffer select */
      VG_WFIELD n_u_5_15:11;           /* Not use bit 5 to 15 */
      } frm_buf_sel;                /* Frame buffer selection */

   VG_UBYTE disp_n_u[8];               /* Not use */

   VG_UBYTE vga_key_color[2];          /* VGA keying color value */
   VG_UBYTE vga_key_mask;              /* VGA compare mask for keying */

   struct
      {
      VG_BFIELD vga_key_0_dis:1;       /* VGA keying color 0 disable */
      VG_BFIELD vga_key_1_dis:1;       /* VGA keying color 1 disable */
      VG_BFIELD vga_inv_key:1;         /* Inverse keying */
      VG_BFIELD n_u_3_7:5;             /* Not use bit 3 to 7 */
      } vga_key_ctrl;               /* VGA keying control */

   VG_UBYTE vga_n_u[12];               /* Not use */

   VG_UBYTE mem_port_0;                /* Memory access register for window 0 */
   VG_UBYTE mem_port_1;                /* Memory access register for window 1 */
   VG_UBYTE end_n_u[46];               /* Not use */

   } VG_STRUCTREG;


/*****************************************************************************
*
*     UNION for multiple register access according to direct structure
*     access or by using directly a VG_UBYTE, VG_UWORD or VG_ULONG array.
*
*****************************************************************************/

typedef union
   {
   VG_STRUCTREG VG_FAR *Struct;
   VG_UBYTE VG_FAR *Byte;
   VG_UWORD VG_FAR *Word;
   VG_ULONG VG_FAR *Long;
   } VG_REGACCESS;
