/*********************************************************************
*
*  VDOTYPES.H
*
*  Copyright (C) 1989 Matrox Electronic Systems, Ltd.
*  All rights reserved.
*
*  This file contains all the pseudo class and pseudo type currently
*  used  in the Matrox Video Graphic group.
*
*********************************************************************/

/*
*  PSEUDO CLASS
*/

#define VG_FAST            register
#define VG_IMPORT          extern
#define VG_GLOBAL
#define VG_LOCAL           static


/*
*  PSEUDO TYPE
*/

#define VG_VOID            void
#define VG_CHAR            char
#define VG_INT             int
#define VG_UINT            unsigned int
#define VG_SHORT           short
#define VG_USHORT          unsigned short
#define VG_LONG            long
#define VG_ULONG           unsigned long
#define VG_FLOAT           float
#define VG_DOUBLE          double

#define VG_BYTE            signed   char
#define VG_UBYTE           unsigned char
#define VG_WORD            short
#define VG_UWORD           unsigned short
#define VG_DWORD           long
#define VG_UDWORD          unsigned long

#define VG_TEXT            char
#define VG_BOOL            unsigned char


/*
*  SYSTEM DATA STATUS
*/

#ifndef TRUE
 #define TRUE            1
#endif

#ifndef FALSE
 #define FALSE           0
#endif

#ifndef YES
 #define YES             1
#endif

#ifndef NO
 #define NO              0
#endif

#ifndef ON
 #define ON              1
#endif

#ifndef OFF
 #define OFF             0
#endif

#ifndef ENABLE
 #define ENABLE          1
#endif

#ifndef DISABLE
 #define DISABLE         0
#endif


/******************************************************************
*
*  Define the specific Compiler switch
*
*******************************************************************/

/*
*  Default compiler defines and switches
*/

#define __MSC__            0x0510
#define VG_NEAR            near
#define VG_FAR             far
#define VG_HUGE            huge
#define VG_BFIELD          VG_UBYTE
#define VG_WFIELD          VG_UWORD

#ifdef __TURBOC__
  #undef  __MSC__
  #undef  VG_BFIELD
  #undef  VG_WFIELD
  #define VG_BFIELD        VG_UWORD
  #define VG_WFIELD        VG_UWORD
#endif

#ifdef __HIGHC__
  #undef  __MSC__
  #undef  VG_NEAR
  #undef  VG_FAR
  #undef  VG_HUGE
  #undef  VG_BFIELD
  #undef  VG_WFIELD
  #define VG_NEAR          _Near
  #define VG_FAR           _Far
  #define VG_HUGE          _Huge
  #define VG_BFIELD        VG_UWORD
  #define VG_WFIELD        VG_UWORD

  #pragma On(Align_members)
#endif

#ifdef _INTELC32_
  #undef  __MSC__
  #undef  VG_NEAR
  #undef  VG_FAR
  #undef  VG_HUGE
  #undef  VG_BFIELD
  #undef  VG_WFIELD
  #define near
  #define VG_NEAR
  #define far
  #define VG_FAR
  #define huge
  #define VG_HUGE
  #define VG_BFIELD        unsigned int
  #define VG_WFIELD        unsigned int
#endif

#ifdef __WATCOMC__
  #undef  __MSC__
  #undef  VG_NEAR
  #undef  VG_FAR
  #undef  VG_HUGE
  #define VG_NEAR
  #define VG_FAR
  #define VG_HUGE
#endif

#ifdef __MSC__
  #pragma warning(disable:4103)
  #pragma pack(1)
#endif

/******************************************************************
*
*  Define the specific Operating System switch
*
*******************************************************************/

/*
*  Default OS defines and switches
*/
#define  _DF_
#define  _DFASM_
#define  _DP_
#define  _DV_
#ifndef DOS
   #define   DOS
#endif

#ifdef WIN30
  #undef   DOS
  #undef   _DF_
  #undef   _DP_
  #undef   _DV_
  #define  _DF_ VG_FAR pascal
  #define  _DP_ VG_FAR
  #define  _DV_ VG_FAR

#ifndef _WINDOWS
  #define  _WINDOWS
#endif

#ifndef _WINDLL
  #define  _WINDLL
#endif
#endif

#ifdef OS2
  #undef   DOS
  #undef   _DF_
  #undef   _DP_
  #undef   _DV_
  #define  _DF_ pascal far _loadds
  #define  _DP_ VG_FAR
  #define  _DV_ VG_FAR
#endif

/*
*  Still using the old type definition under DOS only.
*/

#ifdef DOS
   #define STRUCTREG      VG_STRUCTREG
   #define REGACCESS      VG_REGACCESS
   #define FAST  	        VG_FAST
   #define IMPORT	        VG_IMPORT
   #define GLOBAL	        VG_GLOBAL
   #define LOCAL 	     	  VG_LOCAL
   #define VOID  	     	  VG_VOID
   #define CHAR  	     	  VG_CHAR
   #define INT   	     	  VG_INT
   #define UINT  	     	  VG_UINT
   #define SHORT 	     	  VG_SHORT
   #define USHORT	     	  VG_USHORT
   #define LONG  	     	  VG_LONG
   #define ULONG 	     	  VG_ULONG
   #define FLOAT 	     	  VG_FLOAT
   #define DOUBLE	     	  VG_DOUBLE
   #define BYTE  	     	  VG_BYTE
   #define UBYTE 	     	  VG_UBYTE
   #define WORD  	     	  VG_WORD
   #define UWORD 	     	  VG_UWORD
   #define DWORD 	     	  VG_DWORD
   #define UDWORD	     	  VG_UDWORD
   #define TEXT  	     	  VG_TEXT
   #define BOOL  	     	  VG_BOOL
   #define BFIELD	     	  VG_BFIELD
   #define WFIELD	     	  VG_WFIELD
   #define NEAR	     	  VG_NEAR
   #define FAR 	     	  VG_FAR
   #define APIXEL	     	  VG_APIXEL
   #define PIXEL_PTR      VG_PIXEL_PTR
   #define PIXEL_8	     VG_PIXEL_8
   #define PIXEL_16	     VG_PIXEL_16
   #define PIXEL_24	     VG_PIXEL_24
   #define PIXEL_32	     VG_PIXEL_32
   #define CONV_PIXEL     VG_CONV_PIXEL
   #define LUT_8	     	  VG_LUT_8
   #define LUT_16	     	  VG_LUT_16
   #define LUT_24	     	  VG_LUT_24
   #define CONV_LUT	     VG_CONV_LUT
   #define ACHAR	     	  VG_ACHAR
   #define AFONT	     	  VG_AFONT
   #define ALOGLUT	     VG_ALOGLUT
   #define APEN	     	  VG_APEN
   #define ACURSOR	     VG_ACURSOR
   #define AFONTATTR      VG_AFONTATTR
   #define AVIDEOPARM     VG_AVIDEOPARM
   #define DRVLIBMEM      VG_DRVLIBMEM
   #define CARD_INFO      VG_CARD_INFO
   #define MULTICARD_INFO VG_MULTICARD_INFO
   #define SETUP	     	  VG_SETUP
#endif

#ifdef __WATCOMC__
   #undef _DFASM_
   /* Make assembly functions to receive their parameters on stack */
   #define _DFASM_ cdecl
#endif


