;
; CPMDUMP PROGRAM READS INPUT FILE AND DISPLAYS HEX DATA
;
	ORG	100H
BDOS	EQU	5
CONS	EQU	1
TYPEF	EQU	2		;TYPE FUNCTION
PRINTF	EQU	9		;PRINT BUFFER ENTRY
BRKF	EQU	11		;BREAK KEY FUNCTION
OPENF	EQU	15		;FILE OPEN
READF	EQU	20		;READ FUNCTION
;
FCB	EQU	5CH		;FCB ADDRESS
BUFF	EQU	80H		;INPUT DISK BUFFER ADDRESS
;
; NON GRAPHIC CHARACTERS
CR	EQU	13		;RETURN
LF	EQU	10		;LINE FEED
;
; FCB DEFINITIONS
;
FCBDN	EQU	FCB+0		;DISK NAME
FCBFN	EQU	FCB+1		;FILE NAME
FCBFT	EQU	FCB+9		;FILE TYPE
FCBRL	EQU	FCB+12		;FILE REEL NO.
FCBRC	EQU	FCB+15		;FILE RECORD COUNT
FCBCR	EQU	FCB+32		;NEXT RECORD NUMBER
FCBLN	EQU	FCB+33		;FCB LENGTH
;
; SET UP STACK
;
	LD	HL,0
	ADD	HL,SP		;GET STACK POINTER
	LD	(OLDSP),HL	;SAVE OLD STACK POINTER
	LD	SP,STKTOP	;SET NEW STACK
	CALL	SETUP		;SET UP INPUT FILE
	CP	A,255		;NO FILE?
	JP	NZ,OPENOK	;SKIP IF FILE OK
	LD	DE,OPNMSG	;MESSAGE ADDRESS
	CALL	ERR
	JP	FINIS		;TERMINATE
OPENOK:	LD	A,80H
	LD	(IBP),A		;SET INPUT BUFFER POINTER TO 80H
	LD	HL,0		;START AT 0000H
GLOOP:	PUSH	HL		;SAVE LINE POSITION
	CALL	GNB
	POP	HL		;RECALL
	JP	C,FINIS		;CARRY SET BY GNB IF END OF FILE
	LD	B,A
	LD	A,L		;GET LOW 4 BITS OF LINE POSITION
	AND	A,0FH
	JP	NZ,NONUM
	CALL	CRLF		;PRINT LINE NUMBER
	CALL	BREAK
	RRCA			;LSB TO CARRY FLAG
	JP	C,FINIS		;DO NOT PRINT ANY MORE
	LD	A,H
	CALL	PHEX
	LD	A,L
	CALL	PHEX
NONUM:	INC	HL
	LD	A,' '
	CALL	PCHAR		;PRINT A BLANK
	LD	A,B
	CALL	PHEX
	JP	GLOOP
;
; RETURN TO CPM
;
FINIS:	CALL	CRLF		;NEW LINE
	LD	HL,(OLDSP)	;GET OLD STACK
	LD	SP,HL		;SET STACK FROM HL
	RET
;
; SUBROUTINES
;
BREAK:	PUSH	HL
	PUSH	DE
	PUSH	BC
	LD	C,BRKF		;CHECK FOR ANY KEY PRESSED
	CALL	BDOS
	POP	BC
	POP	DE
	POP	HL
	RET
;
PCHAR:	PUSH	HL
	PUSH	DE
	PUSH	BC
	LD	C,TYPEF		;TYPE CHAR ON CONSOLE
	LD	E,A
	CALL	BDOS
	POP	BC
	POP	DE
	POP	HL
	RET
;
CRLF:	LD	A,CR
	CALL	PCHAR
	LD	A,LF
	CALL	PCHAR
	RET
;
PNIB:	AND	A,0FH
	CP	A,10
	JP	NC,P10
	ADD	A,'0'		;MAKE ASCII
	JP	PRN
P10:	ADD	A,'A'-10
PRN:	CALL	PCHAR
	RET
;
PHEX:	PUSH	AF
	RRCA
	RRCA
	RRCA
	RRCA
	CALL	PNIB		;PRINT NIBBLE
	POP	AF
	CALL	PNIB
	RET
;
; print a message
;
ERR:	LD	C,PRINTF
	CALL	BDOS
	RET
;
; get next byte
;
GNB:	LD	A,(IBP)
	CP	A,80H
	JP	NZ,G0
	CALL	DISKR
	OR	A,A		;SET FLAGS ON REG. A
	JP	Z,G0
	SCF			;SET CARRY FLAG
	RET
G0:	LD	E,A		;SET DE AS POINTER
	LD	D,0		;2 BYTES
	INC	A
	LD	(IBP),A		;SAVE NEW ADDRESS
	LD	HL,BUFF
	ADD	HL,DE
	LD	A,(HL)		;GET BYTE
	OR	A,A		;RESET CARRY
	RET
;
; open default file
;
SETUP:	XOR	A,A		;GET 00H
	LD	(FCBCR),A	;SET CURRENT RECORD
	LD	DE,FCB
	LD	C,OPENF
	CALL	BDOS
	RET
;
; read next record from disk
;
DISKR:	PUSH	HL
	PUSH	DE
	PUSH	BC
	LD	DE,FCB
	LD	C,READF
	CALL	BDOS
	POP	BC
	POP	DE
	POP	HL
	RET
;
SIGNON:	DB	'File Dump Version 2.0$'
OPNMSG:	DB	CR,LF,'No input file present on disk$'
;
IBP:	DW	0
OLDSP:	DW	0
;
	DS	64
STKTOP:	DB	0
;
	END
                                                                                                                                              