/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.text;

import com.supermicro.ipmi.DeviceInfo;
import com.supermicro.ipmi.IPMIAMIOEMCommand;
import com.supermicro.ipmi.IPMIAMIYAFUCommand;
import com.supermicro.ipmi.IPMIGlobalCommand;
import com.supermicro.ipmi.IPMIMessagingCommand;
import com.supermicro.ipmi.text.MOut;
import com.supermicro.ipmi.text.SuperBladeCommand;
import java.io.File;
import java.util.StringTokenizer;

public class IPMIFlashX9Command
extends SuperBladeCommand {
    String options;

    @Override
    public boolean preValidate() {
        this.options = null;
        if (this.parameters == null) {
            MOut.G(this).println("firmware filename is needed");
            return false;
        }
        File file = new File(this.parameters[0]);
        if (!file.isFile()) {
            MOut.G(this).println("File(" + this.parameters[0] + ") not found");
            return false;
        }
        if (this.parameters.length > 1) {
            for (int i = 1; i < this.parameters.length; ++i) {
                this.options = this.options + this.parameters[i] + " ";
            }
        }
        return true;
    }

    public boolean checkIfSupportedDevice() {
        IPMIMessagingCommand ipmiMessagingCommand = new IPMIMessagingCommand(this.ipmiCMMOEMCommand.getIPMIInterface());
        byte[] guid = ipmiMessagingCommand.getSystemGUID();
        return IPMIMessagingCommand.isAMIX9GUID(guid);
    }

    @Override
    public void runCommand() throws Exception {
        boolean result = false;
        IPMIAMIYAFUCommand ipmiAMIYAFUCommand = new IPMIAMIYAFUCommand(null);
        if (this.options != null && this.options.toLowerCase().indexOf("-ver") != -1) {
            this.showFirmwareVer(this.parameters[0]);
            return;
        }
        if (!this.checkIfSupportedDevice()) {
            MOut.G(this).println("Not a supported device");
            MOut.G(this).println("This command is used for updating X9 and B9 BMC firmware (*.ima)");
            this.statusCode = 153;
            return;
        }
        if (!this.checkVersionIfSupportUpdate()) {
            IPMIGlobalCommand ipmiGlobalCommand = new IPMIGlobalCommand(this.ipmiCMMOEMCommand.getIPMIInterface());
            DeviceInfo deviceInfo = ipmiGlobalCommand.getDevice();
            MOut.G(this).println("This BMC version is too old to firmware update (v" + deviceInfo.to3rdVersionNumber() + ")");
            if (this.isB9()) {
                MOut.G(this).println("For B9 board, the version needs to be v1.13.04 or above");
            } else if (this.isX9()) {
                MOut.G(this).println("For X9 board, the version needs to be v2.19.0 or above");
            }
            this.statusCode = 153;
            return;
        }
        if (this.isDownGrade(this.parameters[0])) {
            if (this.isB9()) {
                MOut.G(this).println("For B9 board, cannot down grade to v1.13.03 or below");
            } else if (this.isX9()) {
                MOut.G(this).println("For X9 board, cannot down grade to v2.19.0 or below");
            }
            this.statusCode = 153;
            return;
        }
        MOut.G(this).println("**************************************************************");
        MOut.G(this).println("WARNING!");
        MOut.G(this).println("Firmware upgrade must not be interrupted once it is started.");
        MOut.G(this).println("Once you get error after Upgrading, please use local KCS tool");
        MOut.G(this).println("for recovery.(DOS:RKCSFlsh.exe, Linux:RLin32Flsh or ");
        MOut.G(this).println("Windows:RWin32Flsh.exe ) ");
        MOut.G(this).println("**************************************************************");
        ipmiAMIYAFUCommand.setMOut(MOut.G(this));
        result = ipmiAMIYAFUCommand.flash90(this.parameters[0], true, this.config.getIp(), this.config.getUserName(), this.config.getPassword());
        this.statusCode = result ? 0 : 149;
    }

    public boolean isDownGrade(String filename) {
        if (this.isB9() && this.checkIf1_13_03below(filename)) {
            return true;
        }
        return this.isX9() && this.checkIfV1_V2_V3_Below(filename, 2, 19, 0);
    }

    public boolean checkIf1_13_03below(String filename) {
        byte v1 = 0;
        int v2 = 0;
        int v3 = 0;
        IPMIAMIYAFUCommand ipmiAMIYAFUCommand = new IPMIAMIYAFUCommand(null);
        try {
            String ver = ipmiAMIYAFUCommand.checkFirmwareVersion(filename);
            StringTokenizer st = new StringTokenizer(ver, ".");
            v1 = Byte.parseByte(st.nextToken());
            v2 = Byte.parseByte(st.nextToken());
            v3 = Byte.parseByte(st.nextToken());
        }
        catch (Exception ex) {
            // empty catch block
        }
        if (v1 < 1) {
            return true;
        }
        if (v1 == 1 && v2 < 13) {
            return true;
        }
        return v1 == 1 && v2 == 13 && v3 < 4;
    }

    public boolean checkIfV1_V2_V3_Below(String filename, int V1, int V2, int V3) {
        int v1 = 0;
        int v2 = 0;
        int v3 = 0;
        IPMIAMIYAFUCommand ipmiAMIYAFUCommand = new IPMIAMIYAFUCommand(null);
        try {
            String ver = ipmiAMIYAFUCommand.checkFirmwareVersion(filename);
            StringTokenizer st = new StringTokenizer(ver, ".");
            v1 = Byte.parseByte(st.nextToken());
            v2 = Byte.parseByte(st.nextToken());
            v3 = Byte.parseByte(st.nextToken());
        }
        catch (Exception ex) {
            // empty catch block
        }
        if (v1 < V1) {
            return true;
        }
        if (v1 == V1 && v2 < V2) {
            return true;
        }
        return v1 == V1 && v2 == V2 && v3 < V3;
    }

    public boolean checkVersionIfSupportUpdate() {
        if (this.isB9() && !this.checkB9VersionIfSupportUpdate()) {
            return false;
        }
        return !this.isX9() || this.checkX9VersionIfSupportUpdate(2, 19, 0);
    }

    public boolean isB9() {
        IPMIAMIOEMCommand ipmiAMIOEMCommand = new IPMIAMIOEMCommand(this.ipmiCMMOEMCommand.getIPMIInterface());
        try {
            if (ipmiAMIOEMCommand.isB9()) {
                return true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return true;
        }
        return false;
    }

    public boolean isX9() {
        IPMIAMIOEMCommand ipmiAMIOEMCommand = new IPMIAMIOEMCommand(this.ipmiCMMOEMCommand.getIPMIInterface());
        try {
            if (ipmiAMIOEMCommand.isX9()) {
                return true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return true;
        }
        return false;
    }

    public boolean checkB9VersionIfSupportUpdate() {
        IPMIGlobalCommand ipmiGlobalCommand = new IPMIGlobalCommand(this.ipmiCMMOEMCommand.getIPMIInterface());
        DeviceInfo deviceInfo = ipmiGlobalCommand.getDevice();
        byte v1 = deviceInfo.getFirmwareRevision1();
        byte v2 = deviceInfo.getFirmwareRevision2();
        byte v3 = deviceInfo.auxiliaryFirmwareRevisionInfo[0];
        if (v1 < 1) {
            return false;
        }
        if (v1 == 1 && v2 < 19) {
            return false;
        }
        return v1 != 1 || v2 != 19 || v3 > 3;
    }

    public boolean checkX9VersionIfSupportUpdate(int V1, int V2, int V3) {
        IPMIGlobalCommand ipmiGlobalCommand = new IPMIGlobalCommand(this.ipmiCMMOEMCommand.getIPMIInterface());
        DeviceInfo deviceInfo = ipmiGlobalCommand.getDevice();
        byte v1 = deviceInfo.getFirmwareRevision1();
        byte v2 = deviceInfo.getFirmwareRevision2();
        byte v3 = deviceInfo.auxiliaryFirmwareRevisionInfo[0];
        if (v1 < V1) {
            return false;
        }
        if (v1 == V1 && v2 < V2) {
            return false;
        }
        return v1 != V1 || v2 != V2 || v3 >= V3;
    }

    public void showFirmwareVer(String name) {
        IPMIAMIYAFUCommand ipmiAMIYAFUCommand = new IPMIAMIYAFUCommand(null);
        try {
            String ver = ipmiAMIYAFUCommand.checkFirmwareVersion(name);
            MOut.G(this).println(ver);
        }
        catch (Exception ex) {
            MOut.G(this).println(ex.getMessage());
        }
        this.statusCode = 0;
    }
}

