/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi;

import com.supermicro.ipmi.ByteUtility;

public class FRU_MultiRecordData {
    public byte recordTypeID;
    public byte flag;
    public byte recordLength;
    public byte recordChecksum;
    public byte headerChecksum;
    public byte[] data;
    public byte[] raw;

    public int getRawSize() {
        return 5 + this.data.length;
    }

    public byte[] toRaw() {
        byte[] raw = new byte[5 + this.data.length];
        int index = 0;
        raw[index] = this.recordTypeID;
        raw[++index] = this.flag;
        raw[++index] = this.recordLength;
        raw[++index] = this.recordChecksum;
        raw[++index] = this.headerChecksum;
        System.arraycopy(this.data, 0, raw, ++index, this.data.length);
        return raw;
    }

    public boolean isLastRecord() {
        return (byte)(this.flag & 0x80) == -128;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("MultiRecord Type ID       = " + ByteUtility.byteToHex(this.recordTypeID) + "\n");
        sb.append("Flag                      = " + ByteUtility.byteToHex(this.flag) + "\n");
        sb.append("Record Length             = " + ByteUtility.byteToHex(this.recordLength) + "\n");
        sb.append("Record Checksum           = " + ByteUtility.byteToHex(this.recordChecksum) + "\n");
        sb.append("Header Checksum           = " + ByteUtility.byteToHex(this.headerChecksum) + "\n");
        sb.append("Data                      = " + ByteUtility.bytesToHex(this.data) + "\n");
        return sb.toString();
    }
}

