/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi;

public class SelfTestResultInfo {
    private byte result;
    private byte description;

    public static SelfTestResultInfo fromRaw(byte[] raw) {
        if (raw.length != 2) {
            return null;
        }
        SelfTestResultInfo selfTestResultInfo = new SelfTestResultInfo();
        selfTestResultInfo.result = raw[0];
        selfTestResultInfo.description = raw[1];
        return selfTestResultInfo;
    }

    public String getResultInfo() {
        String resultStr = "";
        switch (this.result) {
            case 85: {
                resultStr = "No error. All Self Tests Passed.";
                break;
            }
            case 86: {
                resultStr = "Self Test function not implemented in this controller";
                break;
            }
            case 87: {
                resultStr = "Corrupted or inaccessible data or devices";
                break;
            }
            case 88: {
                resultStr = "Fatal hardware error (system should consider BMC inoperative). This will indicate that the controller hardware (including associated devices such as sensor hardware or RAM) may need to be repaired or replaced.";
                break;
            }
            case -1: {
                resultStr = "reserved";
                break;
            }
            default: {
                resultStr = "Device-specific 'internal' failure. Refer to the particular device's specification for definition.";
            }
        }
        return resultStr;
    }

    public String getDescriptionInfo() {
        StringBuffer sb = new StringBuffer();
        if ((this.description & 1) > 0) {
            sb.append("controller operational firmware corrupted\n");
        }
        if ((this.description & 2) > 0) {
            sb.append("controller update 'boot block' firmware corrupted\n");
        }
        if ((this.description & 4) > 0) {
            sb.append("Internal Use Area of BMC FRU corrupted\n");
        }
        if ((this.description & 8) > 0) {
            sb.append("SDR Repository empty\n");
        }
        if ((this.description & 0x10) > 0) {
            sb.append("IPMB signal lines do not respond\n");
        }
        if ((this.description & 0x20) > 0) {
            sb.append("Cannot access BMC FRU device\n");
        }
        if ((this.description & 0x40) > 0) {
            sb.append("Cannot access SDR Repository\n");
        }
        if ((this.description & 0x80) > 0) {
            sb.append("Cannot access SEL device\n");
        }
        return sb.toString();
    }

    public void setResult(byte result) {
        this.result = result;
    }

    public void setDescription(byte description) {
        this.description = description;
    }

    public byte getResult() {
        return this.result;
    }

    public byte getDescription() {
        return this.description;
    }
}

