/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.text;

import com.supermicro.ipmi.IPMB;
import com.supermicro.ipmi.IPMIDCMOEMCommand;
import com.supermicro.ipmi.IPMISDRCommand;
import com.supermicro.ipmi.SDRRecordC0h_NMOEMSDR;
import com.supermicro.ipmi.text.MOut;
import com.supermicro.ipmi.text.SuperBladeCommand;

public class NMStatusCommand
extends SuperBladeCommand {
    @Override
    public void runCommand() throws Exception {
        IPMIDCMOEMCommand ipmiDCMOEMCommand = null;
        IPMISDRCommand ipmiSDRCommand = new IPMISDRCommand(this.ipmiCMMOEMCommand.getIPMIInterface());
        SDRRecordC0h_NMOEMSDR nmOEMSDR = ipmiSDRCommand.getNMSDR();
        if (nmOEMSDR == null || !nmOEMSDR.isNMOEMSDR()) {
            MOut.G(this).println("This device does not support Node Manager");
            this.statusCode = 0;
            return;
        }
        if (nmOEMSDR.isIPMB()) {
            IPMB ipmb = new IPMB(this.ipmiCMMOEMCommand.getIPMIInterface());
            ipmb.setAddress(nmOEMSDR.getSlaveAddress());
            ipmb.setChannel(nmOEMSDR.getChannel());
            ipmb.setIpmbType(0);
            ipmiDCMOEMCommand = new IPMIDCMOEMCommand(ipmb);
        } else {
            ipmiDCMOEMCommand = new IPMIDCMOEMCommand(this.ipmiCMMOEMCommand.getIPMIInterface());
        }
        if (this.parameters != null && this.parameters.length == 1) {
            String reset = this.parameters[0];
            if (reset.equalsIgnoreCase("enable")) {
                try {
                    ipmiDCMOEMCommand.enableDisableNodeManagerPolicyControl((byte)1, (byte)0, (byte)0);
                    MOut.G(this).println("Done");
                    this.statusCode = 0;
                    return;
                }
                catch (Exception ex) {
                    MOut.G(this).print(ex.getMessage());
                    this.statusCode = 148;
                    return;
                }
            }
            if (reset.equalsIgnoreCase("disable")) {
                try {
                    ipmiDCMOEMCommand.enableDisableNodeManagerPolicyControl((byte)0, (byte)0, (byte)0);
                    MOut.G(this).println("Done");
                    this.statusCode = 0;
                    return;
                }
                catch (Exception ex) {
                    MOut.G(this).print(ex.getMessage());
                    this.statusCode = 148;
                    return;
                }
            }
        }
        IPMIDCMOEMCommand.NodeManagerStatistics stat = null;
        try {
            stat = ipmiDCMOEMCommand.getNodeManagerStatistics((byte)1, (byte)0, (byte)0);
        }
        catch (Exception ex) {
            MOut.G(this).println(ex.getMessage());
            this.statusCode = 148;
            return;
        }
        if (stat == null) {
            MOut.G(this).println("Call getNodeManagerStatistics failed");
        }
        if ((stat.domainIdAndPolicyState & 0x10) == 16) {
            MOut.G(this).println("Node Manager is enabled");
        } else {
            MOut.G(this).println("Node Manager is not enabled");
        }
        this.statusCode = 0;
    }
}

