/*
 * Decompiled with CFR 0.152.
 */
package nn.pp.rc;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.Socket;
import java.text.MessageFormat;
import nn.pp.rc.T;

public class TunnelSocket
extends Socket {
    public TunnelSocket(String tunnelhost, int tunnelport, String host, int port) throws IOException {
        super(tunnelhost, tunnelport);
        this.doTunnelHandshake(host, port);
    }

    private void doTunnelHandshake(String host, int port) throws IOException {
        String replyStr;
        byte[] b;
        OutputStream out = this.getOutputStream();
        String msg = "CONNECT " + host + ":" + port + " HTTP/1.0\n" + "User-Agent: e-RIC Remote Console Applet" + "\r\n\r\n";
        try {
            b = msg.getBytes("ASCII7");
        }
        catch (UnsupportedEncodingException ignored) {
            b = msg.getBytes();
        }
        out.write(b);
        out.flush();
        byte[] reply = new byte[200];
        int replyLen = 0;
        int newlinesSeen = 0;
        boolean headerDone = false;
        InputStream in = this.getInputStream();
        boolean error = false;
        while (newlinesSeen < 2) {
            int i = in.read();
            if (i < 0) {
                throw new IOException(T._("Unexpected EOF from proxy"));
            }
            if (i == 10) {
                headerDone = true;
                ++newlinesSeen;
                continue;
            }
            if (i == 13) continue;
            newlinesSeen = 0;
            if (headerDone || replyLen >= reply.length) continue;
            reply[replyLen++] = (byte)i;
        }
        try {
            replyStr = new String(reply, 0, replyLen, "ASCII7");
        }
        catch (UnsupportedEncodingException ignored) {
            replyStr = new String(reply, 0, replyLen);
        }
        if (!replyStr.startsWith("HTTP/1.0 200")) {
            throw new IOException(MessageFormat.format(T._("Unable to tunnel through {0}:{1}. Proxy returns \"{2}\""), host, new Integer(port), replyStr));
        }
    }
}

