/************************************************************************
 *     MultiSound Play Example
 *
 *       Plays a PCM sound file based on the parameters defined at compile
 *     time:
 *
 *       SAMPLE_RATE        44100 / 22050 / 11025
 *       BITS               16 / 8
 *     CHANNELS           2 / 1
 *
 *       Command line parameter is the full path of the soundfile to play
 *
 *     Copyright 1992  Turtle Beach Systems Inc., All rights reserved.
 *
 *
 * **********************************************************************/

#include <stdio.h>
#include <malloc.h>
#include <memory.h>
#include <stdlib.h>
#include "msnd_dsp.h"
#include <DOS.H>
#include "pcontrol.h"

#define INT1 {_asm int 1}
#define INT3 {_asm int 3}

#define SAMPLE_RATE 44100
#define BITS        16
#define CHANNELS    2
#define PCM         1

FILE *f_point;

BYTE bTerminator = 0;
BYTE far *pbCurPlayBuff;

void EvalDSPMessage( WORD wDSPMessage );
int SetupPlayStruct( BYTE bBank );


main(argc, argv)
int argc;
char *argv[];
{
    WORD wInker;

    bMem          = HPMEM_D000;
    //bIrq            = HPIRQ_10;
    //nIRQValue       = 10;
    bIrq            = HPIRQ_9;
    nIRQValue       = 9;
    pMEM.dw.h     = 0xD000;
    pMEM.dw.l     = 0x0000;
    wBASEIO       = 0x290;
                                        // non plug and play jumpers as follows:
    wCFGIO          =0x250;           //     -------------------
                                      //     | /-------------\ |    address x250
                                      //     | |   o     o   | |
                                      //     | \-------------/ |
                                      //     |                 |
                                      //     |     o     o     |
                                      //     |                 |
                                      //     -------------------

    pbCurPlayBuff = pMEM.p;

    INT1;

    if( ( pwHostQueue = calloc( sizeof(WORD) , HOSTQ_SIZE ) ) == NULL ) exit(0);
    pwHostHead = pwHostQueue;
    pwHostTail = pwHostQueue;

    outp( ( wBASEIO + HP_WAIT ) , HPWAITSTATE_0 );
    outp( ( wBASEIO + HP_BITM ) , HPBITMODE_16 );

    InitializeSMA();


    if (!UploadDspCode())
    {
        printf("Failed to upload and initialize DSP\n");
        exit(0);
    }



    SetupMsndIRQ();


    // drain the queue if there is anything in there to begin with.
    while ( pwHostTail != pwHostHead ) {
        if( ++pwHostHead >= (pwHostQueue + HOSTQ_SIZE ) ) {
            pwHostHead = pwHostQueue;
            printf("Wrapping Host Queue\n");
        }
        // ignore these,
        // before we start recording we get various overflow
        // and underflow messages from the DSP
        //EvalDSPMessage( *pwHostHead );
    }

    printf( "Hit the spacebar to begin playing\n" );

    while ( !kbhit() ) {}

    if( ( f_point = fopen( argv[1], "rb" ) ) == NULL ) {
        printf("Unable to open file\n");
        ResetMsndIRQ();
        exit(0);
    }


    for( wInker = 0 ; wInker < 3 ; wInker++ ) {
        if (!SetupPlayStruct( (BYTE)wInker ))
        {
            ResetMsndIRQ(); // reset and bug out.
            exit(0);
        }
        CurDAQD++;
        pbCurPlayBuff += DAP_BUFF_SIZE;
    }

    CurDAQD = ( struct DAQueueDataStruct far * )( pMEM.p + DAPQ_DATA_BUFF );

    DAPQ->wTail = PCTODSP_OFFSET( 2 * DAPQ_STRUCT_SIZE );
    SendDSPCommand( HDEX_PLAY_START );

    while( !bTerminator ) {
        if( feof( f_point ) ) bTerminator = 1;
        if( pwHostTail != pwHostHead ) {
            if( ++pwHostHead >= (pwHostQueue + HOSTQ_SIZE ) ) {
                pwHostHead = pwHostQueue;
                printf("Wrapping Host Queue\n");
            }
            EvalDSPMessage( *pwHostHead );
        }
    }

    // not sure whether we should wait until we are done here.
    SendDSPCommand( HDEX_PLAY_STOP );

    // drain the queue if there is anything in there to begin with.
    while ( pwHostTail != pwHostHead ) {
        if( ++pwHostHead >= (pwHostQueue + HOSTQ_SIZE ) ) {
            pwHostHead = pwHostQueue;
            printf("Wrapping Host Queue\n");
        }
        EvalDSPMessage( *pwHostHead );
    }


    ResetMsndIRQ();
    fclose( f_point );

  return (0);
}


int SetupPlayStruct( BYTE bBank )
{
    long lReadSize;
    WORD wReadSize;

    if (feof( f_point ))
        lReadSize = 0;
    else
    lReadSize = fread(pbCurPlayBuff, sizeof(BYTE), DAP_BUFF_SIZE, f_point);
    if (lReadSize == -1)
    {
        printf("Read of file failed\n");
        return(0);
    }
    wReadSize = (WORD)lReadSize;
    if (wReadSize > DAP_BUFF_SIZE)
    {
        printf("File format No good\n");
        return(0);
    }

    CurDAQD->wStart      = PCTODSP_BASED( (DWORD)( DAP_BUFF_SIZE * bBank ) );
    CurDAQD->wSize       = wReadSize;
    CurDAQD->wFormat     = PCM;
    CurDAQD->wSampleSize = BITS;
    CurDAQD->wChannels   = CHANNELS;
    CurDAQD->wSampleRate = SAMPLE_RATE;
    CurDAQD->wIntMsg     = HIMT_PLAY_DONE * 0x100 + bBank;
    CurDAQD->wFlags      = bBank;

    return(1);
}



void EvalDSPMessage( WORD wMessage )
{
    switch ( HIBYTE( wMessage ) )
    {
        case HIMT_PLAY_DONE:
        {
            struct DAQueueDataStruct far *pDAPQData;
            DWORD dwAddr;
            BYTE bBank;
            long lReadSize;
            WORD wReadSize;
            WORD wNewTail;

            // retrieve the bank associated with this play queue entry.
            bBank = LOBYTE(wMessage);

            pbCurPlayBuff = ( BYTE far *)( (DAP_BUFF_SIZE * bBank)  + pMEM.p);

            lReadSize = fread(pbCurPlayBuff, sizeof(BYTE), DAP_BUFF_SIZE, f_point);
            if (lReadSize == -1)
                lReadSize = 0;
            wReadSize = (WORD)lReadSize;

            wNewTail = DAPQ->wTail + PCTODSP_OFFSET(DAPQ_STRUCT_SIZE);
            if (wNewTail > DAPQ->wSize ) 
                wNewTail = 0;


            dwAddr = ((DAPQ->wHead + DAPQ->wStart) - DSP_BASE_ADDR) * 2;
            pDAPQData = (struct DAQueueDataStruct far *)(dwAddr + pMEM.p);

            

            //printf("pbCurPlayBuff = %lx, %x\n", pbCurPlayBuff, wReadSize);


            // tell-em we got the buffer ready.
            pDAPQData->wSize = wReadSize;

            DAPQ->wTail = wNewTail;


            SendDSPCommand( HDEX_PLAY_START );


            switch ( LOBYTE( wMessage ) )
            {
                case 0x00:
                    // Bank 0 Done
                    break;

                case 0x01:
                    // Bank 1 Done
                    break;

                case 0x02:
                    // Bank 2 Done
                    break;

                default:
                    // Unknown Message
                    break;
            }


            break;
        }
        case HIMT_DSP:
            switch ( LOBYTE( wMessage ) )
            {
                case HIDSP_PLAY_UNDER:
                    printf("HIDSP_PLAY_UNDER\n");
                    break;

                case HIDSP_INT_PLAY_UNDER:
                    printf( "HIDSP_INT_PLAY_UNDER\n" );
                    break;

                case HIDSP_SSI_TX_UNDER:
                    printf( "HIDSP_SSI_TX_UNDER\n" );
                    break;
                case HIDSP_RECQ_OVERFLOW:
                    printf( "HIDSP_RECQ_OVERFLOW\n" );
                    break;
                case HIDSP_INT_REC_OVERFLOW:
                    printf( "HIDSP_INT_REC_OVERFLOW\n" );
                    break;
                case HIDSP_SSI_RX_OVERFLOW:
                    printf( "HIDSP_SSI_RX_OVERFLOW\n" );
                    break;
                case HIDSP_MIDI_FRAME_ERR:
                    printf( "HIDSP_MIDI_FRAME_ERR\n" );
                    break;
                case HIDSP_MIDI_PARITY_ERR:
                    printf( "HIDSP_MIDI_PARITY_ERR\n" );
                    break;
                case HIDSP_INPUT_CLIPPING:
                    printf( "HIDSP_INPUT_CLIPPING\n" );
                    break;
                case HIDSP_MIX_CLIPPING:
                    printf( "HIDSP_MIX_CLIPPING\n" );
                    break;
                case HIDSP_DAT_IN_OFF:
                    printf( "HIDSP_DAT_IN_OFF\n" );
                    break;
                case HIDSP_MIDI_IN_OVER:
                    printf( "HIDSP_MIDI_IN_OVER\n" );
                    break;
                case HIDSP_MIDI_OVERRUN_ERR:
                    printf( "HIDSP_MIDI_OVERRUN_ERR\n" );
                    break;
                default:
                    printf("ERROR: UNKNOWN_DSP_MESSAGE %X : %X\n" , HIBYTE( wMessage ) , LOBYTE( wMessage ) );
                    break;
            }
            break;

        case HIMT_RECORD_DONE:
            printf( "HIMT_RECORD_DONE\n" );
            break;

        case HIMT_MIDI_EOS:
            printf( "HIMT_MIDI_EOS\n" );
            break;

        case HIMT_MIDI_IN_UCHAR:
            printf( "HIMT_MIDI_IN_UCHAR\n" );
            break;

        default:
                printf("UNKNOWN_MESSAGE %X : %X\n" , HIBYTE( wMessage ) , LOBYTE( wMessage ) );
                break;

    }
}

