#include <stdio.h>
#include <dos.h>
#include <memory.h>
#include <mcontrol.h>
#include <msnd_dsp.h>

// 12/17/92  -  Changed for compatibility with Borland compiler
//              Added new make files for Borlands MAKE utility
//
// 3/12/93   -  Fixed Board Initialization code
//              UploadDSPcode and put in shared RAM initialization

// This file contains the functions and definitions used to directly
// Access the multisound card

/************************************************************************
 *
 *    function : void InitializeSMA( void )
 *
 *    params   : none
 *
 *    operation: This function initializes the common data in the SMA,
 *							 and initializes the hosts pointers to that area.
 *
 *    returns  : none
 *
 * **********************************************************************/

void InitializeSMA( void )
{
  WORD wInker;

  outp( ( wBASEIO + HP_MEMM ) , bMem );

  outp( ( wBASEIO + HP_BLKS ) , HPBLKSEL_0 );
  for( wInker = 0 ; wInker < 0x8000 ; wInker++ ) {
    *( pMEM.p + wInker ) = 0x00;
  }

  outp( ( wBASEIO + HP_BLKS ) , HPBLKSEL_1 );
  for( wInker = 0 ; wInker < 0x8000 ; wInker++ ) {
    *( pMEM.p + wInker ) = 0x00;
  }

  outp( ( wBASEIO + HP_BLKS ) , HPBLKSEL_0 );

  DAPQ = ( struct JobQueueStruct far * )( pMEM.p + DAPQ_OFFSET );
	DARQ = ( struct JobQueueStruct far * )( pMEM.p + DARQ_OFFSET );
	MODQ = ( struct JobQueueStruct far * )( pMEM.p + MODQ_OFFSET );
	MIDQ = ( struct JobQueueStruct far * )( pMEM.p + MIDQ_OFFSET );
	DSPQ = ( struct JobQueueStruct far * )( pMEM.p + DSPQ_OFFSET );

	SMA = ( struct SMA0_CommonData far * )( pMEM.p + SMA_STRUCT_START );

	CurDAQD = ( struct DAQueueDataStruct far * )( pMEM.p + DAPQ_DATA_BUFF );
	CurDARQD = ( struct DAQueueDataStruct far * )( pMEM.p + DARQ_DATA_BUFF );

	pwDSPQData = (WORD far *)( pMEM.p + DSPQ_DATA_BUFF );
	pwMODQData = (WORD far *)( pMEM.p + MODQ_DATA_BUFF );
	pwMIDQData = (WORD far *)( pMEM.p + MIDQ_DATA_BUFF );


	MIDQ->wStart = PCTODSP_BASED( MIDQ_DATA_BUFF );
	MIDQ->wSize  = PCTODSP_OFFSET( MIDQ_BUFF_SIZE ) - 1;
	MIDQ->wHead  = 0;
	MIDQ->wTail  = 0;

	MODQ->wStart = PCTODSP_BASED( MODQ_DATA_BUFF );
	MODQ->wSize  = PCTODSP_OFFSET( MODQ_BUFF_SIZE ) - 1;
	MODQ->wHead  = 0;
	MODQ->wTail  = 0;

	DAPQ->wStart = PCTODSP_BASED( DAPQ_DATA_BUFF );
	DAPQ->wSize  = PCTODSP_OFFSET( DAPQ_BUFF_SIZE ) - 1;
  DAPQ->wHead  = 0;
	DAPQ->wTail  = 0;

	DARQ->wStart = PCTODSP_BASED( DARQ_DATA_BUFF );
	DARQ->wSize  = PCTODSP_OFFSET( DARQ_BUFF_SIZE ) - 1;
  DARQ->wHead  = 0;
	DARQ->wTail  = 0;

	DSPQ->wStart = PCTODSP_BASED( DSPQ_DATA_BUFF );
	DSPQ->wSize  = PCTODSP_OFFSET( DSPQ_BUFF_SIZE ) - 1;
	DSPQ->wHead  = 0;
	DSPQ->wTail  = 0;

	SMA->wCurrPlayBytes = 0;
	SMA->wCurrRecordBytes = 0;
	SMA->wCurrPlayVolLeft = 0x7FFF;
	SMA->wCurrPlayVolRight = 0x7FFF;

	SMA->wCurrDSPStatusFlags = 0;
	SMA->wCurrHostStatusFlags = 0;
	SMA->wCurrInputTagBits = 0;
	SMA->wCurrLeftPeak = 0;
	SMA->wCurrRightPeak = 0;

	SMA->wExtDSPbits = 0;

	SMA->bExtHostbits = 0;

	SMA->bBoardLevel = 0;

	SMA->bInPotPosRight = 0;
	SMA->bInPotPosLeft = 0;

	SMA->bAuxPotPosRight = 0;
	SMA->bAuxPotPosLeft = 0;

	SMA->wCalFreqAtoD = 44100;
}


/************************************************************************
 *
 *    function : BYTE SetAuxVolume( BYTE bValue , BYTE bLRBN )
 *
 *    params   : bValue - The new volume value
 *               bLRNM  - Can be any of the following
 *									RIGHT - Set right volume to bValue
 *									LEFT  - Set left volume to bValue
 *									GANG  - Set left and right to bValue
 *									NONE  - Don't change value but send update
 *													message to DSP
 *
 *    operation: This function tells the DSP to change the the auxiliary
 *							 volume based on the parameters sent to it.
 *
 *    returns  : 1  -  if succesful
 *						   0  -  if function fails
 *
 * **********************************************************************/

BYTE SetAuxVolume( BYTE bValue , BYTE bLRBN )
{
	if( bLRBN != NONE ) {
		if( bLRBN & RIGHT ) SMA->bAuxPotPosRight = bValue;
	  if( bLRBN & LEFT ) SMA->bAuxPotPosLeft = bValue;
	}

	if( SendHostWord( 0x00 , 0x00 , HDEXAR_AUX_SET_POTS ) &&
				SendDSPCommand( HDEX_AUX_REQ ) ) return( 1 );
	return( 0 );
}

/************************************************************************
 *
 *    function : BYTE SetInVolume( BYTE bValue , BYTE bLRBN )
 *
 *    params   : bValue - The new volume value
 *               bLRNM  => Can be any of the following
 *									RIGHT - Set right volume to bValue
 *									LEFT  - Set left volume to bValue
 *									GANG  - Set left and right to bValue
 *									NONE  - Don't change value but send update
 *													message to DSP
 *
 *    operation: This function tells the DSP to change the the record
 *							 input volume based on the parameters sent to it.
 *
 *    returns  : 1  -  if successful
 *							 0  -  if not successful
 *
 * **********************************************************************/

BYTE SetInVolume( BYTE bValue , BYTE bLRBN )
{
	if( bLRBN != NONE ) {
		if( bLRBN & RIGHT ) SMA->bInPotPosRight = bValue;
	  if( bLRBN & LEFT ) SMA->bInPotPosLeft = bValue;
	}
	if( SendHostWord( 0x00 , 0x00 , HDEXAR_IN_SET_POTS ) &&
	        SendDSPCommand( HDEX_AUX_REQ ) ) return( 1 );
	return( 0 );
}

/************************************************************************
 *
 *    function : BYTE ClearPeaks( void )
 *
 *    params   : none
 *
 *    operation: This function clears the peak values stored in the
 *							 SMA
 *
 *    returns  : 1  -  if succesful
 *						   0  -  if function fails
 *
 * **********************************************************************/

BYTE ClearPeaks( void )
{
	if( SendHostWord( 0x00 , 0x00 , HDEXAR_CLEAR_PEAKS ) &&
				SendDSPCommand( HDEX_AUX_REQ ) ) return( 1 );
	return( 0 );
}

/************************************************************************
 *
 *    function : WORD GetExtDSPBits( void )
 *
 *    params   : none
 *
 *    operation: Updates and returns the values of the external DSP bits
 *
 *    returns  : The value of SMA->wExtDSPbits
 *
 * **********************************************************************/

WORD GetExtDSPBits( void )
{
	SendHostWord( 0x00 , 0x00 , HDEXAR_RD_EXT_DSP_BITS );
	SendDSPCommand( HDEX_AUX_REQ );

	return( SMA->wExtDSPbits );
}

/************************************************************************
 *
 *    function : BYTE CalibrateAD( WORD wSampleRate , BYTE bGndType )
 *
 *    params   : wSampleRate - The sample rate to calibrate to
 *               bGndType  => Can be one of the following
 *									 SIGNAL - calibrate to signal ground
 *                   AGND   - calibrate to board AGND
 *
 *    operation: This function calibrates MultiSounds A/D converters
 *							 based on the sample rate and calibration type passed
 *
 *    returns  : 1 - success
 *							 0 - failure
 *
 * **********************************************************************/

BYTE CalibrateAD( WORD wSampleRate , BYTE bGndType )
{
	BYTE bRetVal;

	SMA->wCalFreqAtoD = wSampleRate;

	if( bGndType == AGND )
		SMA->wCurrHostStatusFlags |= 0x0001;
	else
		SMA->wCurrHostStatusFlags &= ~(0x0001);

	if( SendHostWord( 0x00 , 0x00 , HDEXAR_CAL_A_TO_D ) &&
					SendDSPCommand( HDEX_AUX_REQ ) ) bRetVal = 1;
	else
		bRetVal = 0;

	// The actual time for the calibration is equal to
	// 4096 / SAMPLE_RATE
	// We will poll DCAL to wait untill the calibration is complete
	while( GetExtDSPBits() & ~( EXT_DSP_BIT_DCAL ) );
	return( bRetVal );
}

/************************************************************************
 *
 *    function : WORD MIDPortRead()
 *
 *    params   : none
 *
 *    operation: This function reads the MIDI data from the MIDI in queue
 *							 and returns the data
 *
 *    returns  : The MIDI data read from the queue
 *
 * **********************************************************************/

WORD MIDPortRead( void )
{
	WORD wRetVal , wHead;

	wHead = MIDQ->wHead;
	if( ++wHead > MIDQ->wSize ) wHead = 0;

	wRetVal = *( pwMIDQData + MIDQ->wHead );

	MIDQ->wHead = wHead;

	return( wRetVal );
}


/************************************************************************
 *
 *    function : void MODPortWrite( WORD wMIDIData )
 *
 *    params   : wMIDIData =>
 *									0xFFxx = Patch Change
 *				 0x01xx - 0xFExx = Host defined message
 *									0x00xx = MIDI out data
 *
 *    operation: This function sends the MIDI data contained in
 *							 wMIDIData out to the MIDI queue
 *
 *    returns  : none
 *
 * **********************************************************************/

void MODPortWrite( WORD wMIDIData )
{
	WORD wNewTail , wOldTail;

	wNewTail = MODQ->wTail;
	wOldTail = wNewTail;
	if( ++wNewTail > MODQ->wSize ) wNewTail = 0;
	while( wNewTail == MODQ->wHead );     // Wait if Buffer is full

	*( pwMODQData + MODQ->wTail ) = wMIDIData;

	MODQ->wTail = wNewTail;
	if( MODQ->wHead == wOldTail ) SendDSPCommand( HDEX_MIDI_OUT_START );
}


/************************************************************************
 *
 *    function : void SetMidiInPort( BYTE bNewMIP )
 *
 *    params   : bNewMIP  =  The new MIP mask to change to
 *
 *    operation: This function changes the midi input port to
 *               the value defined by bNewMIP.
 *
 *    returns  : none
 *
 * **********************************************************************/

void SetMidiInPort( BYTE bNewMIP )
{
	BYTE bMASK;

	bMASK = ( LOBYTE( wCurrentMidiPatch ) & MIP_INMASK );
	bNewMIP = ( bNewMIP | bMASK );
	wCurrentMidiPatch = MAKEWORD( bNewMIP , 0x00 );

	MODPortWrite( 0xFE00 );
	MODPortWrite( MAKEWORD( bNewMIP , 0xFF ) );
}


/************************************************************************
 *
 *    function : void SetMidiOutPort( BYTE bNewMOP )
 *
 *    params   : bNewMOP  =  The new MOP mask to change to
 *
 *    operation: This function changes the midi output port to
 *               the value defined by bNewMOP.
 *
 *    returns  : none
 *
 * **********************************************************************/

void SetMidiOutPort( BYTE bNewMOP )
{
	BYTE bMASK;

	bMASK = ( MOP_OUTMASK & LOBYTE( wCurrentMidiPatch ) );
	bNewMOP = ( bNewMOP | bMASK );

	wCurrentMidiPatch = MAKEWORD( bNewMOP , 0x00 );

	MODPortWrite( 0xFE00 );
	MODPortWrite( MAKEWORD( bNewMOP , 0xFF ) );
}


/************************************************************************
 *
 *    function : void SetMidiPatch( BYTE bNewPatch )
 *
 *    params   : bNewPatch = The new value for the patch register
 *
 *    operation: This function changes the midi patch to the
 *               one defined by bNewPatch.
 *
 *    returns  : none
 *
 * **********************************************************************/

void SetMidiPatch( BYTE bNewPatch )
{
	wCurrentMidiPatch = MAKEWORD( bNewPatch , 0x00 );

	MODPortWrite( 0xFE00 );
	MODPortWrite( MAKEWORD( bNewPatch , 0xFF ) );
}


/************************************************************************
 *
 *    function : void ResetProteus( void )
 *
 *    params   : none
 *
 *    operation: This function resets the proteus
 *
 *    returns  : none
 *
 * **********************************************************************/

void ResetProteus( void )
{
	outp( wBASEIO + HP_PROR , HPPRORESET_ON );

	GetDelayTime( TIME_PRO_RESET );

	outp( wBASEIO + HP_PROR , HPPRORESET_OFF );

	GetDelayTime( TIME_PRO_RESET_DONE );
}

/************************************************************************
 *
 *    function : word wsnaptimer( void )
 *
 *    params   : none
 *
 *    operation: This function get the current timer value.
 *
 *    returns  : The value from the timer.
 *
 * **********************************************************************/
WORD wsnaptimer(void)
{
  BYTE b0,b1;

	outp(0x43,0);			// freeze the timer
	b0 = inp(0x40);                 // read it
	b1 = inp(0x40);
	return(MAKEWORD(b0,b1));

}

 /************************************************************************
 *
 *    function : void DelayOneMsec( void )
 *
 *    params   : none
 *
 *    operation: This function returns after one millisecond.
 *
 *    returns  : none
 *
 * **********************************************************************/

void DelayOneMsec(void)
{
WORD w0,w1;

	w0 = wsnaptimer();
	while ((w0-wsnaptimer()) < 2381) {};
}

/************************************************************************
 *
 *    function : void GetDelayTime( WORD wDelay )
 *
 *    params   : wDelay  -  The thousandths of seconds to wait
 *
 *    operation: This function delays for wDelay milliseconds
 *               using the DelayOneMsec function
 *
 *    returns  : none
 *
 * **********************************************************************/

void GetDelayTime( WORD wDelay )
{
	while ( wDelay--)  DelayOneMsec();
}


/************************************************************************
 *
 *    function : void _interrupt _far InterruptHandler( void )
 *
 *    params   : none
 *
 *    operation: This function handles the interrupts from MultiSound
 *               It reads the message into the host queue, and then
 * 							 terminates the interrupt with EOI
 *
 *    returns  : none
 *
 * **********************************************************************/

void _interrupt _far InterruptHandler( void )
{
	if( bIntFlag != 1 ) {
		bIntFlag = 1;
		if( bCurrBank ) outp( wBASEIO + HP_BLKS , HPBLKSEL_0 );
		inp( wBASEIO + HP_RXL );
  	if( nIRQValue > 7 ) outp( PIC2 , EOI );
  	outp( PIC1 , EOI );

		while( DSPQ->wTail != DSPQ->wHead )  {
			if( ++pwHostTail >= ( pwHostQueue + HOSTQ_SIZE ) ) pwHostTail = pwHostQueue;
			*pwHostTail = *( pwDSPQData + DSPQ->wHead );
			if( ++DSPQ->wHead > DSPQ->wSize ) DSPQ->wHead = 0x00;
		}
		if( bCurrBank ) outp( wBASEIO + HP_BLKS , HPBLKSEL_1 );
		bIntFlag = 0;
	}
}

/************************************************************************
 *
 *    function : BYTE UploadDSPCode( void )
 *
 *    params   : none
 *
 *    operation: uploads the DSP code contained in the code segment
 *							 (dspcode.obj) to the DSP.  The initial code is sent up
 *							 through the host port, while the permanent code is
 *							 copied into the SMA.
 *
 *    returns  : 1 if upload successful
 *               0 if upload not successful
 *
 * **********************************************************************/

BYTE UploadDSPCode( void )
{
	 int nInker;
	 pbDSPperm = &bDspPermStart;
	 pbDSPinit = &bDspInitStart;

   outp( ( wBASEIO+ HP_BLKS ), HPBLKSEL_0);
   outp( ( wBASEIO+ HP_MEMM ), bMem );
   _fmemcpy( pMEM.p , pbDSPperm , wDspPermSize );

   for( nInker = 0; nInker < 3*wDspInitSize ; nInker += 3) {
      if( ( SendHostWord( *(pbDSPinit+nInker), *(pbDSPinit+nInker+1), *(pbDSPinit+nInker+2)))==0) {
      return(0);
      }
   }
   return(1);
}

/************************************************************************
 *
 *    function : int uploadbin( char *szBinName )
 *
 *    params   : filename - then name of the bin file to upload
 *
 *    operation: uploads the bin file to the DSP
 *
 *    returns  : 1 if upload successful
 *               0 if upload not successful
 *
 * **********************************************************************/

BYTE uploadbin(char *szBinName )
{
   FILE *fBinFile;
   int lRSize, nInker = 0;
   static BYTE bBinBuff[512*3];

   while( nInker < sizeof( bBinBuff ) ) {
      bBinBuff[ nInker++ ] = 0;
      }

   if((fBinFile = fopen( szBinName, "rb" )) == NULL ) {
      printf("Error opening file : %s\n", szBinName );
      return(0);
      }

   // lRSize = fread( bBinBuff, sizeof( BYTE ), sizeof(bBinBuff), fBinFile);
   fread( bBinBuff, sizeof( BYTE ), sizeof(bBinBuff), fBinFile);

   for( nInker = 0; nInker < sizeof( bBinBuff ); nInker += 3) {
      if( ( SendHostWord( bBinBuff[nInker], bBinBuff[nInker+1], bBinBuff[nInker+2] ) ) == 0 ) {
         printf("Error uploading word %d\n", nInker );
         fclose( fBinFile );
         return(0);
      }
   }

   fclose(fBinFile);
   return(1);
}


/************************************************************************
 *
 *    function : int uploadreb( char *szrebstrname )
 *
 *    params   : filename - then name of the reb file to upload
 *
 *    operation: uploads the reb file to the DSP
 *
 *    returns  : 1 if upload successful
 *               0 if upload not successful
 *
 * **********************************************************************/

BYTE uploadreb(char *rebstrname)
  {
  FILE *rebfile;
  int i;

  if ((rebfile = fopen(rebstrname,"rb")) == NULL )
      {
      printf("Trouble opening %s\n",rebstrname);
      return(0);
      }
  outp( ( wBASEIO+ HP_BLKS ), HPBLKSEL_0);
  outp( ( wBASEIO+ HP_MEMM ), bMem );

  fread( pMEM.p , sizeof(BYTE), wDspPermSize, rebfile);
//  fread( pMEM.p , sizeof(BYTE), BUFFSIZE, rebfile);
  fclose( rebfile );
  return(1);
  }


/************************************************************************
 *
 *    function : BYTE SendHostWord( BYTE bHi , BYTE bMid , BYTE bLow )
 *
 *    params   : The hi, mid, and low byte respectively of the data
 *               to be sent to the DSP receive data address
 *
 *    operation: calls WaitTXDEmpty to wait until the host transmit
 *               data register has been cleared by the DSP.  The
 *               loading of the low order byte tells the DSP that
 *               the data is present.
 *
 *    returns  : 1 if successful
 *               0 if not successful
 *
 * **********************************************************************/
BYTE SendHostWord(BYTE bHi, BYTE bMid , BYTE bLow )
{
   if( WaitTXDEmpty() ) {
      outp( wBASEIO + HP_TXH , bHi );
      outp( wBASEIO + HP_TXM , bMid );
      outp( wBASEIO + HP_TXL , bLow );
      return(1);
      }
   return(0);
}

/************************************************************************
 *
 *    function : BYTE WaitTXDEmpty( void )
 *
 *    params   : none
 *
 *    operation: Waits for the DSP to read any data in the transmit
 *               registers.
 *
 *    returns  : 1 if transmit registers are clear
 *               0 if function times out waiting for TXDE
 *
 * **********************************************************************/
BYTE WaitTXDEmpty( void )
{
   int nTimeOutCount = 20000;

   while(nTimeOutCount-- >= 0) {
      if( inp(wBASEIO + HP_ISR) & HPISR_TXDE ) {
         return(1);
      }
   }
   return(0);
}

/************************************************************************
 *
 *    function : BYTE WaitHostClear( void )
 *
 *    params   : none
 *
 *    operation: Waits for HP_CVR to match HPCVR_HC.  Used in sending
 *               commands to the DSP
 *
 *    returns  : 1 if successful
 *               0 if operation times out
 *
 * **********************************************************************/

BYTE WaitHostClear( void )
{
   int nTimeOutCount = 20000;

   while(nTimeOutCount-- >= 0) {
      if( !(inp(wBASEIO + HP_CVR) & HPCVR_HC )) {
         return(1);
      }
   }
   return(0);
}

/************************************************************************
 *
 *    function : BYTE ResetDSP( void )
 *
 *    params   : none
 *
 *    operation: resets the DSP to initialize operation
 *
 *    returns  : 1 if successful
 *               0 if DSP times out
 *
 * **********************************************************************/

BYTE ResetDSP( void )
{
   int nInker, nTimeOutCount = 20000;

   outp( wBASEIO + HP_DSPR , HPDSPRESET_ON );

   outp( wBASEIO + HP_DSPR , HPDSPRESET_OFF );

   while(nTimeOutCount-- >= 0) {
      if( inp(wBASEIO + HP_CVR) == 0x12 ) {
         return(1);
      }
   }
   return(0);
}


/************************************************************************
 *
 *    function : BYTE SendDSPCommand( BYTE bCommand )
 *
 *    params   : bCommand - the command to send to the DSP
 *
 *    operation: Sends the command bCommand to the DSP
 *
 *    returns  : 1 if successful
 *               0 if not successful
 *
 * **********************************************************************/

BYTE SendDSPCommand( BYTE bCommand )
{
    if( WaitHostClear() ) {
        outp( wBASEIO + HP_CVR , bCommand );
        return(1);
    }
    return(0);
}


/************************************************************************
 *
 *    function : BYTE SetIntMap( bIrq )
 *
 *    params   : bIrq - The interrupt the MultiSound is on
 *
 *    operation: Sets up the Hardware Interrupt on the MultiSound.  The order
 *               of the calls below must be followed to successfully setup
 *               the interrupt.
 *
 *    returns  : 1 if successful
 *               0 if not successful
 *
 * **********************************************************************/


BYTE SetIntMap( BYTE bIrq )
{
  if( WaitTXDEmpty() ) {
    outp( wBASEIO + HP_ICR , inp( wBASEIO + HP_ICR ) | HPICR_TREQ );
    outp( wBASEIO + HP_IRQM , bIrq );
    outp( wBASEIO + HP_ICR , inp( wBASEIO + HP_ICR ) & ~HPICR_TREQ );
    return(1);
    }
return(0);
}


/************************************************************************
 *
 *    function : BYTE SetupMsndIRQ()
 *
 *    params   : none
 *
 *    operation: Sets up the PC to be able to receive interrupts from
 *               the MultiSound, and saves the previous DOS interrupt
 *
 *    returns  : 1 if successful
 *               0 if not successful
 *
 * **********************************************************************/


BYTE SetupMsndIRQ()
{
  WORD wGP;

  if( SetIntMap( bIrq ) == 0 ) {
    return(0);
  }
  if( nIRQValue > 7 ) {
    wGP = nIRQValue + 0x68;
    outp( PIC2 + 1 , ~( 1 << (nIRQValue - 8) & inp( PIC2 + 1 ) ) );
    }
  else {
    wGP = nIRQValue + 8;
    outp( PIC1 + 1 , ~( 1 <<  nIRQValue ) & inp( PIC1 + 1 ) );
  }

  nDSPSaveVect = _dos_getvect( wGP );
  _dos_setvect( wGP , InterruptHandler );

  outp( wBASEIO + HP_ICR , inp( wBASEIO + HP_ICR ) | HPICR_RREQ );

  return(1);
}


/************************************************************************
 *
 *    function : BYTE ResetMsndIRQ()
 *
 *    params   : none
 *
 *    operation: Resets the PC link to the MultiSound interrupt from
 *               the MultiSound, and restores the DOS interrupt
 *
 *    returns  : 1 if successful
 *               0 if not successful
 *
 * **********************************************************************/

BYTE ResetMsndIRQ()
{
  WORD wGP;

  outp( wBASEIO + HP_ICR , inp( wBASEIO + HP_ICR ) & ~HPICR_RREQ );

  if( SetIntMap( HPIRQ_NONE ) == 0 ) {
    return(0);
  }

  if( nIRQValue > 7 ) {
    wGP = nIRQValue + 0x68;
    outp( PIC2 + 1 ,  1 << (nIRQValue - 8 ) | inp( PIC2 + 1 ) );
    }
  else {
    wGP = nIRQValue + 8;
    outp( PIC1 + 1 , (1 << nIRQValue)  | inp( PIC1 + 1 ) );
  }
  _dos_setvect( wGP , nDSPSaveVect );
  return(1);
}

