/*
**  S C A N . C
** 
**  Copyright (c) 1995 ADVANCED MICRO DEVICES, INC. All Rights Reserved.
**  This software is unpblished and contains the trade secrets and
**  confidential proprietary information of AMD. Unless otherwise provided
**  in the Software Agreement associated herewith, it is licensed in confidence
**  "AS IS" and is not to be reproduced in whole or part by any means except
**  for backup. Use, duplication, or disclosure by the Government is subject
**  to the restrictions in paragraph (b) (3) (B) of the Rights in Technical
**  Data and Computer Software clause in DFAR 52.227-7013 (a) (Oct 1988).
**  Software owned by Advanced Micro Devices, Inc., 901 Thompson Place,
**  Sunnyvale, CA 94088.
**
**  D E S C R I P T I O N
**  ~~~~~~~~~~~~~~~~~~~~~
**  Scan the input buffer for the given keyword. If found, the given bfr pointer
**  is left pointing to the quoted value immediately following the keyword
**  and the function returns the number of characters including white space in
**  between the double quotes. 
*/

#include <string.h>
#include <ctype.h>
#include <dmiapi.h>
#include <io.h>
#include "dosins.h"

int ScanInputBfr(char** ppcScanBfr, char* pcKeyword, TType tType)
{
    int     i;
    char*   pcScanBfrTmp;

    while(**ppcScanBfr){
        // Begin scanning for the pcKeyword.
        pcScanBfrTmp=strstr(*ppcScanBfr,pcKeyword);
        if(pcScanBfrTmp){
            *ppcScanBfr=pcScanBfrTmp;
            // Is it really the keyword?
            i=strlen(pcKeyword);
            if(isspace((*ppcScanBfr)[i])||((*ppcScanBfr)[i]=='=')){
                // Apparently so. Scan for the equals sign.
                (*ppcScanBfr)+=i;
                (*ppcScanBfr)+=strspn(*ppcScanBfr," \t");
                // If the equals sign is found, skip over it, the ensuing white
                // space and begin scanning for the opening double quote char.
                if(**ppcScanBfr=='='){
                    (*ppcScanBfr)++;
                    (*ppcScanBfr)+=strspn(*ppcScanBfr," \t");
                    if(tType==t_str){
                        // If an openning double quote is found, begin searching
                         // for the closing double quote.
                        if(**ppcScanBfr=='\"'){
                            (*ppcScanBfr)+=1;
                            pcScanBfrTmp=strchr(*ppcScanBfr,'\"');
                            // If the closing double quote is found, then exit.
                            // Note that ppcScanBfr points to the beginning of the
                            // sub-string and that its length is returned.
                            if(pcScanBfrTmp){
                                return pcScanBfrTmp-*ppcScanBfr;
                                }
                            else{
                                // If no closing quote is found, the buffer has a
                                // syntax error. Since we have exhausted the bfr,
                                // we have no choice but to return an error.
                                return 0;
                                }
                            }
                        else{
                            // Keep scanning since its possible that the keyword
                            // was found in a comment or a string literal.
                            (*ppcScanBfr)+=1;
                            }
                        }
                    else if(tType==t_hexint){
                        return strspn(*ppcScanBfr,"0123456789ABCDEXabcdex");
                        }
                    else{
                        return strspn(*ppcScanBfr,"0123456789");
                        }
                    }
                else{
                    // Keep scanning since its possible that the keyword
                    // was found in a comment or a string literal.
                    (*ppcScanBfr)+=1;
                    }
                }
            else{
                // It isn't the keyword.
                (*ppcScanBfr)+=i;
                }
            }
        else{
            *ppcScanBfr+=strlen(*ppcScanBfr);
            }
        }
    // The keyword was not found.
    return 0;
}
