/* This is file STAT.H */
/*
** Copyright (C) 1991 DJ Delorie, 24 Kirsten Ave, Rochester NH 03867-2954
**
** This file is distributed under the terms listed in the document
** "copying.dj", available from DJ Delorie at the address above.
** A copy of "copying.dj" should accompany this file; if not, a copy
** should be available from where this file was obtained.  This file
** may not be distributed without a verbatim copy of "copying.dj".
**
** This file is distributed WITHOUT ANY WARRANTY; without even the implied
** warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
*/

#ifndef _STAT_H_
#define _STAT_H_

/* This structure must match the one in go32, so it cannot change */
struct  stat {
        short st_dev;
        short st_ino;
        unsigned short st_mode;
        short st_nlink;
        short st_uid;
        short st_gid;
        short st_rdev;
	short __alignment_filler;
        long  st_size;
        long  st_atime;
        long  st_mtime;
        long  st_ctime;
        long  st_blksize;
};

#define S_IFMT  0xF000  /* file type mask */
#define S_IFDIR 0x4000  /* directory */
#define S_IFFIFO 0x1000 /* FIFO special */
#define S_IFIFO 0x1000 /* FIFO special */
#define S_IFCHR 0x2000  /* character special */
#define S_IFBLK 0x3000  /* block special */
#define S_IFREG 0x8000  /* regular file */

#define S_IREAD		0400  /* owner may read */
#define S_IWRITE	0200 /* owner may write */
#define S_IEXEC		0100  /* owner may execute <directory search> */

#define S_IRUSR		0400
#define S_IWUSR		0200
#define S_IXUSR		0100
#define S_IRWXU		0700

#define S_IRGRP		0040
#define S_IWGRP		0020
#define S_IXGRP		0010
#define S_IRWXG		0070

#define S_IROTH		0004
#define S_IWOTH		0002
#define S_IXOTH		0001
#define S_IRWXO		0007


typedef unsigned short mode_t;

#define S_ISREG(x)      (((x) & S_IFMT) == S_IFREG)
#define S_ISDIR(x)      (((x) & S_IFMT) == S_IFDIR)
#define S_ISCHR(x)      (((x) & S_IFMT) == S_IFCHR)
#define S_ISBLK(x)      (((x) & S_IFMT) == S_IFBLK)
#define S_ISFIFO(x)     (((x) & S_IFMT) == S_IFFIFO)

#ifdef __cplusplus
extern "C" {
#endif

extern int (mkfifo) (const char *, mode_t);
int stat(const char *, struct stat *);
int fstat(int, struct stat *);

#ifdef __cplusplus
}
#endif

#endif
