#include "emu.h"
#include "rmov.h"
#include "compare.h"

void emu_43()
{
  if (empty())
    return;
  if (modrm > 0277)
  {
    emu_bad();
  }
  else
  {
    // fcomp m64real
    reg t;
    r_mov((double *)get_modrm(), t);
    int c = compare(st(), t);
    st().tag = TW_E;
    top++;
    int f;
    if (c & COMP_NAN)
    {
      exception(EX_I);
      f = SW_C3 | SW_C2 | SW_C0;
    }
    else
      switch (c)
      {
        case COMP_A_LT_B:
          f = SW_C0;
          break;
        case COMP_A_EQ_B:
          f = SW_C3;
          break;
        case COMP_A_GT_B:
          f = 0;
          break;
        case COMP_NOCOMP:
          f = SW_C3 | SW_C2 | SW_C0;
          break;
      }
    setcc(f);
  }
}
