*** orig/texinfo-.1/info/session.c	Sun Aug 29 18:41:10 1993
--- src/texinfo-.1/info/session.c	Sun Aug 29 19:01:44 1993
***************
*** 22,29 ****
--- 22,35 ----
     Written by Brian Fox (bfox@ai.mit.edu). */
  
  #include "info.h"
+ #if defined (__GO32__)
+ #include <pc.h>     /* to allow read of single keys by getkey */
+ #include <keys.h>   /* the definitions of the special characters */
+ #endif /* __GO32__ */
  #include <sys/file.h>
+ #if !defined (__GO32__)
  #include <sys/ioctl.h>
+ #endif /* !__GO32__ */
  #include <fcntl.h>
  
  #if defined (HAVE_SYS_TIME_H)
***************
*** 292,298 ****
--- 298,308 ----
  {
    FILE *stream;
  
+ #if defined (__MSDOS__)
+   stream = fopen (filename, "rt");
+ #else /* __MSDOS__ */
    stream = fopen (filename, "r");
+ #endif /* __MSDOS__*/
  
    if (!stream)
      return;
***************
*** 2410,2416 ****
--- 2420,2430 ----
    if (strcmp (output_filename, "-") == 0)
      output_stream = stdout;
    else
+ #if defined (__MSDOS__)
+     output_stream = fopen (output_filename, "wb");
+ #else /* __MSDOS__ */
      output_stream = fopen (output_filename, "w");
+ #endif /* __MSDOS__ */
  
    if (!output_stream)
      {
***************
*** 2535,2541 ****
--- 2549,2559 ----
    if (strcmp (filename, "-") == 0)
      output_stream = stdout;
    else
+ #if defined (__MSDOS__)
+     output_stream = fopen (filename, "wb");
+ #else /* __MSDOS__ */
      output_stream = fopen (filename, "w");
+ #endif /* __MSDOS__ */
  
    if (!output_stream)
      {
***************
*** 4135,4140 ****
--- 4153,4209 ----
      {
        int rawkey;
  
+ #if defined (__GO32__)
+       if (info_input_stream == stdin) {
+         char i;
+         static struct
+         {
+           int inkey;
+           unsigned char outkey1, outkey2;
+         } GO32_keytab[] = {
+           K_Right,          'N', 0,  /* these are for between nodes */
+           K_Left,           'P', 0,  /* they're the Numeric-Keypad-Keys, so */
+           K_Up,             'U', 0,  /* NUMLOCK should be off !! */
+           K_Down,           'M', 0,
+           K_Control_Right,  'F', 0,
+           K_Center,         'L', 0,
+           K_Home,           'T', 0,
+           K_Control_Home,   'D', 0,
+ 
+           K_EHome,      K_Control_A, 0, /* .. and these for moving IN a node */
+           K_EEnd,       K_Control_E, 0,  /* they're the 'extended' keys */
+           K_Eleft,      K_Control_B, 0,
+           K_ERight,     K_Control_F, 0,
+           K_EDown,      K_Control_N, 0,
+           K_EUp,        K_Control_P, 0,
+           K_EPageDown,  SPC, 0,
+           K_EPageUp,    K_Control_Backspace, 0,
+           K_Control_ELeft,  ESC, 'b',
+           K_Control_ERight, ESC, 'f',
+           K_Control_EHome,  'B', 0,
+           K_Control_EEnd,   'E', 0,
+ 
+           0x10f, ESC, TAB,  /* 0x10f is Shift-TAB, misses in KEYS.H */
+           K_Alt_X, ESC, 'X', /* the most/only important M-???-key */
+           K_F1, K_Control_H, 0, /* YEAH, gimme that goodold F-one-thing */
+           K_Delete, K_Control_Backspace, 0, /* to make Delete be DEL (0x7f) */
+           0, 0, 0
+         };
+ 
+         do {
+           rawkey=getxkey();
+           if (rawkey & 0x300) {
+             for (i = 0; GO32_keytab[i].inkey; i++) {
+               if (rawkey == GO32_keytab[i].inkey) {
+                 rawkey = GO32_keytab[i].outkey1;
+                 pending_input_character = GO32_keytab[i].outkey2;
+                 break;
+               }
+             }
+           }
+         } while (rawkey & 0x300);
+       } else
+ #endif /* __GO32__ */
        rawkey = getc (info_input_stream);
        keystroke = rawkey;
  
