/*----------------------------------------------------------------------
 *
 *  boxwin.c
 *
 *  copyright (c) 1987,88,89,90 J. Alan Eldridge
 *
 *  display a boxed window on the screen
 *  
 *----------------------------------------------------------------------
 */

#include "curses.h"

int
boxwin(wptrs, lines, cols, orgy, orgx, v, h)
WINDOW  *wptrs[2];
int     lines, cols, orgy, orgx, v, h;
{
    WINDOW  *frame,
            *win;

    frame = newwin(lines + 2, cols + 2, orgy - 1, orgx - 1);

    if (frame)
        win = subwin(frame, lines, cols, orgy, orgx);
    else
        return ERR;
        
    if (win) {
        box(frame, v, h);
        wrefresh(frame);
        wptrs[0] = frame;
        wptrs[1] = win;
        return OK;
    } else {
        delwin(frame);
        wptrs[0] = wptrs[1] = NULL;
        return ERR;
    }
}
