/**
 ** CUSTLINE.H
 **
 **  Copyright (C) 1992, Csaba Biegl
 **    820 Stirrup Dr, Nashville, TN, 37221
 **    csaba@vuse.vanderbilt.edu
 **
 **  This file is distributed under the terms listed in the document
 **  "copying.cb", available from the author at the address above.
 **  A copy of "copying.cb" should accompany this file; if not, a copy
 **  should be available from where this file was obtained.  This file
 **  may not be distributed without a verbatim copy of "copying.cb".
 **  You should also have received a copy of the GNU General Public
 **  License along with this program (it is in the file "copying");
 **  if not, write to the Free Software Foundation, Inc., 675 Mass Ave,
 **  Cambridge, MA 02139, USA.
 **
 **  This program is distributed in the hope that it will be useful,
 **  but WITHOUT ANY WARRANTY; without even the implied warranty of
 **  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 **  GNU General Public License for more details.
 **/

#include "grx.h"
#include "libgrx.h"
#include "thicklne.h"

void _GrSetupPatternedDraw(GrPattern *p,GrCustomLineData *where)
{
	where->is_XOR_color = IS_XOR_PATTERN(p);
	where->pixelproc = _GrDrawPatternedPixel;
	where->borderproc = _GrDrawPatternedLine;
	where->scanfillproc = _GrFillPatternedScanLine;
	where->fillarg = p;
}

void GrPatternedLine(int x1,int y1,int x2,int y2,GrLinePattern *lp)
{
	GrCustomLineData args;

	_GrBuildCustomLineData(lp->lnp_option,&args);
	_GrSetupPatternedDraw(lp->lnp_pattern,&args);
	_GrDoSingleCustomSegment(x1,y1,x2,y2,&args);
}

