/* Project SWORD
   V2.0

   SubSystem : ToolBox for 3D graphics
   File      : Include/ToolBox/Graph3D/Camera.H
   Author    : Eric NICOLAS
   Overview  : Object TCamera : Characteristic of the observation camera
   UpDate    : Apr  3, 1995 

** Copyright (C) 1993,1995 The SWORD Group
**
** This file is distributed under the terms listed in the document
** "copying.en". A copy of "copying.en" should accompany this file.
** if not, a copy should be available from where this file was obtained.
** This file may not be distributed without a verbatim copy of "copying.en".
**
** This file is distributed WITHOUT ANY WARRANTY; without even the implied
** warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
*/

#ifndef _TOOLBOX_GRAPH3D_CAMERA_H_
#define _TOOLBOX_GRAPH3D_CAMERA_H_

// ----- Objet TCamera

struct TCamera
{ public:
    TPoint3D   Position;
    TPoint3D   Observation;
    float      FocalLength;
    float      N;
  protected:
    float      PositionX;
    float      PositionLens;
    TTransform Transform;
    //
  public:
    void  SetUp();
    float ImageSpot(float ObjetX);
    int   Projection(TPoint3D& P, float &X, float& Y, float& s);
};

#endif // _TOOLBOX_GRAPH3D_CAMERA_H_
