/* Project SWORD
   V2.0

   SubSystem : Mathematical toolbox
   File      : Include/ToolBox/Math/Poly.H
   Author    : Eric NICOLAS
   Overview  : Using vectors as polynomial functions
   UpDate    : May 09, 1995

** Copyright (C) 1993,1995 The SWORD Group
**
** This file is distributed under the terms listed in the document
** "copying.en". A copy of "copying.en" should accompany this file.
** if not, a copy should be available from where this file was obtained.
** This file may not be distributed without a verbatim copy of "copying.en".
**
** This file is distributed WITHOUT ANY WARRANTY; without even the implied
** warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
*/

#ifndef _TOOLBOX_MATH_POLY_H_
#define _TOOLBOX_MATH_POLY_H_

struct TPoly : TVector
{ TPoly(int Degree=1);
  complex Evaluate(complex X);
  TPoly   Factor(complex X0);
  TPoly   Differentiate(void);
  int     Degree(void);
  float	  Radius(void);
  complex Solve(void);
};

#endif // _TOOLBOX_MATH_POLY_H_
