/* Project SWORD
   V2.0

   SubSystem : Interface with IntList INTERRUP.LST file
   File      : Src/ToolBox/IntList/IDXView.CC
   Author    : Eric NICOLAS
   Overview  : TIndexScroller, TIndexView object : Show IntList index part
   UpDate    : Nov 13, 1995

** Copyright (C) 1993,1995 The SWORD Group
**
** This file is distributed under the terms listed in the document
** "copying.en". A copy of "copying.en" should accompany this file.
** if not, a copy should be available from where this file was obtained.
** This file may not be distributed without a verbatim copy of "copying.en".
**
** This file is distributed WITHOUT ANY WARRANTY; without even the implied
** warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
*/

#include "Common/Common.H"
#include "Mecanism/Mecanism.H"
#include "Graphics/Graphics.H"
#include "Drawings/Drawings.H"
#include "Gadgets/Gadgets.H"
#include "Tools/Tools.H"
#include "ToolBox/IntList/Index.H"
#include "ToolBox/IntList/IDXView.H"

// Locals vars

static char TempStr[500];

// --- TIndexScroller  object

short RegTIndexScroller;
char *IdentTIndexScroller = "TIndexScroller";

TIndexScroller::TIndexScroller() : TTextScroller()
{ Init();
}

TIndexScroller::TIndexScroller(int X, int Y, int L, int H, TLift *_Horiz, TLift *_Vert) :
   TTextScroller(X,Y,L,H,_Horiz,_Vert)
{ Init();
}

TIndexScroller::TIndexScroller(TRect& R, TLift *_Horiz, TLift *_Vert) :
   TTextScroller(R,_Horiz,_Vert)
{ Init();
}

void TIndexScroller::Init(void)
{ Register=RegTIndexScroller;
  Ident=IdentTIndexScroller;
  // Initialise les entres valides ou non
  int     i,N=0;
  boolean Valid;
  Entries=new TBitField(IDXEntriesNumber);
  BeginPhase("Extracting IntList Index");
  for(i=0;i<IDXEntriesNumber;i++)
  { if (EntryValid(i))
    { N++;
      Entries->SetBit(i);
    }
    else Entries->ClearBit(i);
    AvancePhase((int)1.*i*100/(IDXEntriesNumber-1));
  }
  EndPhase();
  // Positionne le nombre de lignes utiles
  SetTextSize(150,N);
}

TIndexScroller::~TIndexScroller(void)
{ delete Entries;
}

char *TIndexScroller::GetText(int Line)
{ int N=0,i;
  // Cerche le n de l'entre  charger
  while(Entries->GetBit(N)==FALSE) N++;
  for(i=0;i<Line;i++)
  { N++;
    while(Entries->GetBit(N)==FALSE) N++;
  }
  // Charge l'entre
  TIntListIDX Entry;
  GetIntListIDX(&Entry,N);
  // Construit le texte
  BuildIntListIDXDescription(&Entry,TempStr);
  strcat(TempStr," - ");
  strcat(TempStr,Entry.Title);
  // Coupe  150 Caractres
  TempStr[150]=0;
  return TempStr;
}

boolean TIndexScroller::EntryValid(int )
{ return TRUE;
}

// --- TCatIndexScroller  object

short RegTCatIndexScroller;
char *IdentTCatIndexScroller = "TCatIndexScroller";

TCatIndexScroller::TCatIndexScroller() : TIndexScroller()
{ Init(0);
}

TCatIndexScroller::TCatIndexScroller(int X, int Y, int L, int H, TLift *_Horiz, TLift *_Vert, char _Category) :
   TIndexScroller(X,Y,L,H,_Horiz,_Vert)
{ Init(_Category);
}

TCatIndexScroller::TCatIndexScroller(TRect& R, TLift *_Horiz, TLift *_Vert, char _Category) :
   TIndexScroller(R,_Horiz,_Vert)
{ Init(_Category);
}

void TCatIndexScroller::Init(char _Category)
{ Register=RegTCatIndexScroller;
  Ident=IdentTCatIndexScroller;
  //
  Category=_Category;
}

boolean TCatIndexScroller::EntryValid(int NEntry)
{ TIntListIDX Entry;
  GetIntListIDX(&Entry,NEntry);
  return boolean(Entry.Category==Category);
}
