/* Project SWORD
   V2.0

   SubSystem : Interface with IntList INTERRUP.LST file
   ErrNos    : 3000..3099
   File      : Src/ToolBox/IntList/Index.CC
   Author    : Eric NICOLAS
   Overview  : Using the IntList Index INTERRUP.IDX
   UpDate    : Nov 13, 1995

** Copyright (C) 1993,1995 The SWORD Group
**
** This file is distributed under the terms listed in the document
** "copying.en". A copy of "copying.en" should accompany this file.
** if not, a copy should be available from where this file was obtained.
** This file may not be distributed without a verbatim copy of "copying.en".
**
** This file is distributed WITHOUT ANY WARRANTY; without even the implied
** warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
*/

#include "Common/Common.H"
#include "Mecanism/Mecanism.H"
#include "ToolBox/IntList/Index.H"

// Globals

long IDXEntriesNumber;

// Locals

static TDisk *FileIDX;

static char *Messages[2] =
      { "Interrupt List file missing. Check SWORD/INTLIST directory.",
        "Wrong Interrupt List index entry requested."
      };


// Functions

void BuildIntListIDXDescription(TIntListIDX *Entry, char *Str)
{ char Temp[20];
  sprintf(Str,"INT %02X - ",Entry->IntNo);
  // First Number
  switch(strlen(Entry->FstNumber))
  { case 4 : sprintf(Temp,"AX=%s ",Entry->FstNumber); break;
    case 2 : sprintf(Temp,"AH=  %s ",Entry->FstNumber); break;
    default: strcpy(Temp,"        ");
  }
  strcat(Str,Temp);
  // Second Number
  switch(strlen(Entry->SecNumber))
  { case 4 : sprintf(Temp,"; %s=%s ",Entry->SecReg,Entry->SecNumber); break;
    case 2 : sprintf(Temp,"; %s=  %s ",Entry->SecReg,Entry->SecNumber); break;
    default: strcpy(Temp,"          "); break;
  }
  strcat(Str,Temp);
}

void GetIntListIDX(TIntListIDX *Entry, int N)
{ if ((N<0)||(N>=IDXEntriesNumber))
  { Error=erIntListWrongEntryNo;
    return;
  }
  FileIDX->Seek(sizeof(TIntListIDX)*N+sizeof(long),stBegining);
  FileIDX->Read(Entry,sizeof(TIntListIDX));
}

// ===== Gestion locale des erreurs =========================================

static boolean ErrorMessages(char *Message)
{ int MessageNo;
  switch(Error)
  { case erIntListFilesMissing : MessageNo=0;   break;
    case erIntListWrongEntryNo : MessageNo=1;   break;
    default:
      return FALSE;
  }
  strcpy(Message,Messages[MessageNo]);
  return TRUE;
}

// ===== Init/Done de l'unit ===============================================

void InitIDX(void)
{ char FileName[200];
  // Add Error handler
  AddErrorHandler(ErrorMessages);
  // Build Index File Name
  sprintf(FileName,"%sINTLIST/INTERRUPT.IDX",SwordPath);
  // Open the file
  FileIDX=new TDisk(FileName,stOpen);
  if (Error)
  { Error=erIntListFilesMissing;
    FatalError();
  }
  // Get the number of entries
  FileIDX->Read(&IDXEntriesNumber,sizeof(long));
}

void DoneIDX(void)
{ // Close the file
  delete FileIDX;
}
