/* Project SWORD
   V2.0

   SubSystem : Main program objects
   File      : Src/Tools/App.CC
   Author    : Eric NICOLAS
   Overview  : TApp object : The application
   UpDate    : Oct 17, 1995

** Copyright (C) 1993,1995 The SWORD Group
**
** This file is distributed under the terms listed in the document
** "copying.en". A copy of "copying.en" should accompany this file.
** if not, a copy should be available from where this file was obtained.
** This file may not be distributed without a verbatim copy of "copying.en".
**
** This file is distributed WITHOUT ANY WARRANTY; without even the implied
** warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
*/

#include "Sword.H"

TApp::TApp(char *argv0) : TShell()
{ InitCommon(argv0);
  InitMecanism();
  InitSBlaster();
//  InitToolBoxIntList();
  printf("\nPress a key...\n");
  getch();
  InitGraphics();
  InitDrawings();
  InitGadgets();
  InitTools();
  InitToolBoxImage();

  // Cration du bureau virtuel
  Insert(new TStdDesktop());
}

TApp::~TApp()
{ DoneToolBoxImage();
  DoneTools();
  DoneGadgets();
  DoneDrawings();
  DoneGraphics();
//  DoneToolBoxIntList();
  DoneSBlaster();
  DoneMecanism();
  DoneCommon();
}

void TApp::Run(void)
{ EventsLoop(this);
}

boolean TApp::KeyDown(int ScanCode)
{ if (TShell::KeyDown(ScanCode)) return TRUE;
  if (MainMenu!=NULL) return ProcessMenuHotKey(ScanCode, MainMenu);
  return FALSE;
}

boolean TApp::ProcessMenuHotKey(int ScanCode, TMenu* Menu)
{ TMenuChoice *MC=Menu->FirstChoice();
  while(MC!=NULL)
  { if (MC->SubMenu!=NULL)
    { // Teste les choix des sous-menus
      if (ProcessMenuHotKey(ScanCode, MC->SubMenu)) return TRUE;
    }
    else
    { // Teste la HotKey
      if (ScanCode==MC->GlobalScanCode)
      { SetCommand(MC->Command);
        return TRUE;
      }
    }
    MC=MC->NextChoice();
  }
  return FALSE;
}
