/* $Id: find.c,v 1.3 2003/03/02 18:44:09 richdawe Exp $ */

/*
 * find.c - Test program for libpakke's find_* functions
 * Copyright (C) 2002, 2003 by Richard Dawe
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include <libpakke/util.h>

/* --------
 * - main -
 * -------- */

int
main (int argc, char *argv[])
{
  char *file         = NULL;
  char *dir          = NULL;
  char *dirs[2]      = { NULL, NULL };
  char *expected_res = NULL;
  char *res          = NULL;
  int   verbose        = 0;
  int   i;

  if (argc < 4) {
    fprintf(stderr,
	    "Syntax: %s [-q] <file> <base directory> <expected result>\n",
	    argv[0]);
    return(EXIT_FAILURE);
  }

  /* Verbose operation, for manual testing. */
  if (   (getenv("VERBOSE") != NULL)
      && (strcmp(getenv("VERBOSE"), "n") != 0))
    verbose = 1;

  /* Parse arguments. */
  for (i = 1; i < argc; i++) {
    /* Verbose operation, for manual testing. */
    if (   (strcmp(argv[i], "--verbose") == 0)
	|| (strcmp(argv[i], "-v") == 0))
      verbose = 1;
    else if (file == NULL)
      file = argv[i];
    else if (dir == NULL)
      dir = argv[i];
    else if (expected_res == NULL)
      expected_res = argv[i];
  }

  /* Test */
  dirs[0] = dir;

  res = find_archive(file, NULL, (const char **) dirs);

  if (strcmp(res, expected_res) != 0) {
    if (verbose)
      fprintf(stderr, "Expected '%s'; got '%s' - FAIL\n", expected_res, res);

    return(EXIT_FAILURE);
  }

  return(EXIT_SUCCESS);
}
