%{
/* $Id: rc.y,v 1.3 2001/04/18 21:26:37 richdawe Exp $ */

#include <stdlib.h>

#include "rcfile.h"

rc_resource_t res = RC_NONE;
%}

%union {
  char *str;
}

%token TOK_INSTALLED
%token TOK_AVAILABLE
%token TOK_MFT
%token TOK_DSM

%token TOK_ZIP
%token TOK_TAR_GZIP

%token TOK_PROXY
%token TOK_HTTP
%token TOK_FTP

%token TOK_FROM
%token TOK_USING
%token TOK_OR

%token <str> TOK_PATH
%token <str> TOK_URL

%token TOK_EOL

%%

DEFINITION:
  /* empty */
| INSTALLED_MFT TOK_EOL DEFINITION
| INSTALLED_DSM TOK_EOL DEFINITION
| AVAILABLE_DSM TOK_EOL DEFINITION
| ZIP           TOK_EOL DEFINITION
| TAR_GZIP      TOK_EOL DEFINITION
| HTTP_PROXY    TOK_EOL DEFINITION
| FTP_PROXY     TOK_EOL DEFINITION
|               TOK_EOL DEFINITION
| error         TOK_EOL DEFINITION
;

PATH: TOK_PATH { rcfile_add_resource(res, $1); };
URL:  TOK_URL  { rcfile_add_resource(res, $1); };

PATHS:
  PATH
| PATH TOK_OR PATHS
;

URLS:
  URL
| URL TOK_OR URLS
;

PATHS_OR_URLS:
  PATH
| URL
| PATH TOK_OR PATHS_OR_URLS
| URL  TOK_OR PATHS_OR_URLS
;

/* Preludes, to set 'res' correctly. */
INSTALLED_MFT_PRE: TOK_INSTALLED TOK_MFT  { res = RC_INSTALLED_MFT; };
INSTALLED_DSM_PRE: TOK_INSTALLED TOK_DSM  { res = RC_INSTALLED_DSM; };
AVAILABLE_DSM_PRE: TOK_AVAILABLE TOK_DSM  { res = RC_AVAILABLE_DSM; };
ZIP_PRE:           TOK_ZIP                { res = RC_ZIP; };
TAR_GZIP_PRE:      TOK_TAR_GZIP           { res = RC_TAR_GZIP; };
FTP_PROXY_PRE:     TOK_PROXY     TOK_FTP  { res = RC_FTP_PROXY; };
HTTP_PROXY_PRE:    TOK_PROXY     TOK_HTTP { res = RC_HTTP_PROXY; };

INSTALLED_MFT: INSTALLED_MFT_PRE TOK_FROM  PATHS;
INSTALLED_DSM: INSTALLED_DSM_PRE TOK_FROM  PATHS;
AVAILABLE_DSM: AVAILABLE_DSM_PRE TOK_FROM  PATHS ;
ZIP:           ZIP_PRE           TOK_FROM  PATHS_OR_URLS;
TAR_GZIP:      TAR_GZIP_PRE      TOK_FROM  PATHS_OR_URLS;
FTP_PROXY:     FTP_PROXY_PRE     TOK_USING URLS;
HTTP_PROXY:    HTTP_PROXY_PRE    TOK_USING URLS;

%%
