/* $Id: uinstall.h,v 1.9 2001/08/05 14:26:53 richdawe Exp $ */

/*
 *  uinstall.h - Header for uninstall routines for zippo
 *  Copyright (C) 1999-2001 by Richard Dawe
 *      
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef __zippo_uninstall_h__
#define __zippo_uninstall_h__

#include <libzippo/package.h>

/* TODO: Sort out MD5 hash header */
#include "md5hash.h"

/* Install modifiers */
enum {
  UM_NONE = 0x00,
  UM_TEST = 0x01
};

/* remove-action */
/* TODO: Should remove-action be in the DSM spec? */
/* This is analogous to 'duplicate-action'. 'remove-action' does not exist
 * in the DSM spec (yet?), so do something sensible for removing files. */
enum {
  REMOVE_REMOVE = 0x01,
  REMOVE_KEEP   = 0x02,
  REMOVE_BACKUP = 0x04,
  REMOVE_QUERY  = 0x08,
  REMOVE_ABORT  = 0x10
};

/* --- Structures --- */

/* Install data */
typedef struct {
  int	 op;            /* Uninstall operation              */
  int	 mod;           /* Uninstall modifier               */
  int	 verbosity;     /* Uninstall verbosity              */
  char	*root;          /* DJGPP/spec'd root directory      */
  char  *prefix;        /* Prefix to uninstall package from */
  char  *backup_prefix; /* Prefix to store backups under    */
  char	*name;          /* Uninstall package name           */
  char **dsm_path;      /* Uninstalled DSM file list        */
  char **mft_path;      /* Uninstalled manifest file list   */
} ZIPPO_UNINSTALL;

/* --- Functions --- */
extern int perform_uninstall (ZIPPO_UNINSTALL *req);

extern int uninstall_show_changed_files (PACKAGE_INFO *package,
					 const char *db_path,
					 const char *prefix);

extern int uninstall_md5_hashed_files (PACKAGE_INFO *package,
				       const int verbosity,
				       const char *prefix,
				       const char *backup_prefix,
				       md5hash_entry **list,
				       const int remove_action);

extern int uninstall_unhashed_files (PACKAGE_INFO *package,
				     const int verbosity,
				     const char *prefix,
				     const char *backup_prefix,
				     const char **mft_path,
				     const int remove_action);

/* uninstall_info_entries() is actually defined in src/install.c. */
extern int uninstall_info_entries (PACKAGE_INFO *package,
				   const char *db_path,
				   const char *prefix);

extern int uninstall_tidy_up (PACKAGE_INFO *package, const char *db_path);

#endif	/* __zippo_uninstall_h__ */
