// aexecupd.h - defines main autoexec.bat update class, autoexec_update.
//    Copyright (C) 2000 Laurynas Biveinis <lauras@softhome.net>
//
//    This program is free software; you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation; either version 2 of the License, or
//    (at your option) any later version.
//
//    This program is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with this program; if not, write to the Free Software
//    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//
#ifndef AEXECUPD_H_
#define AEXECUPD_H_

#include "global.h"

#define Uses_TDialog
#define Uses_TEvent
#define Uses_TFileEditor
#define Uses_TScrollBar
#include <rhtvision/tv.h>

class autoexec_update : public TDialog
{
   public:
      autoexec_update(void);

      virtual void    handleEvent(TEvent & what);
      int             update(const char * dir);
      virtual Boolean valid(ushort command);
      
   private:
      void save_editor(const TEditor & editor, const char * file_name);
   
      TScrollBar *  old_h_sb;
      TScrollBar *  old_v_sb;
      TScrollBar *  new_h_sb;
      TScrollBar *  new_v_sb;
      TFileEditor * old_editor;
      TFileEditor * new_editor;
};

#endif // #ifndef AEXECUPD_H_
