/* $Id: specpath.c,v 1.1 2002/05/04 10:41:38 richdawe Exp $ */

/*
 * specpath.c - Test program for libzippo's isspecialpath function
 * Copyright (C) 2002 by Richard Dawe
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include <libzippo/util.h>

typedef struct {
  const char *path;
  const int   special;
} testcase_t;

static testcase_t testcases[] = {
#ifdef __DJGPP__
  /* Path components that don't map to real paths */
  { "/dev", 1 },
  { "/dev/", 1 },
  { "/dev/something", 1 },
  { "/dev/something/", 1 },
  { "/dev/env", 1 },
  { "/dev/env/", 1 },

  /* Paths that map to real paths */
  { "/dev/env/DJDIR", 0 },
  { "/dev/env/DJDIR/", 0 },
  { "/dev/c", 0 },
  { "/dev/c/", 0 },
  { "/develop", 0 },
  { "/develop/", 0 },
#endif /* __DJGPP__ */
  { NULL, 0 }
};

/* --------
 * - main -
 * -------- */

int
main (int argc, char *argv[])
{
  int quiet = 0;
  int ok = 1; /* Succeed by default */
  int i, ret;

  /* Parse arguments. */
  for (i = 1; i < argc; i++) {
    /* Quiet operation, for automatic testing. */
    if (   (strcmp(argv[i], "--quiet") == 0)
	|| (strcmp(argv[i], "-q") == 0))
      quiet = 1;
  }

  /* Run the test cases */
  for (i = 0; testcases[i].path != NULL; i++) {
    ret = isspecialpath(testcases[i].path);

    if (!quiet)
      printf("Test case %d: %s: ", i, testcases[i].path);

    if (ret == testcases[i].special) {
      if (!quiet)
	printf("OK - found %s\n", ret ? "special" : "non-special");
    } else {
      if (!quiet) {
	printf("FAILED - found %s, expected %s\n",
	       ret                  ? "special" : "non-special",
	       testcases[i].special ? "special" : "non-special");
      }

      /* Failed */
      ok = 0;
    }
  }

  if (!ok)
    return(EXIT_FAILURE);

  return(EXIT_SUCCESS);
}
