//**************************************************************************
// PROGRAM NAME : MXLODER.C, FOR MXLODER.EXE.  REVISED DATE : 8/14/2001.
// Mxloder.c Version 2.0, a full 32 bit protected mode loader PROGRAM.
// Used for the chain program loading operations in versions 1.5.5 GXV only.
//**************************************************************************
//
//**************************************************************************
// Date Revised : March 16, 2003
//**************************************************************************
//
// ***********************************************
// [ Appendix: Terms Conditions and Aggreements ]
// ***********************************************
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
//
// Author       : JOHN F. CLARK JR.
// I can be contacted by mail at......
// Address      : 11-15 Port Richmond Av. Staten Island, NY 10302
//
//
//                       TERMS AND CONDITIONS
// ----------------------------------------------------------------------------
//                         NO WARRANTY
// BECAUSE THIS PROGRAM IS LICENSED FREE OF CHARGE, THERE IS NO WARRANTY
// FOR THE PROGRAM, TO THE EXTENT PERMITTED BY APPLICABLE LAW.  EXCEPT WHEN
// OTHERWISE STATED IN WRITING THE COPYRIGHT HOLDERS AND/OR OTHER PARTIES
// PROVIDE THE PROGRAM "AS IS" WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED
// OR IMPLIED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
// MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.  THE ENTIRE RISK AS
// TO THE QUALITY AND PERFORMANCE OF THE PROGRAM IS WITH YOU.  SHOULD THE
// PROGRAM PROVE DEFECTIVE, YOU ASSUME THE COST OF ALL NECESSARY SERVICING,
// REPAIR OR CORRECTION.
//
// IN NO EVENT UNLESS REQUIRED BY APPLICABLE LAW OR AGREED TO IN WRITING
// WILL ANY COPYRIGHT HOLDER, OR ANY OTHER PARTY WHO MAY MODIFY AND/OR
// REDISTRIBUTE THE PROGRAM AS PERMITTED ABOVE, BE LIABLE TO YOU FOR DAMAGES,
// INCLUDING ANY GENERAL, SPECIAL, INCIDENTAL OR CONSEQUENTIAL DAMAGES ARISING
// OUT OF THE USE OR INABILITY TO USE THE PROGRAM (INCLUDING BUT NOT LIMITED
// TO LOSS OF DATA OR DATA BEING RENDERED INACCURATE OR LOSSES SUSTAINED BY
// YOU OR THIRD PARTIES OR A FAILURE OF THE PROGRAM TO OPERATE WITH ANY OTHER
// PROGRAMS), EVEN IF SUCH HOLDER OR OTHER PARTY HAS BEEN ADVISED OF THE
// POSSIBILITY OF SUCH DAMAGES.
//                     END OF TERMS AND CONDITIONS
// ----------------------------------------------------------------------------
//
// ***********************************************************
// ***********************************************************
// [ MAIN PROGRAM FOR Mxloder.c Version 2.2  Accessor System ]
// [ Loader For Micro-x Accessor System Version 1.5.5 GXV... ]
// ***********************************************************
// ***********************************************************
// -------------------------------------------
// [ Mxloder.c's header file include section ]
// -------------------------------------------
#include <stdio.h>
#include <conio.h>
#include <stdlib.h>
#include <string.h>
#include <strings.h>
#include <dpmi.h>
#include <go32.h>
#include <libc.h>
#include <dos.h>
#include <dir.h>
#include <keys.h>
#include <pc.h>
#include <fcntl.h>
#include <errno.h>
#include <bios.h>
#include <unistd.h>
#include <sys/stat.h>
#include <process.h>

#define BITMASK1 (0x5C)
#define BITMASK2 (0x2F)

// Mxloder.c's Function Definition Section ...
void Err_Handler(int ER_FLG, char mxfile[16]);
void mem_check();
void close_exit(void);

// Global Variables declaration Section ...
int video_mode = 0;
int Idel_lop = 1;
char home_drv_letter[2];
char user_drv_letter[2];
char *current_path;
unsigned *scrn_buf;
int LocalScrn_y = 0;
int LocalScrn_x = 0;
int current_drive = 0;
int home_drv_number = 0; 
int user_drv_number = 0;

// Start of Mxloder Main Program ...
int main(int argc, char **argv)
{
   _go32_dpmi_registers r;
   int a, y, x;
   FILE *fp;
   int ERR_FLAG = 0;
   char prg_name[130];
   char prg_id[130];
   char home_dir[130];
   extern int viedo_mode;
   signed int prg_rt_code;
   char mx_main[ ] = "MX155.EXE 60795MX155";
   char mx_mainid[ ] = "60795MX155";
   char mx_lod_86[ ] = "MX155.EXE 60796MX155";
   char mx_lod_86id[ ] = "60796MX155";
   char mx_lod_87[ ] = "MX155.EXE 60797MX155";
   char mx_lod_87id[ ] = "60797MX155";
   char mx_lod_88[ ] = "MX155.EXE 60798MX155";
   char mx_lod_88id[ ] = "60798MX155";
   char mx_lod_exit[ ] = "MAINEXIT60795XMX155ACC";
   char user_req[200];
   char corect_path[200];
   char *path_buf = (char*) alloca(200);
   char mxfile[16];
   char tmpset[164];
   int handle = 0;
   unsigned int result = 0;
   int ER_FLG = 0;
   int prg_rtrn_code = 0;
   int prg_zpass = 999;

   extern char **environ;

  _fmode = O_BINARY;
   fflush(stdout);
   fflush(stdin);
   scrn_buf = (unsigned *)alloca(ScreenRows()*ScreenCols()*2);
   current_path = (char *)alloca(128);
   getcwd(current_path, 128);
   current_drive = getdisk();
   a = 0;
   x = 0;
//........
    if (strlen(argv[1]) > 127)
    {
      ER_FLG = 2;
      Err_Handler(ER_FLG, mxfile);
      exit(0);
   }
//........
   if (strlen(argv[1]) == NULL)
   {
     ER_FLG = 2;
     Err_Handler(ER_FLG, mxfile);
     exit(0);
   }
//........
   if ((argc >= 3) || (argc == 0))
   {
     ER_FLG = 2;
     Err_Handler(ER_FLG, mxfile);
     exit(0);
   }
// .......
   fp = fopen("accs.tmp", "w");
   if(fp == NULL)
   {
     ER_FLG = 4;
     Err_Handler(ER_FLG, mxfile);
     exit(0);
   }
   fprintf(fp, "%s", argv[1]);
   fclose(fp);
   fp = fopen("accs.tmp", "r");
   fscanf(fp, "%s", home_dir);
   fclose(fp);
   remove("accs.tmp");
//........
   if(strcmp(home_dir,"/?") == 0)
   {
     ER_FLG = 3;
     Err_Handler(ER_FLG, home_dir);
     exit(0);
   }
//.........
   if (chdir(home_dir))
   {
     ER_FLG = 2;
     Err_Handler(ER_FLG, mxfile);
     perror(home_dir);
     exit(0);
   }
//........
   if (!__file_exists("MX155.EXE"))
   {
     ER_FLG = 1;
     strcpy(mxfile, "Mx155.exe");
     Err_Handler(ER_FLG, mxfile);
     exit(0);
   }
//........
   if (!__file_exists("MX155LCH.CFG"))
   {
     ER_FLG = 1;
     strcpy(mxfile, "Mx155lch.cfg");
     Err_Handler(ER_FLG, mxfile);
     exit(0);
   }
//........
   if (!__file_exists("ACCMMAIN.CFF"))
   {
     ER_FLG = 1;
     strcpy(mxfile, "Accmmain.cff");
     Err_Handler(ER_FLG, mxfile);
     exit(0);
   }
//........
   if (!__file_exists("ACCMSUB1.CFF"))
   {
     ER_FLG = 1;
     strcpy(mxfile, "Accmsub1.cff");
     Err_Handler(ER_FLG, mxfile);
     exit(0);
   }
//........
   if (!__file_exists("ACCMSUB2.CFF"))
   {
     ER_FLG = 1;
     strcpy(mxfile, "Accmsub2.cff");
     Err_Handler(ER_FLG, mxfile);
     exit(0);
   }
//........
   if (!__file_exists("ACCMSUB3.CFF"))
   {
     ER_FLG = 1;
     strcpy(mxfile, "Accmsub3.cff");
     Err_Handler(ER_FLG, mxfile);
     exit(0);
   }
//........
   if (!__file_exists("MXED.CFG"))
   {
     ER_FLG = 1;
     strcpy(mxfile, "Mxed.cfg");
     Err_Handler(ER_FLG, mxfile);
     exit(0);
   }
//........
   if (!__file_exists("MXLHWS.COM"))
   {
     ER_FLG = 1;
     strcpy(mxfile, "Mxlhws.com");
     Err_Handler(ER_FLG, mxfile);
     exit(0);
   }
// Main program INI startup ...
   video_mode = ScreenMode();
   LocalScrn_y = wherey();
   LocalScrn_x = wherex();
   ScreenRetrieve(scrn_buf);
   textmode(C80);
   gppconio_init();
   ScreenClear();
   ScreenSetCursor(0, 0);
   cprintf("Mxloder Version 2.0 Program Loader.  By John F. Clark Jr.\n\r");
   cprintf("Designed For The Micro-x Accessor System Version 1.5.5 GXV.\n\r");
// ..........
    if(!_dos_open("MX155LCH.CFG", O_RDONLY, &handle) )
    {
      if(_dos_read(handle, path_buf, 200, &result) != 0)
      {
        ER_FLG =  1;
        strcpy(mxfile, "Mx155lch.cfg");
        Err_Handler(ER_FLG, mxfile);
        _dos_close(handle);
        close_exit();
      }
    }
    _dos_close(handle);
    strcpy(prg_name, path_buf + 184);
// ........
   home_drv_letter[0] = home_dir[0];
   home_drv_number = (toupper(home_drv_letter)) - 'A';
// ........
   while (Idel_lop == 1)
   {
     setdisk(home_drv_number);
     chdir(home_dir);
     prg_rtrn_code = system("MXLHWS.COM");
     prg_rtrn_code = 0;
     if (strcmp(prg_name, mx_mainid) == 0)
     {
       cprintf("Mxloder ... Program Loading In Process For ...\n\r");
       cprintf("Micro-x Main Accessor System  ( Main Operation )\n\r\n\r");
       prg_rtrn_code = system(mx_main);
       if (prg_rtrn_code != 0)
       {
         ScreenClear();
         ScreenSetCursor(0, 0);
         cprintf("Mxloder ... Exit From Micro-x Main Accessor System ... ( Main Operation )\n\r\n\r");
         cprintf("!! ERROR !!  on program return.\n\r");
         cprintf("Program Return Code = %d\n\r", prg_rtrn_code);
         cprintf("------------------------------------------------------------------------\n\r\n\r");
         close_exit();
       }
       if (prg_rtrn_code == 0)
       {
         ScreenClear();
         ScreenSetCursor(0, 0);
         cprintf("Mxloder ... Exit From Micro-x Main Accessor System ... ( Main Operation )\n\r\n\r");
         cprintf("No Error on program return.\n\r");
         cprintf("Program Return Code = %d\n\r", prg_rtrn_code);
         cprintf("------------------------------------------------------------------------\n\r\n\r");
       }
// ........
     }
     if (strcmp(prg_name, mx_lod_86id) == 0)
     {
       cprintf("Mxloder ... Program Loading In Process For ...\n\r");
       cprintf("Micro-x Main Accessor System  ( Sub#1 Operation )\n\r\n\r");
       mem_check();
       prg_rtrn_code = system(mx_lod_86);
       if (prg_rtrn_code != 0)
       {
         ScreenClear();
         ScreenSetCursor(0, 0);
         cprintf("Mxloder ... Exit From Micro-x Main Accessor System ... ( Sub#1 Operation )\n\r\n\r");
         cprintf("!! ERROR !!  on program return.\n\r");
         cprintf("Program Return Code = %d\n\r", prg_rtrn_code);
         cprintf("------------------------------------------------------------------------\n\r\n\r");
         close_exit();
       }
       if (prg_rtrn_code == 0)
       {
         ScreenClear();
         ScreenSetCursor(0, 0);
         cprintf("Mxloder ... Exit From Micro-x Main Accessor System ... ( Sub#1 Operation )\n\r\n\r");
         cprintf("No Error on program return.\n\r");
         cprintf("Program Return Code = %d\n\r", prg_rtrn_code);
         cprintf("------------------------------------------------------------------------\n\r\n\r");
       }
// ........
     }
// ........
     if (strcmp(prg_name, mx_lod_87id) == 0)
     {
       cprintf("Mxloder ... Program Loading In Process For ...\n\r");
       cprintf("Micro-x Main Accessor System  ( Sub#2 Operation )\n\r\n\r");
       mem_check();
       prg_rtrn_code = system(mx_lod_87);
       if (prg_rtrn_code != 0)
       {
         ScreenClear();
         ScreenSetCursor(0, 0);
         cprintf("Mxloder ... Exit From Micro-x Main Accessor System ... ( Sub#2 Operation )\n\r\n\r");
         cprintf("!! ERROR !!  on program return.\n\r");
         cprintf("Program Return Code = %d\n\r", prg_rtrn_code);
         cprintf("------------------------------------------------------------------------\n\r\n\r");
         close_exit();
       }
       if (prg_rtrn_code == 0)
       {
         ScreenClear();
         ScreenSetCursor(0, 0);
         cprintf("Mxloder ... Exit From Micro-x Main Accessor System ... ( Sub#2 Operation )\n\r\n\r");
         cprintf("No Error on program return.\n\r");
         cprintf("Program Return Code = %d\n\r", prg_rtrn_code);
         cprintf("------------------------------------------------------------------------\n\r\n\r");
       }
// ........
     }
// ........
     if (strcmp(prg_name, mx_lod_88id) == 0)
     {
       cprintf("Mxloder ... Program Loading In Process For ...\n\r");
       cprintf("Micro-x Main Accessor System  ( Sub#3 Operation )\n\r\n\r");
       mem_check();
       prg_rtrn_code = system(mx_lod_88);
       if (prg_rtrn_code != 0)
       {
         ScreenClear();
         ScreenSetCursor(0, 0);
         cprintf("Mxloder ... Exit From Micro-x Main Accessor System ... ( Sub#3 Operation )\n\r\n\r");
         cprintf("!! ERROR !!  on program return.\n\r");
         cprintf("Program Return Code = %d\n\r", prg_rtrn_code);
         cprintf("------------------------------------------------------------------------\n\r\n\r");
         close_exit();
       }
       if (prg_rtrn_code == 0)
       {
         ScreenClear();
         ScreenSetCursor(0, 0);
         cprintf("Mxloder ... Exit From Micro-x Main Accessor System ... ( Sub#3 Operation )\n\r\n\r");
         cprintf("No Error on program return.\n\r");
         cprintf("Program Return Code = %d\n\r", prg_rtrn_code);
         cprintf("------------------------------------------------------------------------\n\r\n\r");
       }
// ........
     }
// ..........
    if(!_dos_open("MX155LCH.CFG", O_RDONLY, &handle) )
    {
      if(_dos_read(handle, path_buf, 200, &result) != 0)
      {
        ER_FLG =  1;
        strcpy(mxfile, "Mx155lch.cfg");
        Err_Handler(ER_FLG, mxfile);
        _dos_close(handle);
        close_exit();
      }
    }
    _dos_close(handle);
    strcpy(user_req, path_buf + 4);
    strcpy(prg_name, path_buf + 184);
// ........
     if (strncmp(user_req, mx_lod_exit, 22) == 0)
     {
        r.h.ah = 0x00;
        r.h.al = video_mode;
        r.x.ss = r.x.sp = 0x00;
        _go32_dpmi_simulate_int(0x10, &r);
        if (LocalScrn_y >= 25)
        {
           LocalScrn_y -= 1;
        }
        if (LocalScrn_x >= 80)
        {
          LocalScrn_x -= 1;
        }
        close_exit();
     }
// ........
     if (strncmp(user_req, mx_lod_86, 20) == 0)
     {
        strcpy(prg_name, mx_lod_86id);
        prg_zpass = 0;
     }
// ........
     if (strncmp(user_req, mx_lod_87, 20) == 0)
     {
        strcpy(prg_name, mx_lod_87id);
        prg_zpass = 0;
     }
// ........
     if (strncmp(user_req, mx_lod_88, 20) == 0)
     {
        strcpy(prg_name, mx_lod_88id);
        prg_zpass = 0;
     }
// ........
     if (prg_zpass != 0)
     {
       strcpy(corect_path, user_req);
       x = 0;
       y = 0;
       x = strcspn(corect_path, ".");
       if(x != 0)
       {
        corect_path[x] = '\0';
       }
// ........
       y = strlen(corect_path);
       x = y;
       while(x != 0)
       {
        if(corect_path[y] == BITMASK1)
        {
         corect_path[y] = '\0';
         break;
        }
        if(corect_path[y] == BITMASK2)
        {
         corect_path[y] = '\0';
         break;
        }
        x -= 1;
        y -= 1;
       }
// .......
       cprintf("Mxloder ... Program Loading In Process For ....\n\r");
       cprintf("%s\n\r\n\r", user_req);
       setdisk(home_drv_number);
       chdir(home_dir);
       prg_rtrn_code = system("MXLHWS.COM");
       prg_rtrn_code = 0;
       mem_check();
       user_drv_letter[0] = user_req[0];
       user_drv_number = (toupper(user_drv_letter[0])) - 'A';
       setdisk(user_drv_number);
       chdir(corect_path);
       prg_rtrn_code = system(user_req);
       cprintf("------------------------------------------------------------------------\n\r\n\r");
// ........
       if (prg_rtrn_code != 0)
       {
         ScreenClear();
         ScreenSetCursor(0, 0);
         cprintf("Mxloder Ver. 2.0. Designed By  John F. Clark Jr.\n\r\n\r");
         cprintf("End of Program Run For ...\n\r");
         cprintf("%s\n\r\n\r", user_req);
         cprintf("!! ERROR !!  on program return.\n\r");
         cprintf("Program Return Code = %d\n\r", prg_rtrn_code);
         cprintf("------------------------------------------------------------------------\n\r\n\r");
       }
// ........
       if (prg_rtrn_code == 0)
       {
         ScreenClear();
         ScreenSetCursor(0, 0);
         cprintf("Mxloder Ver. 2.0. Designed By  John F. Clark Jr.\n\r\n\r");
         cprintf("End of Program Run For ...\n\r");
         cprintf("%s\n\r\n\r", user_req);
         cprintf("No Error on program return.\n\r");
         cprintf("Program Return Code = %d\n\r", prg_rtrn_code);
         cprintf("------------------------------------------------------------------------\n\r\n\r");
       }
     }
     prg_zpass = 999;
   }
   close_exit();
}

// Memory Status Function .....
void mem_check()
{
   extern __Go32_Info_Block _go32_info_block;

  _go32_dpmi_meminfo info;
  _go32_dpmi_get_free_memory_information(&info);
  cprintf("___System's Memory Status____ \n\r");
  cprintf("Total Physical Memory = %x\n\r",info.total_physical_pages);
  cprintf("Available Memory = %x\n\r",info.available_memory * 4096);
  cprintf("Linear Space = %x\n\r",info.linear_space);
  cprintf("Available Pages = %x\n\r",info.available_pages);
  cprintf("Available Physical Pages = %x\n\r",info.available_physical_pages);
  cprintf("Available Lockable Pages = %x\n\r",info.available_lockable_pages);
  cprintf("Max Pages In Paging File = %x\n\r\n\r",info.max_pages_in_paging_file);
  return;
}

// Error Message Handler Function ...
void Err_Handler(int ER_FLG, char mxfile[16])
{
    int presskey = 0;
    unsigned *saved_scrn = (unsigned *)alloca(ScreenRows()*ScreenCols()*2);

    if(ER_FLG == 1)
    {
        ScreenRetrieve(saved_scrn);
        textbackground(0);
        textcolor(7);
        ScreenClear();
        ScreenSetCursor(0, 0);
        cprintf("Mxloder Ver. 2.0. Designed By  John F. Clark Jr.\n\r\n\r");
        cprintf("File Access  !! Error !!  in Mxloder Accessor System Start Up Program.\n\r");
        cprintf("Cannot find the File ... %s\n\r\n\r", mxfile);
        cprintf("Check the Micro-x Files and Directory, and ensure they are correct.\n\r");
        cprintf("Read the Micro-x documentation files for more detailed information ...\n\r\n\r");
        cprintf("Press Escape to continue ....\n\r");
        while(presskey != K_Escape)
        {
          if(kbhit())
          {
            presskey = getkey();
          }
        }
        presskey = 0;
        setdisk(current_drive);
        chdir("/");
        chdir(current_path);
        ScreenUpdate(saved_scrn);
        ScreenSetCursor(LocalScrn_y, LocalScrn_x);
        return;
    }
//........
    if(ER_FLG == 2)
    {
        ScreenRetrieve(saved_scrn);
        textbackground(0);
        textcolor(7);
        ScreenClear();
        ScreenSetCursor(0, 0);
        cprintf("Mxloder Ver. 2.0. Designed By  John F. Clark Jr.\n\r\n\r");
        cprintf("!! Error !! ... in Mxloder Accessor System Start Up Program.\n\r");
        cprintf("Invalid Command Line Paramerters ......\n\r\n\r");
        cprintf("Press Escape to continue ....\n\r");
        while(presskey != K_Escape)
        {
          if(kbhit())
          {
            presskey = getkey();
          }
        }
        presskey = 0;
        setdisk(current_drive);
        chdir("/");
        chdir(current_path);
        ScreenUpdate(saved_scrn);
        ScreenSetCursor(LocalScrn_y, LocalScrn_x);
        return;
    }
//........
    if(ER_FLG == 3)
    {
        ScreenRetrieve(saved_scrn);
        textbackground(0);
        textcolor(7);
        ScreenClear();
        ScreenSetCursor(0, 0);
        cprintf("Mxloder Version 2.0. Designed For Micro-x Accessor\n\r");
        cprintf("System Version 1.5.5 Gxv. ( Start Up Program Only )\n\r\n\r");
        cprintf("Developed under the Engineering for the Water Making Technology.\n\r");
        cprintf("Copyright (C) August 2002   By John F. Clark Jr.\n\r\n\r");
        cprintf("Syntax: [ mxloder {Path} ] - The Complete Path To The Micro-x Directory.\n\r");
        cprintf("      : [ mxloder {/?} ] - Displays This Help Information.\n\r\n\r");
        cprintf("Press Escape to continue ....\n\r");
        while(presskey != K_Escape)
        {
          if(kbhit())
          {
            presskey = getkey();
          }
        }
        presskey = 0;
        setdisk(current_drive);
        chdir("/");
        chdir(current_path);
        ScreenUpdate(saved_scrn);
        ScreenSetCursor(LocalScrn_y, LocalScrn_x);
        return;
    }
//..................
    if(ER_FLG == 4)
    {
        ScreenRetrieve(saved_scrn);
        textbackground(0);
        textcolor(7);
        ScreenClear();
        ScreenSetCursor(0, 0);
        cprintf("Mxloder Ver. 2.0. Designed By  John F. Clark Jr.\n\r\n\r");
        cprintf("Drive Access !! Error !! ... in Mxloder.\n\r");
        cprintf("File Opening Operation Failed ......\n\r\n\r");
        cprintf("Press Escape to continue ....\n\r");
        while(presskey != K_Escape)
        {
          if(kbhit())
          {
            presskey = getkey();
          }
        }
        presskey = 0;
        setdisk(current_drive);
        chdir("/");
        chdir(current_path);
        ScreenUpdate(saved_scrn);
        ScreenSetCursor(LocalScrn_y, LocalScrn_x);
        return;
    }
//........
   presskey = 0;
   setdisk(current_drive);
   chdir("/");
   chdir(current_path);
   ScreenUpdate(saved_scrn);
   ScreenSetCursor(LocalScrn_y, LocalScrn_x);
   return;
}
// Close Down Function .........
void close_exit(void)
{
   _go32_dpmi_registers r;

  r.h.ah = 0x00;
  r.h.al = video_mode;
  r.x.ss = r.x.sp = 0x00;
  _go32_dpmi_simulate_int(0x10, &r);
  if (LocalScrn_y >= 25)
  {
    LocalScrn_y -= 1;
  }
  if (LocalScrn_x >= 80)
  {
   LocalScrn_x -= 1;
  }
  setdisk(current_drive);
  chdir("/");
  chdir(current_path);
  ScreenUpdate(scrn_buf);
  ScreenSetCursor(LocalScrn_y, LocalScrn_x);
  exit(0);
}
//
//*************************************************************
//*************************************************************
// [ Program End For Mxloder.c Version 2.2  Accessor System ]
// [ Loder For Micro-x Accessor System Version 1.5.5 GXV... ]
//*************************************************************
//*************************************************************
