/*****************************************************************************

  Class TGrowDialog

  Copyright (c) 1997 by SET

    This file can be used freely but you must let the copyright untouched
  and give me some credits.

  E-Mail: salvador@inti.edu.ar
  
  Telephone: (+541) 759-0013
  
  Postal Address:
  Salvador E. Tropea
  Curapalige 2124
  (1678) Caseros - 3 de Febrero
  Prov: Buenos Aires
  Argentina

    This is a TDialog that can grow, not shrink, simply grow. You can Zoom
  the dialog too.

    I defined 2 gfXXXXX constants:

    gfMoveBottomCorner: Used in TListBoxes, the uper-left corner still in
                        your place and the bottom-right is moved according
                        to the size of the dialog.

    gfMoveAccording: Used in the TButtons, the buttons are moved according
                     to the new size of the dialog.

    The TScrollBars have grow attributes by default.

*****************************************************************************/

class TGrowDialog : public TDialog
{
 public:

 TGrowDialog( TRect r, const char *name, int extraOptions=0 ) :
      TDialog(r,name),
      TWindowInit( &TGrowDialog::initFrame )
 {
  growMode = gfGrowAll;
  flags   |= wfGrow | wfZoom;
  options |= extraOptions;
  minSize = r.b;
 };
 void sizeLimits(TPoint& min, TPoint& max);

 TPoint minSize;
};

const gfMoveBottomCorner = gfGrowHiX | gfGrowHiY;
const gfMoveAccording = gfGrowAll;
