#! /bin/sh
#-----------------------------------------------------------------------
#  Configures and builds cross-compiler to DJGPP. Edit file as needed
#
#  I have tested this script on i586-pc-linux-gnu only:
#	kernels  2.2.14,
#  	glibc-2.1.2, 
#	gcc-2.95.2
#
#  You need stubify somewhere on path and cross-binutils for target
#  i586-pc-msdosdjgpp
#
#-----------------------------------------------------------------------
#


prefix=/usr
source=`(cd ..; pwd)`
_version=`sed -e 's/.*\"\([^ \"]*\)[ \"].*/\1/' < ${source}/gcc/version.c`
target=i586-pc-msdosdjgpp
version_dir=${prefix}/lib/gcc-lib/${target}/${_version}

if ! [ -d ${version_dir} ]; then
    echo ''
    echo '************************************************************************'
    echo '*'  Please create directory ${version_dir} 
    echo '*'  and rerun this script. This directory must exist to build 
    echo '*'  cross-compiler for target ${target}
    echo '*' 
    echo '*'  Warning: You may need root permissions to do that
    echo '************************************************************************'
    echo ''
    exit 1
fi    
#-----------------------------------------------------------------------
#  To be sure we should convert all source files to unix format
#  Therefore I included modified sources of dtou that should hopefully
#  should built on most systems
#  NOTE: I left this file in however it's not really used (AP)
#----------------------------------------------------------------------- 
echo Building /tmp/dtou
gcc -O2 -o /tmp/dtou -x c - << 'EOF'
/* Copyright (C) 1995 DJ Delorie, see COPYING.DJ for details */
/* Modified by A.Pavenis to work also in different Unix clones */
#include <stdio.h>
#include <fcntl.h>
#include <sys/stat.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <utime.h>

#ifndef O_BINARY
#define O_BINARY 0
#endif

static int
dtou(char *fname)
{
  int i, k, k2, sf, df, l, l2, err=0;
  char buf[16384];
  char tfname[FILENAME_MAX], *bn, *w;
  struct stat st;
  struct utimbuf tim1;
  sf = open(fname, O_RDONLY|O_BINARY);
  if (sf < 1)
  {
    perror(fname);
    return 1;
  }
  
  fstat (sf,&st);
  tim1.actime = st.st_atime;
  tim1.modtime = st.st_mtime;

  strcpy (tfname, fname);
  for (bn=w=tfname; *w; w++) 
    if (*w=='/' || *w=='\\') 
      bn = w+1;  
  if (bn) *bn=0;
  strcat (tfname,"utod.tm$");
  
  df = open(tfname, O_WRONLY|O_CREAT|O_TRUNC|O_BINARY, 0644);
  if (df < 1)
  {
    perror(tfname);
    close(sf);
    return 1;
  }

  k2=0;
  while ((l=read(sf, buf, 16384)) > 0)
  { 
    for (i=k=0; i<l; i++) 
      if (buf[i]!=13)
        buf[k++]=buf[i];
    l2=write(df, buf, k);
    if (l2<0) break;
    if (l2!=k) { err=1; break; }
  }

  if (l<0) perror (fname);
  if (l2<0) perror (tfname);
  if (err) fprintf (stderr,"Cannot process file %s\n",fname);

  close(sf);
  close(df);

  if (l>=0 && l2>=0 && err==0)
  {
    remove(fname);
    rename(tfname, fname);
    utime(fname, &tim1);
  }
  else 
  {
    remove(tfname);
  }
  return 0;
}

int
main(int argc, char **argv)
{
  int rv = 0;
  for (argc--, argv++; argc; argc--, argv++)
    rv += dtou(*argv);
  return rv;
}
EOF

#----------------------------------------------------------------------
##  Uncomment this if needed (it should not be needed)
#echo Converting DOS style text files to Unix style ones...
##  Uncomment this if needed
#for x in `find ${source} -not -type d`; do
#    /tmp/dtou ${x}
#done
rm -f /tmp/dtou
for name in config.sub configure config.guess move-if-change; do
    for x in `find ${source} -name ${name}`; do
	chmod 755 ${x}
    done
done    


host_name=`${source}/config.guess`
echo Configuring compiler for target ${target} for ${host_name} host
########################################################################################

#  configure in gcc fails to find cross-assembler. Therefore let's help it slightly     
for pref in /usr/bin /usr/local/bin; do
	test -f ${pref}/${target}-as && \
	AS=${AS-${pref}/${target}-as}
done
export AS

LANGUAGES="c c++ objc f77" \
$source/configure  \
	--target=$target \
	--host=${host_name} \
	--build=${host_name} \
	--prefix=$prefix \
	--verbose \
	--with-gxx-include-dir=$prefix/$target/lang/cxx \

#  Make sure we'll not have specs in current directory
rm -f specs

#  Find locations of current gcc specs file. We need this as
#  target specific specs file will be in current directory
orig_specs=`gcc -print-file-name=specs`

#
make       XCFLAGS="-specs=$orig_specs" \
           LDFLAGS="-L`echo $orig_specs | sed -e 's,[/]specs,,g'`" \
           AR_FOR_TARGET=${target}-ar \
           RANLIB_FOR_TARGET=${target}-ranlib \
           CFLAGS=-O2 \
           LANGUAGES="c c++ f77 objc"

mkdir ../install.cross
instdir=`(cd ..; pwd)`/install.cross/${prefix}

make 	info install install-info \
	prefix=${instdir} \
        LANGUAGES="c c++ f77 objc" \
	gxx_include_dir=${instdir}/$target/lang/cxx

# Let's make installation as close as possible to native one
cat >${instdir}/${target}/lang/cxx/header.gcc << 'EOF'
String.h _String.h
Complex.h _Complex.h
Regex.h _Regex.h
iostreamP.h _iostreamP.h
stl_algobase.h stlalgobase.h
stl_hash_map.h stlhashmap.h
stl_hash_set.h stlhashset.h
stl_hashtable.h stlhashtable.h
stl_multiset.h stlmultiset.h
GetOpt.h _GetOpt.h
EOF

mv ${instdir}/${target}/lang/cxx/GetOpt.h ${instdir}/${target}/lang/cxx/_GetOpt.h

cat >${instdir}/${target}/lang/cxx/std/header.gcc << 'EOF'
valarray_meta.h _valarray_meta.h
EOF
