#! /bin/sh
#  Warning: not very carefully tested. Use at Your own risc.
#  Copy source original archives of gcc-2.95.2 and libg++-2.8.1.3
#  in this directory and edit them names is required (.tar.gz,.tgz,tar.bz2)
#  Also edit build directory if needed. 
#
#  The checking whether all is Ok with running gcc-patch/gcc-patch.sh
#  is not yet included. So be carefull.
#
gcc_archive=`pwd`/gcc-2.95.2.tar.gz
libgpp_archive=`pwd`/libg++-2.8.1.3.tar.gz
build_base=c:/djgpp

if ! [ -f $gcc_archive ]; then echo $gcc_archive not found; exit 1; fi

if ! [ -f $libgpp_archive ]; then echo $libgpp_archive not found; exit 1; fi

orig_gcc_dirname=`basename $gcc_archive | sed -e 's/[.]tgz//g' -e 's/[.]tar[.]gz//g' -e 's/[.]tar[.]bz2//g'`

case $orig_gcc_dirname in 
	*-2.95.*) gcc_dirname=`echo $orig_gcc_dirname | sed -e 's/95[.]/95/g'` ;;
        *) conv_dirname=$orig_gcc_dirname ;;
esac;		 	

djsrc=`echo $gcc_dirname | sed -e 's/[-]//g' -e 's/[.]//g'`s

libgpp_dirname=`basename $libgpp_archive | sed -e 's/[.]tgz//g' -e 's/[.]tar[.]gz//g' -e 's/[.]tar[.]bz2//g'`

if [ -d $build_base/gnu/$orig_gcc_dirname ]; then
	echo ERROR: Directory $build_base/$gcc_dirname already exists
	exit 1
fi

if [ -d $build_base/gnu/$gcc_dirname ]; then
	echo ERROR: Directory $build_base/$conv_dirname already exists
	exit 1
fi

if [ -d $build_base/gnu/$libgpp_dirname ]; then
	echo ERROR: Directory $build_base/$libgpp_dirname already exists
	exit 1
fi
	
( cd $build_base/gnu && \
	case $gcc_archive in *.tgz | *.tar.gz) tar xvzf $gcc_archive ;;
	             	     *.tar.bz2) tar xvyf $gcc_archive ;;
			     *) false ;;
	esac && \
	case $libgpp_archive in *.tgz | *.tar.gz) tar xvzf $libgpp_archive ;;
	             	     *.tar.bz2) tar xvyf $libgpp_archive ;;
			     *) false ;;
	esac || \
		exit 1;

  mv $orig_gcc_dirname $gcc_dirname
  ( cd $libgpp_dirname && mv -v * ../$gcc_dirname )
  rm -fr $libgpp_dirname
)
  
echo Patching $gcc_dirname for DJGPP
export gccsrc=$build_base/gnu/$gcc_dirname;
( cd gcc-patch && ( redir -eo ./gcc-patch.sh >../gcc-patch.log ) )

( 
   echo Building gcc source archive for DJGPP
   curr=`pwd`
   cd $build_base
   echo "${djsrc}.zip : ${orig_gcc_dirname} source archive (together with ${libgpp_dirname})" >manifest/${djsrc}.ver
   rm -f manifest/${djsrc}.mft;
   touch manifest/${djsrc}.mft;
   (
	find gnu/${gcc_dirname} -not -type d
	find manifest -name ${djsrc}\*
   ) | grep -v [~]1 \
     | grep -v [.]orig \
     | sort \
     | sed -e 's,etc[/]hints,etc/HINTS,g' \
   >manifest/${djsrc}.mft

   rm -f $curr/${djsrc}.zip
   zip -9 $curr/${djsrc}.zip @manifest/${djsrc}.mft
)
