#! /bin/sh

exec >unpack-`date +%y%m%d` 2>&1

top=`pwd`
if [ -f gcc-3.0.3.tar.gz ] ; then 
	default_source_archive=gcc-3.0.3.tar.gz;
else if [ -f gcc-3.0.3.tar.bz2 ] ; then 
	default_source_archive=gcc-3.0.3.tar.bz2;
else
	default_source_archive=unknown
fi
fi	

archive=${1-${default_source_archive}}

DTOU=dtou

rm -rf gcc gnu/gcc*
rm -f s-sources
case $archive in 
	*.tgz | *.tar.gz )
		tar xzf $archive && touch s-sources
		;;
	*.tar.bz2 )
		tar xf $archive --use=bzip2 && touch s-sources
		;;
	unknown)
		echo No source archive
		;;
	*)
		echo Unknown archive format
		;;
esac

if ! [ -f s-sources ] ; then
    echo "Cannot unpack GCC sources"
    exit 1
fi
rm -f s-sources	

if [ -d gcc-3.0.3 ] ; then
    gcc_dir=gcc-3.0.3
else 
    if [ -d gcc ] ; then
        gcc_dir=gcc
    fi
fi

rm -rf djcross djgpp
rm -rf gnu manifest

#
#  Remove parts we don't need for DJGPP
#

rm -rf $gcc_dir/boehm-gc
rm -rf $gcc_dir/fastjar
rm -rf $gcc_dir/libffi
rm -rf $gcc_dir/libjava
rm -rf $gcc_dir/zlib
rm -rf $gcc_dir/gcc/java
rm -rf $gcc_dir/gcc/testsuite

mkdir $gcc_dir/build.djg
mkdir $gcc_dir/install.djg
mkdir $gcc_dir/install.djg/dsmsrc

#
#  List of directories in which we should run autoconf or/and automake
#

automake_list=
aclocal_list=

#
#  Apply DJGPP related diffs and copy files 
#

for x in `(cd diffs && find . -type f | sed -e 's/\.\///g')`; do
    case $x in 
       *.diff)
           cd $top
           diff=`pwd`/$x;
           fname=`echo $x | sed -e 's/\.diff//g'`
           echo "Applying patch to gcc/$fname ..."
           cp -f $gcc_dir/$fname $gcc_dir/${fname}~1 
           patch --verbose $gcc_dir/$fname <diffs/$x
	   ${DTOU} $gcc_dir/$fname	
           case $fname in 
               */acinclude.m4)
            	   dir=`echo $gcc_dir/$fname | sed -e 's/\/acinclude.m4//g'`
                   aclocal_list="$aclocal_list $dir"
                   ;;
               */Makefile.am)
                   dir=`echo $gcc_dir/$fname | sed -e 's/\/Makefile.am//g'`
                   automake_list="$automake_list $dir"
                   ;;
           esac
           ;;
       *~*)
           ;;
       *)
           echo Copying $x
           cp -fv diffs/$x $gcc_dir/$x
	   ${DTOU} $gcc_dir/$x
           ;;
       esac
done

#
#  Run aclocal where needed
#

for dir in $aclocal_list ; do
   if cd $dir ; then
      echo Running aclocal in `pwd`...
      aclocal
   fi
   cd $top
done

#
#  Run automake where needed
#

for dir in $automake_list; do
   if cd $dir ; then
      if ! [ -f configure.in ] ; then
         cd ..;
         if ! [ -f configure.in ] ; then
            cd ..
         fi
      fi
      echo Running automake in `pwd`...
      automake
   fi
   cd $top
done

#
#  Run autoconf where needed
#

for c in `find $gcc_dir -name 'configure.in'`; do
   d=`echo $c | sed -e 's#/configure.in##g'`
   if cd $d ; then
      if grep -q AC_OUTPUT configure.in ; then
          echo Running autoconf in `pwd` ...;
          autoconf;
      fi
   fi
   cd $top
done

#
#  Run autoheader where needed
#

if cd $top/$gcc_dir/gcc ; then
   echo Running autoheader in `pwd` ...;
   autoheader
   rm -f cstamp-h.in
   echo timestamp >cstamp-h.in
fi

if cd $top/$gcc_dir/libf2c/libI77 ; then
   echo Running autoheader in `pwd` ...;
   autoheader
   rm -f stamp-h.in
   echo timestamp > stamp-h.in
fi

cd $top

version=`cat $gcc_dir/gcc/version.c |
	 grep version_string | 
	 sed -e 's,^.*[=],,' | 
	 sed -e 's,[";],,g' | 
	 sed -e 's,^[\ ],,g'`

short_version=`echo $version | sed -e 's,[\ ].*,,' -e 's,^[ ]+,,g'`
arcprefix=gcc`echo $short_version | sed -e 's,\.,,g'`
srcname=gcc-`echo $short_version | sed -e 's,^\(3\.[0-9][0-9]*\)\.\(..*\),\1\2,g'` 

mkdir gnu
mkdir manifest
ginstall -d gnu/$srcname
mv -fv $gcc_dir/* gnu/$srcname
rm -rf gcc-$short_version gcc
echo ${arcprefix}s.zip - GCC $version source archive for DJGPP >manifest/${arcprefix}s.ver
touch manifest/${arcprefix}s.mft

( find gnu/$srcname -type f \
		    -and -not -name '.cvsignore' \
		    -and -not -name '*~*' \
		    -and -not -name '*.orig' \
		    -and -not -name '.brik' ;
  find manifest -type f; ) | sort >manifest/${arcprefix}s.mft

cat manifest/${arcprefix}s.mft | zip -9q@ ${arcprefix}s.zip
