/* Simulator instruction decoder for i960base.

THIS FILE IS MACHINE GENERATED WITH CGEN.

Copyright (C) 1996, 1997, 1998, 1999 Free Software Foundation, Inc.

This file is part of the GNU Simulators.

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License along
with this program; if not, write to the Free Software Foundation, Inc.,
59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

*/

#define WANT_CPU i960base
#define WANT_CPU_I960BASE

#include "sim-main.h"
#include "sim-assert.h"

/* The instruction descriptor array.
   This is computed at runtime.  Space for it is not malloc'd to save a
   teensy bit of cpu in the decoder.  Moving it to malloc space is trivial
   but won't be done until necessary (we don't currently support the runtime
   addition of instructions nor an SMP machine with different cpus).  */
static IDESC i960base_insn_data[I960BASE_INSN_MAX];

/* Commas between elements are contained in the macros.
   Some of these are conditionally compiled out.  */

static const struct insn_sem i960base_insn_sem[] =
{
  { VIRTUAL_INSN_X_INVALID, I960BASE_INSN_X_INVALID, I960BASE_SFMT_EMPTY },
  { VIRTUAL_INSN_X_AFTER, I960BASE_INSN_X_AFTER, I960BASE_SFMT_EMPTY },
  { VIRTUAL_INSN_X_BEFORE, I960BASE_INSN_X_BEFORE, I960BASE_SFMT_EMPTY },
  { VIRTUAL_INSN_X_CTI_CHAIN, I960BASE_INSN_X_CTI_CHAIN, I960BASE_SFMT_EMPTY },
  { VIRTUAL_INSN_X_CHAIN, I960BASE_INSN_X_CHAIN, I960BASE_SFMT_EMPTY },
  { VIRTUAL_INSN_X_BEGIN, I960BASE_INSN_X_BEGIN, I960BASE_SFMT_EMPTY },
  { I960_INSN_MULO, I960BASE_INSN_MULO, I960BASE_SFMT_MULO },
  { I960_INSN_MULO1, I960BASE_INSN_MULO1, I960BASE_SFMT_MULO1 },
  { I960_INSN_MULO2, I960BASE_INSN_MULO2, I960BASE_SFMT_MULO2 },
  { I960_INSN_MULO3, I960BASE_INSN_MULO3, I960BASE_SFMT_MULO3 },
  { I960_INSN_REMO, I960BASE_INSN_REMO, I960BASE_SFMT_MULO },
  { I960_INSN_REMO1, I960BASE_INSN_REMO1, I960BASE_SFMT_MULO1 },
  { I960_INSN_REMO2, I960BASE_INSN_REMO2, I960BASE_SFMT_MULO2 },
  { I960_INSN_REMO3, I960BASE_INSN_REMO3, I960BASE_SFMT_MULO3 },
  { I960_INSN_DIVO, I960BASE_INSN_DIVO, I960BASE_SFMT_MULO },
  { I960_INSN_DIVO1, I960BASE_INSN_DIVO1, I960BASE_SFMT_MULO1 },
  { I960_INSN_DIVO2, I960BASE_INSN_DIVO2, I960BASE_SFMT_MULO2 },
  { I960_INSN_DIVO3, I960BASE_INSN_DIVO3, I960BASE_SFMT_MULO3 },
  { I960_INSN_REMI, I960BASE_INSN_REMI, I960BASE_SFMT_MULO },
  { I960_INSN_REMI1, I960BASE_INSN_REMI1, I960BASE_SFMT_MULO1 },
  { I960_INSN_REMI2, I960BASE_INSN_REMI2, I960BASE_SFMT_MULO2 },
  { I960_INSN_REMI3, I960BASE_INSN_REMI3, I960BASE_SFMT_MULO3 },
  { I960_INSN_DIVI, I960BASE_INSN_DIVI, I960BASE_SFMT_MULO },
  { I960_INSN_DIVI1, I960BASE_INSN_DIVI1, I960BASE_SFMT_MULO1 },
  { I960_INSN_DIVI2, I960BASE_INSN_DIVI2, I960BASE_SFMT_MULO2 },
  { I960_INSN_DIVI3, I960BASE_INSN_DIVI3, I960BASE_SFMT_MULO3 },
  { I960_INSN_ADDO, I960BASE_INSN_ADDO, I960BASE_SFMT_MULO },
  { I960_INSN_ADDO1, I960BASE_INSN_ADDO1, I960BASE_SFMT_MULO1 },
  { I960_INSN_ADDO2, I960BASE_INSN_ADDO2, I960BASE_SFMT_MULO2 },
  { I960_INSN_ADDO3, I960BASE_INSN_ADDO3, I960BASE_SFMT_MULO3 },
  { I960_INSN_SUBO, I960BASE_INSN_SUBO, I960BASE_SFMT_MULO },
  { I960_INSN_SUBO1, I960BASE_INSN_SUBO1, I960BASE_SFMT_MULO1 },
  { I960_INSN_SUBO2, I960BASE_INSN_SUBO2, I960BASE_SFMT_MULO2 },
  { I960_INSN_SUBO3, I960BASE_INSN_SUBO3, I960BASE_SFMT_MULO3 },
  { I960_INSN_NOTBIT, I960BASE_INSN_NOTBIT, I960BASE_SFMT_NOTBIT },
  { I960_INSN_NOTBIT1, I960BASE_INSN_NOTBIT1, I960BASE_SFMT_NOTBIT1 },
  { I960_INSN_NOTBIT2, I960BASE_INSN_NOTBIT2, I960BASE_SFMT_NOTBIT2 },
  { I960_INSN_NOTBIT3, I960BASE_INSN_NOTBIT3, I960BASE_SFMT_NOTBIT3 },
  { I960_INSN_AND, I960BASE_INSN_AND, I960BASE_SFMT_MULO },
  { I960_INSN_AND1, I960BASE_INSN_AND1, I960BASE_SFMT_MULO1 },
  { I960_INSN_AND2, I960BASE_INSN_AND2, I960BASE_SFMT_MULO2 },
  { I960_INSN_AND3, I960BASE_INSN_AND3, I960BASE_SFMT_MULO3 },
  { I960_INSN_ANDNOT, I960BASE_INSN_ANDNOT, I960BASE_SFMT_MULO },
  { I960_INSN_ANDNOT1, I960BASE_INSN_ANDNOT1, I960BASE_SFMT_MULO1 },
  { I960_INSN_ANDNOT2, I960BASE_INSN_ANDNOT2, I960BASE_SFMT_MULO2 },
  { I960_INSN_ANDNOT3, I960BASE_INSN_ANDNOT3, I960BASE_SFMT_MULO3 },
  { I960_INSN_SETBIT, I960BASE_INSN_SETBIT, I960BASE_SFMT_NOTBIT },
  { I960_INSN_SETBIT1, I960BASE_INSN_SETBIT1, I960BASE_SFMT_NOTBIT1 },
  { I960_INSN_SETBIT2, I960BASE_INSN_SETBIT2, I960BASE_SFMT_NOTBIT2 },
  { I960_INSN_SETBIT3, I960BASE_INSN_SETBIT3, I960BASE_SFMT_NOTBIT3 },
  { I960_INSN_NOTAND, I960BASE_INSN_NOTAND, I960BASE_SFMT_MULO },
  { I960_INSN_NOTAND1, I960BASE_INSN_NOTAND1, I960BASE_SFMT_MULO1 },
  { I960_INSN_NOTAND2, I960BASE_INSN_NOTAND2, I960BASE_SFMT_MULO2 },
  { I960_INSN_NOTAND3, I960BASE_INSN_NOTAND3, I960BASE_SFMT_MULO3 },
  { I960_INSN_XOR, I960BASE_INSN_XOR, I960BASE_SFMT_MULO },
  { I960_INSN_XOR1, I960BASE_INSN_XOR1, I960BASE_SFMT_MULO1 },
  { I960_INSN_XOR2, I960BASE_INSN_XOR2, I960BASE_SFMT_MULO2 },
  { I960_INSN_XOR3, I960BASE_INSN_XOR3, I960BASE_SFMT_MULO3 },
  { I960_INSN_OR, I960BASE_INSN_OR, I960BASE_SFMT_MULO },
  { I960_INSN_OR1, I960BASE_INSN_OR1, I960BASE_SFMT_MULO1 },
  { I960_INSN_OR2, I960BASE_INSN_OR2, I960BASE_SFMT_MULO2 },
  { I960_INSN_OR3, I960BASE_INSN_OR3, I960BASE_SFMT_MULO3 },
  { I960_INSN_NOR, I960BASE_INSN_NOR, I960BASE_SFMT_MULO },
  { I960_INSN_NOR1, I960BASE_INSN_NOR1, I960BASE_SFMT_MULO1 },
  { I960_INSN_NOR2, I960BASE_INSN_NOR2, I960BASE_SFMT_MULO2 },
  { I960_INSN_NOR3, I960BASE_INSN_NOR3, I960BASE_SFMT_MULO3 },
  { I960_INSN_XNOR, I960BASE_INSN_XNOR, I960BASE_SFMT_MULO },
  { I960_INSN_XNOR1, I960BASE_INSN_XNOR1, I960BASE_SFMT_MULO1 },
  { I960_INSN_XNOR2, I960BASE_INSN_XNOR2, I960BASE_SFMT_MULO2 },
  { I960_INSN_XNOR3, I960BASE_INSN_XNOR3, I960BASE_SFMT_MULO3 },
  { I960_INSN_NOT, I960BASE_INSN_NOT, I960BASE_SFMT_NOT },
  { I960_INSN_NOT1, I960BASE_INSN_NOT1, I960BASE_SFMT_NOT1 },
  { I960_INSN_NOT2, I960BASE_INSN_NOT2, I960BASE_SFMT_NOT },
  { I960_INSN_NOT3, I960BASE_INSN_NOT3, I960BASE_SFMT_NOT1 },
  { I960_INSN_ORNOT, I960BASE_INSN_ORNOT, I960BASE_SFMT_MULO },
  { I960_INSN_ORNOT1, I960BASE_INSN_ORNOT1, I960BASE_SFMT_MULO1 },
  { I960_INSN_ORNOT2, I960BASE_INSN_ORNOT2, I960BASE_SFMT_MULO2 },
  { I960_INSN_ORNOT3, I960BASE_INSN_ORNOT3, I960BASE_SFMT_MULO3 },
  { I960_INSN_CLRBIT, I960BASE_INSN_CLRBIT, I960BASE_SFMT_NOTBIT },
  { I960_INSN_CLRBIT1, I960BASE_INSN_CLRBIT1, I960BASE_SFMT_NOTBIT1 },
  { I960_INSN_CLRBIT2, I960BASE_INSN_CLRBIT2, I960BASE_SFMT_NOTBIT2 },
  { I960_INSN_CLRBIT3, I960BASE_INSN_CLRBIT3, I960BASE_SFMT_NOTBIT3 },
  { I960_INSN_SHLO, I960BASE_INSN_SHLO, I960BASE_SFMT_SHLO },
  { I960_INSN_SHLO1, I960BASE_INSN_SHLO1, I960BASE_SFMT_SHLO1 },
  { I960_INSN_SHLO2, I960BASE_INSN_SHLO2, I960BASE_SFMT_SHLO2 },
  { I960_INSN_SHLO3, I960BASE_INSN_SHLO3, I960BASE_SFMT_SHLO3 },
  { I960_INSN_SHRO, I960BASE_INSN_SHRO, I960BASE_SFMT_SHLO },
  { I960_INSN_SHRO1, I960BASE_INSN_SHRO1, I960BASE_SFMT_SHLO1 },
  { I960_INSN_SHRO2, I960BASE_INSN_SHRO2, I960BASE_SFMT_SHLO2 },
  { I960_INSN_SHRO3, I960BASE_INSN_SHRO3, I960BASE_SFMT_SHLO3 },
  { I960_INSN_SHLI, I960BASE_INSN_SHLI, I960BASE_SFMT_SHLO },
  { I960_INSN_SHLI1, I960BASE_INSN_SHLI1, I960BASE_SFMT_SHLO1 },
  { I960_INSN_SHLI2, I960BASE_INSN_SHLI2, I960BASE_SFMT_SHLO2 },
  { I960_INSN_SHLI3, I960BASE_INSN_SHLI3, I960BASE_SFMT_SHLO3 },
  { I960_INSN_SHRI, I960BASE_INSN_SHRI, I960BASE_SFMT_SHLO },
  { I960_INSN_SHRI1, I960BASE_INSN_SHRI1, I960BASE_SFMT_SHLO1 },
  { I960_INSN_SHRI2, I960BASE_INSN_SHRI2, I960BASE_SFMT_SHLO2 },
  { I960_INSN_SHRI3, I960BASE_INSN_SHRI3, I960BASE_SFMT_SHLO3 },
  { I960_INSN_EMUL, I960BASE_INSN_EMUL, I960BASE_SFMT_EMUL },
  { I960_INSN_EMUL1, I960BASE_INSN_EMUL1, I960BASE_SFMT_EMUL1 },
  { I960_INSN_EMUL2, I960BASE_INSN_EMUL2, I960BASE_SFMT_EMUL2 },
  { I960_INSN_EMUL3, I960BASE_INSN_EMUL3, I960BASE_SFMT_EMUL3 },
  { I960_INSN_MOV, I960BASE_INSN_MOV, I960BASE_SFMT_NOT },
  { I960_INSN_MOV1, I960BASE_INSN_MOV1, I960BASE_SFMT_NOT1 },
  { I960_INSN_MOVL, I960BASE_INSN_MOVL, I960BASE_SFMT_MOVL },
  { I960_INSN_MOVL1, I960BASE_INSN_MOVL1, I960BASE_SFMT_MOVL1 },
  { I960_INSN_MOVT, I960BASE_INSN_MOVT, I960BASE_SFMT_MOVT },
  { I960_INSN_MOVT1, I960BASE_INSN_MOVT1, I960BASE_SFMT_MOVT1 },
  { I960_INSN_MOVQ, I960BASE_INSN_MOVQ, I960BASE_SFMT_MOVQ },
  { I960_INSN_MOVQ1, I960BASE_INSN_MOVQ1, I960BASE_SFMT_MOVQ1 },
  { I960_INSN_MODPC, I960BASE_INSN_MODPC, I960BASE_SFMT_MODPC },
  { I960_INSN_MODAC, I960BASE_INSN_MODAC, I960BASE_SFMT_MODPC },
  { I960_INSN_LDA_OFFSET, I960BASE_INSN_LDA_OFFSET, I960BASE_SFMT_LDA_OFFSET },
  { I960_INSN_LDA_INDIRECT_OFFSET, I960BASE_INSN_LDA_INDIRECT_OFFSET, I960BASE_SFMT_LDA_INDIRECT_OFFSET },
  { I960_INSN_LDA_INDIRECT, I960BASE_INSN_LDA_INDIRECT, I960BASE_SFMT_LDA_INDIRECT },
  { I960_INSN_LDA_INDIRECT_INDEX, I960BASE_INSN_LDA_INDIRECT_INDEX, I960BASE_SFMT_LDA_INDIRECT_INDEX },
  { I960_INSN_LDA_DISP, I960BASE_INSN_LDA_DISP, I960BASE_SFMT_LDA_DISP },
  { I960_INSN_LDA_INDIRECT_DISP, I960BASE_INSN_LDA_INDIRECT_DISP, I960BASE_SFMT_LDA_INDIRECT_DISP },
  { I960_INSN_LDA_INDEX_DISP, I960BASE_INSN_LDA_INDEX_DISP, I960BASE_SFMT_LDA_INDEX_DISP },
  { I960_INSN_LDA_INDIRECT_INDEX_DISP, I960BASE_INSN_LDA_INDIRECT_INDEX_DISP, I960BASE_SFMT_LDA_INDIRECT_INDEX_DISP },
  { I960_INSN_LD_OFFSET, I960BASE_INSN_LD_OFFSET, I960BASE_SFMT_LD_OFFSET },
  { I960_INSN_LD_INDIRECT_OFFSET, I960BASE_INSN_LD_INDIRECT_OFFSET, I960BASE_SFMT_LD_INDIRECT_OFFSET },
  { I960_INSN_LD_INDIRECT, I960BASE_INSN_LD_INDIRECT, I960BASE_SFMT_LD_INDIRECT },
  { I960_INSN_LD_INDIRECT_INDEX, I960BASE_INSN_LD_INDIRECT_INDEX, I960BASE_SFMT_LD_INDIRECT_INDEX },
  { I960_INSN_LD_DISP, I960BASE_INSN_LD_DISP, I960BASE_SFMT_LD_DISP },
  { I960_INSN_LD_INDIRECT_DISP, I960BASE_INSN_LD_INDIRECT_DISP, I960BASE_SFMT_LD_INDIRECT_DISP },
  { I960_INSN_LD_INDEX_DISP, I960BASE_INSN_LD_INDEX_DISP, I960BASE_SFMT_LD_INDEX_DISP },
  { I960_INSN_LD_INDIRECT_INDEX_DISP, I960BASE_INSN_LD_INDIRECT_INDEX_DISP, I960BASE_SFMT_LD_INDIRECT_INDEX_DISP },
  { I960_INSN_LDOB_OFFSET, I960BASE_INSN_LDOB_OFFSET, I960BASE_SFMT_LD_OFFSET },
  { I960_INSN_LDOB_INDIRECT_OFFSET, I960BASE_INSN_LDOB_INDIRECT_OFFSET, I960BASE_SFMT_LD_INDIRECT_OFFSET },
  { I960_INSN_LDOB_INDIRECT, I960BASE_INSN_LDOB_INDIRECT, I960BASE_SFMT_LD_INDIRECT },
  { I960_INSN_LDOB_INDIRECT_INDEX, I960BASE_INSN_LDOB_INDIRECT_INDEX, I960BASE_SFMT_LD_INDIRECT_INDEX },
  { I960_INSN_LDOB_DISP, I960BASE_INSN_LDOB_DISP, I960BASE_SFMT_LD_DISP },
  { I960_INSN_LDOB_INDIRECT_DISP, I960BASE_INSN_LDOB_INDIRECT_DISP, I960BASE_SFMT_LD_INDIRECT_DISP },
  { I960_INSN_LDOB_INDEX_DISP, I960BASE_INSN_LDOB_INDEX_DISP, I960BASE_SFMT_LD_INDEX_DISP },
  { I960_INSN_LDOB_INDIRECT_INDEX_DISP, I960BASE_INSN_LDOB_INDIRECT_INDEX_DISP, I960BASE_SFMT_LD_INDIRECT_INDEX_DISP },
  { I960_INSN_LDOS_OFFSET, I960BASE_INSN_LDOS_OFFSET, I960BASE_SFMT_LD_OFFSET },
  { I960_INSN_LDOS_INDIRECT_OFFSET, I960BASE_INSN_LDOS_INDIRECT_OFFSET, I960BASE_SFMT_LD_INDIRECT_OFFSET },
  { I960_INSN_LDOS_INDIRECT, I960BASE_INSN_LDOS_INDIRECT, I960BASE_SFMT_LD_INDIRECT },
  { I960_INSN_LDOS_INDIRECT_INDEX, I960BASE_INSN_LDOS_INDIRECT_INDEX, I960BASE_SFMT_LD_INDIRECT_INDEX },
  { I960_INSN_LDOS_DISP, I960BASE_INSN_LDOS_DISP, I960BASE_SFMT_LD_DISP },
  { I960_INSN_LDOS_INDIRECT_DISP, I960BASE_INSN_LDOS_INDIRECT_DISP, I960BASE_SFMT_LD_INDIRECT_DISP },
  { I960_INSN_LDOS_INDEX_DISP, I960BASE_INSN_LDOS_INDEX_DISP, I960BASE_SFMT_LD_INDEX_DISP },
  { I960_INSN_LDOS_INDIRECT_INDEX_DISP, I960BASE_INSN_LDOS_INDIRECT_INDEX_DISP, I960BASE_SFMT_LD_INDIRECT_INDEX_DISP },
  { I960_INSN_LDIB_OFFSET, I960BASE_INSN_LDIB_OFFSET, I960BASE_SFMT_LD_OFFSET },
  { I960_INSN_LDIB_INDIRECT_OFFSET, I960BASE_INSN_LDIB_INDIRECT_OFFSET, I960BASE_SFMT_LD_INDIRECT_OFFSET },
  { I960_INSN_LDIB_INDIRECT, I960BASE_INSN_LDIB_INDIRECT, I960BASE_SFMT_LD_INDIRECT },
  { I960_INSN_LDIB_INDIRECT_INDEX, I960BASE_INSN_LDIB_INDIRECT_INDEX, I960BASE_SFMT_LD_INDIRECT_INDEX },
  { I960_INSN_LDIB_DISP, I960BASE_INSN_LDIB_DISP, I960BASE_SFMT_LD_DISP },
  { I960_INSN_LDIB_INDIRECT_DISP, I960BASE_INSN_LDIB_INDIRECT_DISP, I960BASE_SFMT_LD_INDIRECT_DISP },
  { I960_INSN_LDIB_INDEX_DISP, I960BASE_INSN_LDIB_INDEX_DISP, I960BASE_SFMT_LD_INDEX_DISP },
  { I960_INSN_LDIB_INDIRECT_INDEX_DISP, I960BASE_INSN_LDIB_INDIRECT_INDEX_DISP, I960BASE_SFMT_LD_INDIRECT_INDEX_DISP },
  { I960_INSN_LDIS_OFFSET, I960BASE_INSN_LDIS_OFFSET, I960BASE_SFMT_LD_OFFSET },
  { I960_INSN_LDIS_INDIRECT_OFFSET, I960BASE_INSN_LDIS_INDIRECT_OFFSET, I960BASE_SFMT_LD_INDIRECT_OFFSET },
  { I960_INSN_LDIS_INDIRECT, I960BASE_INSN_LDIS_INDIRECT, I960BASE_SFMT_LD_INDIRECT },
  { I960_INSN_LDIS_INDIRECT_INDEX, I960BASE_INSN_LDIS_INDIRECT_INDEX, I960BASE_SFMT_LD_INDIRECT_INDEX },
  { I960_INSN_LDIS_DISP, I960BASE_INSN_LDIS_DISP, I960BASE_SFMT_LD_DISP },
  { I960_INSN_LDIS_INDIRECT_DISP, I960BASE_INSN_LDIS_INDIRECT_DISP, I960BASE_SFMT_LD_INDIRECT_DISP },
  { I960_INSN_LDIS_INDEX_DISP, I960BASE_INSN_LDIS_INDEX_DISP, I960BASE_SFMT_LD_INDEX_DISP },
  { I960_INSN_LDIS_INDIRECT_INDEX_DISP, I960BASE_INSN_LDIS_INDIRECT_INDEX_DISP, I960BASE_SFMT_LD_INDIRECT_INDEX_DISP },
  { I960_INSN_LDL_OFFSET, I960BASE_INSN_LDL_OFFSET, I960BASE_SFMT_LDL_OFFSET },
  { I960_INSN_LDL_INDIRECT_OFFSET, I960BASE_INSN_LDL_INDIRECT_OFFSET, I960BASE_SFMT_LDL_INDIRECT_OFFSET },
  { I960_INSN_LDL_INDIRECT, I960BASE_INSN_LDL_INDIRECT, I960BASE_SFMT_LDL_INDIRECT },
  { I960_INSN_LDL_INDIRECT_INDEX, I960BASE_INSN_LDL_INDIRECT_INDEX, I960BASE_SFMT_LDL_INDIRECT_INDEX },
  { I960_INSN_LDL_DISP, I960BASE_INSN_LDL_DISP, I960BASE_SFMT_LDL_DISP },
  { I960_INSN_LDL_INDIRECT_DISP, I960BASE_INSN_LDL_INDIRECT_DISP, I960BASE_SFMT_LDL_INDIRECT_DISP },
  { I960_INSN_LDL_INDEX_DISP, I960BASE_INSN_LDL_INDEX_DISP, I960BASE_SFMT_LDL_INDEX_DISP },
  { I960_INSN_LDL_INDIRECT_INDEX_DISP, I960BASE_INSN_LDL_INDIRECT_INDEX_DISP, I960BASE_SFMT_LDL_INDIRECT_INDEX_DISP },
  { I960_INSN_LDT_OFFSET, I960BASE_INSN_LDT_OFFSET, I960BASE_SFMT_LDT_OFFSET },
  { I960_INSN_LDT_INDIRECT_OFFSET, I960BASE_INSN_LDT_INDIRECT_OFFSET, I960BASE_SFMT_LDT_INDIRECT_OFFSET },
  { I960_INSN_LDT_INDIRECT, I960BASE_INSN_LDT_INDIRECT, I960BASE_SFMT_LDT_INDIRECT },
  { I960_INSN_LDT_INDIRECT_INDEX, I960BASE_INSN_LDT_INDIRECT_INDEX, I960BASE_SFMT_LDT_INDIRECT_INDEX },
  { I960_INSN_LDT_DISP, I960BASE_INSN_LDT_DISP, I960BASE_SFMT_LDT_DISP },
  { I960_INSN_LDT_INDIRECT_DISP, I960BASE_INSN_LDT_INDIRECT_DISP, I960BASE_SFMT_LDT_INDIRECT_DISP },
  { I960_INSN_LDT_INDEX_DISP, I960BASE_INSN_LDT_INDEX_DISP, I960BASE_SFMT_LDT_INDEX_DISP },
  { I960_INSN_LDT_INDIRECT_INDEX_DISP, I960BASE_INSN_LDT_INDIRECT_INDEX_DISP, I960BASE_SFMT_LDT_INDIRECT_INDEX_DISP },
  { I960_INSN_LDQ_OFFSET, I960BASE_INSN_LDQ_OFFSET, I960BASE_SFMT_LDQ_OFFSET },
  { I960_INSN_LDQ_INDIRECT_OFFSET, I960BASE_INSN_LDQ_INDIRECT_OFFSET, I960BASE_SFMT_LDQ_INDIRECT_OFFSET },
  { I960_INSN_LDQ_INDIRECT, I960BASE_INSN_LDQ_INDIRECT, I960BASE_SFMT_LDQ_INDIRECT },
  { I960_INSN_LDQ_INDIRECT_INDEX, I960BASE_INSN_LDQ_INDIRECT_INDEX, I960BASE_SFMT_LDQ_INDIRECT_INDEX },
  { I960_INSN_LDQ_DISP, I960BASE_INSN_LDQ_DISP, I960BASE_SFMT_LDQ_DISP },
  { I960_INSN_LDQ_INDIRECT_DISP, I960BASE_INSN_LDQ_INDIRECT_DISP, I960BASE_SFMT_LDQ_INDIRECT_DISP },
  { I960_INSN_LDQ_INDEX_DISP, I960BASE_INSN_LDQ_INDEX_DISP, I960BASE_SFMT_LDQ_INDEX_DISP },
  { I960_INSN_LDQ_INDIRECT_INDEX_DISP, I960BASE_INSN_LDQ_INDIRECT_INDEX_DISP, I960BASE_SFMT_LDQ_INDIRECT_INDEX_DISP },
  { I960_INSN_ST_OFFSET, I960BASE_INSN_ST_OFFSET, I960BASE_SFMT_ST_OFFSET },
  { I960_INSN_ST_INDIRECT_OFFSET, I960BASE_INSN_ST_INDIRECT_OFFSET, I960BASE_SFMT_ST_INDIRECT_OFFSET },
  { I960_INSN_ST_INDIRECT, I960BASE_INSN_ST_INDIRECT, I960BASE_SFMT_ST_INDIRECT },
  { I960_INSN_ST_INDIRECT_INDEX, I960BASE_INSN_ST_INDIRECT_INDEX, I960BASE_SFMT_ST_INDIRECT_INDEX },
  { I960_INSN_ST_DISP, I960BASE_INSN_ST_DISP, I960BASE_SFMT_ST_DISP },
  { I960_INSN_ST_INDIRECT_DISP, I960BASE_INSN_ST_INDIRECT_DISP, I960BASE_SFMT_ST_INDIRECT_DISP },
  { I960_INSN_ST_INDEX_DISP, I960BASE_INSN_ST_INDEX_DISP, I960BASE_SFMT_ST_INDEX_DISP },
  { I960_INSN_ST_INDIRECT_INDEX_DISP, I960BASE_INSN_ST_INDIRECT_INDEX_DISP, I960BASE_SFMT_ST_INDIRECT_INDEX_DISP },
  { I960_INSN_STOB_OFFSET, I960BASE_INSN_STOB_OFFSET, I960BASE_SFMT_ST_OFFSET },
  { I960_INSN_STOB_INDIRECT_OFFSET, I960BASE_INSN_STOB_INDIRECT_OFFSET, I960BASE_SFMT_ST_INDIRECT_OFFSET },
  { I960_INSN_STOB_INDIRECT, I960BASE_INSN_STOB_INDIRECT, I960BASE_SFMT_ST_INDIRECT },
  { I960_INSN_STOB_INDIRECT_INDEX, I960BASE_INSN_STOB_INDIRECT_INDEX, I960BASE_SFMT_ST_INDIRECT_INDEX },
  { I960_INSN_STOB_DISP, I960BASE_INSN_STOB_DISP, I960BASE_SFMT_ST_DISP },
  { I960_INSN_STOB_INDIRECT_DISP, I960BASE_INSN_STOB_INDIRECT_DISP, I960BASE_SFMT_ST_INDIRECT_DISP },
  { I960_INSN_STOB_INDEX_DISP, I960BASE_INSN_STOB_INDEX_DISP, I960BASE_SFMT_ST_INDEX_DISP },
  { I960_INSN_STOB_INDIRECT_INDEX_DISP, I960BASE_INSN_STOB_INDIRECT_INDEX_DISP, I960BASE_SFMT_ST_INDIRECT_INDEX_DISP },
  { I960_INSN_STOS_OFFSET, I960BASE_INSN_STOS_OFFSET, I960BASE_SFMT_ST_OFFSET },
  { I960_INSN_STOS_INDIRECT_OFFSET, I960BASE_INSN_STOS_INDIRECT_OFFSET, I960BASE_SFMT_ST_INDIRECT_OFFSET },
  { I960_INSN_STOS_INDIRECT, I960BASE_INSN_STOS_INDIRECT, I960BASE_SFMT_ST_INDIRECT },
  { I960_INSN_STOS_INDIRECT_INDEX, I960BASE_INSN_STOS_INDIRECT_INDEX, I960BASE_SFMT_ST_INDIRECT_INDEX },
  { I960_INSN_STOS_DISP, I960BASE_INSN_STOS_DISP, I960BASE_SFMT_ST_DISP },
  { I960_INSN_STOS_INDIRECT_DISP, I960BASE_INSN_STOS_INDIRECT_DISP, I960BASE_SFMT_ST_INDIRECT_DISP },
  { I960_INSN_STOS_INDEX_DISP, I960BASE_INSN_STOS_INDEX_DISP, I960BASE_SFMT_ST_INDEX_DISP },
  { I960_INSN_STOS_INDIRECT_INDEX_DISP, I960BASE_INSN_STOS_INDIRECT_INDEX_DISP, I960BASE_SFMT_ST_INDIRECT_INDEX_DISP },
  { I960_INSN_STL_OFFSET, I960BASE_INSN_STL_OFFSET, I960BASE_SFMT_STL_OFFSET },
  { I960_INSN_STL_INDIRECT_OFFSET, I960BASE_INSN_STL_INDIRECT_OFFSET, I960BASE_SFMT_STL_INDIRECT_OFFSET },
  { I960_INSN_STL_INDIRECT, I960BASE_INSN_STL_INDIRECT, I960BASE_SFMT_STL_INDIRECT },
  { I960_INSN_STL_INDIRECT_INDEX, I960BASE_INSN_STL_INDIRECT_INDEX, I960BASE_SFMT_STL_INDIRECT_INDEX },
  { I960_INSN_STL_DISP, I960BASE_INSN_STL_DISP, I960BASE_SFMT_STL_DISP },
  { I960_INSN_STL_INDIRECT_DISP, I960BASE_INSN_STL_INDIRECT_DISP, I960BASE_SFMT_STL_INDIRECT_DISP },
  { I960_INSN_STL_INDEX_DISP, I960BASE_INSN_STL_INDEX_DISP, I960BASE_SFMT_STL_INDEX_DISP },
  { I960_INSN_STL_INDIRECT_INDEX_DISP, I960BASE_INSN_STL_INDIRECT_INDEX_DISP, I960BASE_SFMT_STL_INDIRECT_INDEX_DISP },
  { I960_INSN_STT_OFFSET, I960BASE_INSN_STT_OFFSET, I960BASE_SFMT_STT_OFFSET },
  { I960_INSN_STT_INDIRECT_OFFSET, I960BASE_INSN_STT_INDIRECT_OFFSET, I960BASE_SFMT_STT_INDIRECT_OFFSET },
  { I960_INSN_STT_INDIRECT, I960BASE_INSN_STT_INDIRECT, I960BASE_SFMT_STT_INDIRECT },
  { I960_INSN_STT_INDIRECT_INDEX, I960BASE_INSN_STT_INDIRECT_INDEX, I960BASE_SFMT_STT_INDIRECT_INDEX },
  { I960_INSN_STT_DISP, I960BASE_INSN_STT_DISP, I960BASE_SFMT_STT_DISP },
  { I960_INSN_STT_INDIRECT_DISP, I960BASE_INSN_STT_INDIRECT_DISP, I960BASE_SFMT_STT_INDIRECT_DISP },
  { I960_INSN_STT_INDEX_DISP, I960BASE_INSN_STT_INDEX_DISP, I960BASE_SFMT_STT_INDEX_DISP },
  { I960_INSN_STT_INDIRECT_INDEX_DISP, I960BASE_INSN_STT_INDIRECT_INDEX_DISP, I960BASE_SFMT_STT_INDIRECT_INDEX_DISP },
  { I960_INSN_STQ_OFFSET, I960BASE_INSN_STQ_OFFSET, I960BASE_SFMT_STQ_OFFSET },
  { I960_INSN_STQ_INDIRECT_OFFSET, I960BASE_INSN_STQ_INDIRECT_OFFSET, I960BASE_SFMT_STQ_INDIRECT_OFFSET },
  { I960_INSN_STQ_INDIRECT, I960BASE_INSN_STQ_INDIRECT, I960BASE_SFMT_STQ_INDIRECT },
  { I960_INSN_STQ_INDIRECT_INDEX, I960BASE_INSN_STQ_INDIRECT_INDEX, I960BASE_SFMT_STQ_INDIRECT_INDEX },
  { I960_INSN_STQ_DISP, I960BASE_INSN_STQ_DISP, I960BASE_SFMT_STQ_DISP },
  { I960_INSN_STQ_INDIRECT_DISP, I960BASE_INSN_STQ_INDIRECT_DISP, I960BASE_SFMT_STQ_INDIRECT_DISP },
  { I960_INSN_STQ_INDEX_DISP, I960BASE_INSN_STQ_INDEX_DISP, I960BASE_SFMT_STQ_INDEX_DISP },
  { I960_INSN_STQ_INDIRECT_INDEX_DISP, I960BASE_INSN_STQ_INDIRECT_INDEX_DISP, I960BASE_SFMT_STQ_INDIRECT_INDEX_DISP },
  { I960_INSN_CMPOBE_REG, I960BASE_INSN_CMPOBE_REG, I960BASE_SFMT_CMPOBE_REG },
  { I960_INSN_CMPOBE_LIT, I960BASE_INSN_CMPOBE_LIT, I960BASE_SFMT_CMPOBE_LIT },
  { I960_INSN_CMPOBNE_REG, I960BASE_INSN_CMPOBNE_REG, I960BASE_SFMT_CMPOBE_REG },
  { I960_INSN_CMPOBNE_LIT, I960BASE_INSN_CMPOBNE_LIT, I960BASE_SFMT_CMPOBE_LIT },
  { I960_INSN_CMPOBL_REG, I960BASE_INSN_CMPOBL_REG, I960BASE_SFMT_CMPOBL_REG },
  { I960_INSN_CMPOBL_LIT, I960BASE_INSN_CMPOBL_LIT, I960BASE_SFMT_CMPOBL_LIT },
  { I960_INSN_CMPOBLE_REG, I960BASE_INSN_CMPOBLE_REG, I960BASE_SFMT_CMPOBL_REG },
  { I960_INSN_CMPOBLE_LIT, I960BASE_INSN_CMPOBLE_LIT, I960BASE_SFMT_CMPOBL_LIT },
  { I960_INSN_CMPOBG_REG, I960BASE_INSN_CMPOBG_REG, I960BASE_SFMT_CMPOBL_REG },
  { I960_INSN_CMPOBG_LIT, I960BASE_INSN_CMPOBG_LIT, I960BASE_SFMT_CMPOBL_LIT },
  { I960_INSN_CMPOBGE_REG, I960BASE_INSN_CMPOBGE_REG, I960BASE_SFMT_CMPOBL_REG },
  { I960_INSN_CMPOBGE_LIT, I960BASE_INSN_CMPOBGE_LIT, I960BASE_SFMT_CMPOBL_LIT },
  { I960_INSN_CMPIBE_REG, I960BASE_INSN_CMPIBE_REG, I960BASE_SFMT_CMPOBE_REG },
  { I960_INSN_CMPIBE_LIT, I960BASE_INSN_CMPIBE_LIT, I960BASE_SFMT_CMPOBE_LIT },
  { I960_INSN_CMPIBNE_REG, I960BASE_INSN_CMPIBNE_REG, I960BASE_SFMT_CMPOBE_REG },
  { I960_INSN_CMPIBNE_LIT, I960BASE_INSN_CMPIBNE_LIT, I960BASE_SFMT_CMPOBE_LIT },
  { I960_INSN_CMPIBL_REG, I960BASE_INSN_CMPIBL_REG, I960BASE_SFMT_CMPOBE_REG },
  { I960_INSN_CMPIBL_LIT, I960BASE_INSN_CMPIBL_LIT, I960BASE_SFMT_CMPOBE_LIT },
  { I960_INSN_CMPIBLE_REG, I960BASE_INSN_CMPIBLE_REG, I960BASE_SFMT_CMPOBE_REG },
  { I960_INSN_CMPIBLE_LIT, I960BASE_INSN_CMPIBLE_LIT, I960BASE_SFMT_CMPOBE_LIT },
  { I960_INSN_CMPIBG_REG, I960BASE_INSN_CMPIBG_REG, I960BASE_SFMT_CMPOBE_REG },
  { I960_INSN_CMPIBG_LIT, I960BASE_INSN_CMPIBG_LIT, I960BASE_SFMT_CMPOBE_LIT },
  { I960_INSN_CMPIBGE_REG, I960BASE_INSN_CMPIBGE_REG, I960BASE_SFMT_CMPOBE_REG },
  { I960_INSN_CMPIBGE_LIT, I960BASE_INSN_CMPIBGE_LIT, I960BASE_SFMT_CMPOBE_LIT },
  { I960_INSN_BBC_REG, I960BASE_INSN_BBC_REG, I960BASE_SFMT_BBC_REG },
  { I960_INSN_BBC_LIT, I960BASE_INSN_BBC_LIT, I960BASE_SFMT_BBC_LIT },
  { I960_INSN_BBS_REG, I960BASE_INSN_BBS_REG, I960BASE_SFMT_BBC_REG },
  { I960_INSN_BBS_LIT, I960BASE_INSN_BBS_LIT, I960BASE_SFMT_BBC_LIT },
  { I960_INSN_CMPI, I960BASE_INSN_CMPI, I960BASE_SFMT_CMPI },
  { I960_INSN_CMPI1, I960BASE_INSN_CMPI1, I960BASE_SFMT_CMPI1 },
  { I960_INSN_CMPI2, I960BASE_INSN_CMPI2, I960BASE_SFMT_CMPI2 },
  { I960_INSN_CMPI3, I960BASE_INSN_CMPI3, I960BASE_SFMT_CMPI3 },
  { I960_INSN_CMPO, I960BASE_INSN_CMPO, I960BASE_SFMT_CMPO },
  { I960_INSN_CMPO1, I960BASE_INSN_CMPO1, I960BASE_SFMT_CMPO1 },
  { I960_INSN_CMPO2, I960BASE_INSN_CMPO2, I960BASE_SFMT_CMPO2 },
  { I960_INSN_CMPO3, I960BASE_INSN_CMPO3, I960BASE_SFMT_CMPO3 },
  { I960_INSN_TESTNO_REG, I960BASE_INSN_TESTNO_REG, I960BASE_SFMT_TESTNO_REG },
  { I960_INSN_TESTG_REG, I960BASE_INSN_TESTG_REG, I960BASE_SFMT_TESTNO_REG },
  { I960_INSN_TESTE_REG, I960BASE_INSN_TESTE_REG, I960BASE_SFMT_TESTNO_REG },
  { I960_INSN_TESTGE_REG, I960BASE_INSN_TESTGE_REG, I960BASE_SFMT_TESTNO_REG },
  { I960_INSN_TESTL_REG, I960BASE_INSN_TESTL_REG, I960BASE_SFMT_TESTNO_REG },
  { I960_INSN_TESTNE_REG, I960BASE_INSN_TESTNE_REG, I960BASE_SFMT_TESTNO_REG },
  { I960_INSN_TESTLE_REG, I960BASE_INSN_TESTLE_REG, I960BASE_SFMT_TESTNO_REG },
  { I960_INSN_TESTO_REG, I960BASE_INSN_TESTO_REG, I960BASE_SFMT_TESTNO_REG },
  { I960_INSN_BNO, I960BASE_INSN_BNO, I960BASE_SFMT_BNO },
  { I960_INSN_BG, I960BASE_INSN_BG, I960BASE_SFMT_BNO },
  { I960_INSN_BE, I960BASE_INSN_BE, I960BASE_SFMT_BNO },
  { I960_INSN_BGE, I960BASE_INSN_BGE, I960BASE_SFMT_BNO },
  { I960_INSN_BL, I960BASE_INSN_BL, I960BASE_SFMT_BNO },
  { I960_INSN_BNE, I960BASE_INSN_BNE, I960BASE_SFMT_BNO },
  { I960_INSN_BLE, I960BASE_INSN_BLE, I960BASE_SFMT_BNO },
  { I960_INSN_BO, I960BASE_INSN_BO, I960BASE_SFMT_BNO },
  { I960_INSN_B, I960BASE_INSN_B, I960BASE_SFMT_B },
  { I960_INSN_BX_INDIRECT_OFFSET, I960BASE_INSN_BX_INDIRECT_OFFSET, I960BASE_SFMT_BX_INDIRECT_OFFSET },
  { I960_INSN_BX_INDIRECT, I960BASE_INSN_BX_INDIRECT, I960BASE_SFMT_BX_INDIRECT },
  { I960_INSN_BX_INDIRECT_INDEX, I960BASE_INSN_BX_INDIRECT_INDEX, I960BASE_SFMT_BX_INDIRECT_INDEX },
  { I960_INSN_BX_DISP, I960BASE_INSN_BX_DISP, I960BASE_SFMT_BX_DISP },
  { I960_INSN_BX_INDIRECT_DISP, I960BASE_INSN_BX_INDIRECT_DISP, I960BASE_SFMT_BX_INDIRECT_DISP },
  { I960_INSN_CALLX_DISP, I960BASE_INSN_CALLX_DISP, I960BASE_SFMT_CALLX_DISP },
  { I960_INSN_CALLX_INDIRECT, I960BASE_INSN_CALLX_INDIRECT, I960BASE_SFMT_CALLX_INDIRECT },
  { I960_INSN_CALLX_INDIRECT_OFFSET, I960BASE_INSN_CALLX_INDIRECT_OFFSET, I960BASE_SFMT_CALLX_INDIRECT_OFFSET },
  { I960_INSN_RET, I960BASE_INSN_RET, I960BASE_SFMT_RET },
  { I960_INSN_CALLS, I960BASE_INSN_CALLS, I960BASE_SFMT_CALLS },
  { I960_INSN_FMARK, I960BASE_INSN_FMARK, I960BASE_SFMT_FMARK },
  { I960_INSN_FLUSHREG, I960BASE_INSN_FLUSHREG, I960BASE_SFMT_FLUSHREG },
};

static const struct insn_sem i960base_insn_sem_invalid = {
  VIRTUAL_INSN_X_INVALID, I960BASE_INSN_X_INVALID, I960BASE_SFMT_EMPTY
};

/* Initialize an IDESC from the compile-time computable parts.  */

static INLINE void
init_idesc (SIM_CPU *cpu, IDESC *id, const struct insn_sem *t)
{
  const CGEN_INSN *insn_table = CGEN_CPU_INSN_TABLE (CPU_CPU_DESC (cpu))->init_entries;

  id->num = t->index;
  id->sfmt = t->sfmt;
  if ((int) t->type <= 0)
    id->idata = & cgen_virtual_insn_table[- (int) t->type];
  else
    id->idata = & insn_table[t->type];
  id->attrs = CGEN_INSN_ATTRS (id->idata);
  /* Oh my god, a magic number.  */
  id->length = CGEN_INSN_BITSIZE (id->idata) / 8;

#if WITH_PROFILE_MODEL_P
  id->timing = & MODEL_TIMING (CPU_MODEL (cpu)) [t->index];
  {
    SIM_DESC sd = CPU_STATE (cpu);
    SIM_ASSERT (t->index == id->timing->num);
  }
#endif

  /* Semantic pointers are initialized elsewhere.  */
}

/* Initialize the instruction descriptor table.  */

void
i960base_init_idesc_table (SIM_CPU *cpu)
{
  IDESC *id,*tabend;
  const struct insn_sem *t,*tend;
  int tabsize = I960BASE_INSN_MAX;
  IDESC *table = i960base_insn_data;

  memset (table, 0, tabsize * sizeof (IDESC));

  /* First set all entries to the `invalid insn'.  */
  t = & i960base_insn_sem_invalid;
  for (id = table, tabend = table + tabsize; id < tabend; ++id)
    init_idesc (cpu, id, t);

  /* Now fill in the values for the chosen cpu.  */
  for (t = i960base_insn_sem, tend = t + sizeof (i960base_insn_sem) / sizeof (*t);
       t != tend; ++t)
    {
      init_idesc (cpu, & table[t->index], t);
    }

  /* Link the IDESC table into the cpu.  */
  CPU_IDESC (cpu) = table;
}

/* Given an instruction, return a pointer to its IDESC entry.  */

const IDESC *
i960base_decode (SIM_CPU *current_cpu, IADDR pc,
              CGEN_INSN_INT base_insn,
              ARGBUF *abuf)
{
  /* Result of decoder.  */
  I960BASE_INSN_TYPE itype;

  {
    CGEN_INSN_INT insn = base_insn;

    {
      unsigned int val = (((insn >> 24) & (255 << 0)));
      switch (val)
      {
      case 8 : itype = I960BASE_INSN_B; goto extract_sfmt_b;
      case 10 : itype = I960BASE_INSN_RET; goto extract_sfmt_ret;
      case 16 : itype = I960BASE_INSN_BNO; goto extract_sfmt_bno;
      case 17 : itype = I960BASE_INSN_BG; goto extract_sfmt_bno;
      case 18 : itype = I960BASE_INSN_BE; goto extract_sfmt_bno;
      case 19 : itype = I960BASE_INSN_BGE; goto extract_sfmt_bno;
      case 20 : itype = I960BASE_INSN_BL; goto extract_sfmt_bno;
      case 21 : itype = I960BASE_INSN_BNE; goto extract_sfmt_bno;
      case 22 : itype = I960BASE_INSN_BLE; goto extract_sfmt_bno;
      case 23 : itype = I960BASE_INSN_BO; goto extract_sfmt_bno;
      case 32 : itype = I960BASE_INSN_TESTNO_REG; goto extract_sfmt_testno_reg;
      case 33 : itype = I960BASE_INSN_TESTG_REG; goto extract_sfmt_testno_reg;
      case 34 : itype = I960BASE_INSN_TESTE_REG; goto extract_sfmt_testno_reg;
      case 35 : itype = I960BASE_INSN_TESTGE_REG; goto extract_sfmt_testno_reg;
      case 36 : itype = I960BASE_INSN_TESTL_REG; goto extract_sfmt_testno_reg;
      case 37 : itype = I960BASE_INSN_TESTNE_REG; goto extract_sfmt_testno_reg;
      case 38 : itype = I960BASE_INSN_TESTLE_REG; goto extract_sfmt_testno_reg;
      case 39 : itype = I960BASE_INSN_TESTO_REG; goto extract_sfmt_testno_reg;
      case 48 :
        {
          unsigned int val = (((insn >> 11) & (1 << 2)) | ((insn >> 0) & (3 << 0)));
          switch (val)
          {
          case 0 : itype = I960BASE_INSN_BBC_REG; goto extract_sfmt_bbc_reg;
          case 4 : itype = I960BASE_INSN_BBC_LIT; goto extract_sfmt_bbc_lit;
          default : itype = I960BASE_INSN_X_INVALID; goto extract_sfmt_empty;
          }
        }
      case 49 :
        {
          unsigned int val = (((insn >> 11) & (1 << 2)) | ((insn >> 0) & (3 << 0)));
          switch (val)
          {
          case 0 : itype = I960BASE_INSN_CMPOBG_REG; goto extract_sfmt_cmpobl_reg;
          case 4 : itype = I960BASE_INSN_CMPOBG_LIT; goto extract_sfmt_cmpobl_lit;
          default : itype = I960BASE_INSN_X_INVALID; goto extract_sfmt_empty;
          }
        }
      case 50 :
        {
          unsigned int val = (((insn >> 11) & (1 << 2)) | ((insn >> 0) & (3 << 0)));
          switch (val)
          {
          case 0 : itype = I960BASE_INSN_CMPOBE_REG; goto extract_sfmt_cmpobe_reg;
          case 4 : itype = I960BASE_INSN_CMPOBE_LIT; goto extract_sfmt_cmpobe_lit;
          default : itype = I960BASE_INSN_X_INVALID; goto extract_sfmt_empty;
          }
        }
      case 51 :
        {
          unsigned int val = (((insn >> 11) & (1 << 2)) | ((insn >> 0) & (3 << 0)));
          switch (val)
          {
          case 0 : itype = I960BASE_INSN_CMPOBGE_REG; goto extract_sfmt_cmpobl_reg;
          case 4 : itype = I960BASE_INSN_CMPOBGE_LIT; goto extract_sfmt_cmpobl_lit;
          default : itype = I960BASE_INSN_X_INVALID; goto extract_sfmt_empty;
          }
        }
      case 52 :
        {
          unsigned int val = (((insn >> 11) & (1 << 2)) | ((insn >> 0) & (3 << 0)));
          switch (val)
          {
          case 0 : itype = I960BASE_INSN_CMPOBL_REG; goto extract_sfmt_cmpobl_reg;
          case 4 : itype = I960BASE_INSN_CMPOBL_LIT; goto extract_sfmt_cmpobl_lit;
          default : itype = I960BASE_INSN_X_INVALID; goto extract_sfmt_empty;
          }
        }
      case 53 :
        {
          unsigned int val = (((insn >> 11) & (1 << 2)) | ((insn >> 0) & (3 << 0)));
          switch (val)
          {
          case 0 : itype = I960BASE_INSN_CMPOBNE_REG; goto extract_sfmt_cmpobe_reg;
          case 4 : itype = I960BASE_INSN_CMPOBNE_LIT; goto extract_sfmt_cmpobe_lit;
          default : itype = I960BASE_INSN_X_INVALID; goto extract_sfmt_empty;
          }
        }
      case 54 :
        {
          unsigned int val = (((insn >> 11) & (1 << 2)) | ((insn >> 0) & (3 << 0)));
          switch (val)
          {
          case 0 : itype = I960BASE_INSN_CMPOBLE_REG; goto extract_sfmt_cmpobl_reg;
          case 4 : itype = I960BASE_INSN_CMPOBLE_LIT; goto extract_sfmt_cmpobl_lit;
          default : itype = I960BASE_INSN_X_INVALID; goto extract_sfmt_empty;
          }
        }
      case 55 :
        {
          unsigned int val = (((insn >> 11) & (1 << 2)) | ((insn >> 0) & (3 << 0)));
          switch (val)
          {
          case 0 : itype = I960BASE_INSN_BBS_REG; goto extract_sfmt_bbc_reg;
          case 4 : itype = I960BASE_INSN_BBS_LIT; goto extract_sfmt_bbc_lit;
          default : itype = I960BASE_INSN_X_INVALID; goto extract_sfmt_empty;
          }
        }
      case 57 :
        {
          unsigned int val = (((insn >> 11) & (1 << 2)) | ((insn >> 0) & (3 << 0)));
          switch (val)
          {
          case 0 : itype = I960BASE_INSN_CMPIBG_REG; goto extract_sfmt_cmpobe_reg;
          case 4 : itype = I960BASE_INSN_CMPIBG_LIT; goto extract_sfmt_cmpobe_lit;
          default : itype = I960BASE_INSN_X_INVALID; goto extract_sfmt_empty;
          }
        }
      case 58 :
        {
          unsigned int val = (((insn >> 11) & (1 << 2)) | ((insn >> 0) & (3 << 0)));
          switch (val)
          {
          case 0 : itype = I960BASE_INSN_CMPIBE_REG; goto extract_sfmt_cmpobe_reg;
          case 4 : itype = I960BASE_INSN_CMPIBE_LIT; goto extract_sfmt_cmpobe_lit;
          default : itype = I960BASE_INSN_X_INVALID; goto extract_sfmt_empty;
          }
        }
      case 59 :
        {
          unsigned int val = (((insn >> 11) & (1 << 2)) | ((insn >> 0) & (3 << 0)));
          switch (val)
          {
          case 0 : itype = I960BASE_INSN_CMPIBGE_REG; goto extract_sfmt_cmpobe_reg;
          case 4 : itype = I960BASE_INSN_CMPIBGE_LIT; goto extract_sfmt_cmpobe_lit;
          default : itype = I960BASE_INSN_X_INVALID; goto extract_sfmt_empty;
          }
        }
      case 60 :
        {
          unsigned int val = (((insn >> 11) & (1 << 2)) | ((insn >> 0) & (3 << 0)));
          switch (val)
          {
          case 0 : itype = I960BASE_INSN_CMPIBL_REG; goto extract_sfmt_cmpobe_reg;
          case 4 : itype = I960BASE_INSN_CMPIBL_LIT; goto extract_sfmt_cmpobe_lit;
          default : itype = I960BASE_INSN_X_INVALID; goto extract_sfmt_empty;
          }
        }
      case 61 :
        {
          unsigned int val = (((insn >> 11) & (1 << 2)) | ((insn >> 0) & (3 << 0)));
          switch (val)
          {
          case 0 : itype = I960BASE_INSN_CMPIBNE_REG; goto extract_sfmt_cmpobe_reg;
          case 4 : itype = I960BASE_INSN_CMPIBNE_LIT; goto extract_sfmt_cmpobe_lit;
          default : itype = I960BASE_INSN_X_INVALID; goto extract_sfmt_empty;
          }
        }
      case 62 :
        {
          unsigned int val = (((insn >> 11) & (1 << 2)) | ((insn >> 0) & (3 << 0)));
          switch (val)
          {
          case 0 : itype = I960BASE_INSN_CMPIBLE_REG; goto extract_sfmt_cmpobe_reg;
          case 4 : itype = I960BASE_INSN_CMPIBLE_LIT; goto extract_sfmt_cmpobe_lit;
          default : itype = I960BASE_INSN_X_INVALID; goto extract_sfmt_empty;
          }
        }
      case 88 :
        {
          unsigned int val = (((insn >> 10) & (15 << 0)));
          switch (val)
          {
          case 0 :
            {
              unsigned int val = (((insn >> 6) & (15 << 0)));
              switch (val)
              {
              case 0 : itype = I960BASE_INSN_NOTBIT; goto extract_sfmt_notbit;
              case 2 : itype = I960BASE_INSN_AND; goto extract_sfmt_mulo;
              case 4 : itype = I960BASE_INSN_ANDNOT; goto extract_sfmt_mulo;
              case 6 : itype = I960BASE_INSN_SETBIT; goto extract_sfmt_notbit;
              case 8 : itype = I960BASE_INSN_NOTAND; goto extract_sfmt_mulo;
              case 12 : itype = I960BASE_INSN_XOR; goto extract_sfmt_mulo;
              case 14 : itype = I960BASE_INSN_OR; goto extract_sfmt_mulo;
              default : itype = I960BASE_INSN_X_INVALID; goto extract_sfmt_empty;
              }
            }
          case 1 :
            {
              unsigned int val = (((insn >> 6) & (15 << 0)));
              switch (val)
              {
              case 0 : itype = I960BASE_INSN_NOR; goto extract_sfmt_mulo;
              case 2 : itype = I960BASE_INSN_XNOR; goto extract_sfmt_mulo;
              case 4 : itype = I960BASE_INSN_NOT; goto extract_sfmt_not;
              case 6 : itype = I960BASE_INSN_ORNOT; goto extract_sfmt_mulo;
              case 8 : itype = I960BASE_INSN_CLRBIT; goto extract_sfmt_notbit;
              default : itype = I960BASE_INSN_X_INVALID; goto extract_sfmt_empty;
              }
            }
          case 2 :
            {
              unsigned int val = (((insn >> 6) & (15 << 0)));
              switch (val)
              {
              case 0 : itype = I960BASE_INSN_NOTBIT1; goto extract_sfmt_notbit1;
              case 2 : itype = I960BASE_INSN_AND1; goto extract_sfmt_mulo1;
              case 4 : itype = I960BASE_INSN_ANDNOT1; goto extract_sfmt_mulo1;
              case 6 : itype = I960BASE_INSN_SETBIT1; goto extract_sfmt_notbit1;
              case 8 : itype = I960BASE_INSN_NOTAND1; goto extract_sfmt_mulo1;
              case 12 : itype = I960BASE_INSN_XOR1; goto extract_sfmt_mulo1;
              case 14 : itype = I960BASE_INSN_OR1; goto extract_sfmt_mulo1;
              default : itype = I960BASE_INSN_X_INVALID; goto extract_sfmt_empty;
              }
            }
          case 3 :
            {
              unsigned int val = (((insn >> 6) & (15 << 0)));
              switch (val)
              {
              case 0 : itype = I960BASE_INSN_NOR1; goto extract_sfmt_mulo1;
              case 2 : itype = I960BASE_INSN_XNOR1; goto extract_sfmt_mulo1;
              case 4 : itype = I960BASE_INSN_NOT1; goto extract_sfmt_not1;
              case 6 : itype = I960BASE_INSN_ORNOT1; goto extract_sfmt_mulo1;
              case 8 : itype = I960BASE_INSN_CLRBIT1; goto extract_sfmt_notbit1;
              default : itype = I960BASE_INSN_X_INVALID; goto extract_sfmt_empty;
              }
            }
          case 4 :
            {
              unsigned int val = (((insn >> 6) & (15 << 0)));
              switch (val)
              {
              case 0 : itype = I960BASE_INSN_NOTBIT2; goto extract_sfmt_notbit2;
              case 2 : itype = I960BASE_INSN_AND2; goto extract_sfmt_mulo2;
              case 4 : itype = I960BASE_INSN_ANDNOT2; goto extract_sfmt_mulo2;
              case 6 : itype = I960BASE_INSN_SETBIT2; goto extract_sfmt_notbit2;
              case 8 : itype = I960BASE_INSN_NOTAND2; goto extract_sfmt_mulo2;
              case 12 : itype = I960BASE_INSN_XOR2; goto extract_sfmt_mulo2;
              case 14 : itype = I960BASE_INSN_OR2; goto extract_sfmt_mulo2;
              default : itype = I960BASE_INSN_X_INVALID; goto extract_sfmt_empty;
              }
            }
          case 5 :
            {
              unsigned int val = (((insn >> 6) & (15 << 0)));
              switch (val)
              {
              case 0 : itype = I960BASE_INSN_NOR2; goto extract_sfmt_mulo2;
              case 2 : itype = I960BASE_INSN_XNOR2; goto extract_sfmt_mulo2;
              case 4 : itype = I960BASE_INSN_NOT2; goto extract_sfmt_not;
              case 6 : itype = I960BASE_INSN_ORNOT2; goto extract_sfmt_mulo2;
              case 8 : itype = I960BASE_INSN_CLRBIT2; goto extract_sfmt_notbit2;
              default : itype = I960BASE_INSN_X_INVALID; goto extract_sfmt_empty;
              }
            }
          case 6 :
            {
              unsigned int val = (((insn >> 6) & (15 << 0)));
              switch (val)
              {
              case 0 : itype = I960BASE_INSN_NOTBIT3; goto extract_sfmt_notbit3;
              case 2 : itype = I960BASE_INSN_AND3; goto extract_sfmt_mulo3;
              case 4 : itype = I960BASE_INSN_ANDNOT3; goto extract_sfmt_mulo3;
              case 6 : itype = I960BASE_INSN_SETBIT3; goto extract_sfmt_notbit3;
              case 8 : itype = I960BASE_INSN_NOTAND3; goto extract_sfmt_mulo3;
              case 12 : itype = I960BASE_INSN_XOR3; goto extract_sfmt_mulo3;
              case 14 : itype = I960BASE_INSN_OR3; goto extract_sfmt_mulo3;
              default : itype = I960BASE_INSN_X_INVALID; goto extract_sfmt_empty;
              }
            }
          case 7 :
            {
              unsigned int val = (((insn >> 6) & (15 << 0)));
              switch (val)
              {
              case 0 : itype = I960BASE_INSN_NOR3; goto extract_sfmt_mulo3;
              case 2 : itype = I960BASE_INSN_XNOR3; goto extract_sfmt_mulo3;
              case 4 : itype = I960BASE_INSN_NOT3; goto extract_sfmt_not1;
              case 6 : itype = I960BASE_INSN_ORNOT3; goto extract_sfmt_mulo3;
              case 8 : itype = I960BASE_INSN_CLRBIT3; goto extract_sfmt_notbit3;
              default : itype = I960BASE_INSN_X_INVALID; goto extract_sfmt_empty;
              }
            }
          default : itype = I960BASE_INSN_X_INVALID; goto extract_sfmt_empty;
          }
        }
      case 89 :
        {
          unsigned int val = (((insn >> 10) & (15 << 0)));
          switch (val)
          {
          case 0 :
            {
              unsigned int val = (((insn >> 6) & (15 << 0)));
              switch (val)
              {
              case 0 : itype = I960BASE_INSN_ADDO; goto extract_sfmt_mulo;
              case 4 : itype = I960BASE_INSN_SUBO; goto extract_sfmt_mulo;
              default : itype = I960BASE_INSN_X_INVALID; goto extract_sfmt_empty;
              }
            }
          case 1 :
            {
              unsigned int val = (((insn >> 6) & (15 << 0)));
              switch (val)
              {
              case 0 : itype = I960BASE_INSN_SHRO; goto extract_sfmt_shlo;
              case 6 : itype = I960BASE_INSN_SHRI; goto extract_sfmt_shlo;
              case 8 : itype = I960BASE_INSN_SHLO; goto extract_sfmt_shlo;
              case 12 : itype = I960BASE_INSN_SHLI; goto extract_sfmt_shlo;
              default : itype = I960BASE_INSN_X_INVALID; goto extract_sfmt_empty;
              }
            }
          case 2 :
            {
              unsigned int val = (((insn >> 6) & (15 << 0)));
              switch (val)
              {
              case 0 : itype = I960BASE_INSN_ADDO1; goto extract_sfmt_mulo1;
              case 4 : itype = I960BASE_INSN_SUBO1; goto extract_sfmt_mulo1;
              default : itype = I960BASE_INSN_X_INVALID; goto extract_sfmt_empty;
              }
            }
          case 3 :
            {
              unsigned int val = (((insn >> 6) & (15 << 0)));
              switch (val)
              {
              case 0 : itype = I960BASE_INSN_SHRO1; goto extract_sfmt_shlo1;
              case 6 : itype = I960BASE_INSN_SHRI1; goto extract_sfmt_shlo1;
              case 8 : itype = I960BASE_INSN_SHLO1; goto extract_sfmt_shlo1;
              case 12 : itype = I960BASE_INSN_SHLI1; goto extract_sfmt_shlo1;
              default : itype = I960BASE_INSN_X_INVALID; goto extract_sfmt_empty;
              }
            }
          case 4 :
            {
              unsigned int val = (((insn >> 6) & (15 << 0)));
              switch (val)
              {
              case 0 : itype = I960BASE_INSN_ADDO2; goto extract_sfmt_mulo2;
              case 4 : itype = I960BASE_INSN_SUBO2; goto extract_sfmt_mulo2;
              default : itype = I960BASE_INSN_X_INVALID; goto extract_sfmt_empty;
              }
            }
          case 5 :
            {
              unsigned int val = (((insn >> 6) & (15 << 0)));
              switch (val)
              {
              case 0 : itype = I960BASE_INSN_SHRO2; goto extract_sfmt_shlo2;
              case 6 : itype = I960BASE_INSN_SHRI2; goto extract_sfmt_shlo2;
              case 8 : itype = I960BASE_INSN_SHLO2; goto extract_sfmt_shlo2;
              case 12 : itype = I960BASE_INSN_SHLI2; goto extract_sfmt_shlo2;
              default : itype = I960BASE_INSN_X_INVALID; goto extract_sfmt_empty;
              }
            }
          case 6 :
            {
              unsigned int val = (((insn >> 6) & (15 << 0)));
              switch (val)
              {
              case 0 : itype = I960BASE_INSN_ADDO3; goto extract_sfmt_mulo3;
              case 4 : itype = I960BASE_INSN_SUBO3; goto extract_sfmt_mulo3;
              default : itype = I960BASE_INSN_X_INVALID; goto extract_sfmt_empty;
              }
            }
          case 7 :
            {
              unsigned int val = (((insn >> 6) & (15 << 0)));
              switch (val)
              {
              case 0 : itype = I960BASE_INSN_SHRO3; goto extract_sfmt_shlo3;
              case 6 : itype = I960BASE_INSN_SHRI3; goto extract_sfmt_shlo3;
              case 8 : itype = I960BASE_INSN_SHLO3; goto extract_sfmt_shlo3;
              case 12 : itype = I960BASE_INSN_SHLI3; goto extract_sfmt_shlo3;
              default : itype = I960BASE_INSN_X_INVALID; goto extract_sfmt_empty;
              }
            }
          default : itype = I960BASE_INSN_X_INVALID; goto extract_sfmt_empty;
          }
        }
      case 90 :
        {
          unsigned int val = (((insn >> 10) & (15 << 0)));
          switch (val)
          {
          case 8 :
            {
              unsigned int val = (((insn >> 6) & (15 << 0)));
              switch (val)
              {
              case 0 : itype = I960BASE_INSN_CMPO; goto extract_sfmt_cmpo;
              case 2 : itype = I960BASE_INSN_CMPI; goto extract_sfmt_cmpi;
              default : itype = I960BASE_INSN_X_INVALID; goto extract_sfmt_empty;
              }
            }
          case 10 :
            {
              unsigned int val = (((insn >> 6) & (15 << 0)));
              switch (val)
              {
              case 0 : itype = I960BASE_INSN_CMPO1; goto extract_sfmt_cmpo1;
              case 2 : itype = I960BASE_INSN_CMPI1; goto extract_sfmt_cmpi1;
              default : itype = I960BASE_INSN_X_INVALID; goto extract_sfmt_empty;
              }
            }
          case 12 :
            {
              unsigned int val = (((insn >> 6) & (15 << 0)));
              switch (val)
              {
              case 0 : itype = I960BASE_INSN_CMPO2; goto extract_sfmt_cmpo2;
              case 2 : itype = I960BASE_INSN_CMPI2; goto extract_sfmt_cmpi2;
              default : itype = I960BASE_INSN_X_INVALID; goto extract_sfmt_empty;
              }
            }
          case 14 :
            {
              unsigned int val = (((insn >> 6) & (15 << 0)));
              switch (val)
              {
              case 0 : itype = I960BASE_INSN_CMPO3; goto extract_sfmt_cmpo3;
              case 2 : itype = I960BASE_INSN_CMPI3; goto extract_sfmt_cmpi3;
              default : itype = I960BASE_INSN_X_INVALID; goto extract_sfmt_empty;
              }
            }
          default : itype = I960BASE_INSN_X_INVALID; goto extract_sfmt_empty;
          }
        }
      case 92 :
        {
          unsigned int val = (((insn >> 10) & (15 << 0)));
          switch (val)
          {
          case 5 : itype = I960BASE_INSN_MOV; goto extract_sfmt_not;
          case 7 : itype = I960BASE_INSN_MOV1; goto extract_sfmt_not1;
          default : itype = I960BASE_INSN_X_INVALID; goto extract_sfmt_empty;
          }
        }
      case 93 :
        {
          unsigned int val = (((insn >> 10) & (15 << 0)));
          switch (val)
          {
          case 5 : itype = I960BASE_INSN_MOVL; goto extract_sfmt_movl;
          case 7 : itype = I960BASE_INSN_MOVL1; goto extract_sfmt_movl1;
          default : itype = I960BASE_INSN_X_INVALID; goto extract_sfmt_empty;
          }
        }
      case 94 :
        {
          unsigned int val = (((insn >> 10) & (15 << 0)));
          switch (val)
          {
          case 5 : itype = I960BASE_INSN_MOVT; goto extract_sfmt_movt;
          case 7 : itype = I960BASE_INSN_MOVT1; goto extract_sfmt_movt1;
          default : itype = I960BASE_INSN_X_INVALID; goto extract_sfmt_empty;
          }
        }
      case 95 :
        {
          unsigned int val = (((insn >> 10) & (15 << 0)));
          switch (val)
          {
          case 5 : itype = I960BASE_INSN_MOVQ; goto extract_sfmt_movq;
          case 7 : itype = I960BASE_INSN_MOVQ1; goto extract_sfmt_movq1;
          default : itype = I960BASE_INSN_X_INVALID; goto extract_sfmt_empty;
          }
        }
      case 100 : itype = I960BASE_INSN_MODAC; goto extract_sfmt_modpc;
      case 101 : itype = I960BASE_INSN_MODPC; goto extract_sfmt_modpc;
      case 102 :
        {
          unsigned int val = (((insn >> 10) & (15 << 0)));
          switch (val)
          {
          case 12 : itype = I960BASE_INSN_CALLS; goto extract_sfmt_calls;
          case 15 :
            {
              unsigned int val = (((insn >> 6) & (15 << 0)));
              switch (val)
              {
              case 8 : itype = I960BASE_INSN_FMARK; goto extract_sfmt_fmark;
              case 10 : itype = I960BASE_INSN_FLUSHREG; goto extract_sfmt_flushreg;
              default : itype = I960BASE_INSN_X_INVALID; goto extract_sfmt_empty;
              }
            }
          default : itype = I960BASE_INSN_X_INVALID; goto extract_sfmt_empty;
          }
        }
      case 103 :
        {
          unsigned int val = (((insn >> 10) & (15 << 0)));
          switch (val)
          {
          case 0 : itype = I960BASE_INSN_EMUL; goto extract_sfmt_emul;
          case 2 : itype = I960BASE_INSN_EMUL1; goto extract_sfmt_emul1;
          case 4 : itype = I960BASE_INSN_EMUL2; goto extract_sfmt_emul2;
          case 6 : itype = I960BASE_INSN_EMUL3; goto extract_sfmt_emul3;
          default : itype = I960BASE_INSN_X_INVALID; goto extract_sfmt_empty;
          }
        }
      case 112 :
        {
          unsigned int val = (((insn >> 10) & (15 << 0)));
          switch (val)
          {
          case 0 : itype = I960BASE_INSN_MULO; goto extract_sfmt_mulo;
          case 1 :
            {
              unsigned int val = (((insn >> 6) & (15 << 0)));
              switch (val)
              {
              case 0 : itype = I960BASE_INSN_REMO; goto extract_sfmt_mulo;
              case 6 : itype = I960BASE_INSN_DIVO; goto extract_sfmt_mulo;
              default : itype = I960BASE_INSN_X_INVALID; goto extract_sfmt_empty;
              }
            }
          case 2 : itype = I960BASE_INSN_MULO1; goto extract_sfmt_mulo1;
          case 3 :
            {
              unsigned int val = (((insn >> 6) & (15 << 0)));
              switch (val)
              {
              case 0 : itype = I960BASE_INSN_REMO1; goto extract_sfmt_mulo1;
              case 6 : itype = I960BASE_INSN_DIVO1; goto extract_sfmt_mulo1;
              default : itype = I960BASE_INSN_X_INVALID; goto extract_sfmt_empty;
              }
            }
          case 4 : itype = I960BASE_INSN_MULO2; goto extract_sfmt_mulo2;
          case 5 :
            {
              unsigned int val = (((insn >> 6) & (15 << 0)));
              switch (val)
              {
              case 0 : itype = I960BASE_INSN_REMO2; goto extract_sfmt_mulo2;
              case 6 : itype = I960BASE_INSN_DIVO2; goto extract_sfmt_mulo2;
              default : itype = I960BASE_INSN_X_INVALID; goto extract_sfmt_empty;
              }
            }
          case 6 : itype = I960BASE_INSN_MULO3; goto extract_sfmt_mulo3;
          case 7 :
            {
              unsigned int val = (((insn >> 6) & (15 << 0)));
              switch (val)
              {
              case 0 : itype = I960BASE_INSN_REMO3; goto extract_sfmt_mulo3;
              case 6 : itype = I960BASE_INSN_DIVO3; goto extract_sfmt_mulo3;
              default : itype = I960BASE_INSN_X_INVALID; goto extract_sfmt_empty;
              }
            }
          default : itype = I960BASE_INSN_X_INVALID; goto extract_sfmt_empty;
          }
        }
      case 116 :
        {
          unsigned int val = (((insn >> 10) & (15 << 0)));
          switch (val)
          {
          case 1 :
            {
              unsigned int val = (((insn >> 6) & (15 << 0)));
              switch (val)
              {
              case 0 : itype = I960BASE_INSN_REMI; goto extract_sfmt_mulo;
              case 6 : itype = I960BASE_INSN_DIVI; goto extract_sfmt_mulo;
              default : itype = I960BASE_INSN_X_INVALID; goto extract_sfmt_empty;
              }
            }
          case 3 :
            {
              unsigned int val = (((insn >> 6) & (15 << 0)));
              switch (val)
              {
              case 0 : itype = I960BASE_INSN_REMI1; goto extract_sfmt_mulo1;
              case 6 : itype = I960BASE_INSN_DIVI1; goto extract_sfmt_mulo1;
              default : itype = I960BASE_INSN_X_INVALID; goto extract_sfmt_empty;
              }
            }
          case 5 :
            {
              unsigned int val = (((insn >> 6) & (15 << 0)));
              switch (val)
              {
              case 0 : itype = I960BASE_INSN_REMI2; goto extract_sfmt_mulo2;
              case 6 : itype = I960BASE_INSN_DIVI2; goto extract_sfmt_mulo2;
              default : itype = I960BASE_INSN_X_INVALID; goto extract_sfmt_empty;
              }
            }
          case 7 :
            {
              unsigned int val = (((insn >> 6) & (15 << 0)));
              switch (val)
              {
              case 0 : itype = I960BASE_INSN_REMI3; goto extract_sfmt_mulo3;
              case 6 : itype = I960BASE_INSN_DIVI3; goto extract_sfmt_mulo3;
              default : itype = I960BASE_INSN_X_INVALID; goto extract_sfmt_empty;
              }
            }
          default : itype = I960BASE_INSN_X_INVALID; goto extract_sfmt_empty;
          }
        }
      case 128 :
        {
          unsigned int val = (((insn >> 10) & (15 << 0)));
          switch (val)
          {
          case 0 : /* fall through */
          case 1 : /* fall through */
          case 2 : /* fall through */
          case 3 : itype = I960BASE_INSN_LDOB_OFFSET; goto extract_sfmt_ld_offset;
          case 4 : itype = I960BASE_INSN_LDOB_INDIRECT; goto extract_sfmt_ld_indirect;
          case 7 : itype = I960BASE_INSN_LDOB_INDIRECT_INDEX; goto extract_sfmt_ld_indirect_index;
          case 8 : /* fall through */
          case 9 : /* fall through */
          case 10 : /* fall through */
          case 11 : itype = I960BASE_INSN_LDOB_INDIRECT_OFFSET; goto extract_sfmt_ld_indirect_offset;
          case 12 : itype = I960BASE_INSN_LDOB_DISP; goto extract_sfmt_ld_disp;
          case 13 : itype = I960BASE_INSN_LDOB_INDIRECT_DISP; goto extract_sfmt_ld_indirect_disp;
          case 14 : itype = I960BASE_INSN_LDOB_INDEX_DISP; goto extract_sfmt_ld_index_disp;
          case 15 : itype = I960BASE_INSN_LDOB_INDIRECT_INDEX_DISP; goto extract_sfmt_ld_indirect_index_disp;
          default : itype = I960BASE_INSN_X_INVALID; goto extract_sfmt_empty;
          }
        }
      case 130 :
        {
          unsigned int val = (((insn >> 10) & (15 << 0)));
          switch (val)
          {
          case 0 : /* fall through */
          case 1 : /* fall through */
          case 2 : /* fall through */
          case 3 : itype = I960BASE_INSN_STOB_OFFSET; goto extract_sfmt_st_offset;
          case 4 : itype = I960BASE_INSN_STOB_INDIRECT; goto extract_sfmt_st_indirect;
          case 7 : itype = I960BASE_INSN_STOB_INDIRECT_INDEX; goto extract_sfmt_st_indirect_index;
          case 8 : /* fall through */
          case 9 : /* fall through */
          case 10 : /* fall through */
          case 11 : itype = I960BASE_INSN_STOB_INDIRECT_OFFSET; goto extract_sfmt_st_indirect_offset;
          case 12 : itype = I960BASE_INSN_STOB_DISP; goto extract_sfmt_st_disp;
          case 13 : itype = I960BASE_INSN_STOB_INDIRECT_DISP; goto extract_sfmt_st_indirect_disp;
          case 14 : itype = I960BASE_INSN_STOB_INDEX_DISP; goto extract_sfmt_st_index_disp;
          case 15 : itype = I960BASE_INSN_STOB_INDIRECT_INDEX_DISP; goto extract_sfmt_st_indirect_index_disp;
          default : itype = I960BASE_INSN_X_INVALID; goto extract_sfmt_empty;
          }
        }
      case 132 :
        {
          unsigned int val = (((insn >> 10) & (15 << 0)));
          switch (val)
          {
          case 4 : itype = I960BASE_INSN_BX_INDIRECT; goto extract_sfmt_bx_indirect;
          case 7 : itype = I960BASE_INSN_BX_INDIRECT_INDEX; goto extract_sfmt_bx_indirect_index;
          case 8 : /* fall through */
          case 9 : /* fall through */
          case 10 : /* fall through */
          case 11 : itype = I960BASE_INSN_BX_INDIRECT_OFFSET; goto extract_sfmt_bx_indirect_offset;
          case 12 : itype = I960BASE_INSN_BX_DISP; goto extract_sfmt_bx_disp;
          case 13 : itype = I960BASE_INSN_BX_INDIRECT_DISP; goto extract_sfmt_bx_indirect_disp;
          default : itype = I960BASE_INSN_X_INVALID; goto extract_sfmt_empty;
          }
        }
      case 134 :
        {
          unsigned int val = (((insn >> 10) & (15 << 0)));
          switch (val)
          {
          case 4 : itype = I960BASE_INSN_CALLX_INDIRECT; goto extract_sfmt_callx_indirect;
          case 8 : /* fall through */
          case 9 : /* fall through */
          case 10 : /* fall through */
          case 11 : itype = I960BASE_INSN_CALLX_INDIRECT_OFFSET; goto extract_sfmt_callx_indirect_offset;
          case 12 : itype = I960BASE_INSN_CALLX_DISP; goto extract_sfmt_callx_disp;
          default : itype = I960BASE_INSN_X_INVALID; goto extract_sfmt_empty;
          }
        }
      case 136 :
        {
          unsigned int val = (((insn >> 10) & (15 << 0)));
          switch (val)
          {
          case 0 : /* fall through */
          case 1 : /* fall through */
          case 2 : /* fall through */
          case 3 : itype = I960BASE_INSN_LDOS_OFFSET; goto extract_sfmt_ld_offset;
          case 4 : itype = I960BASE_INSN_LDOS_INDIRECT; goto extract_sfmt_ld_indirect;
          case 7 : itype = I960BASE_INSN_LDOS_INDIRECT_INDEX; goto extract_sfmt_ld_indirect_index;
          case 8 : /* fall through */
          case 9 : /* fall through */
          case 10 : /* fall through */
          case 11 : itype = I960BASE_INSN_LDOS_INDIRECT_OFFSET; goto extract_sfmt_ld_indirect_offset;
          case 12 : itype = I960BASE_INSN_LDOS_DISP; goto extract_sfmt_ld_disp;
          case 13 : itype = I960BASE_INSN_LDOS_INDIRECT_DISP; goto extract_sfmt_ld_indirect_disp;
          case 14 : itype = I960BASE_INSN_LDOS_INDEX_DISP; goto extract_sfmt_ld_index_disp;
          case 15 : itype = I960BASE_INSN_LDOS_INDIRECT_INDEX_DISP; goto extract_sfmt_ld_indirect_index_disp;
          default : itype = I960BASE_INSN_X_INVALID; goto extract_sfmt_empty;
          }
        }
      case 138 :
        {
          unsigned int val = (((insn >> 10) & (15 << 0)));
          switch (val)
          {
          case 0 : /* fall through */
          case 1 : /* fall through */
          case 2 : /* fall through */
          case 3 : itype = I960BASE_INSN_STOS_OFFSET; goto extract_sfmt_st_offset;
          case 4 : itype = I960BASE_INSN_STOS_INDIRECT; goto extract_sfmt_st_indirect;
          case 7 : itype = I960BASE_INSN_STOS_INDIRECT_INDEX; goto extract_sfmt_st_indirect_index;
          case 8 : /* fall through */
          case 9 : /* fall through */
          case 10 : /* fall through */
          case 11 : itype = I960BASE_INSN_STOS_INDIRECT_OFFSET; goto extract_sfmt_st_indirect_offset;
          case 12 : itype = I960BASE_INSN_STOS_DISP; goto extract_sfmt_st_disp;
          case 13 : itype = I960BASE_INSN_STOS_INDIRECT_DISP; goto extract_sfmt_st_indirect_disp;
          case 14 : itype = I960BASE_INSN_STOS_INDEX_DISP; goto extract_sfmt_st_index_disp;
          case 15 : itype = I960BASE_INSN_STOS_INDIRECT_INDEX_DISP; goto extract_sfmt_st_indirect_index_disp;
          default : itype = I960BASE_INSN_X_INVALID; goto extract_sfmt_empty;
          }
        }
      case 140 :
        {
          unsigned int val = (((insn >> 10) & (15 << 0)));
          switch (val)
          {
          case 0 : /* fall through */
          case 1 : /* fall through */
          case 2 : /* fall through */
          case 3 : itype = I960BASE_INSN_LDA_OFFSET; goto extract_sfmt_lda_offset;
          case 4 : itype = I960BASE_INSN_LDA_INDIRECT; goto extract_sfmt_lda_indirect;
          case 7 : itype = I960BASE_INSN_LDA_INDIRECT_INDEX; goto extract_sfmt_lda_indirect_index;
          case 8 : /* fall through */
          case 9 : /* fall through */
          case 10 : /* fall through */
          case 11 : itype = I960BASE_INSN_LDA_INDIRECT_OFFSET; goto extract_sfmt_lda_indirect_offset;
          case 12 : itype = I960BASE_INSN_LDA_DISP; goto extract_sfmt_lda_disp;
          case 13 : itype = I960BASE_INSN_LDA_INDIRECT_DISP; goto extract_sfmt_lda_indirect_disp;
          case 14 : itype = I960BASE_INSN_LDA_INDEX_DISP; goto extract_sfmt_lda_index_disp;
          case 15 : itype = I960BASE_INSN_LDA_INDIRECT_INDEX_DISP; goto extract_sfmt_lda_indirect_index_disp;
          default : itype = I960BASE_INSN_X_INVALID; goto extract_sfmt_empty;
          }
        }
      case 144 :
        {
          unsigned int val = (((insn >> 10) & (15 << 0)));
          switch (val)
          {
          case 0 : /* fall through */
          case 1 : /* fall through */
          case 2 : /* fall through */
          case 3 : itype = I960BASE_INSN_LD_OFFSET; goto extract_sfmt_ld_offset;
          case 4 : itype = I960BASE_INSN_LD_INDIRECT; goto extract_sfmt_ld_indirect;
          case 7 : itype = I960BASE_INSN_LD_INDIRECT_INDEX; goto extract_sfmt_ld_indirect_index;
          case 8 : /* fall through */
          case 9 : /* fall through */
          case 10 : /* fall through */
          case 11 : itype = I960BASE_INSN_LD_INDIRECT_OFFSET; goto extract_sfmt_ld_indirect_offset;
          case 12 : itype = I960BASE_INSN_LD_DISP; goto extract_sfmt_ld_disp;
          case 13 : itype = I960BASE_INSN_LD_INDIRECT_DISP; goto extract_sfmt_ld_indirect_disp;
          case 14 : itype = I960BASE_INSN_LD_INDEX_DISP; goto extract_sfmt_ld_index_disp;
          case 15 : itype = I960BASE_INSN_LD_INDIRECT_INDEX_DISP; goto extract_sfmt_ld_indirect_index_disp;
          default : itype = I960BASE_INSN_X_INVALID; goto extract_sfmt_empty;
          }
        }
      case 146 :
        {
          unsigned int val = (((insn >> 10) & (15 << 0)));
          switch (val)
          {
          case 0 : /* fall through */
          case 1 : /* fall through */
          case 2 : /* fall through */
          case 3 : itype = I960BASE_INSN_ST_OFFSET; goto extract_sfmt_st_offset;
          case 4 : itype = I960BASE_INSN_ST_INDIRECT; goto extract_sfmt_st_indirect;
          case 7 : itype = I960BASE_INSN_ST_INDIRECT_INDEX; goto extract_sfmt_st_indirect_index;
          case 8 : /* fall through */
          case 9 : /* fall through */
          case 10 : /* fall through */
          case 11 : itype = I960BASE_INSN_ST_INDIRECT_OFFSET; goto extract_sfmt_st_indirect_offset;
          case 12 : itype = I960BASE_INSN_ST_DISP; goto extract_sfmt_st_disp;
          case 13 : itype = I960BASE_INSN_ST_INDIRECT_DISP; goto extract_sfmt_st_indirect_disp;
          case 14 : itype = I960BASE_INSN_ST_INDEX_DISP; goto extract_sfmt_st_index_disp;
          case 15 : itype = I960BASE_INSN_ST_INDIRECT_INDEX_DISP; goto extract_sfmt_st_indirect_index_disp;
          default : itype = I960BASE_INSN_X_INVALID; goto extract_sfmt_empty;
          }
        }
      case 152 :
        {
          unsigned int val = (((insn >> 10) & (15 << 0)));
          switch (val)
          {
          case 0 : /* fall through */
          case 1 : /* fall through */
          case 2 : /* fall through */
          case 3 : itype = I960BASE_INSN_LDL_OFFSET; goto extract_sfmt_ldl_offset;
          case 4 : itype = I960BASE_INSN_LDL_INDIRECT; goto extract_sfmt_ldl_indirect;
          case 7 : itype = I960BASE_INSN_LDL_INDIRECT_INDEX; goto extract_sfmt_ldl_indirect_index;
          case 8 : /* fall through */
          case 9 : /* fall through */
          case 10 : /* fall through */
          case 11 : itype = I960BASE_INSN_LDL_INDIRECT_OFFSET; goto extract_sfmt_ldl_indirect_offset;
          case 12 : itype = I960BASE_INSN_LDL_DISP; goto extract_sfmt_ldl_disp;
          case 13 : itype = I960BASE_INSN_LDL_INDIRECT_DISP; goto extract_sfmt_ldl_indirect_disp;
          case 14 : itype = I960BASE_INSN_LDL_INDEX_DISP; goto extract_sfmt_ldl_index_disp;
          case 15 : itype = I960BASE_INSN_LDL_INDIRECT_INDEX_DISP; goto extract_sfmt_ldl_indirect_index_disp;
          default : itype = I960BASE_INSN_X_INVALID; goto extract_sfmt_empty;
          }
        }
      case 154 :
        {
          unsigned int val = (((insn >> 10) & (15 << 0)));
          switch (val)
          {
          case 0 : /* fall through */
          case 1 : /* fall through */
          case 2 : /* fall through */
          case 3 : itype = I960BASE_INSN_STL_OFFSET; goto extract_sfmt_stl_offset;
          case 4 : itype = I960BASE_INSN_STL_INDIRECT; goto extract_sfmt_stl_indirect;
          case 7 : itype = I960BASE_INSN_STL_INDIRECT_INDEX; goto extract_sfmt_stl_indirect_index;
          case 8 : /* fall through */
          case 9 : /* fall through */
          case 10 : /* fall through */
          case 11 : itype = I960BASE_INSN_STL_INDIRECT_OFFSET; goto extract_sfmt_stl_indirect_offset;
          case 12 : itype = I960BASE_INSN_STL_DISP; goto extract_sfmt_stl_disp;
          case 13 : itype = I960BASE_INSN_STL_INDIRECT_DISP; goto extract_sfmt_stl_indirect_disp;
          case 14 : itype = I960BASE_INSN_STL_INDEX_DISP; goto extract_sfmt_stl_index_disp;
          case 15 : itype = I960BASE_INSN_STL_INDIRECT_INDEX_DISP; goto extract_sfmt_stl_indirect_index_disp;
          default : itype = I960BASE_INSN_X_INVALID; goto extract_sfmt_empty;
          }
        }
      case 160 :
        {
          unsigned int val = (((insn >> 10) & (15 << 0)));
          switch (val)
          {
          case 0 : /* fall through */
          case 1 : /* fall through */
          case 2 : /* fall through */
          case 3 : itype = I960BASE_INSN_LDT_OFFSET; goto extract_sfmt_ldt_offset;
          case 4 : itype = I960BASE_INSN_LDT_INDIRECT; goto extract_sfmt_ldt_indirect;
          case 7 : itype = I960BASE_INSN_LDT_INDIRECT_INDEX; goto extract_sfmt_ldt_indirect_index;
          case 8 : /* fall through */
          case 9 : /* fall through */
          case 10 : /* fall through */
          case 11 : itype = I960BASE_INSN_LDT_INDIRECT_OFFSET; goto extract_sfmt_ldt_indirect_offset;
          case 12 : itype = I960BASE_INSN_LDT_DISP; goto extract_sfmt_ldt_disp;
          case 13 : itype = I960BASE_INSN_LDT_INDIRECT_DISP; goto extract_sfmt_ldt_indirect_disp;
          case 14 : itype = I960BASE_INSN_LDT_INDEX_DISP; goto extract_sfmt_ldt_index_disp;
          case 15 : itype = I960BASE_INSN_LDT_INDIRECT_INDEX_DISP; goto extract_sfmt_ldt_indirect_index_disp;
          default : itype = I960BASE_INSN_X_INVALID; goto extract_sfmt_empty;
          }
        }
      case 162 :
        {
          unsigned int val = (((insn >> 10) & (15 << 0)));
          switch (val)
          {
          case 0 : /* fall through */
          case 1 : /* fall through */
          case 2 : /* fall through */
          case 3 : itype = I960BASE_INSN_STT_OFFSET; goto extract_sfmt_stt_offset;
          case 4 : itype = I960BASE_INSN_STT_INDIRECT; goto extract_sfmt_stt_indirect;
          case 7 : itype = I960BASE_INSN_STT_INDIRECT_INDEX; goto extract_sfmt_stt_indirect_index;
          case 8 : /* fall through */
          case 9 : /* fall through */
          case 10 : /* fall through */
          case 11 : itype = I960BASE_INSN_STT_INDIRECT_OFFSET; goto extract_sfmt_stt_indirect_offset;
          case 12 : itype = I960BASE_INSN_STT_DISP; goto extract_sfmt_stt_disp;
          case 13 : itype = I960BASE_INSN_STT_INDIRECT_DISP; goto extract_sfmt_stt_indirect_disp;
          case 14 : itype = I960BASE_INSN_STT_INDEX_DISP; goto extract_sfmt_stt_index_disp;
          case 15 : itype = I960BASE_INSN_STT_INDIRECT_INDEX_DISP; goto extract_sfmt_stt_indirect_index_disp;
          default : itype = I960BASE_INSN_X_INVALID; goto extract_sfmt_empty;
          }
        }
      case 176 :
        {
          unsigned int val = (((insn >> 10) & (15 << 0)));
          switch (val)
          {
          case 0 : /* fall through */
          case 1 : /* fall through */
          case 2 : /* fall through */
          case 3 : itype = I960BASE_INSN_LDQ_OFFSET; goto extract_sfmt_ldq_offset;
          case 4 : itype = I960BASE_INSN_LDQ_INDIRECT; goto extract_sfmt_ldq_indirect;
          case 7 : itype = I960BASE_INSN_LDQ_INDIRECT_INDEX; goto extract_sfmt_ldq_indirect_index;
          case 8 : /* fall through */
          case 9 : /* fall through */
          case 10 : /* fall through */
          case 11 : itype = I960BASE_INSN_LDQ_INDIRECT_OFFSET; goto extract_sfmt_ldq_indirect_offset;
          case 12 : itype = I960BASE_INSN_LDQ_DISP; goto extract_sfmt_ldq_disp;
          case 13 : itype = I960BASE_INSN_LDQ_INDIRECT_DISP; goto extract_sfmt_ldq_indirect_disp;
          case 14 : itype = I960BASE_INSN_LDQ_INDEX_DISP; goto extract_sfmt_ldq_index_disp;
          case 15 : itype = I960BASE_INSN_LDQ_INDIRECT_INDEX_DISP; goto extract_sfmt_ldq_indirect_index_disp;
          default : itype = I960BASE_INSN_X_INVALID; goto extract_sfmt_empty;
          }
        }
      case 178 :
        {
          unsigned int val = (((insn >> 10) & (15 << 0)));
          switch (val)
          {
          case 0 : /* fall through */
          case 1 : /* fall through */
          case 2 : /* fall through */
          case 3 : itype = I960BASE_INSN_STQ_OFFSET; goto extract_sfmt_stq_offset;
          case 4 : itype = I960BASE_INSN_STQ_INDIRECT; goto extract_sfmt_stq_indirect;
          case 7 : itype = I960BASE_INSN_STQ_INDIRECT_INDEX; goto extract_sfmt_stq_indirect_index;
          case 8 : /* fall through */
          case 9 : /* fall through */
          case 10 : /* fall through */
          case 11 : itype = I960BASE_INSN_STQ_INDIRECT_OFFSET; goto extract_sfmt_stq_indirect_offset;
          case 12 : itype = I960BASE_INSN_STQ_DISP; goto extract_sfmt_stq_disp;
          case 13 : itype = I960BASE_INSN_STQ_INDIRECT_DISP; goto extract_sfmt_stq_indirect_disp;
          case 14 : itype = I960BASE_INSN_STQ_INDEX_DISP; goto extract_sfmt_stq_index_disp;
          case 15 : itype = I960BASE_INSN_STQ_INDIRECT_INDEX_DISP; goto extract_sfmt_stq_indirect_index_disp;
          default : itype = I960BASE_INSN_X_INVALID; goto extract_sfmt_empty;
          }
        }
      case 192 :
        {
          unsigned int val = (((insn >> 10) & (15 << 0)));
          switch (val)
          {
          case 0 : /* fall through */
          case 1 : /* fall through */
          case 2 : /* fall through */
          case 3 : itype = I960BASE_INSN_LDIB_OFFSET; goto extract_sfmt_ld_offset;
          case 4 : itype = I960BASE_INSN_LDIB_INDIRECT; goto extract_sfmt_ld_indirect;
          case 7 : itype = I960BASE_INSN_LDIB_INDIRECT_INDEX; goto extract_sfmt_ld_indirect_index;
          case 8 : /* fall through */
          case 9 : /* fall through */
          case 10 : /* fall through */
          case 11 : itype = I960BASE_INSN_LDIB_INDIRECT_OFFSET; goto extract_sfmt_ld_indirect_offset;
          case 12 : itype = I960BASE_INSN_LDIB_DISP; goto extract_sfmt_ld_disp;
          case 13 : itype = I960BASE_INSN_LDIB_INDIRECT_DISP; goto extract_sfmt_ld_indirect_disp;
          case 14 : itype = I960BASE_INSN_LDIB_INDEX_DISP; goto extract_sfmt_ld_index_disp;
          case 15 : itype = I960BASE_INSN_LDIB_INDIRECT_INDEX_DISP; goto extract_sfmt_ld_indirect_index_disp;
          default : itype = I960BASE_INSN_X_INVALID; goto extract_sfmt_empty;
          }
        }
      case 200 :
        {
          unsigned int val = (((insn >> 10) & (15 << 0)));
          switch (val)
          {
          case 0 : /* fall through */
          case 1 : /* fall through */
          case 2 : /* fall through */
          case 3 : itype = I960BASE_INSN_LDIS_OFFSET; goto extract_sfmt_ld_offset;
          case 4 : itype = I960BASE_INSN_LDIS_INDIRECT; goto extract_sfmt_ld_indirect;
          case 7 : itype = I960BASE_INSN_LDIS_INDIRECT_INDEX; goto extract_sfmt_ld_indirect_index;
          case 8 : /* fall through */
          case 9 : /* fall through */
          case 10 : /* fall through */
          case 11 : itype = I960BASE_INSN_LDIS_INDIRECT_OFFSET; goto extract_sfmt_ld_indirect_offset;
          case 12 : itype = I960BASE_INSN_LDIS_DISP; goto extract_sfmt_ld_disp;
          case 13 : itype = I960BASE_INSN_LDIS_INDIRECT_DISP; goto extract_sfmt_ld_indirect_disp;
          case 14 : itype = I960BASE_INSN_LDIS_INDEX_DISP; goto extract_sfmt_ld_index_disp;
          case 15 : itype = I960BASE_INSN_LDIS_INDIRECT_INDEX_DISP; goto extract_sfmt_ld_indirect_index_disp;
          default : itype = I960BASE_INSN_X_INVALID; goto extract_sfmt_empty;
          }
        }
      default : itype = I960BASE_INSN_X_INVALID; goto extract_sfmt_empty;
      }
    }
  }

  /* The instruction has been decoded, now extract the fields.  */

 extract_sfmt_empty:
  {
    const IDESC *idesc = &i960base_insn_data[itype];
    CGEN_INSN_INT insn = base_insn;
#define FLD(f) abuf->fields.fmt_empty.f


  /* Record the fields for the semantic handler.  */
  TRACE_EXTRACT (current_cpu, abuf, (current_cpu, pc, "sfmt_empty", (char *) 0));

#undef FLD
    return idesc;
  }

 extract_sfmt_mulo:
  {
    const IDESC *idesc = &i960base_insn_data[itype];
    CGEN_INSN_INT insn = base_insn;
#define FLD(f) abuf->fields.sfmt_emul.f
    UINT f_srcdst;
    UINT f_src2;
    UINT f_src1;

    f_srcdst = EXTRACT_MSB0_UINT (insn, 32, 8, 5);
    f_src2 = EXTRACT_MSB0_UINT (insn, 32, 13, 5);
    f_src1 = EXTRACT_MSB0_UINT (insn, 32, 27, 5);

  /* Record the fields for the semantic handler.  */
  FLD (i_src1) = & CPU (h_gr)[f_src1];
  FLD (i_src2) = & CPU (h_gr)[f_src2];
  FLD (i_dst) = & CPU (h_gr)[f_srcdst];
  TRACE_EXTRACT (current_cpu, abuf, (current_cpu, pc, "sfmt_mulo", "src1 0x%x", 'x', f_src1, "src2 0x%x", 'x', f_src2, "dst 0x%x", 'x', f_srcdst, (char *) 0));

#if WITH_PROFILE_MODEL_P
  /* Record the fields for profiling.  */
  if (PROFILE_MODEL_P (current_cpu))
    {
      FLD (in_src1) = f_src1;
      FLD (in_src2) = f_src2;
      FLD (out_dst) = f_srcdst;
    }
#endif
#undef FLD
    return idesc;
  }

 extract_sfmt_mulo1:
  {
    const IDESC *idesc = &i960base_insn_data[itype];
    CGEN_INSN_INT insn = base_insn;
#define FLD(f) abuf->fields.sfmt_emul1.f
    UINT f_srcdst;
    UINT f_src2;
    UINT f_src1;

    f_srcdst = EXTRACT_MSB0_UINT (insn, 32, 8, 5);
    f_src2 = EXTRACT_MSB0_UINT (insn, 32, 13, 5);
    f_src1 = EXTRACT_MSB0_UINT (insn, 32, 27, 5);

  /* Record the fields for the semantic handler.  */
  FLD (f_src1) = f_src1;
  FLD (i_src2) = & CPU (h_gr)[f_src2];
  FLD (i_dst) = & CPU (h_gr)[f_srcdst];
  TRACE_EXTRACT (current_cpu, abuf, (current_cpu, pc, "sfmt_mulo1", "f_src1 0x%x", 'x', f_src1, "src2 0x%x", 'x', f_src2, "dst 0x%x", 'x', f_srcdst, (char *) 0));

#if WITH_PROFILE_MODEL_P
  /* Record the fields for profiling.  */
  if (PROFILE_MODEL_P (current_cpu))
    {
      FLD (in_src2) = f_src2;
      FLD (out_dst) = f_srcdst;
    }
#endif
#undef FLD
    return idesc;
  }

 extract_sfmt_mulo2:
  {
    const IDESC *idesc = &i960base_insn_data[itype];
    CGEN_INSN_INT insn = base_insn;
#define FLD(f) abuf->fields.sfmt_emul2.f
    UINT f_srcdst;
    UINT f_src2;
    UINT f_src1;

    f_srcdst = EXTRACT_MSB0_UINT (insn, 32, 8, 5);
    f_src2 = EXTRACT_MSB0_UINT (insn, 32, 13, 5);
    f_src1 = EXTRACT_MSB0_UINT (insn, 32, 27, 5);

  /* Record the fields for the semantic handler.  */
  FLD (f_src2) = f_src2;
  FLD (i_src1) = & CPU (h_gr)[f_src1];
  FLD (i_dst) = & CPU (h_gr)[f_srcdst];
  TRACE_EXTRACT (current_cpu, abuf, (current_cpu, pc, "sfmt_mulo2", "f_src2 0x%x", 'x', f_src2, "src1 0x%x", 'x', f_src1, "dst 0x%x", 'x', f_srcdst, (char *) 0));

#if WITH_PROFILE_MODEL_P
  /* Record the fields for profiling.  */
  if (PROFILE_MODEL_P (current_cpu))
    {
      FLD (in_src1) = f_src1;
      FLD (out_dst) = f_srcdst;
    }
#endif
#undef FLD
    return idesc;
  }

 extract_sfmt_mulo3:
  {
    const IDESC *idesc = &i960base_insn_data[itype];
    CGEN_INSN_INT insn = base_insn;
#define FLD(f) abuf->fields.sfmt_emul3.f
    UINT f_srcdst;
    UINT f_src2;
    UINT f_src1;

    f_srcdst = EXTRACT_MSB0_UINT (insn, 32, 8, 5);
    f_src2 = EXTRACT_MSB0_UINT (insn, 32, 13, 5);
    f_src1 = EXTRACT_MSB0_UINT (insn, 32, 27, 5);

  /* Record the fields for the semantic handler.  */
  FLD (f_src1) = f_src1;
  FLD (f_src2) = f_src2;
  FLD (i_dst) = & CPU (h_gr)[f_srcdst];
  TRACE_EXTRACT (current_cpu, abuf, (current_cpu, pc, "sfmt_mulo3", "f_src1 0x%x", 'x', f_src1, "f_src2 0x%x", 'x', f_src2, "dst 0x%x", 'x', f_srcdst, (char *) 0));

#if WITH_PROFILE_MODEL_P
  /* Record the fields for profiling.  */
  if (PROFILE_MODEL_P (current_cpu))
    {
      FLD (out_dst) = f_srcdst;
    }
#endif
#undef FLD
    return idesc;
  }

 extract_sfmt_notbit:
  {
    const IDESC *idesc = &i960base_insn_data[itype];
    CGEN_INSN_INT insn = base_insn;
#define FLD(f) abuf->fields.sfmt_emul.f
    UINT f_srcdst;
    UINT f_src2;
    UINT f_src1;

    f_srcdst = EXTRACT_MSB0_UINT (insn, 32, 8, 5);
    f_src2 = EXTRACT_MSB0_UINT (insn, 32, 13, 5);
    f_src1 = EXTRACT_MSB0_UINT (insn, 32, 27, 5);

  /* Record the fields for the semantic handler.  */
  FLD (i_src1) = & CPU (h_gr)[f_src1];
  FLD (i_src2) = & CPU (h_gr)[f_src2];
  FLD (i_dst) = & CPU (h_gr)[f_srcdst];
  TRACE_EXTRACT (current_cpu, abuf, (current_cpu, pc, "sfmt_notbit", "src1 0x%x", 'x', f_src1, "src2 0x%x", 'x', f_src2, "dst 0x%x", 'x', f_srcdst, (char *) 0));

#if WITH_PROFILE_MODEL_P
  /* Record the fields for profiling.  */
  if (PROFILE_MODEL_P (current_cpu))
    {
      FLD (in_src1) = f_src1;
      FLD (in_src2) = f_src2;
      FLD (out_dst) = f_srcdst;
    }
#endif
#undef FLD
    return idesc;
  }

 extract_sfmt_notbit1:
  {
    const IDESC *idesc = &i960base_insn_data[itype];
    CGEN_INSN_INT insn = base_insn;
#define FLD(f) abuf->fields.sfmt_emul1.f
    UINT f_srcdst;
    UINT f_src2;
    UINT f_src1;

    f_srcdst = EXTRACT_MSB0_UINT (insn, 32, 8, 5);
    f_src2 = EXTRACT_MSB0_UINT (insn, 32, 13, 5);
    f_src1 = EXTRACT_MSB0_UINT (insn, 32, 27, 5);

  /* Record the fields for the semantic handler.  */
  FLD (f_src1) = f_src1;
  FLD (i_src2) = & CPU (h_gr)[f_src2];
  FLD (i_dst) = & CPU (h_gr)[f_srcdst];
  TRACE_EXTRACT (current_cpu, abuf, (current_cpu, pc, "sfmt_notbit1", "f_src1 0x%x", 'x', f_src1, "src2 0x%x", 'x', f_src2, "dst 0x%x", 'x', f_srcdst, (char *) 0));

#if WITH_PROFILE_MODEL_P
  /* Record the fields for profiling.  */
  if (PROFILE_MODEL_P (current_cpu))
    {
      FLD (in_src2) = f_src2;
      FLD (out_dst) = f_srcdst;
    }
#endif
#undef FLD
    return idesc;
  }

 extract_sfmt_notbit2:
  {
    const IDESC *idesc = &i960base_insn_data[itype];
    CGEN_INSN_INT insn = base_insn;
#define FLD(f) abuf->fields.sfmt_emul2.f
    UINT f_srcdst;
    UINT f_src2;
    UINT f_src1;

    f_srcdst = EXTRACT_MSB0_UINT (insn, 32, 8, 5);
    f_src2 = EXTRACT_MSB0_UINT (insn, 32, 13, 5);
    f_src1 = EXTRACT_MSB0_UINT (insn, 32, 27, 5);

  /* Record the fields for the semantic handler.  */
  FLD (f_src2) = f_src2;
  FLD (i_src1) = & CPU (h_gr)[f_src1];
  FLD (i_dst) = & CPU (h_gr)[f_srcdst];
  TRACE_EXTRACT (current_cpu, abuf, (current_cpu, pc, "sfmt_notbit2", "f_src2 0x%x", 'x', f_src2, "src1 0x%x", 'x', f_src1, "dst 0x%x", 'x', f_srcdst, (char *) 0));

#if WITH_PROFILE_MODEL_P
  /* Record the fields for profiling.  */
  if (PROFILE_MODEL_P (current_cpu))
    {
      FLD (in_src1) = f_src1;
      FLD (out_dst) = f_srcdst;
    }
#endif
#undef FLD
    return idesc;
  }

 extract_sfmt_notbit3:
  {
    const IDESC *idesc = &i960base_insn_data[itype];
    CGEN_INSN_INT insn = base_insn;
#define FLD(f) abuf->fields.sfmt_emul3.f
    UINT f_srcdst;
    UINT f_src2;
    UINT f_src1;

    f_srcdst = EXTRACT_MSB0_UINT (insn, 32, 8, 5);
    f_src2 = EXTRACT_MSB0_UINT (insn, 32, 13, 5);
    f_src1 = EXTRACT_MSB0_UINT (insn, 32, 27, 5);

  /* Record the fields for the semantic handler.  */
  FLD (f_src1) = f_src1;
  FLD (f_src2) = f_src2;
  FLD (i_dst) = & CPU (h_gr)[f_srcdst];
  TRACE_EXTRACT (current_cpu, abuf, (current_cpu, pc, "sfmt_notbit3", "f_src1 0x%x", 'x', f_src1, "f_src2 0x%x", 'x', f_src2, "dst 0x%x", 'x', f_srcdst, (char *) 0));

#if WITH_PROFILE_MODEL_P
  /* Record the fields for profiling.  */
  if (PROFILE_MODEL_P (current_cpu))
    {
      FLD (out_dst) = f_srcdst;
    }
#endif
#undef FLD
    return idesc;
  }

 extract_sfmt_not:
  {
    const IDESC *idesc = &i960base_insn_data[itype];
    CGEN_INSN_INT insn = base_insn;
#define FLD(f) abuf->fields.sfmt_emul2.f
    UINT f_srcdst;
    UINT f_src1;

    f_srcdst = EXTRACT_MSB0_UINT (insn, 32, 8, 5);
    f_src1 = EXTRACT_MSB0_UINT (insn, 32, 27, 5);

  /* Record the fields for the semantic handler.  */
  FLD (i_src1) = & CPU (h_gr)[f_src1];
  FLD (i_dst) = & CPU (h_gr)[f_srcdst];
  TRACE_EXTRACT (current_cpu, abuf, (current_cpu, pc, "sfmt_not", "src1 0x%x", 'x', f_src1, "dst 0x%x", 'x', f_srcdst, (char *) 0));

#if WITH_PROFILE_MODEL_P
  /* Record the fields for profiling.  */
  if (PROFILE_MODEL_P (current_cpu))
    {
      FLD (in_src1) = f_src1;
      FLD (out_dst) = f_srcdst;
    }
#endif
#undef FLD
    return idesc;
  }

 extract_sfmt_not1:
  {
    const IDESC *idesc = &i960base_insn_data[itype];
    CGEN_INSN_INT insn = base_insn;
#define FLD(f) abuf->fields.sfmt_emul3.f
    UINT f_srcdst;
    UINT f_src1;

    f_srcdst = EXTRACT_MSB0_UINT (insn, 32, 8, 5);
    f_src1 = EXTRACT_MSB0_UINT (insn, 32, 27, 5);

  /* Record the fields for the semantic handler.  */
  FLD (f_src1) = f_src1;
  FLD (i_dst) = & CPU (h_gr)[f_srcdst];
  TRACE_EXTRACT (current_cpu, abuf, (current_cpu, pc, "sfmt_not1", "f_src1 0x%x", 'x', f_src1, "dst 0x%x", 'x', f_srcdst, (char *) 0));

#if WITH_PROFILE_MODEL_P
  /* Record the fields for profiling.  */
  if (PROFILE_MODEL_P (current_cpu))
    {
      FLD (out_dst) = f_srcdst;
    }
#endif
#undef FLD
    return idesc;
  }

 extract_sfmt_shlo:
  {
    const IDESC *idesc = &i960base_insn_data[itype];
    CGEN_INSN_INT insn = base_insn;
#define FLD(f) abuf->fields.sfmt_emul.f
    UINT f_srcdst;
    UINT f_src2;
    UINT f_src1;

    f_srcdst = EXTRACT_MSB0_UINT (insn, 32, 8, 5);
    f_src2 = EXTRACT_MSB0_UINT (insn, 32, 13, 5);
    f_src1 = EXTRACT_MSB0_UINT (insn, 32, 27, 5);

  /* Record the fields for the semantic handler.  */
  FLD (i_src1) = & CPU (h_gr)[f_src1];
  FLD (i_src2) = & CPU (h_gr)[f_src2];
  FLD (i_dst) = & CPU (h_gr)[f_srcdst];
  TRACE_EXTRACT (current_cpu, abuf, (current_cpu, pc, "sfmt_shlo", "src1 0x%x", 'x', f_src1, "src2 0x%x", 'x', f_src2, "dst 0x%x", 'x', f_srcdst, (char *) 0));

#if WITH_PROFILE_MODEL_P
  /* Record the fields for profiling.  */
  if (PROFILE_MODEL_P (current_cpu))
    {
      FLD (in_src1) = f_src1;
      FLD (in_src2) = f_src2;
      FLD (out_dst) = f_srcdst;
    }
#endif
#undef FLD
    return idesc;
  }

 extract_sfmt_shlo1:
  {
    const IDESC *idesc = &i960base_insn_data[itype];
    CGEN_INSN_INT insn = base_insn;
#define FLD(f) abuf->fields.sfmt_emul1.f
    UINT f_srcdst;
    UINT f_src2;
    UINT f_src1;

    f_srcdst = EXTRACT_MSB0_UINT (insn, 32, 8, 5);
    f_src2 = EXTRACT_MSB0_UINT (insn, 32, 13, 5);
    f_src1 = EXTRACT_MSB0_UINT (insn, 32, 27, 5);

  /* Record the fields for the semantic handler.  */
  FLD (f_src1) = f_src1;
  FLD (i_src2) = & CPU (h_gr)[f_src2];
  FLD (i_dst) = & CPU (h_gr)[f_srcdst];
  TRACE_EXTRACT (current_cpu, abuf, (current_cpu, pc, "sfmt_shlo1", "f_src1 0x%x", 'x', f_src1, "src2 0x%x", 'x', f_src2, "dst 0x%x", 'x', f_srcdst, (char *) 0));

#if WITH_PROFILE_MODEL_P
  /* Record the fields for profiling.  */
  if (PROFILE_MODEL_P (current_cpu))
    {
      FLD (in_src2) = f_src2;
      FLD (out_dst) = f_srcdst;
    }
#endif
#undef FLD
    return idesc;
  }

 extract_sfmt_shlo2:
  {
    const IDESC *idesc = &i960base_insn_data[itype];
    CGEN_INSN_INT insn = base_insn;
#define FLD(f) abuf->fields.sfmt_emul2.f
    UINT f_srcdst;
    UINT f_src2;
    UINT f_src1;

    f_srcdst = EXTRACT_MSB0_UINT (insn, 32, 8, 5);
    f_src2 = EXTRACT_MSB0_UINT (insn, 32, 13, 5);
    f_src1 = EXTRACT_MSB0_UINT (insn, 32, 27, 5);

  /* Record the fields for the semantic handler.  */
  FLD (f_src2) = f_src2;
  FLD (i_src1) = & CPU (h_gr)[f_src1];
  FLD (i_dst) = & CPU (h_gr)[f_srcdst];
  TRACE_EXTRACT (current_cpu, abuf, (current_cpu, pc, "sfmt_shlo2", "f_src2 0x%x", 'x', f_src2, "src1 0x%x", 'x', f_src1, "dst 0x%x", 'x', f_srcdst, (char *) 0));

#if WITH_PROFILE_MODEL_P
  /* Record the fields for profiling.  */
  if (PROFILE_MODEL_P (current_cpu))
    {
      FLD (in_src1) = f_src1;
      FLD (out_dst) = f_srcdst;
    }
#endif
#undef FLD
    return idesc;
  }

 extract_sfmt_shlo3:
  {
    const IDESC *idesc = &i960base_insn_data[itype];
    CGEN_INSN_INT insn = base_insn;
#define FLD(f) abuf->fields.sfmt_emul3.f
    UINT f_srcdst;
    UINT f_src2;
    UINT f_src1;

    f_srcdst = EXTRACT_MSB0_UINT (insn, 32, 8, 5);
    f_src2 = EXTRACT_MSB0_UINT (insn, 32, 13, 5);
    f_src1 = EXTRACT_MSB0_UINT (insn, 32, 27, 5);

  /* Record the fields for the semantic handler.  */
  FLD (f_src1) = f_src1;
  FLD (f_src2) = f_src2;
  FLD (i_dst) = & CPU (h_gr)[f_srcdst];
  TRACE_EXTRACT (current_cpu, abuf, (current_cpu, pc, "sfmt_shlo3", "f_src1 0x%x", 'x', f_src1, "f_src2 0x%x", 'x', f_src2, "dst 0x%x", 'x', f_srcdst, (char *) 0));

#if WITH_PROFILE_MODEL_P
  /* Record the fields for profiling.  */
  if (PROFILE_MODEL_P (current_cpu))
    {
      FLD (out_dst) = f_srcdst;
    }
#endif
#undef FLD
    return idesc;
  }

 extract_sfmt_emul:
  {
    const IDESC *idesc = &i960base_insn_data[itype];
    CGEN_INSN_INT insn = base_insn;
#define FLD(f) abuf->fields.sfmt_emul.f
    UINT f_srcdst;
    UINT f_src2;
    UINT f_src1;

    f_srcdst = EXTRACT_MSB0_UINT (insn, 32, 8, 5);
    f_src2 = EXTRACT_MSB0_UINT (insn, 32, 13, 5);
    f_src1 = EXTRACT_MSB0_UINT (insn, 32, 27, 5);

  /* Record the fields for the semantic handler.  */
  FLD (f_srcdst) = f_srcdst;
  FLD (i_src1) = & CPU (h_gr)[f_src1];
  FLD (i_src2) = & CPU (h_gr)[f_src2];
  FLD (i_dst) = & CPU (h_gr)[f_srcdst];
  TRACE_EXTRACT (current_cpu, abuf, (current_cpu, pc, "sfmt_emul", "f_srcdst 0x%x", 'x', f_srcdst, "src1 0x%x", 'x', f_src1, "src2 0x%x", 'x', f_src2, "dst 0x%x", 'x', f_srcdst, (char *) 0));

#if WITH_PROFILE_MODEL_P
  /* Record the fields for profiling.  */
  if (PROFILE_MODEL_P (current_cpu))
    {
      FLD (in_src1) = f_src1;
      FLD (in_src2) = f_src2;
      FLD (out_dst) = f_srcdst;
      FLD (out_h_gr_add__DFLT_index_of__DFLT_dst_1) = ((FLD (f_srcdst)) + (1));
    }
#endif
#undef FLD
    return idesc;
  }

 extract_sfmt_emul1:
  {
    const IDESC *idesc = &i960base_insn_data[itype];
    CGEN_INSN_INT insn = base_insn;
#define FLD(f) abuf->fields.sfmt_emul1.f
    UINT f_srcdst;
    UINT f_src2;
    UINT f_src1;

    f_srcdst = EXTRACT_MSB0_UINT (insn, 32, 8, 5);
    f_src2 = EXTRACT_MSB0_UINT (insn, 32, 13, 5);
    f_src1 = EXTRACT_MSB0_UINT (insn, 32, 27, 5);

  /* Record the fields for the semantic handler.  */
  FLD (f_srcdst) = f_srcdst;
  FLD (f_src1) = f_src1;
  FLD (i_src2) = & CPU (h_gr)[f_src2];
  FLD (i_dst) = & CPU (h_gr)[f_srcdst];
  TRACE_EXTRACT (current_cpu, abuf, (current_cpu, pc, "sfmt_emul1", "f_srcdst 0x%x", 'x', f_srcdst, "f_src1 0x%x", 'x', f_src1, "src2 0x%x", 'x', f_src2, "dst 0x%x", 'x', f_srcdst, (char *) 0));

#if WITH_PROFILE_MODEL_P
  /* Record the fields for profiling.  */
  if (PROFILE_MODEL_P (current_cpu))
    {
      FLD (in_src2) = f_src2;
      FLD (out_dst) = f_srcdst;
      FLD (out_h_gr_add__DFLT_index_of__DFLT_dst_1) = ((FLD (f_srcdst)) + (1));
    }
#endif
#undef FLD
    return idesc;
  }

 extract_sfmt_emul2:
  {
    const IDESC *idesc = &i960base_insn_data[itype];
    CGEN_INSN_INT insn = base_insn;
#define FLD(f) abuf->fields.sfmt_emul2.f
    UINT f_srcdst;
    UINT f_src2;
    UINT f_src1;

    f_srcdst = EXTRACT_MSB0_UINT (insn, 32, 8, 5);
    f_src2 = EXTRACT_MSB0_UINT (insn, 32, 13, 5);
    f_src1 = EXTRACT_MSB0_UINT (insn, 32, 27, 5);

  /* Record the fields for the semantic handler.  */
  FLD (f_srcdst) = f_srcdst;
  FLD (f_src2) = f_src2;
  FLD (i_src1) = & CPU (h_gr)[f_src1];
  FLD (i_dst) = & CPU (h_gr)[f_srcdst];
  TRACE_EXTRACT (current_cpu, abuf, (current_cpu, pc, "sfmt_emul2", "f_srcdst 0x%x", 'x', f_srcdst, "f_src2 0x%x", 'x', f_src2, "src1 0x%x", 'x', f_src1, "dst 0x%x", 'x', f_srcdst, (char *) 0));

#if WITH_PROFILE_MODEL_P
  /* Record the fields for profiling.  */
  if (PROFILE_MODEL_P (current_cpu))
    {
      FLD (in_src1) = f_src1;
      FLD (out_dst) = f_srcdst;
      FLD (out_h_gr_add__DFLT_index_of__DFLT_dst_1) = ((FLD (f_srcdst)) + (1));
    }
#endif
#undef FLD
    return idesc;
  }

 extract_sfmt_emul3:
  {
    const IDESC *idesc = &i960base_insn_data[itype];
    CGEN_INSN_INT insn = base_insn;
#define FLD(f) abuf->fields.sfmt_emul3.f
    UINT f_srcdst;
    UINT f_src2;
    UINT f_src1;

    f_srcdst = EXTRACT_MSB0_UINT (insn, 32, 8, 5);
    f_src2 = EXTRACT_MSB0_UINT (insn, 32, 13, 5);
    f_src1 = EXTRACT_MSB0_UINT (insn, 32, 27, 5);

  /* Record the fields for the semantic handler.  */
  FLD (f_srcdst) = f_srcdst;
  FLD (f_src1) = f_src1;
  FLD (f_src2) = f_src2;
  FLD (i_dst) = & CPU (h_gr)[f_srcdst];
  TRACE_EXTRACT (current_cpu, abuf, (current_cpu, pc, "sfmt_emul3", "f_srcdst 0x%x", 'x', f_srcdst, "f_src1 0x%x", 'x', f_src1, "f_src2 0x%x", 'x', f_src2, "dst 0x%x", 'x', f_srcdst, (char *) 0));

#if WITH_PROFILE_MODEL_P
  /* Record the fields for profiling.  */
  if (PROFILE_MODEL_P (current_cpu))
    {
      FLD (out_dst) = f_srcdst;
      FLD (out_h_gr_add__DFLT_index_of__DFLT_dst_1) = ((FLD (f_srcdst)) + (1));
    }
#endif
#undef FLD
    return idesc;
  }

 extract_sfmt_movl:
  {
    const IDESC *idesc = &i960base_insn_data[itype];
    CGEN_INSN_INT insn = base_insn;
#define FLD(f) abuf->fields.sfmt_movq.f
    UINT f_srcdst;
    UINT f_src1;

    f_srcdst = EXTRACT_MSB0_UINT (insn, 32, 8, 5);
    f_src1 = EXTRACT_MSB0_UINT (insn, 32, 27, 5);

  /* Record the fields for the semantic handler.  */
  FLD (f_src1) = f_src1;
  FLD (f_srcdst) = f_srcdst;
  FLD (i_src1) = & CPU (h_gr)[f_src1];
  FLD (i_dst) = & CPU (h_gr)[f_srcdst];
  TRACE_EXTRACT (current_cpu, abuf, (current_cpu, pc, "sfmt_movl", "f_src1 0x%x", 'x', f_src1, "f_srcdst 0x%x", 'x', f_srcdst, "src1 0x%x", 'x', f_src1, "dst 0x%x", 'x', f_srcdst, (char *) 0));

#if WITH_PROFILE_MODEL_P
  /* Record the fields for profiling.  */
  if (PROFILE_MODEL_P (current_cpu))
    {
      FLD (in_h_gr_add__DFLT_index_of__DFLT_src1_1) = ((FLD (f_src1)) + (1));
      FLD (in_src1) = f_src1;
      FLD (out_dst) = f_srcdst;
      FLD (out_h_gr_add__DFLT_index_of__DFLT_dst_1) = ((FLD (f_srcdst)) + (1));
    }
#endif
#undef FLD
    return idesc;
  }

 extract_sfmt_movl1:
  {
    const IDESC *idesc = &i960base_insn_data[itype];
    CGEN_INSN_INT insn = base_insn;
#define FLD(f) abuf->fields.sfmt_emul3.f
    UINT f_srcdst;
    UINT f_src1;

    f_srcdst = EXTRACT_MSB0_UINT (insn, 32, 8, 5);
    f_src1 = EXTRACT_MSB0_UINT (insn, 32, 27, 5);

  /* Record the fields for the semantic handler.  */
  FLD (f_srcdst) = f_srcdst;
  FLD (f_src1) = f_src1;
  FLD (i_dst) = & CPU (h_gr)[f_srcdst];
  TRACE_EXTRACT (current_cpu, abuf, (current_cpu, pc, "sfmt_movl1", "f_srcdst 0x%x", 'x', f_srcdst, "f_src1 0x%x", 'x', f_src1, "dst 0x%x", 'x', f_srcdst, (char *) 0));

#if WITH_PROFILE_MODEL_P
  /* Record the fields for profiling.  */
  if (PROFILE_MODEL_P (current_cpu))
    {
      FLD (out_dst) = f_srcdst;
      FLD (out_h_gr_add__DFLT_index_of__DFLT_dst_1) = ((FLD (f_srcdst)) + (1));
    }
#endif
#undef FLD
    return idesc;
  }

 extract_sfmt_movt:
  {
    const IDESC *idesc = &i960base_insn_data[itype];
    CGEN_INSN_INT insn = base_insn;
#define FLD(f) abuf->fields.sfmt_movq.f
    UINT f_srcdst;
    UINT f_src1;

    f_srcdst = EXTRACT_MSB0_UINT (insn, 32, 8, 5);
    f_src1 = EXTRACT_MSB0_UINT (insn, 32, 27, 5);

  /* Record the fields for the semantic handler.  */
  FLD (f_src1) = f_src1;
  FLD (f_srcdst) = f_srcdst;
  FLD (i_src1) = & CPU (h_gr)[f_src1];
  FLD (i_dst) = & CPU (h_gr)[f_srcdst];
  TRACE_EXTRACT (current_cpu, abuf, (current_cpu, pc, "sfmt_movt", "f_src1 0x%x", 'x', f_src1, "f_srcdst 0x%x", 'x', f_srcdst, "src1 0x%x", 'x', f_src1, "dst 0x%x", 'x', f_srcdst, (char *) 0));

#if WITH_PROFILE_MODEL_P
  /* Record the fields for profiling.  */
  if (PROFILE_MODEL_P (current_cpu))
    {
      FLD (in_h_gr_add__DFLT_index_of__DFLT_src1_1) = ((FLD (f_src1)) + (1));
      FLD (in_h_gr_add__DFLT_index_of__DFLT_src1_2) = ((FLD (f_src1)) + (2));
      FLD (in_src1) = f_src1;
      FLD (out_dst) = f_srcdst;
      FLD (out_h_gr_add__DFLT_index_of__DFLT_dst_1) = ((FLD (f_srcdst)) + (1));
      FLD (out_h_gr_add__DFLT_index_of__DFLT_dst_2) = ((FLD (f_srcdst)) + (2));
    }
#endif
#undef FLD
    return idesc;
  }

 extract_sfmt_movt1:
  {
    const IDESC *idesc = &i960base_insn_data[itype];
    CGEN_INSN_INT insn = base_insn;
#define FLD(f) abuf->fields.sfmt_movq.f
    UINT f_srcdst;
    UINT f_src1;

    f_srcdst = EXTRACT_MSB0_UINT (insn, 32, 8, 5);
    f_src1 = EXTRACT_MSB0_UINT (insn, 32, 27, 5);

  /* Record the fields for the semantic handler.  */
  FLD (f_srcdst) = f_srcdst;
  FLD (f_src1) = f_src1;
  FLD (i_dst) = & CPU (h_gr)[f_srcdst];
  TRACE_EXTRACT (current_cpu, abuf, (current_cpu, pc, "sfmt_movt1", "f_srcdst 0x%x", 'x', f_srcdst, "f_src1 0x%x", 'x', f_src1, "dst 0x%x", 'x', f_srcdst, (char *) 0));

#if WITH_PROFILE_MODEL_P
  /* Record the fields for profiling.  */
  if (PROFILE_MODEL_P (current_cpu))
    {
      FLD (out_dst) = f_srcdst;
      FLD (out_h_gr_add__DFLT_index_of__DFLT_dst_1) = ((FLD (f_srcdst)) + (1));
      FLD (out_h_gr_add__DFLT_index_of__DFLT_dst_2) = ((FLD (f_srcdst)) + (2));
    }
#endif
#undef FLD
    return idesc;
  }

 extract_sfmt_movq:
  {
    const IDESC *idesc = &i960base_insn_data[itype];
    CGEN_INSN_INT insn = base_insn;
#define FLD(f) abuf->fields.sfmt_movq.f
    UINT f_srcdst;
    UINT f_src1;

    f_srcdst = EXTRACT_MSB0_UINT (insn, 32, 8, 5);
    f_src1 = EXTRACT_MSB0_UINT (insn, 32, 27, 5);

  /* Record the fields for the semantic handler.  */
  FLD (f_src1) = f_src1;
  FLD (f_srcdst) = f_srcdst;
  FLD (i_src1) = & CPU (h_gr)[f_src1];
  FLD (i_dst) = & CPU (h_gr)[f_srcdst];
  TRACE_EXTRACT (current_cpu, abuf, (current_cpu, pc, "sfmt_movq", "f_src1 0x%x", 'x', f_src1, "f_srcdst 0x%x", 'x', f_srcdst, "src1 0x%x", 'x', f_src1, "dst 0x%x", 'x', f_srcdst, (char *) 0));

#if WITH_PROFILE_MODEL_P
  /* Record the fields for profiling.  */
  if (PROFILE_MODEL_P (current_cpu))
    {
      FLD (in_h_gr_add__DFLT_index_of__DFLT_src1_1) = ((FLD (f_src1)) + (1));
      FLD (in_h_gr_add__DFLT_index_of__DFLT_src1_2) = ((FLD (f_src1)) + (2));
      FLD (in_h_gr_add__DFLT_index_of__DFLT_src1_3) = ((FLD (f_src1)) + (3));
      FLD (in_src1) = f_src1;
      FLD (out_dst) = f_srcdst;
      FLD (out_h_gr_add__DFLT_index_of__DFLT_dst_1) = ((FLD (f_srcdst)) + (1));
      FLD (out_h_gr_add__DFLT_index_of__DFLT_dst_2) = ((FLD (f_srcdst)) + (2));
      FLD (out_h_gr_add__DFLT_index_of__DFLT_dst_3) = ((FLD (f_srcdst)) + (3));
    }
#endif
#undef FLD
    return idesc;
  }

 extract_sfmt_movq1:
  {
    const IDESC *idesc = &i960base_insn_data[itype];
    CGEN_INSN_INT insn = base_insn;
#define FLD(f) abuf->fields.sfmt_movq.f
    UINT f_srcdst;
    UINT f_src1;

    f_srcdst = EXTRACT_MSB0_UINT (insn, 32, 8, 5);
    f_src1 = EXTRACT_MSB0_UINT (insn, 32, 27, 5);

  /* Record the fields for the semantic handler.  */
  FLD (f_srcdst) = f_srcdst;
  FLD (f_src1) = f_src1;
  FLD (i_dst) = & CPU (h_gr)[f_srcdst];
  TRACE_EXTRACT (current_cpu, abuf, (current_cpu, pc, "sfmt_movq1", "f_srcdst 0x%x", 'x', f_srcdst, "f_src1 0x%x", 'x', f_src1, "dst 0x%x", 'x', f_srcdst, (char *) 0));

#if WITH_PROFILE_MODEL_P
  /* Record the fields for profiling.  */
  if (PROFILE_MODEL_P (current_cpu))
    {
      FLD (out_dst) = f_srcdst;
      FLD (out_h_gr_add__DFLT_index_of__DFLT_dst_1) = ((FLD (f_srcdst)) + (1));
      FLD (out_h_gr_add__DFLT_index_of__DFLT_dst_2) = ((FLD (f_srcdst)) + (2));
      FLD (out_h_gr_add__DFLT_index_of__DFLT_dst_3) = ((FLD (f_srcdst)) + (3));
    }
#endif
#undef FLD
    return idesc;
  }

 extract_sfmt_modpc:
  {
    const IDESC *idesc = &i960base_insn_data[itype];
    CGEN_INSN_INT insn = base_insn;
#define FLD(f) abuf->fields.sfmt_emul1.f
    UINT f_srcdst;
    UINT f_src2;

    f_srcdst = EXTRACT_MSB0_UINT (insn, 32, 8, 5);
    f_src2 = EXTRACT_MSB0_UINT (insn, 32, 13, 5);

  /* Record the fields for the semantic handler.  */
  FLD (i_src2) = & CPU (h_gr)[f_src2];
  FLD (i_dst) = & CPU (h_gr)[f_srcdst];
  TRACE_EXTRACT (current_cpu, abuf, (current_cpu, pc, "sfmt_modpc", "src2 0x%x", 'x', f_src2, "dst 0x%x", 'x', f_srcdst, (char *) 0));

#if WITH_PROFILE_MODEL_P
  /* Record the fields for profiling.  */
  if (PROFILE_MODEL_P (current_cpu))
    {
      FLD (in_src2) = f_src2;
      FLD (out_dst) = f_srcdst;
    }
#endif
#undef FLD
    return idesc;
  }

 extract_sfmt_lda_offset:
  {
    const IDESC *idesc = &i960base_insn_data[itype];
    CGEN_INSN_INT insn = base_insn;
#define FLD(f) abuf->fields.sfmt_ldq_indirect_offset.f
    UINT f_srcdst;
    UINT f_offset;

    f_srcdst = EXTRACT_MSB0_UINT (insn, 32, 8, 5);
    f_offset = EXTRACT_MSB0_UINT (insn, 32, 20, 12);

  /* Record the fields for the semantic handler.  */
  FLD (f_offset) = f_offset;
  FLD (i_dst) = & CPU (h_gr)[f_srcdst];
  TRACE_EXTRACT (current_cpu, abuf, (current_cpu, pc, "sfmt_lda_offset", "f_offset 0x%x", 'x', f_offset, "dst 0x%x", 'x', f_srcdst, (char *) 0));

#if WITH_PROFILE_MODEL_P
  /* Record the fields for profiling.  */
  if (PROFILE_MODEL_P (current_cpu))
    {
      FLD (out_dst) = f_srcdst;
    }
#endif
#undef FLD
    return idesc;
  }

 extract_sfmt_lda_indirect_offset:
  {
    const IDESC *idesc = &i960base_insn_data[itype];
    CGEN_INSN_INT insn = base_insn;
#define FLD(f) abuf->fields.sfmt_ldq_indirect_offset.f
    UINT f_srcdst;
    UINT f_abase;
    UINT f_offset;

    f_srcdst = EXTRACT_MSB0_UINT (insn, 32, 8, 5);
    f_abase = EXTRACT_MSB0_UINT (insn, 32, 13, 5);
    f_offset = EXTRACT_MSB0_UINT (insn, 32, 20, 12);

  /* Record the fields for the semantic handler.  */
  FLD (f_offset) = f_offset;
  FLD (i_abase) = & CPU (h_gr)[f_abase];
  FLD (i_dst) = & CPU (h_gr)[f_srcdst];
  TRACE_EXTRACT (current_cpu, abuf, (current_cpu, pc, "sfmt_lda_indirect_offset", "f_offset 0x%x", 'x', f_offset, "abase 0x%x", 'x', f_abase, "dst 0x%x", 'x', f_srcdst, (char *) 0));

#if WITH_PROFILE_MODEL_P
  /* Record the fields for profiling.  */
  if (PROFILE_MODEL_P (current_cpu))
    {
      FLD (in_abase) = f_abase;
      FLD (out_dst) = f_srcdst;
    }
#endif
#undef FLD
    return idesc;
  }

 extract_sfmt_lda_indirect:
  {
    const IDESC *idesc = &i960base_insn_data[itype];
    CGEN_INSN_INT insn = base_insn;
#define FLD(f) abuf->fields.sfmt_ldq_indirect_offset.f
    UINT f_srcdst;
    UINT f_abase;

    f_srcdst = EXTRACT_MSB0_UINT (insn, 32, 8, 5);
    f_abase = EXTRACT_MSB0_UINT (insn, 32, 13, 5);

  /* Record the fields for the semantic handler.  */
  FLD (i_abase) = & CPU (h_gr)[f_abase];
  FLD (i_dst) = & CPU (h_gr)[f_srcdst];
  TRACE_EXTRACT (current_cpu, abuf, (current_cpu, pc, "sfmt_lda_indirect", "abase 0x%x", 'x', f_abase, "dst 0x%x", 'x', f_srcdst, (char *) 0));

#if WITH_PROFILE_MODEL_P
  /* Record the fields for profiling.  */
  if (PROFILE_MODEL_P (current_cpu))
    {
      FLD (in_abase) = f_abase;
      FLD (out_dst) = f_srcdst;
    }
#endif
#undef FLD
    return idesc;
  }

 extract_sfmt_lda_indirect_index:
  {
    const IDESC *idesc = &i960base_insn_data[itype];
    CGEN_INSN_INT insn = base_insn;
#define FLD(f) abuf->fields.sfmt_ldq_indirect_index_disp.f
    UINT f_srcdst;
    UINT f_abase;
    UINT f_scale;
    UINT f_index;

    f_srcdst = EXTRACT_MSB0_UINT (insn, 32, 8, 5);
    f_abase = EXTRACT_MSB0_UINT (insn, 32, 13, 5);
    f_scale = EXTRACT_MSB0_UINT (insn, 32, 22, 3);
    f_index = EXTRACT_MSB0_UINT (insn, 32, 27, 5);

  /* Record the fields for the semantic handler.  */
  FLD (f_scale) = f_scale;
  FLD (i_abase) = & CPU (h_gr)[f_abase];
  FLD (i_index) = & CPU (h_gr)[f_index];
  FLD (i_dst) = & CPU (h_gr)[f_srcdst];
  TRACE_EXTRACT (current_cpu, abuf, (current_cpu, pc, "sfmt_lda_indirect_index", "f_scale 0x%x", 'x', f_scale, "abase 0x%x", 'x', f_abase, "index 0x%x", 'x', f_index, "dst 0x%x", 'x', f_srcdst, (char *) 0));

#if WITH_PROFILE_MODEL_P
  /* Record the fields for profiling.  */
  if (PROFILE_MODEL_P (current_cpu))
    {
      FLD (in_abase) = f_abase;
      FLD (in_index) = f_index;
      FLD (out_dst) = f_srcdst;
    }
#endif
#undef FLD
    return idesc;
  }

 extract_sfmt_lda_disp:
  {
    const IDESC *idesc = &i960base_insn_data[itype];
    CGEN_INSN_INT insn = base_insn;
#define FLD(f) abuf->fields.sfmt_ldq_indirect_index_disp.f
    UINT f_optdisp;
    UINT f_srcdst;
    /* Contents of trailing part of insn.  */
    UINT word_1;

  word_1 = GETIMEMUSI (current_cpu, pc + 4);
    f_optdisp = (0|(EXTRACT_MSB0_UINT (word_1, 32, 0, 32) << 0));
    f_srcdst = EXTRACT_MSB0_UINT (insn, 32, 8, 5);

  /* Record the fields for the semantic handler.  */
  FLD (f_optdisp) = f_optdisp;
  FLD (i_dst) = & CPU (h_gr)[f_srcdst];
  TRACE_EXTRACT (current_cpu, abuf, (current_cpu, pc, "sfmt_lda_disp", "f_optdisp 0x%x", 'x', f_optdisp, "dst 0x%x", 'x', f_srcdst, (char *) 0));

#if WITH_PROFILE_MODEL_P
  /* Record the fields for profiling.  */
  if (PROFILE_MODEL_P (current_cpu))
    {
      FLD (out_dst) = f_srcdst;
    }
#endif
#undef FLD
    return idesc;
  }

 extract_sfmt_lda_indirect_disp:
  {
    const IDESC *idesc = &i960base_insn_data[itype];
    CGEN_INSN_INT insn = base_insn;
#define FLD(f) abuf->fields.sfmt_ldq_indirect_index_disp.f
    UINT f_optdisp;
    UINT f_srcdst;
    UINT f_abase;
    /* Contents of trailing part of insn.  */
    UINT word_1;

  word_1 = GETIMEMUSI (current_cpu, pc + 4);
    f_optdisp = (0|(EXTRACT_MSB0_UINT (word_1, 32, 0, 32) << 0));
    f_srcdst = EXTRACT_MSB0_UINT (insn, 32, 8, 5);
    f_abase = EXTRACT_MSB0_UINT (insn, 32, 13, 5);

  /* Record the fields for the semantic handler.  */
  FLD (f_optdisp) = f_optdisp;
  FLD (i_abase) = & CPU (h_gr)[f_abase];
  FLD (i_dst) = & CPU (h_gr)[f_srcdst];
  TRACE_EXTRACT (current_cpu, abuf, (current_cpu, pc, "sfmt_lda_indirect_disp", "f_optdisp 0x%x", 'x', f_optdisp, "abase 0x%x", 'x', f_abase, "dst 0x%x", 'x', f_srcdst, (char *) 0));

#if WITH_PROFILE_MODEL_P
  /* Record the fields for profiling.  */
  if (PROFILE_MODEL_P (current_cpu))
    {
      FLD (in_abase) = f_abase;
      FLD (out_dst) = f_srcdst;
    }
#endif
#undef FLD
    return idesc;
  }

 extract_sfmt_lda_index_disp:
  {
    const IDESC *idesc = &i960base_insn_data[itype];
    CGEN_INSN_INT insn = base_insn;
#define FLD(f) abuf->fields.sfmt_ldq_indirect_index_disp.f
    UINT f_optdisp;
    UINT f_srcdst;
    UINT f_scale;
    UINT f_index;
    /* Contents of trailing part of insn.  */
    UINT word_1;

  word_1 = GETIMEMUSI (current_cpu, pc + 4);
    f_optdisp = (0|(EXTRACT_MSB0_UINT (word_1, 32, 0, 32) << 0));
    f_srcdst = EXTRACT_MSB0_UINT (insn, 32, 8, 5);
    f_scale = EXTRACT_MSB0_UINT (insn, 32, 22, 3);
    f_index = EXTRACT_MSB0_UINT (insn, 32, 27, 5);

  /* Record the fields for the semantic handler.  */
  FLD (f_optdisp) = f_optdisp;
  FLD (f_scale) = f_scale;
  FLD (i_index) = & CPU (h_gr)[f_index];
  FLD (i_dst) = & CPU (h_gr)[f_srcdst];
  TRACE_EXTRACT (current_cpu, abuf, (current_cpu, pc, "sfmt_lda_index_disp", "f_optdisp 0x%x", 'x', f_optdisp, "f_scale 0x%x", 'x', f_scale, "index 0x%x", 'x', f_index, "dst 0x%x", 'x', f_srcdst, (char *) 0));

#if WITH_PROFILE_MODEL_P
  /* Record the fields for profiling.  */
  if (PROFILE_MODEL_P (current_cpu))
    {
      FLD (in_index) = f_index;
      FLD (out_dst) = f_srcdst;
    }
#endif
#undef FLD
    return idesc;
  }

 extract_sfmt_lda_indirect_index_disp:
  {
    const IDESC *idesc = &i960base_insn_data[itype];
    CGEN_INSN_INT insn = base_insn;
#define FLD(f) abuf->fields.sfmt_ldq_indirect_index_disp.f
    UINT f_optdisp;
    UINT f_srcdst;
    UINT f_abase;
    UINT f_scale;
    UINT f_index;
    /* Contents of trailing part of insn.  */
    UINT word_1;

  word_1 = GETIMEMUSI (current_cpu, pc + 4);
    f_optdisp = (0|(EXTRACT_MSB0_UINT (word_1, 32, 0, 32) << 0));
    f_srcdst = EXTRACT_MSB0_UINT (insn, 32, 8, 5);
    f_abase = EXTRACT_MSB0_UINT (insn, 32, 13, 5);
    f_scale = EXTRACT_MSB0_UINT (insn, 32, 22, 3);
    f_index = EXTRACT_MSB0_UINT (insn, 32, 27, 5);

  /* Record the fields for the semantic handler.  */
  FLD (f_optdisp) = f_optdisp;
  FLD (f_scale) = f_scale;
  FLD (i_abase) = & CPU (h_gr)[f_abase];
  FLD (i_index) = & CPU (h_gr)[f_index];
  FLD (i_dst) = & CPU (h_gr)[f_srcdst];
  TRACE_EXTRACT (current_cpu, abuf, (current_cpu, pc, "sfmt_lda_indirect_index_disp", "f_optdisp 0x%x", 'x', f_optdisp, "f_scale 0x%x", 'x', f_scale, "abase 0x%x", 'x', f_abase, "index 0x%x", 'x', f_index, "dst 0x%x", 'x', f_srcdst, (char *) 0));

#if WITH_PROFILE_MODEL_P
  /* Record the fields for profiling.  */
  if (PROFILE_MODEL_P (current_cpu))
    {
      FLD (in_abase) = f_abase;
      FLD (in_index) = f_index;
      FLD (out_dst) = f_srcdst;
    }
#endif
#undef FLD
    return idesc;
  }

 extract_sfmt_ld_offset:
  {
    const IDESC *idesc = &i960base_insn_data[itype];
    CGEN_INSN_INT insn = base_insn;
#define FLD(f) abuf->fields.sfmt_ldq_indirect_offset.f
    UINT f_srcdst;
    UINT f_offset;

    f_srcdst = EXTRACT_MSB0_UINT (insn, 32, 8, 5);
    f_offset = EXTRACT_MSB0_UINT (insn, 32, 20, 12);

  /* Record the fields for the semantic handler.  */
  FLD (f_offset) = f_offset;
  FLD (i_dst) = & CPU (h_gr)[f_srcdst];
  TRACE_EXTRACT (current_cpu, abuf, (current_cpu, pc, "sfmt_ld_offset", "f_offset 0x%x", 'x', f_offset, "dst 0x%x", 'x', f_srcdst, (char *) 0));

#if WITH_PROFILE_MODEL_P
  /* Record the fields for profiling.  */
  if (PROFILE_MODEL_P (current_cpu))
    {
      FLD (out_dst) = f_srcdst;
    }
#endif
#undef FLD
    return idesc;
  }

 extract_sfmt_ld_indirect_offset:
  {
    const IDESC *idesc = &i960base_insn_data[itype];
    CGEN_INSN_INT insn = base_insn;
#define FLD(f) abuf->fields.sfmt_ldq_indirect_offset.f
    UINT f_srcdst;
    UINT f_abase;
    UINT f_offset;

    f_srcdst = EXTRACT_MSB0_UINT (insn, 32, 8, 5);
    f_abase = EXTRACT_MSB0_UINT (insn, 32, 13, 5);
    f_offset = EXTRACT_MSB0_UINT (insn, 32, 20, 12);

  /* Record the fields for the semantic handler.  */
  FLD (f_offset) = f_offset;
  FLD (i_abase) = & CPU (h_gr)[f_abase];
  FLD (i_dst) = & CPU (h_gr)[f_srcdst];
  TRACE_EXTRACT (current_cpu, abuf, (current_cpu, pc, "sfmt_ld_indirect_offset", "f_offset 0x%x", 'x', f_offset, "abase 0x%x", 'x', f_abase, "dst 0x%x", 'x', f_srcdst, (char *) 0));

#if WITH_PROFILE_MODEL_P
  /* Record the fields for profiling.  */
  if (PROFILE_MODEL_P (current_cpu))
    {
      FLD (in_abase) = f_abase;
      FLD (out_dst) = f_srcdst;
    }
#endif
#undef FLD
    return idesc;
  }

 extract_sfmt_ld_indirect:
  {
    const IDESC *idesc = &i960base_insn_data[itype];
    CGEN_INSN_INT insn = base_insn;
#define FLD(f) abuf->fields.sfmt_ldq_indirect_offset.f
    UINT f_srcdst;
    UINT f_abase;

    f_srcdst = EXTRACT_MSB0_UINT (insn, 32, 8, 5);
    f_abase = EXTRACT_MSB0_UINT (insn, 32, 13, 5);

  /* Record the fields for the semantic handler.  */
  FLD (i_abase) = & CPU (h_gr)[f_abase];
  FLD (i_dst) = & CPU (h_gr)[f_srcdst];
  TRACE_EXTRACT (current_cpu, abuf, (current_cpu, pc, "sfmt_ld_indirect", "abase 0x%x", 'x', f_abase, "dst 0x%x", 'x', f_srcdst, (char *) 0));

#if WITH_PROFILE_MODEL_P
  /* Record the fields for profiling.  */
  if (PROFILE_MODEL_P (current_cpu))
    {
      FLD (in_abase) = f_abase;
      FLD (out_dst) = f_srcdst;
    }
#endif
#undef FLD
    return idesc;
  }

 extract_sfmt_ld_indirect_index:
  {
    const IDESC *idesc = &i960base_insn_data[itype];
    CGEN_INSN_INT insn = base_insn;
#define FLD(f) abuf->fields.sfmt_ldq_indirect_index_disp.f
    UINT f_srcdst;
    UINT f_abase;
    UINT f_scale;
    UINT f_index;

    f_srcdst = EXTRACT_MSB0_UINT (insn, 32, 8, 5);
    f_abase = EXTRACT_MSB0_UINT (insn, 32, 13, 5);
    f_scale = EXTRACT_MSB0_UINT (insn, 32, 22, 3);
    f_index = EXTRACT_MSB0_UINT (insn, 32, 27, 5);

  /* Record the fields for the semantic handler.  */
  FLD (f_scale) = f_scale;
  FLD (i_abase) = & CPU (h_gr)[f_abase];
  FLD (i_index) = & CPU (h_gr)[f_index];
  FLD (i_dst) = & CPU (h_gr)[f_srcdst];
  TRACE_EXTRACT (current_cpu, abuf, (current_cpu, pc, "sfmt_ld_indirect_index", "f_scale 0x%x", 'x', f_scale, "abase 0x%x", 'x', f_abase, "index 0x%x", 'x', f_index, "dst 0x%x", 'x', f_srcdst, (char *) 0));

#if WITH_PROFILE_MODEL_P
  /* Record the fields for profiling.  */
  if (PROFILE_MODEL_P (current_cpu))
    {
      FLD (in_abase) = f_abase;
      FLD (in_index) = f_index;
      FLD (out_dst) = f_srcdst;
    }
#endif
#undef FLD
    return idesc;
  }

 extract_sfmt_ld_disp:
  {
    const IDESC *idesc = &i960base_insn_data[itype];
    CGEN_INSN_INT insn = base_insn;
#define FLD(f) abuf->fields.sfmt_ldq_indirect_index_disp.f
    UINT f_optdisp;
    UINT f_srcdst;
    /* Contents of trailing part of insn.  */
    UINT word_1;

  word_1 = GETIMEMUSI (current_cpu, pc + 4);
    f_optdisp = (0|(EXTRACT_MSB0_UINT (word_1, 32, 0, 32) << 0));
    f_srcdst = EXTRACT_MSB0_UINT (insn, 32, 8, 5);

  /* Record the fields for the semantic handler.  */
  FLD (f_optdisp) = f_optdisp;
  FLD (i_dst) = & CPU (h_gr)[f_srcdst];
  TRACE_EXTRACT (current_cpu, abuf, (current_cpu, pc, "sfmt_ld_disp", "f_optdisp 0x%x", 'x', f_optdisp, "dst 0x%x", 'x', f_srcdst, (char *) 0));

#if WITH_PROFILE_MODEL_P
  /* Record the fields for profiling.  */
  if (PROFILE_MODEL_P (current_cpu))
    {
      FLD (out_dst) = f_srcdst;
    }
#endif
#undef FLD
    return idesc;
  }

 extract_sfmt_ld_indirect_disp:
  {
    const IDESC *idesc = &i960base_insn_data[itype];
    CGEN_INSN_INT insn = base_insn;
#define FLD(f) abuf->fields.sfmt_ldq_indirect_index_disp.f
    UINT f_optdisp;
    UINT f_srcdst;
    UINT f_abase;
    /* Contents of trailing part of insn.  */
    UINT word_1;

  word_1 = GETIMEMUSI (current_cpu, pc + 4);
    f_optdisp = (0|(EXTRACT_MSB0_UINT (word_1, 32, 0, 32) << 0));
    f_srcdst = EXTRACT_MSB0_UINT (insn, 32, 8, 5);
    f_abase = EXTRACT_MSB0_UINT (insn, 32, 13, 5);

  /* Record the fields for the semantic handler.  */
  FLD (f_optdisp) = f_optdisp;
  FLD (i_abase) = & CPU (h_gr)[f_abase];
  FLD (i_dst) = & CPU (h_gr)[f_srcdst];
  TRACE_EXTRACT (current_cpu, abuf, (current_cpu, pc, "sfmt_ld_indirect_disp", "f_optdisp 0x%x", 'x', f_optdisp, "abase 0x%x", 'x', f_abase, "dst 0x%x", 'x', f_srcdst, (char *) 0));

#if WITH_PROFILE_MODEL_P
  /* Record the fields for profiling.  */
  if (PROFILE_MODEL_P (current_cpu))
    {
      FLD (in_abase) = f_abase;
      FLD (out_dst) = f_srcdst;
    }
#endif
#undef FLD
    return idesc;
  }

 extract_sfmt_ld_index_disp:
  {
    const IDESC *idesc = &i960base_insn_data[itype];
    CGEN_INSN_INT insn = base_insn;
#define FLD(f) abuf->fields.sfmt_ldq_indirect_index_disp.f
    UINT f_optdisp;
    UINT f_srcdst;
    UINT f_scale;
    UINT f_index;
    /* Contents of trailing part of insn.  */
    UINT word_1;

  word_1 = GETIMEMUSI (current_cpu, pc + 4);
    f_optdisp = (0|(EXTRACT_MSB0_UINT (word_1, 32, 0, 32) << 0));
    f_srcdst = EXTRACT_MSB0_UINT (insn, 32, 8, 5);
    f_scale = EXTRACT_MSB0_UINT (insn, 32, 22, 3);
    f_index = EXTRACT_MSB0_UINT (insn, 32, 27, 5);

  /* Record the fields for the semantic handler.  */
  FLD (f_optdisp) = f_optdisp;
  FLD (f_scale) = f_scale;
  FLD (i_index) = & CPU (h_gr)[f_index];
  FLD (i_dst) = & CPU (h_gr)[f_srcdst];
  TRACE_EXTRACT (current_cpu, abuf, (current_cpu, pc, "sfmt_ld_index_disp", "f_optdisp 0x%x", 'x', f_optdisp, "f_scale 0x%x", 'x', f_scale, "index 0x%x", 'x', f_index, "dst 0x%x", 'x', f_srcdst, (char *) 0));

#if WITH_PROFILE_MODEL_P
  /* Record the fields for profiling.  */
  if (PROFILE_MODEL_P (current_cpu))
    {
      FLD (in_index) = f_index;
      FLD (out_dst) = f_srcdst;
    }
#endif
#undef FLD
    return idesc;
  }

 extract_sfmt_ld_indirect_index_disp:
  {
    const IDESC *idesc = &i960base_insn_data[itype];
    CGEN_INSN_INT insn = base_insn;
#define FLD(f) abuf->fields.sfmt_ldq_indirect_index_disp.f
    UINT f_optdisp;
    UINT f_srcdst;
    UINT f_abase;
    UINT f_scale;
    UINT f_index;
    /* Contents of trailing part of insn.  */
    UINT word_1;

  word_1 = GETIMEMUSI (current_cpu, pc + 4);
    f_optdisp = (0|(EXTRACT_MSB0_UINT (word_1, 32, 0, 32) << 0));
    f_srcdst = EXTRACT_MSB0_UINT (insn, 32, 8, 5);
    f_abase = EXTRACT_MSB0_UINT (insn, 32, 13, 5);
    f_scale = EXTRACT_MSB0_UINT (insn, 32, 22, 3);
    f_index = EXTRACT_MSB0_UINT (insn, 32, 27, 5);

  /* Record the fields for the semantic handler.  */
  FLD (f_optdisp) = f_optdisp;
  FLD (f_scale) = f_scale;
  FLD (i_abase) = & CPU (h_gr)[f_abase];
  FLD (i_index) = & CPU (h_gr)[f_index];
  FLD (i_dst) = & CPU (h_gr)[f_srcdst];
  TRACE_EXTRACT (current_cpu, abuf, (current_cpu, pc, "sfmt_ld_indirect_index_disp", "f_optdisp 0x%x", 'x', f_optdisp, "f_scale 0x%x", 'x', f_scale, "abase 0x%x", 'x', f_abase, "index 0x%x", 'x', f_index, "dst 0x%x", 'x', f_srcdst, (char *) 0));

#if WITH_PROFILE_MODEL_P
  /* Record the fields for profiling.  */
  if (PROFILE_MODEL_P (current_cpu))
    {
      FLD (in_abase) = f_abase;
      FLD (in_index) = f_index;
      FLD (out_dst) = f_srcdst;
    }
#endif
#undef FLD
    return idesc;
  }

 extract_sfmt_ldl_offset:
  {
    const IDESC *idesc = &i960base_insn_data[itype];
    CGEN_INSN_INT insn = base_insn;
#define FLD(f) abuf->fields.sfmt_ldq_indirect_offset.f
    UINT f_srcdst;
    UINT f_offset;

    f_srcdst = EXTRACT_MSB0_UINT (insn, 32, 8, 5);
    f_offset = EXTRACT_MSB0_UINT (insn, 32, 20, 12);

  /* Record the fields for the semantic handler.  */
  FLD (f_srcdst) = f_srcdst;
  FLD (f_offset) = f_offset;
  FLD (i_dst) = & CPU (h_gr)[f_srcdst];
  TRACE_EXTRACT (current_cpu, abuf, (current_cpu, pc, "sfmt_ldl_offset", "f_srcdst 0x%x", 'x', f_srcdst, "f_offset 0x%x", 'x', f_offset, "dst 0x%x", 'x', f_srcdst, (char *) 0));

#if WITH_PROFILE_MODEL_P
  /* Record the fields for profiling.  */
  if (PROFILE_MODEL_P (current_cpu))
    {
      FLD (out_dst) = f_srcdst;
      FLD (out_h_gr_add__DFLT_index_of__DFLT_dst_1) = ((FLD (f_srcdst)) + (1));
    }
#endif
#undef FLD
    return idesc;
  }

 extract_sfmt_ldl_indirect_offset:
  {
    const IDESC *idesc = &i960base_insn_data[itype];
    CGEN_INSN_INT insn = base_insn;
#define FLD(f) abuf->fields.sfmt_ldq_indirect_offset.f
    UINT f_srcdst;
    UINT f_abase;
    UINT f_offset;

    f_srcdst = EXTRACT_MSB0_UINT (insn, 32, 8, 5);
    f_abase = EXTRACT_MSB0_UINT (insn, 32, 13, 5);
    f_offset = EXTRACT_MSB0_UINT (insn, 32, 20, 12);

  /* Record the fields for the semantic handler.  */
  FLD (f_srcdst) = f_srcdst;
  FLD (f_offset) = f_offset;
  FLD (i_abase) = & CPU (h_gr)[f_abase];
  FLD (i_dst) = & CPU (h_gr)[f_srcdst];
  TRACE_EXTRACT (current_cpu, abuf, (current_cpu, pc, "sfmt_ldl_indirect_offset", "f_srcdst 0x%x", 'x', f_srcdst, "f_offset 0x%x", 'x', f_offset, "abase 0x%x", 'x', f_abase, "dst 0x%x", 'x', f_srcdst, (char *) 0));

#if WITH_PROFILE_MODEL_P
  /* Record the fields for profiling.  */
  if (PROFILE_MODEL_P (current_cpu))
    {
      FLD (in_abase) = f_abase;
      FLD (out_dst) = f_srcdst;
      FLD (out_h_gr_add__DFLT_index_of__DFLT_dst_1) = ((FLD (f_srcdst)) + (1));
    }
#endif
#undef FLD
    return idesc;
  }

 extract_sfmt_ldl_indirect:
  {
    const IDESC *idesc = &i960base_insn_data[itype];
    CGEN_INSN_INT insn = base_insn;
#define FLD(f) abuf->fields.sfmt_ldq_indirect_offset.f
    UINT f_srcdst;
    UINT f_abase;

    f_srcdst = EXTRACT_MSB0_UINT (insn, 32, 8, 5);
    f_abase = EXTRACT_MSB0_UINT (insn, 32, 13, 5);

  /* Record the fields for the semantic handler.  */
  FLD (f_srcdst) = f_srcdst;
  FLD (i_abase) = & CPU (h_gr)[f_abase];
  FLD (i_dst) = & CPU (h_gr)[f_srcdst];
  TRACE_EXTRACT (current_cpu, abuf, (current_cpu, pc, "sfmt_ldl_indirect", "f_srcdst 0x%x", 'x', f_srcdst, "abase 0x%x", 'x', f_abase, "dst 0x%x", 'x', f_srcdst, (char *) 0));

#if WITH_PROFILE_MODEL_P
  /* Record the fields for profiling.  */
  if (PROFILE_MODEL_P (current_cpu))
    {
      FLD (in_abase) = f_abase;
      FLD (out_dst) = f_srcdst;
      FLD (out_h_gr_add__DFLT_index_of__DFLT_dst_1) = ((FLD (f_srcdst)) + (1));
    }
#endif
#undef FLD
    return idesc;
  }

 extract_sfmt_ldl_indirect_index:
  {
    const IDESC *idesc = &i960base_insn_data[itype];
    CGEN_INSN_INT insn = base_insn;
#define FLD(f) abuf->fields.sfmt_ldq_indirect_index_disp.f
    UINT f_srcdst;
    UINT f_abase;
    UINT f_scale;
    UINT f_index;

    f_srcdst = EXTRACT_MSB0_UINT (insn, 32, 8, 5);
    f_abase = EXTRACT_MSB0_UINT (insn, 32, 13, 5);
    f_scale = EXTRACT_MSB0_UINT (insn, 32, 22, 3);
    f_index = EXTRACT_MSB0_UINT (insn, 32, 27, 5);

  /* Record the fields for the semantic handler.  */
  FLD (f_srcdst) = f_srcdst;
  FLD (f_scale) = f_scale;
  FLD (i_abase) = & CPU (h_gr)[f_abase];
  FLD (i_index) = & CPU (h_gr)[f_index];
  FLD (i_dst) = & CPU (h_gr)[f_srcdst];
  TRACE_EXTRACT (current_cpu, abuf, (current_cpu, pc, "sfmt_ldl_indirect_index", "f_srcdst 0x%x", 'x', f_srcdst, "f_scale 0x%x", 'x', f_scale, "abase 0x%x", 'x', f_abase, "index 0x%x", 'x', f_index, "dst 0x%x", 'x', f_srcdst, (char *) 0));

#if WITH_PROFILE_MODEL_P
  /* Record the fields for profiling.  */
  if (PROFILE_MODEL_P (current_cpu))
    {
      FLD (in_abase) = f_abase;
      FLD (in_index) = f_index;
      FLD (out_dst) = f_srcdst;
      FLD (out_h_gr_add__DFLT_index_of__DFLT_dst_1) = ((FLD (f_srcdst)) + (1));
    }
#endif
#undef FLD
    return idesc;
  }

 extract_sfmt_ldl_disp:
  {
    const IDESC *idesc = &i960base_insn_data[itype];
    CGEN_INSN_INT insn = base_insn;
#define FLD(f) abuf->fields.sfmt_ldq_indirect_index_disp.f
    UINT f_optdisp;
    UINT f_srcdst;
    /* Contents of trailing part of insn.  */
    UINT word_1;

  word_1 = GETIMEMUSI (current_cpu, pc + 4);
    f_optdisp = (0|(EXTRACT_MSB0_UINT (word_1, 32, 0, 32) << 0));
    f_srcdst = EXTRACT_MSB0_UINT (insn, 32, 8, 5);

  /* Record the fields for the semantic handler.  */
  FLD (f_srcdst) = f_srcdst;
  FLD (f_optdisp) = f_optdisp;
  FLD (i_dst) = & CPU (h_gr)[f_srcdst];
  TRACE_EXTRACT (current_cpu, abuf, (current_cpu, pc, "sfmt_ldl_disp", "f_srcdst 0x%x", 'x', f_srcdst, "f_optdisp 0x%x", 'x', f_optdisp, "dst 0x%x", 'x', f_srcdst, (char *) 0));

#if WITH_PROFILE_MODEL_P
  /* Record the fields for profiling.  */
  if (PROFILE_MODEL_P (current_cpu))
    {
      FLD (out_dst) = f_srcdst;
      FLD (out_h_gr_add__DFLT_index_of__DFLT_dst_1) = ((FLD (f_srcdst)) + (1));
    }
#endif
#undef FLD
    return idesc;
  }

 extract_sfmt_ldl_indirect_disp:
  {
    const IDESC *idesc = &i960base_insn_data[itype];
    CGEN_INSN_INT insn = base_insn;
#define FLD(f) abuf->fields.sfmt_ldq_indirect_index_disp.f
    UINT f_optdisp;
    UINT f_srcdst;
    UINT f_abase;
    /* Contents of trailing part of insn.  */
    UINT word_1;

  word_1 = GETIMEMUSI (current_cpu, pc + 4);
    f_optdisp = (0|(EXTRACT_MSB0_UINT (word_1, 32, 0, 32) << 0));
    f_srcdst = EXTRACT_MSB0_UINT (insn, 32, 8, 5);
    f_abase = EXTRACT_MSB0_UINT (insn, 32, 13, 5);

  /* Record the fields for the semantic handler.  */
  FLD (f_srcdst) = f_srcdst;
  FLD (f_optdisp) = f_optdisp;
  FLD (i_abase) = & CPU (h_gr)[f_abase];
  FLD (i_dst) = & CPU (h_gr)[f_srcdst];
  TRACE_EXTRACT (current_cpu, abuf, (current_cpu, pc, "sfmt_ldl_indirect_disp", "f_srcdst 0x%x", 'x', f_srcdst, "f_optdisp 0x%x", 'x', f_optdisp, "abase 0x%x", 'x', f_abase, "dst 0x%x", 'x', f_srcdst, (char *) 0));

#if WITH_PROFILE_MODEL_P
  /* Record the fields for profiling.  */
  if (PROFILE_MODEL_P (current_cpu))
    {
      FLD (in_abase) = f_abase;
      FLD (out_dst) = f_srcdst;
      FLD (out_h_gr_add__DFLT_index_of__DFLT_dst_1) = ((FLD (f_srcdst)) + (1));
    }
#endif
#undef FLD
    return idesc;
  }

 extract_sfmt_ldl_index_disp:
  {
    const IDESC *idesc = &i960base_insn_data[itype];
    CGEN_INSN_INT insn = base_insn;
#define FLD(f) abuf->fields.sfmt_ldq_indirect_index_disp.f
    UINT f_optdisp;
    UINT f_srcdst;
    UINT f_scale;
    UINT f_index;
    /* Contents of trailing part of insn.  */
    UINT word_1;

  word_1 = GETIMEMUSI (current_cpu, pc + 4);
    f_optdisp = (0|(EXTRACT_MSB0_UINT (word_1, 32, 0, 32) << 0));
    f_srcdst = EXTRACT_MSB0_UINT (insn, 32, 8, 5);
    f_scale = EXTRACT_MSB0_UINT (insn, 32, 22, 3);
    f_index = EXTRACT_MSB0_UINT (insn, 32, 27, 5);

  /* Record the fields for the semantic handler.  */
  FLD (f_srcdst) = f_srcdst;
  FLD (f_optdisp) = f_optdisp;
  FLD (f_scale) = f_scale;
  FLD (i_index) = & CPU (h_gr)[f_index];
  FLD (i_dst) = & CPU (h_gr)[f_srcdst];
  TRACE_EXTRACT (current_cpu, abuf, (current_cpu, pc, "sfmt_ldl_index_disp", "f_srcdst 0x%x", 'x', f_srcdst, "f_optdisp 0x%x", 'x', f_optdisp, "f_scale 0x%x", 'x', f_scale, "index 0x%x", 'x', f_index, "dst 0x%x", 'x', f_srcdst, (char *) 0));

#if WITH_PROFILE_MODEL_P
  /* Record the fields for profiling.  */
  if (PROFILE_MODEL_P (current_cpu))
    {
      FLD (in_index) = f_index;
      FLD (out_dst) = f_srcdst;
      FLD (out_h_gr_add__DFLT_index_of__DFLT_dst_1) = ((FLD (f_srcdst)) + (1));
    }
#endif
#undef FLD
    return idesc;
  }

 extract_sfmt_ldl_indirect_index_disp:
  {
    const IDESC *idesc = &i960base_insn_data[itype];
    CGEN_INSN_INT insn = base_insn;
#define FLD(f) abuf->fields.sfmt_ldq_indirect_index_disp.f
    UINT f_optdisp;
    UINT f_srcdst;
    UINT f_abase;
    UINT f_scale;
    UINT f_index;
    /* Contents of trailing part of insn.  */
    UINT word_1;

  word_1 = GETIMEMUSI (current_cpu, pc + 4);
    f_optdisp = (0|(EXTRACT_MSB0_UINT (word_1, 32, 0, 32) << 0));
    f_srcdst = EXTRACT_MSB0_UINT (insn, 32, 8, 5);
    f_abase = EXTRACT_MSB0_UINT (insn, 32, 13, 5);
    f_scale = EXTRACT_MSB0_UINT (insn, 32, 22, 3);
    f_index = EXTRACT_MSB0_UINT (insn, 32, 27, 5);

  /* Record the fields for the semantic handler.  */
  FLD (f_srcdst) = f_srcdst;
  FLD (f_optdisp) = f_optdisp;
  FLD (f_scale) = f_scale;
  FLD (i_abase) = & CPU (h_gr)[f_abase];
  FLD (i_index) = & CPU (h_gr)[f_index];
  FLD (i_dst) = & CPU (h_gr)[f_srcdst];
  TRACE_EXTRACT (current_cpu, abuf, (current_cpu, pc, "sfmt_ldl_indirect_index_disp", "f_srcdst 0x%x", 'x', f_srcdst, "f_optdisp 0x%x", 'x', f_optdisp, "f_scale 0x%x", 'x', f_scale, "abase 0x%x", 'x', f_abase, "index 0x%x", 'x', f_index, "dst 0x%x", 'x', f_srcdst, (char *) 0));

#if WITH_PROFILE_MODEL_P
  /* Record the fields for profiling.  */
  if (PROFILE_MODEL_P (current_cpu))
    {
      FLD (in_abase) = f_abase;
      FLD (in_index) = f_index;
      FLD (out_dst) = f_srcdst;
      FLD (out_h_gr_add__DFLT_index_of__DFLT_dst_1) = ((FLD (f_srcdst)) + (1));
    }
#endif
#undef FLD
    return idesc;
  }

 extract_sfmt_ldt_offset:
  {
    const IDESC *idesc = &i960base_insn_data[itype];
    CGEN_INSN_INT insn = base_insn;
#define FLD(f) abuf->fields.sfmt_ldq_indirect_offset.f
    UINT f_srcdst;
    UINT f_offset;

    f_srcdst = EXTRACT_MSB0_UINT (insn, 32, 8, 5);
    f_offset = EXTRACT_MSB0_UINT (insn, 32, 20, 12);

  /* Record the fields for the semantic handler.  */
  FLD (f_srcdst) = f_srcdst;
  FLD (f_offset) = f_offset;
  FLD (i_dst) = & CPU (h_gr)[f_srcdst];
  TRACE_EXTRACT (current_cpu, abuf, (current_cpu, pc, "sfmt_ldt_offset", "f_srcdst 0x%x", 'x', f_srcdst, "f_offset 0x%x", 'x', f_offset, "dst 0x%x", 'x', f_srcdst, (char *) 0));

#if WITH_PROFILE_MODEL_P
  /* Record the fields for profiling.  */
  if (PROFILE_MODEL_P (current_cpu))
    {
      FLD (out_dst) = f_srcdst;
      FLD (out_h_gr_add__DFLT_index_of__DFLT_dst_1) = ((FLD (f_srcdst)) + (1));
      FLD (out_h_gr_add__DFLT_index_of__DFLT_dst_2) = ((FLD (f_srcdst)) + (2));
    }
#endif
#undef FLD
    return idesc;
  }

 extract_sfmt_ldt_indirect_offset:
  {
    const IDESC *idesc = &i960base_insn_data[itype];
    CGEN_INSN_INT insn = base_insn;
#define FLD(f) abuf->fields.sfmt_ldq_indirect_offset.f
    UINT f_srcdst;
    UINT f_abase;
    UINT f_offset;

    f_srcdst = EXTRACT_MSB0_UINT (insn, 32, 8, 5);
    f_abase = EXTRACT_MSB0_UINT (insn, 32, 13, 5);
    f_offset = EXTRACT_MSB0_UINT (insn, 32, 20, 12);

  /* Record the fields for the semantic handler.  */
  FLD (f_srcdst) = f_srcdst;
  FLD (f_offset) = f_offset;
  FLD (i_abase) = & CPU (h_gr)[f_abase];
  FLD (i_dst) = & CPU (h_gr)[f_srcdst];
  TRACE_EXTRACT (current_cpu, abuf, (current_cpu, pc, "sfmt_ldt_indirect_offset", "f_srcdst 0x%x", 'x', f_srcdst, "f_offset 0x%x", 'x', f_offset, "abase 0x%x", 'x', f_abase, "dst 0x%x", 'x', f_srcdst, (char *) 0));

#if WITH_PROFILE_MODEL_P
  /* Record the fields for profiling.  */
  if (PROFILE_MODEL_P (current_cpu))
    {
      FLD (in_abase) = f_abase;
      FLD (out_dst) = f_srcdst;
      FLD (out_h_gr_add__DFLT_index_of__DFLT_dst_1) = ((FLD (f_srcdst)) + (1));
      FLD (out_h_gr_add__DFLT_index_of__DFLT_dst_2) = ((FLD (f_srcdst)) + (2));
    }
#endif
#undef FLD
    return idesc;
  }

 extract_sfmt_ldt_indirect:
  {
    const IDESC *idesc = &i960base_insn_data[itype];
    CGEN_INSN_INT insn = base_insn;
#define FLD(f) abuf->fields.sfmt_ldq_indirect_offset.f
    UINT f_srcdst;
    UINT f_abase;

    f_srcdst = EXTRACT_MSB0_UINT (insn, 32, 8, 5);
    f_abase = EXTRACT_MSB0_UINT (insn, 32, 13, 5);

  /* Record the fields for the semantic handler.  */
  FLD (f_srcdst) = f_srcdst;
  FLD (i_abase) = & CPU (h_gr)[f_abase];
  FLD (i_dst) = & CPU (h_gr)[f_srcdst];
  TRACE_EXTRACT (current_cpu, abuf, (current_cpu, pc, "sfmt_ldt_indirect", "f_srcdst 0x%x", 'x', f_srcdst, "abase 0x%x", 'x', f_abase, "dst 0x%x", 'x', f_srcdst, (char *) 0));

#if WITH_PROFILE_MODEL_P
  /* Record the fields for profiling.  */
  if (PROFILE_MODEL_P (current_cpu))
    {
      FLD (in_abase) = f_abase;
      FLD (out_dst) = f_srcdst;
      FLD (out_h_gr_add__DFLT_index_of__DFLT_dst_1) = ((FLD (f_srcdst)) + (1));
      FLD (out_h_gr_add__DFLT_index_of__DFLT_dst_2) = ((FLD (f_srcdst)) + (2));
    }
#endif
#undef FLD
    return idesc;
  }

 extract_sfmt_ldt_indirect_index:
  {
    const IDESC *idesc = &i960base_insn_data[itype];
    CGEN_INSN_INT insn = base_insn;
#define FLD(f) abuf->fields.sfmt_ldq_indirect_index_disp.f
    UINT f_srcdst;
    UINT f_abase;
    UINT f_scale;
    UINT f_index;

    f_srcdst = EXTRACT_MSB0_UINT (insn, 32, 8, 5);
    f_abase = EXTRACT_MSB0_UINT (insn, 32, 13, 5);
    f_scale = EXTRACT_MSB0_UINT (insn, 32, 22, 3);
    f_index = EXTRACT_MSB0_UINT (insn, 32, 27, 5);

  /* Record the fields for the semantic handler.  */
  FLD (f_srcdst) = f_srcdst;
  FLD (f_scale) = f_scale;
  FLD (i_abase) = & CPU (h_gr)[f_abase];
  FLD (i_index) = & CPU (h_gr)[f_index];
  FLD (i_dst) = & CPU (h_gr)[f_srcdst];
  TRACE_EXTRACT (current_cpu, abuf, (current_cpu, pc, "sfmt_ldt_indirect_index", "f_srcdst 0x%x", 'x', f_srcdst, "f_scale 0x%x", 'x', f_scale, "abase 0x%x", 'x', f_abase, "index 0x%x", 'x', f_index, "dst 0x%x", 'x', f_srcdst, (char *) 0));

#if WITH_PROFILE_MODEL_P
  /* Record the fields for profiling.  */
  if (PROFILE_MODEL_P (current_cpu))
    {
      FLD (in_abase) = f_abase;
      FLD (in_index) = f_index;
      FLD (out_dst) = f_srcdst;
      FLD (out_h_gr_add__DFLT_index_of__DFLT_dst_1) = ((FLD (f_srcdst)) + (1));
      FLD (out_h_gr_add__DFLT_index_of__DFLT_dst_2) = ((FLD (f_srcdst)) + (2));
    }
#endif
#undef FLD
    return idesc;
  }

 extract_sfmt_ldt_disp:
  {
    const IDESC *idesc = &i960base_insn_data[itype];
    CGEN_INSN_INT insn = base_insn;
#define FLD(f) abuf->fields.sfmt_ldq_indirect_index_disp.f
    UINT f_optdisp;
    UINT f_srcdst;
    /* Contents of trailing part of insn.  */
    UINT word_1;

  word_1 = GETIMEMUSI (current_cpu, pc + 4);
    f_optdisp = (0|(EXTRACT_MSB0_UINT (word_1, 32, 0, 32) << 0));
    f_srcdst = EXTRACT_MSB0_UINT (insn, 32, 8, 5);

  /* Record the fields for the semantic handler.  */
  FLD (f_srcdst) = f_srcdst;
  FLD (f_optdisp) = f_optdisp;
  FLD (i_dst) = & CPU (h_gr)[f_srcdst];
  TRACE_EXTRACT (current_cpu, abuf, (current_cpu, pc, "sfmt_ldt_disp", "f_srcdst 0x%x", 'x', f_srcdst, "f_optdisp 0x%x", 'x', f_optdisp, "dst 0x%x", 'x', f_srcdst, (char *) 0));

#if WITH_PROFILE_MODEL_P
  /* Record the fields for profiling.  */
  if (PROFILE_MODEL_P (current_cpu))
    {
      FLD (out_dst) = f_srcdst;
      FLD (out_h_gr_add__DFLT_index_of__DFLT_dst_1) = ((FLD (f_srcdst)) + (1));
      FLD (out_h_gr_add__DFLT_index_of__DFLT_dst_2) = ((FLD (f_srcdst)) + (2));
    }
#endif
#undef FLD
    return idesc;
  }

 extract_sfmt_ldt_indirect_disp:
  {
    const IDESC *idesc = &i960base_insn_data[itype];
    CGEN_INSN_INT insn = base_insn;
#define FLD(f) abuf->fields.sfmt_ldq_indirect_index_disp.f
    UINT f_optdisp;
    UINT f_srcdst;
    UINT f_abase;
    /* Contents of trailing part of insn.  */
    UINT word_1;

  word_1 = GETIMEMUSI (current_cpu, pc + 4);
    f_optdisp = (0|(EXTRACT_MSB0_UINT (word_1, 32, 0, 32) << 0));
    f_srcdst = EXTRACT_MSB0_UINT (insn, 32, 8, 5);
    f_abase = EXTRACT_MSB0_UINT (insn, 32, 13, 5);

  /* Record the fields for the semantic handler.  */
  FLD (f_srcdst) = f_srcdst;
  FLD (f_optdisp) = f_optdisp;
  FLD (i_abase) = & CPU (h_gr)[f_abase];
  FLD (i_dst) = & CPU (h_gr)[f_srcdst];
  TRACE_EXTRACT (current_cpu, abuf, (current_cpu, pc, "sfmt_ldt_indirect_disp", "f_srcdst 0x%x", 'x', f_srcdst, "f_optdisp 0x%x", 'x', f_optdisp, "abase 0x%x", 'x', f_abase, "dst 0x%x", 'x', f_srcdst, (char *) 0));

#if WITH_PROFILE_MODEL_P
  /* Record the fields for profiling.  */
  if (PROFILE_MODEL_P (current_cpu))
    {
      FLD (in_abase) = f_abase;
      FLD (out_dst) = f_srcdst;
      FLD (out_h_gr_add__DFLT_index_of__DFLT_dst_1) = ((FLD (f_srcdst)) + (1));
      FLD (out_h_gr_add__DFLT_index_of__DFLT_dst_2) = ((FLD (f_srcdst)) + (2));
    }
#endif
#undef FLD
    return idesc;
  }

 extract_sfmt_ldt_index_disp:
  {
    const IDESC *idesc = &i960base_insn_data[itype];
    CGEN_INSN_INT insn = base_insn;
#define FLD(f) abuf->fields.sfmt_ldq_indirect_index_disp.f
    UINT f_optdisp;
    UINT f_srcdst;
    UINT f_scale;
    UINT f_index;
    /* Contents of trailing part of insn.  */
    UINT word_1;

  word_1 = GETIMEMUSI (current_cpu, pc + 4);
    f_optdisp = (0|(EXTRACT_MSB0_UINT (word_1, 32, 0, 32) << 0));
    f_srcdst = EXTRACT_MSB0_UINT (insn, 32, 8, 5);
    f_scale = EXTRACT_MSB0_UINT (insn, 32, 22, 3);
    f_index = EXTRACT_MSB0_UINT (insn, 32, 27, 5);

  /* Record the fields for the semantic handler.  */
  FLD (f_srcdst) = f_srcdst;
  FLD (f_optdisp) = f_optdisp;
  FLD (f_scale) = f_scale;
  FLD (i_index) = & CPU (h_gr)[f_index];
  FLD (i_dst) = & CPU (h_gr)[f_srcdst];
  TRACE_EXTRACT (current_cpu, abuf, (current_cpu, pc, "sfmt_ldt_index_disp", "f_srcdst 0x%x", 'x', f_srcdst, "f_optdisp 0x%x", 'x', f_optdisp, "f_scale 0x%x", 'x', f_scale, "index 0x%x", 'x', f_index, "dst 0x%x", 'x', f_srcdst, (char *) 0));

#if WITH_PROFILE_MODEL_P
  /* Record the fields for profiling.  */
  if (PROFILE_MODEL_P (current_cpu))
    {
      FLD (in_index) = f_index;
      FLD (out_dst) = f_srcdst;
      FLD (out_h_gr_add__DFLT_index_of__DFLT_dst_1) = ((FLD (f_srcdst)) + (1));
      FLD (out_h_gr_add__DFLT_index_of__DFLT_dst_2) = ((FLD (f_srcdst)) + (2));
    }
#endif
#undef FLD
    return idesc;
  }

 extract_sfmt_ldt_indirect_index_disp:
  {
    const IDESC *idesc = &i960base_insn_data[itype];
    CGEN_INSN_INT insn = base_insn;
#define FLD(f) abuf->fields.sfmt_ldq_indirect_index_disp.f
    UINT f_optdisp;
    UINT f_srcdst;
    UINT f_abase;
    UINT f_scale;
    UINT f_index;
    /* Contents of trailing part of insn.  */
    UINT word_1;

  word_1 = GETIMEMUSI (current_cpu, pc + 4);
    f_optdisp = (0|(EXTRACT_MSB0_UINT (word_1, 32, 0, 32) << 0));
    f_srcdst = EXTRACT_MSB0_UINT (insn, 32, 8, 5);
    f_abase = EXTRACT_MSB0_UINT (insn, 32, 13, 5);
    f_scale = EXTRACT_MSB0_UINT (insn, 32, 22, 3);
    f_index = EXTRACT_MSB0_UINT (insn, 32, 27, 5);

  /* Record the fields for the semantic handler.  */
  FLD (f_srcdst) = f_srcdst;
  FLD (f_optdisp) = f_optdisp;
  FLD (f_scale) = f_scale;
  FLD (i_abase) = & CPU (h_gr)[f_abase];
  FLD (i_index) = & CPU (h_gr)[f_index];
  FLD (i_dst) = & CPU (h_gr)[f_srcdst];
  TRACE_EXTRACT (current_cpu, abuf, (current_cpu, pc, "sfmt_ldt_indirect_index_disp", "f_srcdst 0x%x", 'x', f_srcdst, "f_optdisp 0x%x", 'x', f_optdisp, "f_scale 0x%x", 'x', f_scale, "abase 0x%x", 'x', f_abase, "index 0x%x", 'x', f_index, "dst 0x%x", 'x', f_srcdst, (char *) 0));

#if WITH_PROFILE_MODEL_P
  /* Record the fields for profiling.  */
  if (PROFILE_MODEL_P (current_cpu))
    {
      FLD (in_abase) = f_abase;
      FLD (in_index) = f_index;
      FLD (out_dst) = f_srcdst;
      FLD (out_h_gr_add__DFLT_index_of__DFLT_dst_1) = ((FLD (f_srcdst)) + (1));
      FLD (out_h_gr_add__DFLT_index_of__DFLT_dst_2) = ((FLD (f_srcdst)) + (2));
    }
#endif
#undef FLD
    return idesc;
  }

 extract_sfmt_ldq_offset:
  {
    const IDESC *idesc = &i960base_insn_data[itype];
    CGEN_INSN_INT insn = base_insn;
#define FLD(f) abuf->fields.sfmt_ldq_indirect_offset.f
    UINT f_srcdst;
    UINT f_offset;

    f_srcdst = EXTRACT_MSB0_UINT (insn, 32, 8, 5);
    f_offset = EXTRACT_MSB0_UINT (insn, 32, 20, 12);

  /* Record the fields for the semantic handler.  */
  FLD (f_srcdst) = f_srcdst;
  FLD (f_offset) = f_offset;
  FLD (i_dst) = & CPU (h_gr)[f_srcdst];
  TRACE_EXTRACT (current_cpu, abuf, (current_cpu, pc, "sfmt_ldq_offset", "f_srcdst 0x%x", 'x', f_srcdst, "f_offset 0x%x", 'x', f_offset, "dst 0x%x", 'x', f_srcdst, (char *) 0));

#if WITH_PROFILE_MODEL_P
  /* Record the fields for profiling.  */
  if (PROFILE_MODEL_P (current_cpu))
    {
      FLD (out_dst) = f_srcdst;
      FLD (out_h_gr_add__DFLT_index_of__DFLT_dst_1) = ((FLD (f_srcdst)) + (1));
      FLD (out_h_gr_add__DFLT_index_of__DFLT_dst_2) = ((FLD (f_srcdst)) + (2));
      FLD (out_h_gr_add__DFLT_index_of__DFLT_dst_3) = ((FLD (f_srcdst)) + (3));
    }
#endif
#undef FLD
    return idesc;
  }

 extract_sfmt_ldq_indirect_offset:
  {
    const IDESC *idesc = &i960base_insn_data[itype];
    CGEN_INSN_INT insn = base_insn;
#define FLD(f) abuf->fields.sfmt_ldq_indirect_offset.f
    UINT f_srcdst;
    UINT f_abase;
    UINT f_offset;

    f_srcdst = EXTRACT_MSB0_UINT (insn, 32, 8, 5);
    f_abase = EXTRACT_MSB0_UINT (insn, 32, 13, 5);
    f_offset = EXTRACT_MSB0_UINT (insn, 32, 20, 12);

  /* Record the fields for the semantic handler.  */
  FLD (f_srcdst) = f_srcdst;
  FLD (f_offset) = f_offset;
  FLD (i_abase) = & CPU (h_gr)[f_abase];
  FLD (i_dst) = & CPU (h_gr)[f_srcdst];
  TRACE_EXTRACT (current_cpu, abuf, (current_cpu, pc, "sfmt_ldq_indirect_offset", "f_srcdst 0x%x", 'x', f_srcdst, "f_offset 0x%x", 'x', f_offset, "abase 0x%x", 'x', f_abase, "dst 0x%x", 'x', f_srcdst, (char *) 0));

#if WITH_PROFILE_MODEL_P
  /* Record the fields for profiling.  */
  if (PROFILE_MODEL_P (current_cpu))
    {
      FLD (in_abase) = f_abase;
      FLD (out_dst) = f_srcdst;
      FLD (out_h_gr_add__DFLT_index_of__DFLT_dst_1) = ((FLD (f_srcdst)) + (1));
      FLD (out_h_gr_add__DFLT_index_of__DFLT_dst_2) = ((FLD (f_srcdst)) + (2));
      FLD (out_h_gr_add__DFLT_index_of__DFLT_dst_3) = ((FLD (f_srcdst)) + (3));
    }
#endif
#undef FLD
    return idesc;
  }

 extract_sfmt_ldq_indirect:
  {
    const IDESC *idesc = &i960base_insn_data[itype];
    CGEN_INSN_INT insn = base_insn;
#define FLD(f) abuf->fields.sfmt_ldq_indirect_offset.f
    UINT f_srcdst;
    UINT f_abase;

    f_srcdst = EXTRACT_MSB0_UINT (insn, 32, 8, 5);
    f_abase = EXTRACT_MSB0_UINT (insn, 32, 13, 5);

  /* Record the fields for the semantic handler.  */
  FLD (f_srcdst) = f_srcdst;
  FLD (i_abase) = & CPU (h_gr)[f_abase];
  FLD (i_dst) = & CPU (h_gr)[f_srcdst];
  TRACE_EXTRACT (current_cpu, abuf, (current_cpu, pc, "sfmt_ldq_indirect", "f_srcdst 0x%x", 'x', f_srcdst, "abase 0x%x", 'x', f_abase, "dst 0x%x", 'x', f_srcdst, (char *) 0));

#if WITH_PROFILE_MODEL_P
  /* Record the fields for profiling.  */
  if (PROFILE_MODEL_P (current_cpu))
    {
      FLD (in_abase) = f_abase;
      FLD (out_dst) = f_srcdst;
      FLD (out_h_gr_add__DFLT_index_of__DFLT_dst_1) = ((FLD (f_srcdst)) + (1));
      FLD (out_h_gr_add__DFLT_index_of__DFLT_dst_2) = ((FLD (f_srcdst)) + (2));
      FLD (out_h_gr_add__DFLT_index_of__DFLT_dst_3) = ((FLD (f_srcdst)) + (3));
    }
#endif
#undef FLD
    return idesc;
  }

 extract_sfmt_ldq_indirect_index:
  {
    const IDESC *idesc = &i960base_insn_data[itype];
    CGEN_INSN_INT insn = base_insn;
#define FLD(f) abuf->fields.sfmt_ldq_indirect_index_disp.f
    UINT f_srcdst;
    UINT f_abase;
    UINT f_scale;
    UINT f_index;

    f_srcdst = EXTRACT_MSB0_UINT (insn, 32, 8, 5);
    f_abase = EXTRACT_MSB0_UINT (insn, 32, 13, 5);
    f_scale = EXTRACT_MSB0_UINT (insn, 32, 22, 3);
    f_index = EXTRACT_MSB0_UINT (insn, 32, 27, 5);

  /* Record the fields for the semantic handler.  */
  FLD (f_srcdst) = f_srcdst;
  FLD (f_scale) = f_scale;
  FLD (i_abase) = & CPU (h_gr)[f_abase];
  FLD (i_index) = & CPU (h_gr)[f_index];
  FLD (i_dst) = & CPU (h_gr)[f_srcdst];
  TRACE_EXTRACT (current_cpu, abuf, (current_cpu, pc, "sfmt_ldq_indirect_index", "f_srcdst 0x%x", 'x', f_srcdst, "f_scale 0x%x", 'x', f_scale, "abase 0x%x", 'x', f_abase, "index 0x%x", 'x', f_index, "dst 0x%x", 'x', f_srcdst, (char *) 0));

#if WITH_PROFILE_MODEL_P
  /* Record the fields for profiling.  */
  if (PROFILE_MODEL_P (current_cpu))
    {
      FLD (in_abase) = f_abase;
      FLD (in_index) = f_index;
      FLD (out_dst) = f_srcdst;
      FLD (out_h_gr_add__DFLT_index_of__DFLT_dst_1) = ((FLD (f_srcdst)) + (1));
      FLD (out_h_gr_add__DFLT_index_of__DFLT_dst_2) = ((FLD (f_srcdst)) + (2));
      FLD (out_h_gr_add__DFLT_index_of__DFLT_dst_3) = ((FLD (f_srcdst)) + (3));
    }
#endif
#undef FLD
    return idesc;
  }

 extract_sfmt_ldq_disp:
  {
    const IDESC *idesc = &i960base_insn_data[itype];
    CGEN_INSN_INT insn = base_insn;
#define FLD(f) abuf->fields.sfmt_ldq_indirect_index_disp.f
    UINT f_optdisp;
    UINT f_srcdst;
    /* Contents of trailing part of insn.  */
    UINT word_1;

  word_1 = GETIMEMUSI (current_cpu, pc + 4);
    f_optdisp = (0|(EXTRACT_MSB0_UINT (word_1, 32, 0, 32) << 0));
    f_srcdst = EXTRACT_MSB0_UINT (insn, 32, 8, 5);

  /* Record the fields for the semantic handler.  */
  FLD (f_srcdst) = f_srcdst;
  FLD (f_optdisp) = f_optdisp;
  FLD (i_dst) = & CPU (h_gr)[f_srcdst];
  TRACE_EXTRACT (current_cpu, abuf, (current_cpu, pc, "sfmt_ldq_disp", "f_srcdst 0x%x", 'x', f_srcdst, "f_optdisp 0x%x", 'x', f_optdisp, "dst 0x%x", 'x', f_srcdst, (char *) 0));

#if WITH_PROFILE_MODEL_P
  /* Record the fields for profiling.  */
  if (PROFILE_MODEL_P (current_cpu))
    {
      FLD (out_dst) = f_srcdst;
      FLD (out_h_gr_add__DFLT_index_of__DFLT_dst_1) = ((FLD (f_srcdst)) + (1));
      FLD (out_h_gr_add__DFLT_index_of__DFLT_dst_2) = ((FLD (f_srcdst)) + (2));
      FLD (out_h_gr_add__DFLT_index_of__DFLT_dst_3) = ((FLD (f_srcdst)) + (3));
    }
#endif
#undef FLD
    return idesc;
  }

 extract_sfmt_ldq_indirect_disp:
  {
    const IDESC *idesc = &i960base_insn_data[itype];
    CGEN_INSN_INT insn = base_insn;
#define FLD(f) abuf->fields.sfmt_ldq_indirect_index_disp.f
    UINT f_optdisp;
    UINT f_srcdst;
    UINT f_abase;
    /* Contents of trailing part of insn.  */
    UINT word_1;

  word_1 = GETIMEMUSI (current_cpu, pc + 4);
    f_optdisp = (0|(EXTRACT_MSB0_UINT (word_1, 32, 0, 32) << 0));
    f_srcdst = EXTRACT_MSB0_UINT (insn, 32, 8, 5);
    f_abase = EXTRACT_MSB0_UINT (insn, 32, 13, 5);

  /* Record the fields for the semantic handler.  */
  FLD (f_srcdst) = f_srcdst;
  FLD (f_optdisp) = f_optdisp;
  FLD (i_abase) = & CPU (h_gr)[f_abase];
  FLD (i_dst) = & CPU (h_gr)[f_srcdst];
  TRACE_EXTRACT (current_cpu, abuf, (current_cpu, pc, "sfmt_ldq_indirect_disp", "f_srcdst 0x%x", 'x', f_srcdst, "f_optdisp 0x%x", 'x', f_optdisp, "abase 0x%x", 'x', f_abase, "dst 0x%x", 'x', f_srcdst, (char *) 0));

#if WITH_PROFILE_MODEL_P
  /* Record the fields for profiling.  */
  if (PROFILE_MODEL_P (current_cpu))
    {
      FLD (in_abase) = f_abase;
      FLD (out_dst) = f_srcdst;
      FLD (out_h_gr_add__DFLT_index_of__DFLT_dst_1) = ((FLD (f_srcdst)) + (1));
      FLD (out_h_gr_add__DFLT_index_of__DFLT_dst_2) = ((FLD (f_srcdst)) + (2));
      FLD (out_h_gr_add__DFLT_index_of__DFLT_dst_3) = ((FLD (f_srcdst)) + (3));
    }
#endif
#undef FLD
    return idesc;
  }

 extract_sfmt_ldq_index_disp:
  {
    const IDESC *idesc = &i960base_insn_data[itype];
    CGEN_INSN_INT insn = base_insn;
#define FLD(f) abuf->fields.sfmt_ldq_indirect_index_disp.f
    UINT f_optdisp;
    UINT f_srcdst;
    UINT f_scale;
    UINT f_index;
    /* Contents of trailing part of insn.  */
    UINT word_1;

  word_1 = GETIMEMUSI (current_cpu, pc + 4);
    f_optdisp = (0|(EXTRACT_MSB0_UINT (word_1, 32, 0, 32) << 0));
    f_srcdst = EXTRACT_MSB0_UINT (insn, 32, 8, 5);
    f_scale = EXTRACT_MSB0_UINT (insn, 32, 22, 3);
    f_index = EXTRACT_MSB0_UINT (insn, 32, 27, 5);

  /* Record the fields for the semantic handler.  */
  FLD (f_srcdst) = f_srcdst;
  FLD (f_optdisp) = f_optdisp;
  FLD (f_scale) = f_scale;
  FLD (i_index) = & CPU (h_gr)[f_index];
  FLD (i_dst) = & CPU (h_gr)[f_srcdst];
  TRACE_EXTRACT (current_cpu, abuf, (current_cpu, pc, "sfmt_ldq_index_disp", "f_srcdst 0x%x", 'x', f_srcdst, "f_optdisp 0x%x", 'x', f_optdisp, "f_scale 0x%x", 'x', f_scale, "index 0x%x", 'x', f_index, "dst 0x%x", 'x', f_srcdst, (char *) 0));

#if WITH_PROFILE_MODEL_P
  /* Record the fields for profiling.  */
  if (PROFILE_MODEL_P (current_cpu))
    {
      FLD (in_index) = f_index;
      FLD (out_dst) = f_srcdst;
      FLD (out_h_gr_add__DFLT_index_of__DFLT_dst_1) = ((FLD (f_srcdst)) + (1));
      FLD (out_h_gr_add__DFLT_index_of__DFLT_dst_2) = ((FLD (f_srcdst)) + (2));
      FLD (out_h_gr_add__DFLT_index_of__DFLT_dst_3) = ((FLD (f_srcdst)) + (3));
    }
#endif
#undef FLD
    return idesc;
  }

 extract_sfmt_ldq_indirect_index_disp:
  {
    const IDESC *idesc = &i960base_insn_data[itype];
    CGEN_INSN_INT insn = base_insn;
#define FLD(f) abuf->fields.sfmt_ldq_indirect_index_disp.f
    UINT f_optdisp;
    UINT f_srcdst;
    UINT f_abase;
    UINT f_scale;
    UINT f_index;
    /* Contents of trailing part of insn.  */
    UINT word_1;

  word_1 = GETIMEMUSI (current_cpu, pc + 4);
    f_optdisp = (0|(EXTRACT_MSB0_UINT (word_1, 32, 0, 32) << 0));
    f_srcdst = EXTRACT_MSB0_UINT (insn, 32, 8, 5);
    f_abase = EXTRACT_MSB0_UINT (insn, 32, 13, 5);
    f_scale = EXTRACT_MSB0_UINT (insn, 32, 22, 3);
    f_index = EXTRACT_MSB0_UINT (insn, 32, 27, 5);

  /* Record the fields for the semantic handler.  */
  FLD (f_srcdst) = f_srcdst;
  FLD (f_optdisp) = f_optdisp;
  FLD (f_scale) = f_scale;
  FLD (i_abase) = & CPU (h_gr)[f_abase];
  FLD (i_index) = & CPU (h_gr)[f_index];
  FLD (i_dst) = & CPU (h_gr)[f_srcdst];
  TRACE_EXTRACT (current_cpu, abuf, (current_cpu, pc, "sfmt_ldq_indirect_index_disp", "f_srcdst 0x%x", 'x', f_srcdst, "f_optdisp 0x%x", 'x', f_optdisp, "f_scale 0x%x", 'x', f_scale, "abase 0x%x", 'x', f_abase, "index 0x%x", 'x', f_index, "dst 0x%x", 'x', f_srcdst, (char *) 0));

#if WITH_PROFILE_MODEL_P
  /* Record the fields for profiling.  */
  if (PROFILE_MODEL_P (current_cpu))
    {
      FLD (in_abase) = f_abase;
      FLD (in_index) = f_index;
      FLD (out_dst) = f_srcdst;
      FLD (out_h_gr_add__DFLT_index_of__DFLT_dst_1) = ((FLD (f_srcdst)) + (1));
      FLD (out_h_gr_add__DFLT_index_of__DFLT_dst_2) = ((FLD (f_srcdst)) + (2));
      FLD (out_h_gr_add__DFLT_index_of__DFLT_dst_3) = ((FLD (f_srcdst)) + (3));
    }
#endif
#undef FLD
    return idesc;
  }

 extract_sfmt_st_offset:
  {
    const IDESC *idesc = &i960base_insn_data[itype];
    CGEN_INSN_INT insn = base_insn;
#define FLD(f) abuf->fields.sfmt_stq_indirect_offset.f
    UINT f_srcdst;
    UINT f_offset;

    f_srcdst = EXTRACT_MSB0_UINT (insn, 32, 8, 5);
    f_offset = EXTRACT_MSB0_UINT (insn, 32, 20, 12);

  /* Record the fields for the semantic handler.  */
  FLD (f_offset) = f_offset;
  FLD (i_st_src) = & CPU (h_gr)[f_srcdst];
  TRACE_EXTRACT (current_cpu, abuf, (current_cpu, pc, "sfmt_st_offset", "f_offset 0x%x", 'x', f_offset, "st_src 0x%x", 'x', f_srcdst, (char *) 0));

#if WITH_PROFILE_MODEL_P
  /* Record the fields for profiling.  */
  if (PROFILE_MODEL_P (current_cpu))
    {
      FLD (in_st_src) = f_srcdst;
    }
#endif
#undef FLD
    return idesc;
  }

 extract_sfmt_st_indirect_offset:
  {
    const IDESC *idesc = &i960base_insn_data[itype];
    CGEN_INSN_INT insn = base_insn;
#define FLD(f) abuf->fields.sfmt_stq_indirect_offset.f
    UINT f_srcdst;
    UINT f_abase;
    UINT f_offset;

    f_srcdst = EXTRACT_MSB0_UINT (insn, 32, 8, 5);
    f_abase = EXTRACT_MSB0_UINT (insn, 32, 13, 5);
    f_offset = EXTRACT_MSB0_UINT (insn, 32, 20, 12);

  /* Record the fields for the semantic handler.  */
  FLD (f_offset) = f_offset;
  FLD (i_abase) = & CPU (h_gr)[f_abase];
  FLD (i_st_src) = & CPU (h_gr)[f_srcdst];
  TRACE_EXTRACT (current_cpu, abuf, (current_cpu, pc, "sfmt_st_indirect_offset", "f_offset 0x%x", 'x', f_offset, "abase 0x%x", 'x', f_abase, "st_src 0x%x", 'x', f_srcdst, (char *) 0));

#if WITH_PROFILE_MODEL_P
  /* Record the fields for profiling.  */
  if (PROFILE_MODEL_P (current_cpu))
    {
      FLD (in_abase) = f_abase;
      FLD (in_st_src) = f_srcdst;
    }
#endif
#undef FLD
    return idesc;
  }

 extract_sfmt_st_indirect:
  {
    const IDESC *idesc = &i960base_insn_data[itype];
    CGEN_INSN_INT insn = base_insn;
#define FLD(f) abuf->fields.sfmt_stq_indirect_offset.f
    UINT f_srcdst;
    UINT f_abase;

    f_srcdst = EXTRACT_MSB0_UINT (insn, 32, 8, 5);
    f_abase = EXTRACT_MSB0_UINT (insn, 32, 13, 5);

  /* Record the fields for the semantic handler.  */
  FLD (i_abase) = & CPU (h_gr)[f_abase];
  FLD (i_st_src) = & CPU (h_gr)[f_srcdst];
  TRACE_EXTRACT (current_cpu, abuf, (current_cpu, pc, "sfmt_st_indirect", "abase 0x%x", 'x', f_abase, "st_src 0x%x", 'x', f_srcdst, (char *) 0));

#if WITH_PROFILE_MODEL_P
  /* Record the fields for profiling.  */
  if (PROFILE_MODEL_P (current_cpu))
    {
      FLD (in_abase) = f_abase;
      FLD (in_st_src) = f_srcdst;
    }
#endif
#undef FLD
    return idesc;
  }

 extract_sfmt_st_indirect_index:
  {
    const IDESC *idesc = &i960base_insn_data[itype];
    CGEN_INSN_INT insn = base_insn;
#define FLD(f) abuf->fields.sfmt_stq_indirect_index_disp.f
    UINT f_srcdst;
    UINT f_abase;
    UINT f_scale;
    UINT f_index;

    f_srcdst = EXTRACT_MSB0_UINT (insn, 32, 8, 5);
    f_abase = EXTRACT_MSB0_UINT (insn, 32, 13, 5);
    f_scale = EXTRACT_MSB0_UINT (insn, 32, 22, 3);
    f_index = EXTRACT_MSB0_UINT (insn, 32, 27, 5);

  /* Record the fields for the semantic handler.  */
  FLD (f_scale) = f_scale;
  FLD (i_abase) = & CPU (h_gr)[f_abase];
  FLD (i_index) = & CPU (h_gr)[f_index];
  FLD (i_st_src) = & CPU (h_gr)[f_srcdst];
  TRACE_EXTRACT (current_cpu, abuf, (current_cpu, pc, "sfmt_st_indirect_index", "f_scale 0x%x", 'x', f_scale, "abase 0x%x", 'x', f_abase, "index 0x%x", 'x', f_index, "st_src 0x%x", 'x', f_srcdst, (char *) 0));

#if WITH_PROFILE_MODEL_P
  /* Record the fields for profiling.  */
  if (PROFILE_MODEL_P (current_cpu))
    {
      FLD (in_abase) = f_abase;
      FLD (in_index) = f_index;
      FLD (in_st_src) = f_srcdst;
    }
#endif
#undef FLD
    return idesc;
  }

 extract_sfmt_st_disp:
  {
    const IDESC *idesc = &i960base_insn_data[itype];
    CGEN_INSN_INT insn = base_insn;
#define FLD(f) abuf->fields.sfmt_stq_indirect_index_disp.f
    UINT f_optdisp;
    UINT f_srcdst;
    /* Contents of trailing part of insn.  */
    UINT word_1;

  word_1 = GETIMEMUSI (current_cpu, pc + 4);
    f_optdisp = (0|(EXTRACT_MSB0_UINT (word_1, 32, 0, 32) << 0));
    f_srcdst = EXTRACT_MSB0_UINT (insn, 32, 8, 5);

  /* Record the fields for the semantic handler.  */
  FLD (f_optdisp) = f_optdisp;
  FLD (i_st_src) = & CPU (h_gr)[f_srcdst];
  TRACE_EXTRACT (current_cpu, abuf, (current_cpu, pc, "sfmt_st_disp", "f_optdisp 0x%x", 'x', f_optdisp, "st_src 0x%x", 'x', f_srcdst, (char *) 0));

#if WITH_PROFILE_MODEL_P
  /* Record the fields for profiling.  */
  if (PROFILE_MODEL_P (current_cpu))
    {
      FLD (in_st_src) = f_srcdst;
    }
#endif
#undef FLD
    return idesc;
  }

 extract_sfmt_st_indirect_disp:
  {
    const IDESC *idesc = &i960base_insn_data[itype];
    CGEN_INSN_INT insn = base_insn;
#define FLD(f) abuf->fields.sfmt_stq_indirect_index_disp.f
    UINT f_optdisp;
    UINT f_srcdst;
    UINT f_abase;
    /* Contents of trailing part of insn.  */
    UINT word_1;

  word_1 = GETIMEMUSI (current_cpu, pc + 4);
    f_optdisp = (0|(EXTRACT_MSB0_UINT (word_1, 32, 0, 32) << 0));
    f_srcdst = EXTRACT_MSB0_UINT (insn, 32, 8, 5);
    f_abase = EXTRACT_MSB0_UINT (insn, 32, 13, 5);

  /* Record the fields for the semantic handler.  */
  FLD (f_optdisp) = f_optdisp;
  FLD (i_abase) = & CPU (h_gr)[f_abase];
  FLD (i_st_src) = & CPU (h_gr)[f_srcdst];
  TRACE_EXTRACT (current_cpu, abuf, (current_cpu, pc, "sfmt_st_indirect_disp", "f_optdisp 0x%x", 'x', f_optdisp, "abase 0x%x", 'x', f_abase, "st_src 0x%x", 'x', f_srcdst, (char *) 0));

#if WITH_PROFILE_MODEL_P
  /* Record the fields for profiling.  */
  if (PROFILE_MODEL_P (current_cpu))
    {
      FLD (in_abase) = f_abase;
      FLD (in_st_src) = f_srcdst;
    }
#endif
#undef FLD
    return idesc;
  }

 extract_sfmt_st_index_disp:
  {
    const IDESC *idesc = &i960base_insn_data[itype];
    CGEN_INSN_INT insn = base_insn;
#define FLD(f) abuf->fields.sfmt_stq_indirect_index_disp.f
    UINT f_optdisp;
    UINT f_srcdst;
    UINT f_scale;
    UINT f_index;
    /* Contents of trailing part of insn.  */
    UINT word_1;

  word_1 = GETIMEMUSI (current_cpu, pc + 4);
    f_optdisp = (0|(EXTRACT_MSB0_UINT (word_1, 32, 0, 32) << 0));
    f_srcdst = EXTRACT_MSB0_UINT (insn, 32, 8, 5);
    f_scale = EXTRACT_MSB0_UINT (insn, 32, 22, 3);
    f_index = EXTRACT_MSB0_UINT (insn, 32, 27, 5);

  /* Record the fields for the semantic handler.  */
  FLD (f_optdisp) = f_optdisp;
  FLD (f_scale) = f_scale;
  FLD (i_index) = & CPU (h_gr)[f_index];
  FLD (i_st_src) = & CPU (h_gr)[f_srcdst];
  TRACE_EXTRACT (current_cpu, abuf, (current_cpu, pc, "sfmt_st_index_disp", "f_optdisp 0x%x", 'x', f_optdisp, "f_scale 0x%x", 'x', f_scale, "index 0x%x", 'x', f_index, "st_src 0x%x", 'x', f_srcdst, (char *) 0));

#if WITH_PROFILE_MODEL_P
  /* Record the fields for profiling.  */
  if (PROFILE_MODEL_P (current_cpu))
    {
      FLD (in_index) = f_index;
      FLD (in_st_src) = f_srcdst;
    }
#endif
#undef FLD
    return idesc;
  }

 extract_sfmt_st_indirect_index_disp:
  {
    const IDESC *idesc = &i960base_insn_data[itype];
    CGEN_INSN_INT insn = base_insn;
#define FLD(f) abuf->fields.sfmt_stq_indirect_index_disp.f
    UINT f_optdisp;
    UINT f_srcdst;
    UINT f_abase;
    UINT f_scale;
    UINT f_index;
    /* Contents of trailing part of insn.  */
    UINT word_1;

  word_1 = GETIMEMUSI (current_cpu, pc + 4);
    f_optdisp = (0|(EXTRACT_MSB0_UINT (word_1, 32, 0, 32) << 0));
    f_srcdst = EXTRACT_MSB0_UINT (insn, 32, 8, 5);
    f_abase = EXTRACT_MSB0_UINT (insn, 32, 13, 5);
    f_scale = EXTRACT_MSB0_UINT (insn, 32, 22, 3);
    f_index = EXTRACT_MSB0_UINT (insn, 32, 27, 5);

  /* Record the fields for the semantic handler.  */
  FLD (f_optdisp) = f_optdisp;
  FLD (f_scale) = f_scale;
  FLD (i_abase) = & CPU (h_gr)[f_abase];
  FLD (i_index) = & CPU (h_gr)[f_index];
  FLD (i_st_src) = & CPU (h_gr)[f_srcdst];
  TRACE_EXTRACT (current_cpu, abuf, (current_cpu, pc, "sfmt_st_indirect_index_disp", "f_optdisp 0x%x", 'x', f_optdisp, "f_scale 0x%x", 'x', f_scale, "abase 0x%x", 'x', f_abase, "index 0x%x", 'x', f_index, "st_src 0x%x", 'x', f_srcdst, (char *) 0));

#if WITH_PROFILE_MODEL_P
  /* Record the fields for profiling.  */
  if (PROFILE_MODEL_P (current_cpu))
    {
      FLD (in_abase) = f_abase;
      FLD (in_index) = f_index;
      FLD (in_st_src) = f_srcdst;
    }
#endif
#undef FLD
    return idesc;
  }

 extract_sfmt_stl_offset:
  {
    const IDESC *idesc = &i960base_insn_data[itype];
    CGEN_INSN_INT insn = base_insn;
#define FLD(f) abuf->fields.sfmt_stq_indirect_offset.f
    UINT f_srcdst;
    UINT f_offset;

    f_srcdst = EXTRACT_MSB0_UINT (insn, 32, 8, 5);
    f_offset = EXTRACT_MSB0_UINT (insn, 32, 20, 12);

  /* Record the fields for the semantic handler.  */
  FLD (f_srcdst) = f_srcdst;
  FLD (f_offset) = f_offset;
  FLD (i_st_src) = & CPU (h_gr)[f_srcdst];
  TRACE_EXTRACT (current_cpu, abuf, (current_cpu, pc, "sfmt_stl_offset", "f_srcdst 0x%x", 'x', f_srcdst, "f_offset 0x%x", 'x', f_offset, "st_src 0x%x", 'x', f_srcdst, (char *) 0));

#if WITH_PROFILE_MODEL_P
  /* Record the fields for profiling.  */
  if (PROFILE_MODEL_P (current_cpu))
    {
      FLD (in_h_gr_add__DFLT_index_of__DFLT_st_src_1) = ((FLD (f_srcdst)) + (1));
      FLD (in_st_src) = f_srcdst;
    }
#endif
#undef FLD
    return idesc;
  }

 extract_sfmt_stl_indirect_offset:
  {
    const IDESC *idesc = &i960base_insn_data[itype];
    CGEN_INSN_INT insn = base_insn;
#define FLD(f) abuf->fields.sfmt_stq_indirect_offset.f
    UINT f_srcdst;
    UINT f_abase;
    UINT f_offset;

    f_srcdst = EXTRACT_MSB0_UINT (insn, 32, 8, 5);
    f_abase = EXTRACT_MSB0_UINT (insn, 32, 13, 5);
    f_offset = EXTRACT_MSB0_UINT (insn, 32, 20, 12);

  /* Record the fields for the semantic handler.  */
  FLD (f_srcdst) = f_srcdst;
  FLD (f_offset) = f_offset;
  FLD (i_abase) = & CPU (h_gr)[f_abase];
  FLD (i_st_src) = & CPU (h_gr)[f_srcdst];
  TRACE_EXTRACT (current_cpu, abuf, (current_cpu, pc, "sfmt_stl_indirect_offset", "f_srcdst 0x%x", 'x', f_srcdst, "f_offset 0x%x", 'x', f_offset, "abase 0x%x", 'x', f_abase, "st_src 0x%x", 'x', f_srcdst, (char *) 0));

#if WITH_PROFILE_MODEL_P
  /* Record the fields for profiling.  */
  if (PROFILE_MODEL_P (current_cpu))
    {
      FLD (in_abase) = f_abase;
      FLD (in_h_gr_add__DFLT_index_of__DFLT_st_src_1) = ((FLD (f_srcdst)) + (1));
      FLD (in_st_src) = f_srcdst;
    }
#endif
#undef FLD
    return idesc;
  }

 extract_sfmt_stl_indirect:
  {
    const IDESC *idesc = &i960base_insn_data[itype];
    CGEN_INSN_INT insn = base_insn;
#define FLD(f) abuf->fields.sfmt_stq_indirect_offset.f
    UINT f_srcdst;
    UINT f_abase;

    f_srcdst = EXTRACT_MSB0_UINT (insn, 32, 8, 5);
    f_abase = EXTRACT_MSB0_UINT (insn, 32, 13, 5);

  /* Record the fields for the semantic handler.  */
  FLD (f_srcdst) = f_srcdst;
  FLD (i_abase) = & CPU (h_gr)[f_abase];
  FLD (i_st_src) = & CPU (h_gr)[f_srcdst];
  TRACE_EXTRACT (current_cpu, abuf, (current_cpu, pc, "sfmt_stl_indirect", "f_srcdst 0x%x", 'x', f_srcdst, "abase 0x%x", 'x', f_abase, "st_src 0x%x", 'x', f_srcdst, (char *) 0));

#if WITH_PROFILE_MODEL_P
  /* Record the fields for profiling.  */
  if (PROFILE_MODEL_P (current_cpu))
    {
      FLD (in_abase) = f_abase;
      FLD (in_h_gr_add__DFLT_index_of__DFLT_st_src_1) = ((FLD (f_srcdst)) + (1));
      FLD (in_st_src) = f_srcdst;
    }
#endif
#undef FLD
    return idesc;
  }

 extract_sfmt_stl_indirect_index:
  {
    const IDESC *idesc = &i960base_insn_data[itype];
    CGEN_INSN_INT insn = base_insn;
#define FLD(f) abuf->fields.sfmt_stq_indirect_index_disp.f
    UINT f_srcdst;
    UINT f_abase;
    UINT f_scale;
    UINT f_index;

    f_srcdst = EXTRACT_MSB0_UINT (insn, 32, 8, 5);
    f_abase = EXTRACT_MSB0_UINT (insn, 32, 13, 5);
    f_scale = EXTRACT_MSB0_UINT (insn, 32, 22, 3);
    f_index = EXTRACT_MSB0_UINT (insn, 32, 27, 5);

  /* Record the fields for the semantic handler.  */
  FLD (f_srcdst) = f_srcdst;
  FLD (f_scale) = f_scale;
  FLD (i_abase) = & CPU (h_gr)[f_abase];
  FLD (i_index) = & CPU (h_gr)[f_index];
  FLD (i_st_src) = & CPU (h_gr)[f_srcdst];
  TRACE_EXTRACT (current_cpu, abuf, (current_cpu, pc, "sfmt_stl_indirect_index", "f_srcdst 0x%x", 'x', f_srcdst, "f_scale 0x%x", 'x', f_scale, "abase 0x%x", 'x', f_abase, "index 0x%x", 'x', f_index, "st_src 0x%x", 'x', f_srcdst, (char *) 0));

#if WITH_PROFILE_MODEL_P
  /* Record the fields for profiling.  */
  if (PROFILE_MODEL_P (current_cpu))
    {
      FLD (in_abase) = f_abase;
      FLD (in_h_gr_add__DFLT_index_of__DFLT_st_src_1) = ((FLD (f_srcdst)) + (1));
      FLD (in_index) = f_index;
      FLD (in_st_src) = f_srcdst;
    }
#endif
#undef FLD
    return idesc;
  }

 extract_sfmt_stl_disp:
  {
    const IDESC *idesc = &i960base_insn_data[itype];
    CGEN_INSN_INT insn = base_insn;
#define FLD(f) abuf->fields.sfmt_stq_indirect_index_disp.f
    UINT f_optdisp;
    UINT f_srcdst;
    /* Contents of trailing part of insn.  */
    UINT word_1;

  word_1 = GETIMEMUSI (current_cpu, pc + 4);
    f_optdisp = (0|(EXTRACT_MSB0_UINT (word_1, 32, 0, 32) << 0));
    f_srcdst = EXTRACT_MSB0_UINT (insn, 32, 8, 5);

  /* Record the fields for the semantic handler.  */
  FLD (f_srcdst) = f_srcdst;
  FLD (f_optdisp) = f_optdisp;
  FLD (i_st_src) = & CPU (h_gr)[f_srcdst];
  TRACE_EXTRACT (current_cpu, abuf, (current_cpu, pc, "sfmt_stl_disp", "f_srcdst 0x%x", 'x', f_srcdst, "f_optdisp 0x%x", 'x', f_optdisp, "st_src 0x%x", 'x', f_srcdst, (char *) 0));

#if WITH_PROFILE_MODEL_P
  /* Record the fields for profiling.  */
  if (PROFILE_MODEL_P (current_cpu))
    {
      FLD (in_h_gr_add__DFLT_index_of__DFLT_st_src_1) = ((FLD (f_srcdst)) + (1));
      FLD (in_st_src) = f_srcdst;
    }
#endif
#undef FLD
    return idesc;
  }

 extract_sfmt_stl_indirect_disp:
  {
    const IDESC *idesc = &i960base_insn_data[itype];
    CGEN_INSN_INT insn = base_insn;
#define FLD(f) abuf->fields.sfmt_stq_indirect_index_disp.f
    UINT f_optdisp;
    UINT f_srcdst;
    UINT f_abase;
    /* Contents of trailing part of insn.  */
    UINT word_1;

  word_1 = GETIMEMUSI (current_cpu, pc + 4);
    f_optdisp = (0|(EXTRACT_MSB0_UINT (word_1, 32, 0, 32) << 0));
    f_srcdst = EXTRACT_MSB0_UINT (insn, 32, 8, 5);
    f_abase = EXTRACT_MSB0_UINT (insn, 32, 13, 5);

  /* Record the fields for the semantic handler.  */
  FLD (f_srcdst) = f_srcdst;
  FLD (f_optdisp) = f_optdisp;
  FLD (i_abase) = & CPU (h_gr)[f_abase];
  FLD (i_st_src) = & CPU (h_gr)[f_srcdst];
  TRACE_EXTRACT (current_cpu, abuf, (current_cpu, pc, "sfmt_stl_indirect_disp", "f_srcdst 0x%x", 'x', f_srcdst, "f_optdisp 0x%x", 'x', f_optdisp, "abase 0x%x", 'x', f_abase, "st_src 0x%x", 'x', f_srcdst, (char *) 0));

#if WITH_PROFILE_MODEL_P
  /* Record the fields for profiling.  */
  if (PROFILE_MODEL_P (current_cpu))
    {
      FLD (in_abase) = f_abase;
      FLD (in_h_gr_add__DFLT_index_of__DFLT_st_src_1) = ((FLD (f_srcdst)) + (1));
      FLD (in_st_src) = f_srcdst;
    }
#endif
#undef FLD
    return idesc;
  }

 extract_sfmt_stl_index_disp:
  {
    const IDESC *idesc = &i960base_insn_data[itype];
    CGEN_INSN_INT insn = base_insn;
#define FLD(f) abuf->fields.sfmt_stq_indirect_index_disp.f
    UINT f_optdisp;
    UINT f_srcdst;
    UINT f_scale;
    UINT f_index;
    /* Contents of trailing part of insn.  */
    UINT word_1;

  word_1 = GETIMEMUSI (current_cpu, pc + 4);
    f_optdisp = (0|(EXTRACT_MSB0_UINT (word_1, 32, 0, 32) << 0));
    f_srcdst = EXTRACT_MSB0_UINT (insn, 32, 8, 5);
    f_scale = EXTRACT_MSB0_UINT (insn, 32, 22, 3);
    f_index = EXTRACT_MSB0_UINT (insn, 32, 27, 5);

  /* Record the fields for the semantic handler.  */
  FLD (f_srcdst) = f_srcdst;
  FLD (f_optdisp) = f_optdisp;
  FLD (f_scale) = f_scale;
  FLD (i_index) = & CPU (h_gr)[f_index];
  FLD (i_st_src) = & CPU (h_gr)[f_srcdst];
  TRACE_EXTRACT (current_cpu, abuf, (current_cpu, pc, "sfmt_stl_index_disp", "f_srcdst 0x%x", 'x', f_srcdst, "f_optdisp 0x%x", 'x', f_optdisp, "f_scale 0x%x", 'x', f_scale, "index 0x%x", 'x', f_index, "st_src 0x%x", 'x', f_srcdst, (char *) 0));

#if WITH_PROFILE_MODEL_P
  /* Record the fields for profiling.  */
  if (PROFILE_MODEL_P (current_cpu))
    {
      FLD (in_h_gr_add__DFLT_index_of__DFLT_st_src_1) = ((FLD (f_srcdst)) + (1));
      FLD (in_index) = f_index;
      FLD (in_st_src) = f_srcdst;
    }
#endif
#undef FLD
    return idesc;
  }

 extract_sfmt_stl_indirect_index_disp:
  {
    const IDESC *idesc = &i960base_insn_data[itype];
    CGEN_INSN_INT insn = base_insn;
#define FLD(f) abuf->fields.sfmt_stq_indirect_index_disp.f
    UINT f_optdisp;
    UINT f_srcdst;
    UINT f_abase;
    UINT f_scale;
    UINT f_index;
    /* Contents of trailing part of insn.  */
    UINT word_1;

  word_1 = GETIMEMUSI (current_cpu, pc + 4);
    f_optdisp = (0|(EXTRACT_MSB0_UINT (word_1, 32, 0, 32) << 0));
    f_srcdst = EXTRACT_MSB0_UINT (insn, 32, 8, 5);
    f_abase = EXTRACT_MSB0_UINT (insn, 32, 13, 5);
    f_scale = EXTRACT_MSB0_UINT (insn, 32, 22, 3);
    f_index = EXTRACT_MSB0_UINT (insn, 32, 27, 5);

  /* Record the fields for the semantic handler.  */
  FLD (f_srcdst) = f_srcdst;
  FLD (f_optdisp) = f_optdisp;
  FLD (f_scale) = f_scale;
  FLD (i_abase) = & CPU (h_gr)[f_abase];
  FLD (i_index) = & CPU (h_gr)[f_index];
  FLD (i_st_src) = & CPU (h_gr)[f_srcdst];
  TRACE_EXTRACT (current_cpu, abuf, (current_cpu, pc, "sfmt_stl_indirect_index_disp", "f_srcdst 0x%x", 'x', f_srcdst, "f_optdisp 0x%x", 'x', f_optdisp, "f_scale 0x%x", 'x', f_scale, "abase 0x%x", 'x', f_abase, "index 0x%x", 'x', f_index, "st_src 0x%x", 'x', f_srcdst, (char *) 0));

#if WITH_PROFILE_MODEL_P
  /* Record the fields for profiling.  */
  if (PROFILE_MODEL_P (current_cpu))
    {
      FLD (in_abase) = f_abase;
      FLD (in_h_gr_add__DFLT_index_of__DFLT_st_src_1) = ((FLD (f_srcdst)) + (1));
      FLD (in_index) = f_index;
      FLD (in_st_src) = f_srcdst;
    }
#endif
#undef FLD
    return idesc;
  }

 extract_sfmt_stt_offset:
  {
    const IDESC *idesc = &i960base_insn_data[itype];
    CGEN_INSN_INT insn = base_insn;
#define FLD(f) abuf->fields.sfmt_stq_indirect_offset.f
    UINT f_srcdst;
    UINT f_offset;

    f_srcdst = EXTRACT_MSB0_UINT (insn, 32, 8, 5);
    f_offset = EXTRACT_MSB0_UINT (insn, 32, 20, 12);

  /* Record the fields for the semantic handler.  */
  FLD (f_srcdst) = f_srcdst;
  FLD (f_offset) = f_offset;
  FLD (i_st_src) = & CPU (h_gr)[f_srcdst];
  TRACE_EXTRACT (current_cpu, abuf, (current_cpu, pc, "sfmt_stt_offset", "f_srcdst 0x%x", 'x', f_srcdst, "f_offset 0x%x", 'x', f_offset, "st_src 0x%x", 'x', f_srcdst, (char *) 0));

#if WITH_PROFILE_MODEL_P
  /* Record the fields for profiling.  */
  if (PROFILE_MODEL_P (current_cpu))
    {
      FLD (in_h_gr_add__DFLT_index_of__DFLT_st_src_1) = ((FLD (f_srcdst)) + (1));
      FLD (in_h_gr_add__DFLT_index_of__DFLT_st_src_2) = ((FLD (f_srcdst)) + (2));
      FLD (in_st_src) = f_srcdst;
    }
#endif
#undef FLD
    return idesc;
  }

 extract_sfmt_stt_indirect_offset:
  {
    const IDESC *idesc = &i960base_insn_data[itype];
    CGEN_INSN_INT insn = base_insn;
#define FLD(f) abuf->fields.sfmt_stq_indirect_offset.f
    UINT f_srcdst;
    UINT f_abase;
    UINT f_offset;

    f_srcdst = EXTRACT_MSB0_UINT (insn, 32, 8, 5);
    f_abase = EXTRACT_MSB0_UINT (insn, 32, 13, 5);
    f_offset = EXTRACT_MSB0_UINT (insn, 32, 20, 12);

  /* Record the fields for the semantic handler.  */
  FLD (f_srcdst) = f_srcdst;
  FLD (f_offset) = f_offset;
  FLD (i_abase) = & CPU (h_gr)[f_abase];
  FLD (i_st_src) = & CPU (h_gr)[f_srcdst];
  TRACE_EXTRACT (current_cpu, abuf, (current_cpu, pc, "sfmt_stt_indirect_offset", "f_srcdst 0x%x", 'x', f_srcdst, "f_offset 0x%x", 'x', f_offset, "abase 0x%x", 'x', f_abase, "st_src 0x%x", 'x', f_srcdst, (char *) 0));

#if WITH_PROFILE_MODEL_P
  /* Record the fields for profiling.  */
  if (PROFILE_MODEL_P (current_cpu))
    {
      FLD (in_abase) = f_abase;
      FLD (in_h_gr_add__DFLT_index_of__DFLT_st_src_1) = ((FLD (f_srcdst)) + (1));
      FLD (in_h_gr_add__DFLT_index_of__DFLT_st_src_2) = ((FLD (f_srcdst)) + (2));
      FLD (in_st_src) = f_srcdst;
    }
#endif
#undef FLD
    return idesc;
  }

 extract_sfmt_stt_indirect:
  {
    const IDESC *idesc = &i960base_insn_data[itype];
    CGEN_INSN_INT insn = base_insn;
#define FLD(f) abuf->fields.sfmt_stq_indirect_offset.f
    UINT f_srcdst;
    UINT f_abase;

    f_srcdst = EXTRACT_MSB0_UINT (insn, 32, 8, 5);
    f_abase = EXTRACT_MSB0_UINT (insn, 32, 13, 5);

  /* Record the fields for the semantic handler.  */
  FLD (f_srcdst) = f_srcdst;
  FLD (i_abase) = & CPU (h_gr)[f_abase];
  FLD (i_st_src) = & CPU (h_gr)[f_srcdst];
  TRACE_EXTRACT (current_cpu, abuf, (current_cpu, pc, "sfmt_stt_indirect", "f_srcdst 0x%x", 'x', f_srcdst, "abase 0x%x", 'x', f_abase, "st_src 0x%x", 'x', f_srcdst, (char *) 0));

#if WITH_PROFILE_MODEL_P
  /* Record the fields for profiling.  */
  if (PROFILE_MODEL_P (current_cpu))
    {
      FLD (in_abase) = f_abase;
      FLD (in_h_gr_add__DFLT_index_of__DFLT_st_src_1) = ((FLD (f_srcdst)) + (1));
      FLD (in_h_gr_add__DFLT_index_of__DFLT_st_src_2) = ((FLD (f_srcdst)) + (2));
      FLD (in_st_src) = f_srcdst;
    }
#endif
#undef FLD
    return idesc;
  }

 extract_sfmt_stt_indirect_index:
  {
    const IDESC *idesc = &i960base_insn_data[itype];
    CGEN_INSN_INT insn = base_insn;
#define FLD(f) abuf->fields.sfmt_stq_indirect_index_disp.f
    UINT f_srcdst;
    UINT f_abase;
    UINT f_scale;
    UINT f_index;

    f_srcdst = EXTRACT_MSB0_UINT (insn, 32, 8, 5);
    f_abase = EXTRACT_MSB0_UINT (insn, 32, 13, 5);
    f_scale = EXTRACT_MSB0_UINT (insn, 32, 22, 3);
    f_index = EXTRACT_MSB0_UINT (insn, 32, 27, 5);

  /* Record the fields for the semantic handler.  */
  FLD (f_srcdst) = f_srcdst;
  FLD (f_scale) = f_scale;
  FLD (i_abase) = & CPU (h_gr)[f_abase];
  FLD (i_index) = & CPU (h_gr)[f_index];
  FLD (i_st_src) = & CPU (h_gr)[f_srcdst];
  TRACE_EXTRACT (current_cpu, abuf, (current_cpu, pc, "sfmt_stt_indirect_index", "f_srcdst 0x%x", 'x', f_srcdst, "f_scale 0x%x", 'x', f_scale, "abase 0x%x", 'x', f_abase, "index 0x%x", 'x', f_index, "st_src 0x%x", 'x', f_srcdst, (char *) 0));

#if WITH_PROFILE_MODEL_P
  /* Record the fields for profiling.  */
  if (PROFILE_MODEL_P (current_cpu))
    {
      FLD (in_abase) = f_abase;
      FLD (in_h_gr_add__DFLT_index_of__DFLT_st_src_1) = ((FLD (f_srcdst)) + (1));
      FLD (in_h_gr_add__DFLT_index_of__DFLT_st_src_2) = ((FLD (f_srcdst)) + (2));
      FLD (in_index) = f_index;
      FLD (in_st_src) = f_srcdst;
    }
#endif
#undef FLD
    return idesc;
  }

 extract_sfmt_stt_disp:
  {
    const IDESC *idesc = &i960base_insn_data[itype];
    CGEN_INSN_INT insn = base_insn;
#define FLD(f) abuf->fields.sfmt_stq_indirect_index_disp.f
    UINT f_optdisp;
    UINT f_srcdst;
    /* Contents of trailing part of insn.  */
    UINT word_1;

  word_1 = GETIMEMUSI (current_cpu, pc + 4);
    f_optdisp = (0|(EXTRACT_MSB0_UINT (word_1, 32, 0, 32) << 0));
    f_srcdst = EXTRACT_MSB0_UINT (insn, 32, 8, 5);

  /* Record the fields for the semantic handler.  */
  FLD (f_srcdst) = f_srcdst;
  FLD (f_optdisp) = f_optdisp;
  FLD (i_st_src) = & CPU (h_gr)[f_srcdst];
  TRACE_EXTRACT (current_cpu, abuf, (current_cpu, pc, "sfmt_stt_disp", "f_srcdst 0x%x", 'x', f_srcdst, "f_optdisp 0x%x", 'x', f_optdisp, "st_src 0x%x", 'x', f_srcdst, (char *) 0));

#if WITH_PROFILE_MODEL_P
  /* Record the fields for profiling.  */
  if (PROFILE_MODEL_P (current_cpu))
    {
      FLD (in_h_gr_add__DFLT_index_of__DFLT_st_src_1) = ((FLD (f_srcdst)) + (1));
      FLD (in_h_gr_add__DFLT_index_of__DFLT_st_src_2) = ((FLD (f_srcdst)) + (2));
      FLD (in_st_src) = f_srcdst;
    }
#endif
#undef FLD
    return idesc;
  }

 extract_sfmt_stt_indirect_disp:
  {
    const IDESC *idesc = &i960base_insn_data[itype];
    CGEN_INSN_INT insn = base_insn;
#define FLD(f) abuf->fields.sfmt_stq_indirect_index_disp.f
    UINT f_optdisp;
    UINT f_srcdst;
    UINT f_abase;
    /* Contents of trailing part of insn.  */
    UINT word_1;

  word_1 = GETIMEMUSI (current_cpu, pc + 4);
    f_optdisp = (0|(EXTRACT_MSB0_UINT (word_1, 32, 0, 32) << 0));
    f_srcdst = EXTRACT_MSB0_UINT (insn, 32, 8, 5);
    f_abase = EXTRACT_MSB0_UINT (insn, 32, 13, 5);

  /* Record the fields for the semantic handler.  */
  FLD (f_srcdst) = f_srcdst;
  FLD (f_optdisp) = f_optdisp;
  FLD (i_abase) = & CPU (h_gr)[f_abase];
  FLD (i_st_src) = & CPU (h_gr)[f_srcdst];
  TRACE_EXTRACT (current_cpu, abuf, (current_cpu, pc, "sfmt_stt_indirect_disp", "f_srcdst 0x%x", 'x', f_srcdst, "f_optdisp 0x%x", 'x', f_optdisp, "abase 0x%x", 'x', f_abase, "st_src 0x%x", 'x', f_srcdst, (char *) 0));

#if WITH_PROFILE_MODEL_P
  /* Record the fields for profiling.  */
  if (PROFILE_MODEL_P (current_cpu))
    {
      FLD (in_abase) = f_abase;
      FLD (in_h_gr_add__DFLT_index_of__DFLT_st_src_1) = ((FLD (f_srcdst)) + (1));
      FLD (in_h_gr_add__DFLT_index_of__DFLT_st_src_2) = ((FLD (f_srcdst)) + (2));
      FLD (in_st_src) = f_srcdst;
    }
#endif
#undef FLD
    return idesc;
  }

 extract_sfmt_stt_index_disp:
  {
    const IDESC *idesc = &i960base_insn_data[itype];
    CGEN_INSN_INT insn = base_insn;
#define FLD(f) abuf->fields.sfmt_stq_indirect_index_disp.f
    UINT f_optdisp;
    UINT f_srcdst;
    UINT f_scale;
    UINT f_index;
    /* Contents of trailing part of insn.  */
    UINT word_1;

  word_1 = GETIMEMUSI (current_cpu, pc + 4);
    f_optdisp = (0|(EXTRACT_MSB0_UINT (word_1, 32, 0, 32) << 0));
    f_srcdst = EXTRACT_MSB0_UINT (insn, 32, 8, 5);
    f_scale = EXTRACT_MSB0_UINT (insn, 32, 22, 3);
    f_index = EXTRACT_MSB0_UINT (insn, 32, 27, 5);

  /* Record the fields for the semantic handler.  */
  FLD (f_srcdst) = f_srcdst;
  FLD (f_optdisp) = f_optdisp;
  FLD (f_scale) = f_scale;
  FLD (i_index) = & CPU (h_gr)[f_index];
  FLD (i_st_src) = & CPU (h_gr)[f_srcdst];
  TRACE_EXTRACT (current_cpu, abuf, (current_cpu, pc, "sfmt_stt_index_disp", "f_srcdst 0x%x", 'x', f_srcdst, "f_optdisp 0x%x", 'x', f_optdisp, "f_scale 0x%x", 'x', f_scale, "index 0x%x", 'x', f_index, "st_src 0x%x", 'x', f_srcdst, (char *) 0));

#if WITH_PROFILE_MODEL_P
  /* Record the fields for profiling.  */
  if (PROFILE_MODEL_P (current_cpu))
    {
      FLD (in_h_gr_add__DFLT_index_of__DFLT_st_src_1) = ((FLD (f_srcdst)) + (1));
      FLD (in_h_gr_add__DFLT_index_of__DFLT_st_src_2) = ((FLD (f_srcdst)) + (2));
      FLD (in_index) = f_index;
      FLD (in_st_src) = f_srcdst;
    }
#endif
#undef FLD
    return idesc;
  }

 extract_sfmt_stt_indirect_index_disp:
  {
    const IDESC *idesc = &i960base_insn_data[itype];
    CGEN_INSN_INT insn = base_insn;
#define FLD(f) abuf->fields.sfmt_stq_indirect_index_disp.f
    UINT f_optdisp;
    UINT f_srcdst;
    UINT f_abase;
    UINT f_scale;
    UINT f_index;
    /* Contents of trailing part of insn.  */
    UINT word_1;

  word_1 = GETIMEMUSI (current_cpu, pc + 4);
    f_optdisp = (0|(EXTRACT_MSB0_UINT (word_1, 32, 0, 32) << 0));
    f_srcdst = EXTRACT_MSB0_UINT (insn, 32, 8, 5);
    f_abase = EXTRACT_MSB0_UINT (insn, 32, 13, 5);
    f_scale = EXTRACT_MSB0_UINT (insn, 32, 22, 3);
    f_index = EXTRACT_MSB0_UINT (insn, 32, 27, 5);

  /* Record the fields for the semantic handler.  */
  FLD (f_srcdst) = f_srcdst;
  FLD (f_optdisp) = f_optdisp;
  FLD (f_scale) = f_scale;
  FLD (i_abase) = & CPU (h_gr)[f_abase];
  FLD (i_index) = & CPU (h_gr)[f_index];
  FLD (i_st_src) = & CPU (h_gr)[f_srcdst];
  TRACE_EXTRACT (current_cpu, abuf, (current_cpu, pc, "sfmt_stt_indirect_index_disp", "f_srcdst 0x%x", 'x', f_srcdst, "f_optdisp 0x%x", 'x', f_optdisp, "f_scale 0x%x", 'x', f_scale, "abase 0x%x", 'x', f_abase, "index 0x%x", 'x', f_index, "st_src 0x%x", 'x', f_srcdst, (char *) 0));

#if WITH_PROFILE_MODEL_P
  /* Record the fields for profiling.  */
  if (PROFILE_MODEL_P (current_cpu))
    {
      FLD (in_abase) = f_abase;
      FLD (in_h_gr_add__DFLT_index_of__DFLT_st_src_1) = ((FLD (f_srcdst)) + (1));
      FLD (in_h_gr_add__DFLT_index_of__DFLT_st_src_2) = ((FLD (f_srcdst)) + (2));
      FLD (in_index) = f_index;
      FLD (in_st_src) = f_srcdst;
    }
#endif
#undef FLD
    return idesc;
  }

 extract_sfmt_stq_offset:
  {
    const IDESC *idesc = &i960base_insn_data[itype];
    CGEN_INSN_INT insn = base_insn;
#define FLD(f) abuf->fields.sfmt_stq_indirect_offset.f
    UINT f_srcdst;
    UINT f_offset;

    f_srcdst = EXTRACT_MSB0_UINT (insn, 32, 8, 5);
    f_offset = EXTRACT_MSB0_UINT (insn, 32, 20, 12);

  /* Record the fields for the semantic handler.  */
  FLD (f_srcdst) = f_srcdst;
  FLD (f_offset) = f_offset;
  FLD (i_st_src) = & CPU (h_gr)[f_srcdst];
  TRACE_EXTRACT (current_cpu, abuf, (current_cpu, pc, "sfmt_stq_offset", "f_srcdst 0x%x", 'x', f_srcdst, "f_offset 0x%x", 'x', f_offset, "st_src 0x%x", 'x', f_srcdst, (char *) 0));

#if WITH_PROFILE_MODEL_P
  /* Record the fields for profiling.  */
  if (PROFILE_MODEL_P (current_cpu))
    {
      FLD (in_h_gr_add__DFLT_index_of__DFLT_st_src_1) = ((FLD (f_srcdst)) + (1));
      FLD (in_h_gr_add__DFLT_index_of__DFLT_st_src_2) = ((FLD (f_srcdst)) + (2));
      FLD (in_h_gr_add__DFLT_index_of__DFLT_st_src_3) = ((FLD (f_srcdst)) + (3));
      FLD (in_st_src) = f_srcdst;
    }
#endif
#undef FLD
    return idesc;
  }

 extract_sfmt_stq_indirect_offset:
  {
    const IDESC *idesc = &i960base_insn_data[itype];
    CGEN_INSN_INT insn = base_insn;
#define FLD(f) abuf->fields.sfmt_stq_indirect_offset.f
    UINT f_srcdst;
    UINT f_abase;
    UINT f_offset;

    f_srcdst = EXTRACT_MSB0_UINT (insn, 32, 8, 5);
    f_abase = EXTRACT_MSB0_UINT (insn, 32, 13, 5);
    f_offset = EXTRACT_MSB0_UINT (insn, 32, 20, 12);

  /* Record the fields for the semantic handler.  */
  FLD (f_srcdst) = f_srcdst;
  FLD (f_offset) = f_offset;
  FLD (i_abase) = & CPU (h_gr)[f_abase];
  FLD (i_st_src) = & CPU (h_gr)[f_srcdst];
  TRACE_EXTRACT (current_cpu, abuf, (current_cpu, pc, "sfmt_stq_indirect_offset", "f_srcdst 0x%x", 'x', f_srcdst, "f_offset 0x%x", 'x', f_offset, "abase 0x%x", 'x', f_abase, "st_src 0x%x", 'x', f_srcdst, (char *) 0));

#if WITH_PROFILE_MODEL_P
  /* Record the fields for profiling.  */
  if (PROFILE_MODEL_P (current_cpu))
    {
      FLD (in_abase) = f_abase;
      FLD (in_h_gr_add__DFLT_index_of__DFLT_st_src_1) = ((FLD (f_srcdst)) + (1));
      FLD (in_h_gr_add__DFLT_index_of__DFLT_st_src_2) = ((FLD (f_srcdst)) + (2));
      FLD (in_h_gr_add__DFLT_index_of__DFLT_st_src_3) = ((FLD (f_srcdst)) + (3));
      FLD (in_st_src) = f_srcdst;
    }
#endif
#undef FLD
    return idesc;
  }

 extract_sfmt_stq_indirect:
  {
    const IDESC *idesc = &i960base_insn_data[itype];
    CGEN_INSN_INT insn = base_insn;
#define FLD(f) abuf->fields.sfmt_stq_indirect_offset.f
    UINT f_srcdst;
    UINT f_abase;

    f_srcdst = EXTRACT_MSB0_UINT (insn, 32, 8, 5);
    f_abase = EXTRACT_MSB0_UINT (insn, 32, 13, 5);

  /* Record the fields for the semantic handler.  */
  FLD (f_srcdst) = f_srcdst;
  FLD (i_abase) = & CPU (h_gr)[f_abase];
  FLD (i_st_src) = & CPU (h_gr)[f_srcdst];
  TRACE_EXTRACT (current_cpu, abuf, (current_cpu, pc, "sfmt_stq_indirect", "f_srcdst 0x%x", 'x', f_srcdst, "abase 0x%x", 'x', f_abase, "st_src 0x%x", 'x', f_srcdst, (char *) 0));

#if WITH_PROFILE_MODEL_P
  /* Record the fields for profiling.  */
  if (PROFILE_MODEL_P (current_cpu))
    {
      FLD (in_abase) = f_abase;
      FLD (in_h_gr_add__DFLT_index_of__DFLT_st_src_1) = ((FLD (f_srcdst)) + (1));
      FLD (in_h_gr_add__DFLT_index_of__DFLT_st_src_2) = ((FLD (f_srcdst)) + (2));
      FLD (in_h_gr_add__DFLT_index_of__DFLT_st_src_3) = ((FLD (f_srcdst)) + (3));
      FLD (in_st_src) = f_srcdst;
    }
#endif
#undef FLD
    return idesc;
  }

 extract_sfmt_stq_indirect_index:
  {
    const IDESC *idesc = &i960base_insn_data[itype];
    CGEN_INSN_INT insn = base_insn;
#define FLD(f) abuf->fields.sfmt_stq_indirect_index_disp.f
    UINT f_srcdst;
    UINT f_abase;
    UINT f_scale;
    UINT f_index;

    f_srcdst = EXTRACT_MSB0_UINT (insn, 32, 8, 5);
    f_abase = EXTRACT_MSB0_UINT (insn, 32, 13, 5);
    f_scale = EXTRACT_MSB0_UINT (insn, 32, 22, 3);
    f_index = EXTRACT_MSB0_UINT (insn, 32, 27, 5);

  /* Record the fields for the semantic handler.  */
  FLD (f_srcdst) = f_srcdst;
  FLD (f_scale) = f_scale;
  FLD (i_abase) = & CPU (h_gr)[f_abase];
  FLD (i_index) = & CPU (h_gr)[f_index];
  FLD (i_st_src) = & CPU (h_gr)[f_srcdst];
  TRACE_EXTRACT (current_cpu, abuf, (current_cpu, pc, "sfmt_stq_indirect_index", "f_srcdst 0x%x", 'x', f_srcdst, "f_scale 0x%x", 'x', f_scale, "abase 0x%x", 'x', f_abase, "index 0x%x", 'x', f_index, "st_src 0x%x", 'x', f_srcdst, (char *) 0));

#if WITH_PROFILE_MODEL_P
  /* Record the fields for profiling.  */
  if (PROFILE_MODEL_P (current_cpu))
    {
      FLD (in_abase) = f_abase;
      FLD (in_h_gr_add__DFLT_index_of__DFLT_st_src_1) = ((FLD (f_srcdst)) + (1));
      FLD (in_h_gr_add__DFLT_index_of__DFLT_st_src_2) = ((FLD (f_srcdst)) + (2));
      FLD (in_h_gr_add__DFLT_index_of__DFLT_st_src_3) = ((FLD (f_srcdst)) + (3));
      FLD (in_index) = f_index;
      FLD (in_st_src) = f_srcdst;
    }
#endif
#undef FLD
    return idesc;
  }

 extract_sfmt_stq_disp:
  {
    const IDESC *idesc = &i960base_insn_data[itype];
    CGEN_INSN_INT insn = base_insn;
#define FLD(f) abuf->fields.sfmt_stq_indirect_index_disp.f
    UINT f_optdisp;
    UINT f_srcdst;
    /* Contents of trailing part of insn.  */
    UINT word_1;

  word_1 = GETIMEMUSI (current_cpu, pc + 4);
    f_optdisp = (0|(EXTRACT_MSB0_UINT (word_1, 32, 0, 32) << 0));
    f_srcdst = EXTRACT_MSB0_UINT (insn, 32, 8, 5);

  /* Record the fields for the semantic handler.  */
  FLD (f_srcdst) = f_srcdst;
  FLD (f_optdisp) = f_optdisp;
  FLD (i_st_src) = & CPU (h_gr)[f_srcdst];
  TRACE_EXTRACT (current_cpu, abuf, (current_cpu, pc, "sfmt_stq_disp", "f_srcdst 0x%x", 'x', f_srcdst, "f_optdisp 0x%x", 'x', f_optdisp, "st_src 0x%x", 'x', f_srcdst, (char *) 0));

#if WITH_PROFILE_MODEL_P
  /* Record the fields for profiling.  */
  if (PROFILE_MODEL_P (current_cpu))
    {
      FLD (in_h_gr_add__DFLT_index_of__DFLT_st_src_1) = ((FLD (f_srcdst)) + (1));
      FLD (in_h_gr_add__DFLT_index_of__DFLT_st_src_2) = ((FLD (f_srcdst)) + (2));
      FLD (in_h_gr_add__DFLT_index_of__DFLT_st_src_3) = ((FLD (f_srcdst)) + (3));
      FLD (in_st_src) = f_srcdst;
    }
#endif
#undef FLD
    return idesc;
  }

 extract_sfmt_stq_indirect_disp:
  {
    const IDESC *idesc = &i960base_insn_data[itype];
    CGEN_INSN_INT insn = base_insn;
#define FLD(f) abuf->fields.sfmt_stq_indirect_index_disp.f
    UINT f_optdisp;
    UINT f_srcdst;
    UINT f_abase;
    /* Contents of trailing part of insn.  */
    UINT word_1;

  word_1 = GETIMEMUSI (current_cpu, pc + 4);
    f_optdisp = (0|(EXTRACT_MSB0_UINT (word_1, 32, 0, 32) << 0));
    f_srcdst = EXTRACT_MSB0_UINT (insn, 32, 8, 5);
    f_abase = EXTRACT_MSB0_UINT (insn, 32, 13, 5);

  /* Record the fields for the semantic handler.  */
  FLD (f_srcdst) = f_srcdst;
  FLD (f_optdisp) = f_optdisp;
  FLD (i_abase) = & CPU (h_gr)[f_abase];
  FLD (i_st_src) = & CPU (h_gr)[f_srcdst];
  TRACE_EXTRACT (current_cpu, abuf, (current_cpu, pc, "sfmt_stq_indirect_disp", "f_srcdst 0x%x", 'x', f_srcdst, "f_optdisp 0x%x", 'x', f_optdisp, "abase 0x%x", 'x', f_abase, "st_src 0x%x", 'x', f_srcdst, (char *) 0));

#if WITH_PROFILE_MODEL_P
  /* Record the fields for profiling.  */
  if (PROFILE_MODEL_P (current_cpu))
    {
      FLD (in_abase) = f_abase;
      FLD (in_h_gr_add__DFLT_index_of__DFLT_st_src_1) = ((FLD (f_srcdst)) + (1));
      FLD (in_h_gr_add__DFLT_index_of__DFLT_st_src_2) = ((FLD (f_srcdst)) + (2));
      FLD (in_h_gr_add__DFLT_index_of__DFLT_st_src_3) = ((FLD (f_srcdst)) + (3));
      FLD (in_st_src) = f_srcdst;
    }
#endif
#undef FLD
    return idesc;
  }

 extract_sfmt_stq_index_disp:
  {
    const IDESC *idesc = &i960base_insn_data[itype];
    CGEN_INSN_INT insn = base_insn;
#define FLD(f) abuf->fields.sfmt_stq_indirect_index_disp.f
    UINT f_optdisp;
    UINT f_srcdst;
    UINT f_scale;
    UINT f_index;
    /* Contents of trailing part of insn.  */
    UINT word_1;

  word_1 = GETIMEMUSI (current_cpu, pc + 4);
    f_optdisp = (0|(EXTRACT_MSB0_UINT (word_1, 32, 0, 32) << 0));
    f_srcdst = EXTRACT_MSB0_UINT (insn, 32, 8, 5);
    f_scale = EXTRACT_MSB0_UINT (insn, 32, 22, 3);
    f_index = EXTRACT_MSB0_UINT (insn, 32, 27, 5);

  /* Record the fields for the semantic handler.  */
  FLD (f_srcdst) = f_srcdst;
  FLD (f_optdisp) = f_optdisp;
  FLD (f_scale) = f_scale;
  FLD (i_index) = & CPU (h_gr)[f_index];
  FLD (i_st_src) = & CPU (h_gr)[f_srcdst];
  TRACE_EXTRACT (current_cpu, abuf, (current_cpu, pc, "sfmt_stq_index_disp", "f_srcdst 0x%x", 'x', f_srcdst, "f_optdisp 0x%x", 'x', f_optdisp, "f_scale 0x%x", 'x', f_scale, "index 0x%x", 'x', f_index, "st_src 0x%x", 'x', f_srcdst, (char *) 0));

#if WITH_PROFILE_MODEL_P
  /* Record the fields for profiling.  */
  if (PROFILE_MODEL_P (current_cpu))
    {
      FLD (in_h_gr_add__DFLT_index_of__DFLT_st_src_1) = ((FLD (f_srcdst)) + (1));
      FLD (in_h_gr_add__DFLT_index_of__DFLT_st_src_2) = ((FLD (f_srcdst)) + (2));
      FLD (in_h_gr_add__DFLT_index_of__DFLT_st_src_3) = ((FLD (f_srcdst)) + (3));
      FLD (in_index) = f_index;
      FLD (in_st_src) = f_srcdst;
    }
#endif
#undef FLD
    return idesc;
  }

 extract_sfmt_stq_indirect_index_disp:
  {
    const IDESC *idesc = &i960base_insn_data[itype];
    CGEN_INSN_INT insn = base_insn;
#define FLD(f) abuf->fields.sfmt_stq_indirect_index_disp.f
    UINT f_optdisp;
    UINT f_srcdst;
    UINT f_abase;
    UINT f_scale;
    UINT f_index;
    /* Contents of trailing part of insn.  */
    UINT word_1;

  word_1 = GETIMEMUSI (current_cpu, pc + 4);
    f_optdisp = (0|(EXTRACT_MSB0_UINT (word_1, 32, 0, 32) << 0));
    f_srcdst = EXTRACT_MSB0_UINT (insn, 32, 8, 5);
    f_abase = EXTRACT_MSB0_UINT (insn, 32, 13, 5);
    f_scale = EXTRACT_MSB0_UINT (insn, 32, 22, 3);
    f_index = EXTRACT_MSB0_UINT (insn, 32, 27, 5);

  /* Record the fields for the semantic handler.  */
  FLD (f_srcdst) = f_srcdst;
  FLD (f_optdisp) = f_optdisp;
  FLD (f_scale) = f_scale;
  FLD (i_abase) = & CPU (h_gr)[f_abase];
  FLD (i_index) = & CPU (h_gr)[f_index];
  FLD (i_st_src) = & CPU (h_gr)[f_srcdst];
  TRACE_EXTRACT (current_cpu, abuf, (current_cpu, pc, "sfmt_stq_indirect_index_disp", "f_srcdst 0x%x", 'x', f_srcdst, "f_optdisp 0x%x", 'x', f_optdisp, "f_scale 0x%x", 'x', f_scale, "abase 0x%x", 'x', f_abase, "index 0x%x", 'x', f_index, "st_src 0x%x", 'x', f_srcdst, (char *) 0));

#if WITH_PROFILE_MODEL_P
  /* Record the fields for profiling.  */
  if (PROFILE_MODEL_P (current_cpu))
    {
      FLD (in_abase) = f_abase;
      FLD (in_h_gr_add__DFLT_index_of__DFLT_st_src_1) = ((FLD (f_srcdst)) + (1));
      FLD (in_h_gr_add__DFLT_index_of__DFLT_st_src_2) = ((FLD (f_srcdst)) + (2));
      FLD (in_h_gr_add__DFLT_index_of__DFLT_st_src_3) = ((FLD (f_srcdst)) + (3));
      FLD (in_index) = f_index;
      FLD (in_st_src) = f_srcdst;
    }
#endif
#undef FLD
    return idesc;
  }

 extract_sfmt_cmpobe_reg:
  {
    const IDESC *idesc = &i960base_insn_data[itype];
    CGEN_INSN_INT insn = base_insn;
#define FLD(f) abuf->fields.sfmt_cmpobe_reg.f
    UINT f_br_src1;
    UINT f_br_src2;
    SI f_br_disp;

    f_br_src1 = EXTRACT_MSB0_UINT (insn, 32, 8, 5);
    f_br_src2 = EXTRACT_MSB0_UINT (insn, 32, 13, 5);
    f_br_disp = ((((EXTRACT_MSB0_INT (insn, 32, 19, 11)) << (2))) + (pc));

  /* Record the fields for the semantic handler.  */
  FLD (i_br_disp) = f_br_disp;
  FLD (i_br_src1) = & CPU (h_gr)[f_br_src1];
  FLD (i_br_src2) = & CPU (h_gr)[f_br_src2];
  TRACE_EXTRACT (current_cpu, abuf, (current_cpu, pc, "sfmt_cmpobe_reg", "br_disp 0x%x", 'x', f_br_disp, "br_src1 0x%x", 'x', f_br_src1, "br_src2 0x%x", 'x', f_br_src2, (char *) 0));

#if WITH_PROFILE_MODEL_P
  /* Record the fields for profiling.  */
  if (PROFILE_MODEL_P (current_cpu))
    {
      FLD (in_br_src1) = f_br_src1;
      FLD (in_br_src2) = f_br_src2;
    }
#endif
#undef FLD
    return idesc;
  }

 extract_sfmt_cmpobe_lit:
  {
    const IDESC *idesc = &i960base_insn_data[itype];
    CGEN_INSN_INT insn = base_insn;
#define FLD(f) abuf->fields.sfmt_cmpobe_lit.f
    UINT f_br_src1;
    UINT f_br_src2;
    SI f_br_disp;

    f_br_src1 = EXTRACT_MSB0_UINT (insn, 32, 8, 5);
    f_br_src2 = EXTRACT_MSB0_UINT (insn, 32, 13, 5);
    f_br_disp = ((((EXTRACT_MSB0_INT (insn, 32, 19, 11)) << (2))) + (pc));

  /* Record the fields for the semantic handler.  */
  FLD (f_br_src1) = f_br_src1;
  FLD (i_br_disp) = f_br_disp;
  FLD (i_br_src2) = & CPU (h_gr)[f_br_src2];
  TRACE_EXTRACT (current_cpu, abuf, (current_cpu, pc, "sfmt_cmpobe_lit", "f_br_src1 0x%x", 'x', f_br_src1, "br_disp 0x%x", 'x', f_br_disp, "br_src2 0x%x", 'x', f_br_src2, (char *) 0));

#if WITH_PROFILE_MODEL_P
  /* Record the fields for profiling.  */
  if (PROFILE_MODEL_P (current_cpu))
    {
      FLD (in_br_src2) = f_br_src2;
    }
#endif
#undef FLD
    return idesc;
  }

 extract_sfmt_cmpobl_reg:
  {
    const IDESC *idesc = &i960base_insn_data[itype];
    CGEN_INSN_INT insn = base_insn;
#define FLD(f) abuf->fields.sfmt_cmpobe_reg.f
    UINT f_br_src1;
    UINT f_br_src2;
    SI f_br_disp;

    f_br_src1 = EXTRACT_MSB0_UINT (insn, 32, 8, 5);
    f_br_src2 = EXTRACT_MSB0_UINT (insn, 32, 13, 5);
    f_br_disp = ((((EXTRACT_MSB0_INT (insn, 32, 19, 11)) << (2))) + (pc));

  /* Record the fields for the semantic handler.  */
  FLD (i_br_disp) = f_br_disp;
  FLD (i_br_src1) = & CPU (h_gr)[f_br_src1];
  FLD (i_br_src2) = & CPU (h_gr)[f_br_src2];
  TRACE_EXTRACT (current_cpu, abuf, (current_cpu, pc, "sfmt_cmpobl_reg", "br_disp 0x%x", 'x', f_br_disp, "br_src1 0x%x", 'x', f_br_src1, "br_src2 0x%x", 'x', f_br_src2, (char *) 0));

#if WITH_PROFILE_MODEL_P
  /* Record the fields for profiling.  */
  if (PROFILE_MODEL_P (current_cpu))
    {
      FLD (in_br_src1) = f_br_src1;
      FLD (in_br_src2) = f_br_src2;
    }
#endif
#undef FLD
    return idesc;
  }

 extract_sfmt_cmpobl_lit:
  {
    const IDESC *idesc = &i960base_insn_data[itype];
    CGEN_INSN_INT insn = base_insn;
#define FLD(f) abuf->fields.sfmt_cmpobe_lit.f
    UINT f_br_src1;
    UINT f_br_src2;
    SI f_br_disp;

    f_br_src1 = EXTRACT_MSB0_UINT (insn, 32, 8, 5);
    f_br_src2 = EXTRACT_MSB0_UINT (insn, 32, 13, 5);
    f_br_disp = ((((EXTRACT_MSB0_INT (insn, 32, 19, 11)) << (2))) + (pc));

  /* Record the fields for the semantic handler.  */
  FLD (f_br_src1) = f_br_src1;
  FLD (i_br_disp) = f_br_disp;
  FLD (i_br_src2) = & CPU (h_gr)[f_br_src2];
  TRACE_EXTRACT (current_cpu, abuf, (current_cpu, pc, "sfmt_cmpobl_lit", "f_br_src1 0x%x", 'x', f_br_src1, "br_disp 0x%x", 'x', f_br_disp, "br_src2 0x%x", 'x', f_br_src2, (char *) 0));

#if WITH_PROFILE_MODEL_P
  /* Record the fields for profiling.  */
  if (PROFILE_MODEL_P (current_cpu))
    {
      FLD (in_br_src2) = f_br_src2;
    }
#endif
#undef FLD
    return idesc;
  }

 extract_sfmt_bbc_reg:
  {
    const IDESC *idesc = &i960base_insn_data[itype];
    CGEN_INSN_INT insn = base_insn;
#define FLD(f) abuf->fields.sfmt_cmpobe_reg.f
    UINT f_br_src1;
    UINT f_br_src2;
    SI f_br_disp;

    f_br_src1 = EXTRACT_MSB0_UINT (insn, 32, 8, 5);
    f_br_src2 = EXTRACT_MSB0_UINT (insn, 32, 13, 5);
    f_br_disp = ((((EXTRACT_MSB0_INT (insn, 32, 19, 11)) << (2))) + (pc));

  /* Record the fields for the semantic handler.  */
  FLD (i_br_disp) = f_br_disp;
  FLD (i_br_src1) = & CPU (h_gr)[f_br_src1];
  FLD (i_br_src2) = & CPU (h_gr)[f_br_src2];
  TRACE_EXTRACT (current_cpu, abuf, (current_cpu, pc, "sfmt_bbc_reg", "br_disp 0x%x", 'x', f_br_disp, "br_src1 0x%x", 'x', f_br_src1, "br_src2 0x%x", 'x', f_br_src2, (char *) 0));

#if WITH_PROFILE_MODEL_P
  /* Record the fields for profiling.  */
  if (PROFILE_MODEL_P (current_cpu))
    {
      FLD (in_br_src1) = f_br_src1;
      FLD (in_br_src2) = f_br_src2;
    }
#endif
#undef FLD
    return idesc;
  }

 extract_sfmt_bbc_lit:
  {
    const IDESC *idesc = &i960base_insn_data[itype];
    CGEN_INSN_INT insn = base_insn;
#define FLD(f) abuf->fields.sfmt_cmpobe_lit.f
    UINT f_br_src1;
    UINT f_br_src2;
    SI f_br_disp;

    f_br_src1 = EXTRACT_MSB0_UINT (insn, 32, 8, 5);
    f_br_src2 = EXTRACT_MSB0_UINT (insn, 32, 13, 5);
    f_br_disp = ((((EXTRACT_MSB0_INT (insn, 32, 19, 11)) << (2))) + (pc));

  /* Record the fields for the semantic handler.  */
  FLD (f_br_src1) = f_br_src1;
  FLD (i_br_disp) = f_br_disp;
  FLD (i_br_src2) = & CPU (h_gr)[f_br_src2];
  TRACE_EXTRACT (current_cpu, abuf, (current_cpu, pc, "sfmt_bbc_lit", "f_br_src1 0x%x", 'x', f_br_src1, "br_disp 0x%x", 'x', f_br_disp, "br_src2 0x%x", 'x', f_br_src2, (char *) 0));

#if WITH_PROFILE_MODEL_P
  /* Record the fields for profiling.  */
  if (PROFILE_MODEL_P (current_cpu))
    {
      FLD (in_br_src2) = f_br_src2;
    }
#endif
#undef FLD
    return idesc;
  }

 extract_sfmt_cmpi:
  {
    const IDESC *idesc = &i960base_insn_data[itype];
    CGEN_INSN_INT insn = base_insn;
#define FLD(f) abuf->fields.sfmt_emul.f
    UINT f_src2;
    UINT f_src1;

    f_src2 = EXTRACT_MSB0_UINT (insn, 32, 13, 5);
    f_src1 = EXTRACT_MSB0_UINT (insn, 32, 27, 5);

  /* Record the fields for the semantic handler.  */
  FLD (i_src1) = & CPU (h_gr)[f_src1];
  FLD (i_src2) = & CPU (h_gr)[f_src2];
  TRACE_EXTRACT (current_cpu, abuf, (current_cpu, pc, "sfmt_cmpi", "src1 0x%x", 'x', f_src1, "src2 0x%x", 'x', f_src2, (char *) 0));

#if WITH_PROFILE_MODEL_P
  /* Record the fields for profiling.  */
  if (PROFILE_MODEL_P (current_cpu))
    {
      FLD (in_src1) = f_src1;
      FLD (in_src2) = f_src2;
    }
#endif
#undef FLD
    return idesc;
  }

 extract_sfmt_cmpi1:
  {
    const IDESC *idesc = &i960base_insn_data[itype];
    CGEN_INSN_INT insn = base_insn;
#define FLD(f) abuf->fields.sfmt_emul1.f
    UINT f_src2;
    UINT f_src1;

    f_src2 = EXTRACT_MSB0_UINT (insn, 32, 13, 5);
    f_src1 = EXTRACT_MSB0_UINT (insn, 32, 27, 5);

  /* Record the fields for the semantic handler.  */
  FLD (f_src1) = f_src1;
  FLD (i_src2) = & CPU (h_gr)[f_src2];
  TRACE_EXTRACT (current_cpu, abuf, (current_cpu, pc, "sfmt_cmpi1", "f_src1 0x%x", 'x', f_src1, "src2 0x%x", 'x', f_src2, (char *) 0));

#if WITH_PROFILE_MODEL_P
  /* Record the fields for profiling.  */
  if (PROFILE_MODEL_P (current_cpu))
    {
      FLD (in_src2) = f_src2;
    }
#endif
#undef FLD
    return idesc;
  }

 extract_sfmt_cmpi2:
  {
    const IDESC *idesc = &i960base_insn_data[itype];
    CGEN_INSN_INT insn = base_insn;
#define FLD(f) abuf->fields.sfmt_emul2.f
    UINT f_src2;
    UINT f_src1;

    f_src2 = EXTRACT_MSB0_UINT (insn, 32, 13, 5);
    f_src1 = EXTRACT_MSB0_UINT (insn, 32, 27, 5);

  /* Record the fields for the semantic handler.  */
  FLD (f_src2) = f_src2;
  FLD (i_src1) = & CPU (h_gr)[f_src1];
  TRACE_EXTRACT (current_cpu, abuf, (current_cpu, pc, "sfmt_cmpi2", "f_src2 0x%x", 'x', f_src2, "src1 0x%x", 'x', f_src1, (char *) 0));

#if WITH_PROFILE_MODEL_P
  /* Record the fields for profiling.  */
  if (PROFILE_MODEL_P (current_cpu))
    {
      FLD (in_src1) = f_src1;
    }
#endif
#undef FLD
    return idesc;
  }

 extract_sfmt_cmpi3:
  {
    const IDESC *idesc = &i960base_insn_data[itype];
    CGEN_INSN_INT insn = base_insn;
#define FLD(f) abuf->fields.sfmt_emul3.f
    UINT f_src2;
    UINT f_src1;

    f_src2 = EXTRACT_MSB0_UINT (insn, 32, 13, 5);
    f_src1 = EXTRACT_MSB0_UINT (insn, 32, 27, 5);

  /* Record the fields for the semantic handler.  */
  FLD (f_src1) = f_src1;
  FLD (f_src2) = f_src2;
  TRACE_EXTRACT (current_cpu, abuf, (current_cpu, pc, "sfmt_cmpi3", "f_src1 0x%x", 'x', f_src1, "f_src2 0x%x", 'x', f_src2, (char *) 0));

#if WITH_PROFILE_MODEL_P
  /* Record the fields for profiling.  */
  if (PROFILE_MODEL_P (current_cpu))
    {
    }
#endif
#undef FLD
    return idesc;
  }

 extract_sfmt_cmpo:
  {
    const IDESC *idesc = &i960base_insn_data[itype];
    CGEN_INSN_INT insn = base_insn;
#define FLD(f) abuf->fields.sfmt_emul.f
    UINT f_src2;
    UINT f_src1;

    f_src2 = EXTRACT_MSB0_UINT (insn, 32, 13, 5);
    f_src1 = EXTRACT_MSB0_UINT (insn, 32, 27, 5);

  /* Record the fields for the semantic handler.  */
  FLD (i_src1) = & CPU (h_gr)[f_src1];
  FLD (i_src2) = & CPU (h_gr)[f_src2];
  TRACE_EXTRACT (current_cpu, abuf, (current_cpu, pc, "sfmt_cmpo", "src1 0x%x", 'x', f_src1, "src2 0x%x", 'x', f_src2, (char *) 0));

#if WITH_PROFILE_MODEL_P
  /* Record the fields for profiling.  */
  if (PROFILE_MODEL_P (current_cpu))
    {
      FLD (in_src1) = f_src1;
      FLD (in_src2) = f_src2;
    }
#endif
#undef FLD
    return idesc;
  }

 extract_sfmt_cmpo1:
  {
    const IDESC *idesc = &i960base_insn_data[itype];
    CGEN_INSN_INT insn = base_insn;
#define FLD(f) abuf->fields.sfmt_emul1.f
    UINT f_src2;
    UINT f_src1;

    f_src2 = EXTRACT_MSB0_UINT (insn, 32, 13, 5);
    f_src1 = EXTRACT_MSB0_UINT (insn, 32, 27, 5);

  /* Record the fields for the semantic handler.  */
  FLD (f_src1) = f_src1;
  FLD (i_src2) = & CPU (h_gr)[f_src2];
  TRACE_EXTRACT (current_cpu, abuf, (current_cpu, pc, "sfmt_cmpo1", "f_src1 0x%x", 'x', f_src1, "src2 0x%x", 'x', f_src2, (char *) 0));

#if WITH_PROFILE_MODEL_P
  /* Record the fields for profiling.  */
  if (PROFILE_MODEL_P (current_cpu))
    {
      FLD (in_src2) = f_src2;
    }
#endif
#undef FLD
    return idesc;
  }

 extract_sfmt_cmpo2:
  {
    const IDESC *idesc = &i960base_insn_data[itype];
    CGEN_INSN_INT insn = base_insn;
#define FLD(f) abuf->fields.sfmt_emul2.f
    UINT f_src2;
    UINT f_src1;

    f_src2 = EXTRACT_MSB0_UINT (insn, 32, 13, 5);
    f_src1 = EXTRACT_MSB0_UINT (insn, 32, 27, 5);

  /* Record the fields for the semantic handler.  */
  FLD (f_src2) = f_src2;
  FLD (i_src1) = & CPU (h_gr)[f_src1];
  TRACE_EXTRACT (current_cpu, abuf, (current_cpu, pc, "sfmt_cmpo2", "f_src2 0x%x", 'x', f_src2, "src1 0x%x", 'x', f_src1, (char *) 0));

#if WITH_PROFILE_MODEL_P
  /* Record the fields for profiling.  */
  if (PROFILE_MODEL_P (current_cpu))
    {
      FLD (in_src1) = f_src1;
    }
#endif
#undef FLD
    return idesc;
  }

 extract_sfmt_cmpo3:
  {
    const IDESC *idesc = &i960base_insn_data[itype];
    CGEN_INSN_INT insn = base_insn;
#define FLD(f) abuf->fields.sfmt_emul3.f
    UINT f_src2;
    UINT f_src1;

    f_src2 = EXTRACT_MSB0_UINT (insn, 32, 13, 5);
    f_src1 = EXTRACT_MSB0_UINT (insn, 32, 27, 5);

  /* Record the fields for the semantic handler.  */
  FLD (f_src1) = f_src1;
  FLD (f_src2) = f_src2;
  TRACE_EXTRACT (current_cpu, abuf, (current_cpu, pc, "sfmt_cmpo3", "f_src1 0x%x", 'x', f_src1, "f_src2 0x%x", 'x', f_src2, (char *) 0));

#if WITH_PROFILE_MODEL_P
  /* Record the fields for profiling.  */
  if (PROFILE_MODEL_P (current_cpu))
    {
    }
#endif
#undef FLD
    return idesc;
  }

 extract_sfmt_testno_reg:
  {
    const IDESC *idesc = &i960base_insn_data[itype];
    CGEN_INSN_INT insn = base_insn;
#define FLD(f) abuf->fields.sfmt_testno_reg.f
    UINT f_br_src1;

    f_br_src1 = EXTRACT_MSB0_UINT (insn, 32, 8, 5);

  /* Record the fields for the semantic handler.  */
  FLD (i_br_src1) = & CPU (h_gr)[f_br_src1];
  TRACE_EXTRACT (current_cpu, abuf, (current_cpu, pc, "sfmt_testno_reg", "br_src1 0x%x", 'x', f_br_src1, (char *) 0));

#if WITH_PROFILE_MODEL_P
  /* Record the fields for profiling.  */
  if (PROFILE_MODEL_P (current_cpu))
    {
      FLD (out_br_src1) = f_br_src1;
    }
#endif
#undef FLD
    return idesc;
  }

 extract_sfmt_bno:
  {
    const IDESC *idesc = &i960base_insn_data[itype];
    CGEN_INSN_INT insn = base_insn;
#define FLD(f) abuf->fields.sfmt_bno.f
    SI f_ctrl_disp;

    f_ctrl_disp = ((((EXTRACT_MSB0_INT (insn, 32, 8, 22)) << (2))) + (pc));

  /* Record the fields for the semantic handler.  */
  FLD (i_ctrl_disp) = f_ctrl_disp;
  TRACE_EXTRACT (current_cpu, abuf, (current_cpu, pc, "sfmt_bno", "ctrl_disp 0x%x", 'x', f_ctrl_disp, (char *) 0));

#if WITH_PROFILE_MODEL_P
  /* Record the fields for profiling.  */
  if (PROFILE_MODEL_P (current_cpu))
    {
    }
#endif
#undef FLD
    return idesc;
  }

 extract_sfmt_b:
  {
    const IDESC *idesc = &i960base_insn_data[itype];
    CGEN_INSN_INT insn = base_insn;
#define FLD(f) abuf->fields.sfmt_bno.f
    SI f_ctrl_disp;

    f_ctrl_disp = ((((EXTRACT_MSB0_INT (insn, 32, 8, 22)) << (2))) + (pc));

  /* Record the fields for the semantic handler.  */
  FLD (i_ctrl_disp) = f_ctrl_disp;
  TRACE_EXTRACT (current_cpu, abuf, (current_cpu, pc, "sfmt_b", "ctrl_disp 0x%x", 'x', f_ctrl_disp, (char *) 0));

#if WITH_PROFILE_MODEL_P
  /* Record the fields for profiling.  */
  if (PROFILE_MODEL_P (current_cpu))
    {
    }
#endif
#undef FLD
    return idesc;
  }

 extract_sfmt_bx_indirect_offset:
  {
    const IDESC *idesc = &i960base_insn_data[itype];
    CGEN_INSN_INT insn = base_insn;
#define FLD(f) abuf->fields.sfmt_stq_indirect_offset.f
    UINT f_abase;
    UINT f_offset;

    f_abase = EXTRACT_MSB0_UINT (insn, 32, 13, 5);
    f_offset = EXTRACT_MSB0_UINT (insn, 32, 20, 12);

  /* Record the fields for the semantic handler.  */
  FLD (f_offset) = f_offset;
  FLD (i_abase) = & CPU (h_gr)[f_abase];
  TRACE_EXTRACT (current_cpu, abuf, (current_cpu, pc, "sfmt_bx_indirect_offset", "f_offset 0x%x", 'x', f_offset, "abase 0x%x", 'x', f_abase, (char *) 0));

#if WITH_PROFILE_MODEL_P
  /* Record the fields for profiling.  */
  if (PROFILE_MODEL_P (current_cpu))
    {
      FLD (in_abase) = f_abase;
    }
#endif
#undef FLD
    return idesc;
  }

 extract_sfmt_bx_indirect:
  {
    const IDESC *idesc = &i960base_insn_data[itype];
    CGEN_INSN_INT insn = base_insn;
#define FLD(f) abuf->fields.sfmt_stq_indirect_offset.f
    UINT f_abase;

    f_abase = EXTRACT_MSB0_UINT (insn, 32, 13, 5);

  /* Record the fields for the semantic handler.  */
  FLD (i_abase) = & CPU (h_gr)[f_abase];
  TRACE_EXTRACT (current_cpu, abuf, (current_cpu, pc, "sfmt_bx_indirect", "abase 0x%x", 'x', f_abase, (char *) 0));

#if WITH_PROFILE_MODEL_P
  /* Record the fields for profiling.  */
  if (PROFILE_MODEL_P (current_cpu))
    {
      FLD (in_abase) = f_abase;
    }
#endif
#undef FLD
    return idesc;
  }

 extract_sfmt_bx_indirect_index:
  {
    const IDESC *idesc = &i960base_insn_data[itype];
    CGEN_INSN_INT insn = base_insn;
#define FLD(f) abuf->fields.sfmt_stq_indirect_index_disp.f
    UINT f_abase;
    UINT f_scale;
    UINT f_index;

    f_abase = EXTRACT_MSB0_UINT (insn, 32, 13, 5);
    f_scale = EXTRACT_MSB0_UINT (insn, 32, 22, 3);
    f_index = EXTRACT_MSB0_UINT (insn, 32, 27, 5);

  /* Record the fields for the semantic handler.  */
  FLD (f_scale) = f_scale;
  FLD (i_abase) = & CPU (h_gr)[f_abase];
  FLD (i_index) = & CPU (h_gr)[f_index];
  TRACE_EXTRACT (current_cpu, abuf, (current_cpu, pc, "sfmt_bx_indirect_index", "f_scale 0x%x", 'x', f_scale, "abase 0x%x", 'x', f_abase, "index 0x%x", 'x', f_index, (char *) 0));

#if WITH_PROFILE_MODEL_P
  /* Record the fields for profiling.  */
  if (PROFILE_MODEL_P (current_cpu))
    {
      FLD (in_abase) = f_abase;
      FLD (in_index) = f_index;
    }
#endif
#undef FLD
    return idesc;
  }

 extract_sfmt_bx_disp:
  {
    const IDESC *idesc = &i960base_insn_data[itype];
    CGEN_INSN_INT insn = base_insn;
#define FLD(f) abuf->fields.sfmt_stq_indirect_index_disp.f
    UINT f_optdisp;
    /* Contents of trailing part of insn.  */
    UINT word_1;

  word_1 = GETIMEMUSI (current_cpu, pc + 4);
    f_optdisp = (0|(EXTRACT_MSB0_UINT (word_1, 32, 0, 32) << 0));

  /* Record the fields for the semantic handler.  */
  FLD (f_optdisp) = f_optdisp;
  TRACE_EXTRACT (current_cpu, abuf, (current_cpu, pc, "sfmt_bx_disp", "f_optdisp 0x%x", 'x', f_optdisp, (char *) 0));

#if WITH_PROFILE_MODEL_P
  /* Record the fields for profiling.  */
  if (PROFILE_MODEL_P (current_cpu))
    {
    }
#endif
#undef FLD
    return idesc;
  }

 extract_sfmt_bx_indirect_disp:
  {
    const IDESC *idesc = &i960base_insn_data[itype];
    CGEN_INSN_INT insn = base_insn;
#define FLD(f) abuf->fields.sfmt_stq_indirect_index_disp.f
    UINT f_optdisp;
    UINT f_abase;
    /* Contents of trailing part of insn.  */
    UINT word_1;

  word_1 = GETIMEMUSI (current_cpu, pc + 4);
    f_optdisp = (0|(EXTRACT_MSB0_UINT (word_1, 32, 0, 32) << 0));
    f_abase = EXTRACT_MSB0_UINT (insn, 32, 13, 5);

  /* Record the fields for the semantic handler.  */
  FLD (f_optdisp) = f_optdisp;
  FLD (i_abase) = & CPU (h_gr)[f_abase];
  TRACE_EXTRACT (current_cpu, abuf, (current_cpu, pc, "sfmt_bx_indirect_disp", "f_optdisp 0x%x", 'x', f_optdisp, "abase 0x%x", 'x', f_abase, (char *) 0));

#if WITH_PROFILE_MODEL_P
  /* Record the fields for profiling.  */
  if (PROFILE_MODEL_P (current_cpu))
    {
      FLD (in_abase) = f_abase;
    }
#endif
#undef FLD
    return idesc;
  }

 extract_sfmt_callx_disp:
  {
    const IDESC *idesc = &i960base_insn_data[itype];
    CGEN_INSN_INT insn = base_insn;
#define FLD(f) abuf->fields.sfmt_callx_disp.f
    UINT f_optdisp;
    /* Contents of trailing part of insn.  */
    UINT word_1;

  word_1 = GETIMEMUSI (current_cpu, pc + 4);
    f_optdisp = (0|(EXTRACT_MSB0_UINT (word_1, 32, 0, 32) << 0));

  /* Record the fields for the semantic handler.  */
  FLD (f_optdisp) = f_optdisp;
  TRACE_EXTRACT (current_cpu, abuf, (current_cpu, pc, "sfmt_callx_disp", "f_optdisp 0x%x", 'x', f_optdisp, (char *) 0));

#if WITH_PROFILE_MODEL_P
  /* Record the fields for profiling.  */
  if (PROFILE_MODEL_P (current_cpu))
    {
      FLD (in_h_gr_0) = 0;
      FLD (in_h_gr_1) = 1;
      FLD (in_h_gr_10) = 10;
      FLD (in_h_gr_11) = 11;
      FLD (in_h_gr_12) = 12;
      FLD (in_h_gr_13) = 13;
      FLD (in_h_gr_14) = 14;
      FLD (in_h_gr_15) = 15;
      FLD (in_h_gr_2) = 2;
      FLD (in_h_gr_3) = 3;
      FLD (in_h_gr_31) = 31;
      FLD (in_h_gr_4) = 4;
      FLD (in_h_gr_5) = 5;
      FLD (in_h_gr_6) = 6;
      FLD (in_h_gr_7) = 7;
      FLD (in_h_gr_8) = 8;
      FLD (in_h_gr_9) = 9;
      FLD (out_h_gr_0) = 0;
      FLD (out_h_gr_1) = 1;
      FLD (out_h_gr_10) = 10;
      FLD (out_h_gr_11) = 11;
      FLD (out_h_gr_12) = 12;
      FLD (out_h_gr_13) = 13;
      FLD (out_h_gr_14) = 14;
      FLD (out_h_gr_15) = 15;
      FLD (out_h_gr_2) = 2;
      FLD (out_h_gr_3) = 3;
      FLD (out_h_gr_31) = 31;
      FLD (out_h_gr_4) = 4;
      FLD (out_h_gr_5) = 5;
      FLD (out_h_gr_6) = 6;
      FLD (out_h_gr_7) = 7;
      FLD (out_h_gr_8) = 8;
      FLD (out_h_gr_9) = 9;
    }
#endif
#undef FLD
    return idesc;
  }

 extract_sfmt_callx_indirect:
  {
    const IDESC *idesc = &i960base_insn_data[itype];
    CGEN_INSN_INT insn = base_insn;
#define FLD(f) abuf->fields.sfmt_callx_indirect_offset.f
    UINT f_abase;

    f_abase = EXTRACT_MSB0_UINT (insn, 32, 13, 5);

  /* Record the fields for the semantic handler.  */
  FLD (i_abase) = & CPU (h_gr)[f_abase];
  TRACE_EXTRACT (current_cpu, abuf, (current_cpu, pc, "sfmt_callx_indirect", "abase 0x%x", 'x', f_abase, (char *) 0));

#if WITH_PROFILE_MODEL_P
  /* Record the fields for profiling.  */
  if (PROFILE_MODEL_P (current_cpu))
    {
      FLD (in_abase) = f_abase;
      FLD (in_h_gr_0) = 0;
      FLD (in_h_gr_1) = 1;
      FLD (in_h_gr_10) = 10;
      FLD (in_h_gr_11) = 11;
      FLD (in_h_gr_12) = 12;
      FLD (in_h_gr_13) = 13;
      FLD (in_h_gr_14) = 14;
      FLD (in_h_gr_15) = 15;
      FLD (in_h_gr_2) = 2;
      FLD (in_h_gr_3) = 3;
      FLD (in_h_gr_31) = 31;
      FLD (in_h_gr_4) = 4;
      FLD (in_h_gr_5) = 5;
      FLD (in_h_gr_6) = 6;
      FLD (in_h_gr_7) = 7;
      FLD (in_h_gr_8) = 8;
      FLD (in_h_gr_9) = 9;
      FLD (out_h_gr_0) = 0;
      FLD (out_h_gr_1) = 1;
      FLD (out_h_gr_10) = 10;
      FLD (out_h_gr_11) = 11;
      FLD (out_h_gr_12) = 12;
      FLD (out_h_gr_13) = 13;
      FLD (out_h_gr_14) = 14;
      FLD (out_h_gr_15) = 15;
      FLD (out_h_gr_2) = 2;
      FLD (out_h_gr_3) = 3;
      FLD (out_h_gr_31) = 31;
      FLD (out_h_gr_4) = 4;
      FLD (out_h_gr_5) = 5;
      FLD (out_h_gr_6) = 6;
      FLD (out_h_gr_7) = 7;
      FLD (out_h_gr_8) = 8;
      FLD (out_h_gr_9) = 9;
    }
#endif
#undef FLD
    return idesc;
  }

 extract_sfmt_callx_indirect_offset:
  {
    const IDESC *idesc = &i960base_insn_data[itype];
    CGEN_INSN_INT insn = base_insn;
#define FLD(f) abuf->fields.sfmt_callx_indirect_offset.f
    UINT f_abase;
    UINT f_offset;

    f_abase = EXTRACT_MSB0_UINT (insn, 32, 13, 5);
    f_offset = EXTRACT_MSB0_UINT (insn, 32, 20, 12);

  /* Record the fields for the semantic handler.  */
  FLD (f_offset) = f_offset;
  FLD (i_abase) = & CPU (h_gr)[f_abase];
  TRACE_EXTRACT (current_cpu, abuf, (current_cpu, pc, "sfmt_callx_indirect_offset", "f_offset 0x%x", 'x', f_offset, "abase 0x%x", 'x', f_abase, (char *) 0));

#if WITH_PROFILE_MODEL_P
  /* Record the fields for profiling.  */
  if (PROFILE_MODEL_P (current_cpu))
    {
      FLD (in_abase) = f_abase;
      FLD (in_h_gr_0) = 0;
      FLD (in_h_gr_1) = 1;
      FLD (in_h_gr_10) = 10;
      FLD (in_h_gr_11) = 11;
      FLD (in_h_gr_12) = 12;
      FLD (in_h_gr_13) = 13;
      FLD (in_h_gr_14) = 14;
      FLD (in_h_gr_15) = 15;
      FLD (in_h_gr_2) = 2;
      FLD (in_h_gr_3) = 3;
      FLD (in_h_gr_31) = 31;
      FLD (in_h_gr_4) = 4;
      FLD (in_h_gr_5) = 5;
      FLD (in_h_gr_6) = 6;
      FLD (in_h_gr_7) = 7;
      FLD (in_h_gr_8) = 8;
      FLD (in_h_gr_9) = 9;
      FLD (out_h_gr_0) = 0;
      FLD (out_h_gr_1) = 1;
      FLD (out_h_gr_10) = 10;
      FLD (out_h_gr_11) = 11;
      FLD (out_h_gr_12) = 12;
      FLD (out_h_gr_13) = 13;
      FLD (out_h_gr_14) = 14;
      FLD (out_h_gr_15) = 15;
      FLD (out_h_gr_2) = 2;
      FLD (out_h_gr_3) = 3;
      FLD (out_h_gr_31) = 31;
      FLD (out_h_gr_4) = 4;
      FLD (out_h_gr_5) = 5;
      FLD (out_h_gr_6) = 6;
      FLD (out_h_gr_7) = 7;
      FLD (out_h_gr_8) = 8;
      FLD (out_h_gr_9) = 9;
    }
#endif
#undef FLD
    return idesc;
  }

 extract_sfmt_ret:
  {
    const IDESC *idesc = &i960base_insn_data[itype];
    CGEN_INSN_INT insn = base_insn;
#define FLD(f) abuf->fields.sfmt_callx_disp.f


  /* Record the fields for the semantic handler.  */
  TRACE_EXTRACT (current_cpu, abuf, (current_cpu, pc, "sfmt_ret", (char *) 0));

#if WITH_PROFILE_MODEL_P
  /* Record the fields for profiling.  */
  if (PROFILE_MODEL_P (current_cpu))
    {
      FLD (in_h_gr_0) = 0;
      FLD (in_h_gr_2) = 2;
      FLD (in_h_gr_31) = 31;
      FLD (out_h_gr_0) = 0;
      FLD (out_h_gr_1) = 1;
      FLD (out_h_gr_10) = 10;
      FLD (out_h_gr_11) = 11;
      FLD (out_h_gr_12) = 12;
      FLD (out_h_gr_13) = 13;
      FLD (out_h_gr_14) = 14;
      FLD (out_h_gr_15) = 15;
      FLD (out_h_gr_2) = 2;
      FLD (out_h_gr_3) = 3;
      FLD (out_h_gr_31) = 31;
      FLD (out_h_gr_4) = 4;
      FLD (out_h_gr_5) = 5;
      FLD (out_h_gr_6) = 6;
      FLD (out_h_gr_7) = 7;
      FLD (out_h_gr_8) = 8;
      FLD (out_h_gr_9) = 9;
    }
#endif
#undef FLD
    return idesc;
  }

 extract_sfmt_calls:
  {
    const IDESC *idesc = &i960base_insn_data[itype];
    CGEN_INSN_INT insn = base_insn;
#define FLD(f) abuf->fields.sfmt_emul2.f
    UINT f_src1;

    f_src1 = EXTRACT_MSB0_UINT (insn, 32, 27, 5);

  /* Record the fields for the semantic handler.  */
  FLD (i_src1) = & CPU (h_gr)[f_src1];
  TRACE_EXTRACT (current_cpu, abuf, (current_cpu, pc, "sfmt_calls", "src1 0x%x", 'x', f_src1, (char *) 0));

#if WITH_PROFILE_MODEL_P
  /* Record the fields for profiling.  */
  if (PROFILE_MODEL_P (current_cpu))
    {
      FLD (in_src1) = f_src1;
    }
#endif
#undef FLD
    return idesc;
  }

 extract_sfmt_fmark:
  {
    const IDESC *idesc = &i960base_insn_data[itype];
    CGEN_INSN_INT insn = base_insn;
#define FLD(f) abuf->fields.fmt_empty.f


  /* Record the fields for the semantic handler.  */
  TRACE_EXTRACT (current_cpu, abuf, (current_cpu, pc, "sfmt_fmark", (char *) 0));

#if WITH_PROFILE_MODEL_P
  /* Record the fields for profiling.  */
  if (PROFILE_MODEL_P (current_cpu))
    {
    }
#endif
#undef FLD
    return idesc;
  }

 extract_sfmt_flushreg:
  {
    const IDESC *idesc = &i960base_insn_data[itype];
    CGEN_INSN_INT insn = base_insn;
#define FLD(f) abuf->fields.fmt_empty.f


  /* Record the fields for the semantic handler.  */
  TRACE_EXTRACT (current_cpu, abuf, (current_cpu, pc, "sfmt_flushreg", (char *) 0));

#undef FLD
    return idesc;
  }

}
