(* COMPILE-CMD: gettext2.cmp *)

program GetText2Test;

uses GPC, Intl;

var
  s: TString;
  OK: Boolean = True;
  n: Integer = 0;

procedure Check (const s, e: String);
begin
  Inc (n);
  if s <> e then
    begin
      WriteLn ('failed ', n, ': ', s, ' (', e, ')');
      OK := False
    end
end;

begin
{$ifdef DJGPP}
  s := SetLocale (LC_MESSAGES, '');
  if s <> 'C' then
    begin
      WriteLn ('SKIPPED: could not set locale `''');
{$else}
  s := SetLocale (LC_MESSAGES, 'de_DE');
  if s <> 'de_DE' then
    begin
      WriteLn ('SKIPPED: could not set locale `de_DE''');
{$endif}
      Halt
    end;
  Check (BindTextDomain ('gettext2test', 'tmplocale'), 'tmplocale');
  Check (TextDomain ('gettext2test'), 'gettext2test');
  Check (GetText ('foobar'), 'bazqux');
  if OK then WriteLn ('OK')
end.
