/* dispatch.c -- main dispatch routine
   Copyright (C) 1999-2000 Wojciech Galazka

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software Foundation,
   Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  */

#include "lfnsrv.h"
#include "lfnsrv.rc"

static PVOID pSFT = NULL;

VOID	LFNDispatch(VOID)
{
	WORD  regAX = HIWORD(getEAX());
	WORD  regAH = HIBYTE(regAX);
	WORD result = 0;
	PROLOG(Dispatch);

	switch (regAH)
	{
		case GET_DISK_FREE_SPACE:
		{
			BYTE nDrive = getDL();				
			WORD wSectorsPerCluster;					
			WORD wBytesPerSector;
			WORD wFreeClusters;
			WORD wTotalClusters;
			result = process_get_disk_free_space(
					nDrive,		
					&wSectorsPerCluster,
					&wBytesPerSector,    
					&wFreeClusters,     
					&wTotalClusters);   
			if (result)
				setAX(0xFFFF);
			else {
				setAX(wSectorsPerCluster);
				setCX(wBytesPerSector);    
				setBX(wFreeClusters);     
				setDX(wTotalClusters);    
			}
			goto safe_exit;
		}
		case SET_CURRENT_DIRECTORY:
		{
			regAX = LONG_SET_CURRENT_DIRECTORY;
			break;
		}
		default:
			break;
	}

	switch (regAX)
	{
		case LFNSRV_API:
{
	WORD wSubFun = getBX();
	switch (wSubFun)
	{
		case LFNSRV_GET_VERSION_INFO:
			setBX(VER_PRODUCTBUILD);
			break;  			
		case LFNSRV_SET_SFT_INFO:
		{
		        ULONG SFTAddress = MAKEADDRESS(getES(), getDI());
			pSFT = (PVOID) GetVDMPointer(SFTAddress, SFT_SIZE, FALSE); 
			FreeVDMPointer(SFTAddress, SFT_SIZE, pSFT, FALSE);
			if (SFTAddress == 0)
				result = ERROR_INVALID_DATA;
			else
				result = ERROR_SUCCESS;
			break;	
		}
		default:
			result = ERROR_INVALID_FUNCTION;
			break;	
	}

	if (result) {
		setCF(1);		
		setAX(result);
	} else {
		setCF(0);			
		setAX(0);
	}
	break;	
}
		case W95_GET_COMPRESSED_FILE_SIZE:
{
	PCHAR lpPathName;
	DWORD dwSize;
	ULONG Address = MAKEADDRESS(getDS(), getDX());
	lpPathName = (PCHAR) GetVDMPointer(Address, MAX_PATHNAME_SIZE, FALSE);
	result = process_get_compressed_file_size(lpPathName, &dwSize);
	FreeVDMPointer(Address,MAX_PATHNAME_SIZE, lpPathName, FALSE);
	if (result) {
		setCF(1);		
		setAX(result);
	} else {
		setCF(0);			
		setAX(LOWORD(dwSize));
		setDX(HIWORD(dwSize));
	}
	break;  			
}
		case W95_EXT_LENGTH_FILENAME_OPERATIONS:
{
#define MAGIC_BP_VALUE			0x5053
#define	E_F_O_CREATE_DIRECTORY		0x39
#define E_F_O_RENAME_FILE       	0x56
	BYTE nCall = getCL();
	if (getBP() != MAGIC_BP_VALUE)
		break;
	if (nCall == E_F_O_CREATE_DIRECTORY)
		goto jump_from_e_f_create_directory;	
	if (nCall == E_F_O_RENAME_FILE)
		goto jump_from_e_f_rename_file;	
	break;
}
		case GET_LAST_ACCESS_DATE:	
		case GET_CREATION_DATE:	   
{
	WORD nDate;
	WORD nTime;
	WORD nHandle = getBX();
/*!*/	ULONG pPDB   = getECX(); 
/*!*/   ULONG JFTAddress = MAKEADDRESS(getES(), getDI());
	PVOID pJFT = (PVOID) GetVDMPointer(JFTAddress, JFT_SIZE, FALSE); 
	result = process_get_date_time(
			nHandle, pPDB, &pSFT, &pJFT,
			regAX, &nDate, &nTime);
	FreeVDMPointer(JFTAddress, JFT_SIZE, pJFT, FALSE);
	if (result) {
		setCF(1);		
		setAX(result);
	} else {
		setCF(0);			
		setAX(0);
		setDX(nDate);
		setCX(nTime);
		setBX(0);
	}
	break;  			
}
		case SET_LAST_ACCESS_DATE:	
		case SET_CREATION_DATE:	
{
	WORD nHandle = getBX();
	WORD nDate   = getDX();
	WORD nTime   = getCX();
/*!*/	ULONG pPDB   = getECX() & 0xffff0000; 
/*!*/   ULONG JFTAddress = MAKEADDRESS(getES(), getDI());
	PVOID pJFT = (PVOID) GetVDMPointer(JFTAddress, JFT_SIZE, FALSE); 
	result = process_set_date_time(
			nHandle, pPDB, &pSFT, &pJFT,
			regAX, nDate, nTime);
	FreeVDMPointer(JFTAddress, JFT_SIZE, pJFT, FALSE);
	if (result) {
		setCF(1);		
		setAX(result);
	} else {
		setCF(0);			
		setAX(0);
	}
	break;  			
}
jump_from_e_f_create_directory:
		case LONG_CREATE_DIRECTORY      :
{
	PCHAR lpPathName;
	ULONG Address = MAKEADDRESS(getDS(), getDX());
	lpPathName = (PCHAR) GetVDMPointer(Address, MAX_PATHNAME_SIZE, FALSE);
	result = process_create_directory(lpPathName);
	FreeVDMPointer(Address,MAX_PATHNAME_SIZE, lpPathName, FALSE);
	if (result) {
		setCF(1);		
		setAX(result);
	} else {
		setCF(0);			
		setAX(0);
	}
	break;  			
}
		case LONG_REMOVE_DIRECTORY      :
{
	PCHAR lpPathName;
	ULONG Address = MAKEADDRESS(getDS(), getDX());
	lpPathName = (PCHAR) GetVDMPointer(Address, MAX_PATHNAME_SIZE, FALSE);
	result = process_remove_directory(lpPathName);
	FreeVDMPointer(Address,MAX_PATHNAME_SIZE, lpPathName, FALSE);
	if (result) {
		setCF(1);		
		setAX(result);
	} else {
		setCF(0);			
		setAX(0);
	}
	break;  			
}
		case LONG_SET_CURRENT_DIRECTORY :
{
	PCHAR lpPathName;
	ULONG Address = MAKEADDRESS(getDS(), getDX());
	lpPathName = (PCHAR) GetVDMPointer(Address, MAX_PATHNAME_SIZE, FALSE);
	result = process_set_current_directory(lpPathName);
	FreeVDMPointer(Address,MAX_PATHNAME_SIZE, lpPathName, FALSE);
	if (result) {
		setCF(1);		
		setAX(result);
	} else {
		setCF(0);			
		setAX(0);
	}
	break;  			
}
		case LONG_DELETE_FILE           :
{
	PCHAR lpPathName;
	WORD wWildcard          = getSI();
	BYTE nSearchAttr	= getCL();  
	BYTE nMustMatchAttr	= getCH();
	ULONG Address = MAKEADDRESS(getDS(), getDX());
	lpPathName = (PCHAR) GetVDMPointer(Address, MAX_PATHNAME_SIZE, FALSE);
	result = process_delete_file(lpPathName, wWildcard, nSearchAttr, nMustMatchAttr);
	FreeVDMPointer(Address,MAX_PATHNAME_SIZE, lpPathName, FALSE);
	if (result) {
		setCF(1);		
		setAX(result);
	} else {
		setCF(0);			
		setAX(0);
	}
	break;  				
}
		case LONG_GET_SET_FILE_ATTR     :
{
	PCHAR lpPathName;
	BYTE nAction = getBL();
	WORD nDosDate ;
	WORD nDosTime ; 
	WORD nDosMilisec ;
	WORD nFileAttr ;
	DWORD nFileSize ;
	ULONG Address;	

	switch (nAction)
	{
		case LONG_GET_SET_FILE_ATTR_FILE_PHYS_SIZE     :
		case LONG_GET_SET_FILE_ATTR_GET_ATTR		:
		case LONG_GET_SET_FILE_ATTR_GET_WRITE_DATE      :
		case LONG_GET_SET_FILE_ATTR_GET_ACCESS_DATE     :
		case LONG_GET_SET_FILE_ATTR_GET_CREATION_DATE   :
			break;
		case LONG_GET_SET_FILE_ATTR_SET_ATTR            :
			nFileAttr = getCX();
			break;
		case LONG_GET_SET_FILE_ATTR_SET_WRITE_DATE      :
			nDosDate = getDI();
			nDosTime = getCX();
			break;
		case LONG_GET_SET_FILE_ATTR_SET_ACCESS_DATE     :
			nDosDate = getDI();
			nDosTime = getCX();
			break;
		case LONG_GET_SET_FILE_ATTR_SET_CREATION_DATE   :
			nDosDate = getDI();
			nDosTime = getCX();
			nDosMilisec = getSI();
			break;
                default:
			setCF(1);		
			setAX(ERROR_INVALID_FUNCTION);
			DBGVALUE(regAX, "%x");
			DBGVALUE(result, "%d");
			EPILOG(Dispatch,FALSE);
			return;	
	}		
	Address = MAKEADDRESS(getDS(), getDX());
	lpPathName = (PCHAR) GetVDMPointer(Address, MAX_PATHNAME_SIZE, FALSE);
	result = process_get_set_file_attr(lpPathName, nAction, 
				&nFileAttr, &nFileSize,
				&nDosDate,  &nDosTime, &nDosMilisec);
	FreeVDMPointer(Address,MAX_PATHNAME_SIZE, lpPathName, FALSE);
	if (result) {
		setCF(1);		
		setAX(result);
	} else {
		setCF(0);				
		setAX(0);
		switch (nAction)
		{
			case LONG_GET_SET_FILE_ATTR_FILE_PHYS_SIZE     :
				setAX(LOWORD(nFileSize));
				setDX(HIWORD(nFileSize));
				break;
			case LONG_GET_SET_FILE_ATTR_GET_ATTR            :
				setCX(nFileAttr);
				break;
			case LONG_GET_SET_FILE_ATTR_GET_WRITE_DATE      :
				setDI(nDosDate);
				setCX(nDosTime);
				break;
			case LONG_GET_SET_FILE_ATTR_GET_ACCESS_DATE     :
				setDI(nDosDate);
				setCX(nDosTime);
				break;
			case LONG_GET_SET_FILE_ATTR_GET_CREATION_DATE   :
				setDI(nDosDate);
				setCX(nDosTime);
				setSI(nDosMilisec);
				break;
	                default:
				break;
		}
	}		
	break;  
}
		case LONG_GET_CURRENT_DIRECTORY :
{
	PCHAR lpPathName;
	BYTE nDrive = getDL();	
	ULONG Address = MAKEADDRESS(getDS(), getSI());
	lpPathName = (PCHAR) GetVDMPointer(Address, MAX_PATHNAME_SIZE, FALSE);
	result = process_get_current_directory(lpPathName, nDrive);
	FreeVDMPointer(Address,MAX_PATHNAME_SIZE, lpPathName, FALSE);
	if (result) {
		setCF(1);		
		setAX(result);
	} else {
		setCF(0);			
		setAX(0);
	}
	break;  			
}
		case LONG_FIND_FIRST            :
{
	BYTE nSearchAttr    = getCL();		
	BYTE nMustMatchAttr = getCH();
	WORD wDateType     = getSI();
	PWIN32_FIND_DATA pFindStruct;
	BYTE nUnicode ;
	PCHAR lpPathName;
	WORD nHandle;
	ULONG WildcardAddress = MAKEADDRESS(getDS(), getDX());
	ULONG FindStructAddress = MAKEADDRESS(getES(), getDI());
	lpPathName = (PCHAR) GetVDMPointer(WildcardAddress, MAX_PATHNAME_SIZE, FALSE);
	pFindStruct = (PWIN32_FIND_DATA) GetVDMPointer(FindStructAddress, sizeof (WIN32_FIND_DATA), FALSE);
	result =	process_find_first(
		lpPathName, nSearchAttr, nMustMatchAttr,
		wDateType, pFindStruct, &nUnicode, &nHandle);
	FreeVDMPointer(WildcardAddress,MAX_PATHNAME_SIZE, lpPathName, FALSE);
	FreeVDMPointer(FindStructAddress, sizeof (WIN32_FIND_DATA), pFindStruct, FALSE);
	if (result) {
		setCF(1);		
		setAX(result);
	} else {
		setCF(0);			
		setAX(nHandle);
		setCX(nUnicode);
	}
	break;  				
}
		case LONG_FIND_NEXT             :
		case LONG_FIND_NEXT_EXT         :
{
	WORD wFind 	= getBX();
	WORD wDateType 	= getSI();
	PWIN32_FIND_DATA pFindStruct;
	BYTE nUnicode ;
	ULONG FindAddress = MAKEADDRESS(getES(), getDI());
	pFindStruct = (PWIN32_FIND_DATA) GetVDMPointer(FindAddress, sizeof (PWIN32_FIND_DATA), FALSE);
	result =	process_find_next(wFind, wDateType, pFindStruct, &nUnicode);
	FreeVDMPointer(FindAddress, sizeof (PWIN32_FIND_DATA), pFindStruct, FALSE);
	if (result) {
		setCF(1);		
		setAX(result);
	} else {
		setCF(0);			
		setAX(0);
		setCX(nUnicode);
	}
	break;  				
}
jump_from_e_f_rename_file:
		case LONG_RENAME_FILE           :
{
	PCHAR lpOldPathName;
	PCHAR lpNewPathName;
	ULONG OldPathAddress = MAKEADDRESS(getDS(), getDX());	
	ULONG NewPathAddress = MAKEADDRESS(getES(), getDI());	
	lpOldPathName = (PCHAR) GetVDMPointer(OldPathAddress, MAX_PATHNAME_SIZE, FALSE);
	lpNewPathName = (PCHAR) GetVDMPointer(NewPathAddress, MAX_PATHNAME_SIZE, FALSE);
	result =	process_rename_file(lpOldPathName,lpNewPathName);
	FreeVDMPointer(OldPathAddress,MAX_PATHNAME_SIZE, lpOldPathName, FALSE);
	FreeVDMPointer(NewPathAddress,MAX_PATHNAME_SIZE, lpNewPathName, FALSE);
	if (result) {
		setCF(1);		
		setAX(result);
	} else {
		setCF(0);			
		setAX(0);
	}
	break;  
}
		case LONG_TRUENAME              :
{
	BYTE nAction = getCL();
	BYTE nSubst  = getCH();
	PCHAR lpOldPathName;
	PCHAR lpNewPathName;
	ULONG OldPathAddress = MAKEADDRESS(getDS(), getSI());	
	ULONG NewPathAddress = MAKEADDRESS(getES(), getDI());	
	lpOldPathName = (PCHAR) GetVDMPointer(OldPathAddress, MAX_PATHNAME_SIZE, FALSE);
	lpNewPathName = (PCHAR) GetVDMPointer(NewPathAddress, MAX_PATHNAME_SIZE, FALSE);
	result =	process_truename(lpOldPathName, lpNewPathName, nAction, nSubst);
	FreeVDMPointer(OldPathAddress,MAX_PATHNAME_SIZE, lpOldPathName, FALSE);
	FreeVDMPointer(NewPathAddress,MAX_PATHNAME_SIZE, lpNewPathName, FALSE);
	if (result) {
		setCF(1);		
		setAX(result);
	} else {
		setCF(0);			
		setAX(0);
	}
	break;  
}
		case LONG_CREATE_FILE           :
		case LONG_SERVER_CREATE_FILE    :
{
	PCHAR lpPathName;
	WORD nMode    = getBX();
	WORD nAttrs   = getCX();		
	WORD nAction  = getDX();
//	WORD nAlias   = getDI();	// not used
	WORD nResult  ;
	ULONG Address = MAKEADDRESS(getDS(), getSI());
	lpPathName = (PCHAR) GetVDMPointer(Address, MAX_PATHNAME_SIZE, FALSE);
	result =	process_create_file(lpPathName, nAttrs, nAction, 
				&nResult);
	FreeVDMPointer(Address,MAX_PATHNAME_SIZE, lpPathName, FALSE);
	if (result) {
		setCF(1);		
		setAX(result);
	} else {
		// return original parameters so that DOS will open the file itself
		if (nResult == 0) {
		// operation completed, don't call AH=6C
			setAX(0x0000);		
		} else {
			setAX(0x6C00);
			setBX(nMode);
			setCX(nAttrs);
			setDX(nResult);
		}
		setCF(0);			
	}
	break;  			
}
		case LONG_GET_VOLUME_INFORMATION:
{
	VOLINFO VolInfo;
	PCHAR lpRootName;
 	PCHAR lpFsName;
	WORD nFsNameBufSize = getCX();
	ULONG lRootNameAddress = MAKEADDRESS(getDS(), getDX());
	ULONG lFsNameAddress   = MAKEADDRESS(getES(), getDI());
	lpRootName = (PCHAR) GetVDMPointer(lRootNameAddress, SMALL_BUF_SIZE, FALSE);
	lpFsName   = (PCHAR) GetVDMPointer(lFsNameAddress,   nFsNameBufSize, FALSE);                                                                            
	result = process_get_volume_information(	
			lpRootName, lpFsName, nFsNameBufSize, &VolInfo);
	FreeVDMPointer(lRootNameAddress, SMALL_BUF_SIZE, lpRootName, FALSE);
	FreeVDMPointer(lFsNameAddress,   nFsNameBufSize, lpFsName  , FALSE);
	if (result) {
		setCF(1);		
		setAX(result);
	} else {
		setCF(0);			
		setAX(0);
		setBX(VolInfo.volflags);
		setCX(VolInfo.filename_maxlen);
		setDX(VolInfo.pathname_naxlen);
	}
	break;
}
		case LONG_FIND_CLOSE            :
{
	WORD wFind = getBX();
	result = process_find_close(wFind);
	if (result) {
		setCF(1);		
		setAX(result);
	} else {
		setCF(0);			
		setAX(0);
	}
	break;  			
}
		case LONG_GET_FILE_INFORMATION  :
{
	WORD nHandle = getBX();
	ULONG pPDB   = getECX(); 

        ULONG JFTAddress = MAKEADDRESS(getES(), getDI());
	ULONG ByHandleInfoAddress = MAKEADDRESS(getDS(), getDX());

	PVOID  pJFT;
	PBY_HANDLE_FILE_INFORMATION lpByHandleInfo; 	

	pJFT = (PVOID) GetVDMPointer(JFTAddress, JFT_SIZE, FALSE); 
	lpByHandleInfo = (PBY_HANDLE_FILE_INFORMATION) 
		GetVDMPointer(ByHandleInfoAddress, 
			sizeof (BY_HANDLE_FILE_INFORMATION), FALSE);

	result = process_get_file_information(
			nHandle, 
                	pPDB,
                        &pSFT,
                        &pJFT,
			lpByHandleInfo);

	FreeVDMPointer(JFTAddress, JFT_SIZE, pJFT, FALSE);
	FreeVDMPointer(ByHandleInfoAddress, sizeof (BY_HANDLE_FILE_INFORMATION),
			 lpByHandleInfo, FALSE);
	if (result) {
		setCF(1);		
		setAX(result);
	} else {
		setCF(0);			
		setAX(0);
	}
	break;
}
		case LONG_CONVERT_TIME    	:   
{
	WORD DosDate ;
	WORD DosTime ;
	BYTE DosMilisec ;
	PFILETIME lpFileTime;
	BYTE nAction = getBL();
	switch (nAction)
	{
		case LONG_CONVERT_TIME_TO_DOS  :
		{
			ULONG FileTimeAddress = MAKEADDRESS(getDS(), getSI());
			lpFileTime = (PFILETIME) GetVDMPointer(FileTimeAddress, sizeof (FILETIME), FALSE);
			break;				
		}
		case LONG_CONVERT_TIME_FROM_DOS:
		{
			ULONG FileTimeAddress = MAKEADDRESS(getES(), getDI());
			lpFileTime = (PFILETIME) GetVDMPointer(FileTimeAddress, sizeof (FILETIME), FALSE);
			DosDate = getDX();
			DosTime = getCX();
			DosMilisec = getBH();
			break;					
		}
		default:
			setCF(1);		
			setAX(ERROR_INVALID_FUNCTION);
			DBGVALUE(regAX, "%x");
			DBGVALUE(result, "%d");
			EPILOG(Dispatch, FALSE);
			return;	
	}
	result = process_convert_time(nAction, &DosDate, &DosTime, 
					&DosMilisec, lpFileTime);
	FreeVDMPointer(FileTimeAdress, sizeof FILETIME, lpFileTime, FALSE);
	if (result) {
		setCF(1);		
		setAX(result);
	} else {
		setCF(0);			
		setAX(0);
		if (nAction == LONG_CONVERT_TIME_TO_DOS) {
			setCX(DosTime);
			setDX(DosDate);
			setBH(DosMilisec);
		}
	}	
	break;
}
		case LONG_GENERATE_SHORT_NAME   :
{
	BYTE nFormat = getDH();
	BYTE nCharset  = getDL();
	PCHAR lpOldPathName;
	PCHAR lpNewPathName;
	ULONG OldPathAddress = MAKEADDRESS(getDS(), getSI());	
	ULONG NewPathAddress = MAKEADDRESS(getES(), getDI());	
	lpOldPathName = (PCHAR) GetVDMPointer(OldPathAddress, MAX_PATHNAME_SIZE, FALSE);
	lpNewPathName = (PCHAR) GetVDMPointer(NewPathAddress, MAX_PATHNAME_SIZE, FALSE);
	result =	process_generate_short_filename(lpOldPathName, lpNewPathName, nFormat, nCharset);
	FreeVDMPointer(OldPathAddress,MAX_PATHNAME_SIZE, lpOldPathName, FALSE);
	FreeVDMPointer(NewPathAddress,MAX_PATHNAME_SIZE, lpNewPathName, FALSE);
	if (result) {
		setCF(1);		
		setAX(result);
	} else {
		setCF(0);			
		setAX(0);
	}
	break;  
}
		case LONG_HANDLE_SUBST          :
{
	BYTE nAction = getBH();
	BYTE nDrive  = getBL();
	PCHAR lpPathName;
	ULONG PathAddress = MAKEADDRESS(getDS(), getDX());	
	lpPathName = (PCHAR) GetVDMPointer(PathAddress, MAX_PATHNAME_SIZE, FALSE);
	result =	process_handle_subst(lpPathName, nDrive, nAction);
	FreeVDMPointer(PathAddress,MAX_PATHNAME_SIZE, lpPathName, FALSE);
	if (result) {
		setCF(1);		
		setAX(result);
	} else {
		setCF(0);			
		setAX(0);
	}
	break;  
}
		case LONG_RESERVED_1:
		case LONG_RESERVED_2:
		case LONG_RESERVED_3:
{
	DBGMSG("Undocumented call");
	break;

}
		default:
{
	DBGMSG("Unknown call");
	setCF(1);
	setAX(0x7100);
	break;
}
	}
safe_exit:
	DBGVALUE(regAX, "%x");
	DBGVALUE(result, "%d");
	EPILOG(Dispatch,TRUE);
	return;
}
