#ifndef text_page_header
#define text_page_header

#include "s_array.h"
#include "pane.h"

#define DEFAULT_PAGE_CHAR    ' '
#define DEFAULT_PAGE_COLOUR  white_bg + black_fg

class text_page : public screen_pane
{
public:
text_page();
text_page( const text_page & model );
text_page( const string_array & model );
text_page( const char * file_name );
text_page & operator=( const text_page & model );
text_page & operator=( const string_array & model );

bool read_file( const char * file_name );
bool write_file( const char * file_name );

void refresh_text();
void refresh_line( int which );
void insert_line( const char * new_line, int y = -1 );
void insert_at( char character, int x, int y );
void delete_at( int x, int y );
void delete_line( int y );
void resize( int new_height );
void resize_and_keep( int new_height );

void cursor_to( int x, int y );
void cursor_left( int amount = 1 );
void cursor_right( int amount = 1 );
void cursor_up( int amount = 1 );
void cursor_down( int amount = 1 );

point cursor() const { return _cursor; }

string_array text;

private:
void adopt( screen_pane & ) {}
point _cursor;
};

#endif
