/* System-specific file */
/* Stonewheel's object loader isn't here because it isn't system-specific */
#include <libc/stubs.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <float.h>
#include <unistd.h>
#include <io.h>
#include <libc/farptrgs.h>
#include <dpmi.h>
#include <go32.h>
#include <signal.h>
#include <setjmp.h>
#include <errno.h>
#include <crt0.h>
#include <pc.h>
#include <sys/exceptn.h>
#include <sys/nearptr.h>		/* For DS base/limit info */
#include <libc/internal.h>

extern unsigned end __asm__ ("end");
extern unsigned _stklen;
extern unsigned __djgpp_stack_limit;

#include "stone.h"

void stone_dofunc (void *ptr)
{
   stone_object *obj;
   int c, d, best;

   for (c = 0, obj = stone_obj; c < stone_nobj; c ++, obj ++)
   {
      if (ptr >= (void *) obj->code && ptr < (void *) (obj->code + obj->len))
      {
         best = -1;
         for (d = 0; d < obj->nsym; d ++)
            if (obj->sym [d].off < (int) ptr - (int) obj->code
             && obj->sym [d].name [0] == '_'
             && (best == -1 || obj->sym [d].off > obj->sym [best].off))
               best = d;

         if (best == -1)
            goto skip;

         stone_report ("  0x%08x   %s+%d of %s",
                    (int) ptr, obj->sym [best].name,
                    ((int) ptr - (int) obj->code) - obj->sym [best].off,
                    obj->src);
         return;
      }
   }

skip:
   stone_report ("  0x%08x", (int) ptr);
}

/* This creates an O3 call frame traceback */
/* It can handle modules and objects */
void stone_die (int signal)
{
   unsigned *vbp, *vbp_new, *tos;
   unsigned veip;
   int max;
   
   /* This could be MAX_INT.  But the stack can be scrogged, so we
      limit by the maximum that the stack could hold (2 int's per frame).  */
   max = _stklen / (2 * sizeof (unsigned));

   tos = (unsigned *) __djgpp_selector_limit;
   vbp = (unsigned *) __djgpp_exception_state->__ebp;
   stone_report ("Call frame traceback EIPs:");
   stone_dofunc ((void *) __djgpp_exception_state->__eip);
   while (((unsigned)vbp >= __djgpp_exception_state->__esp) && (vbp >= &end) && (vbp < tos))
   {
      vbp_new = (unsigned *)*vbp;
      if (vbp_new == 0)
         break;
      veip = *(vbp + 1);
      stone_dofunc ((void *) veip);
      vbp = vbp_new;
      if (--max <= 0)
         break;
   }
}

/* This is called whenever an unlinked symbol is executed		*/
/* It needs to be extended to search for the symbol that was executed	*/
/* This will require something similar to a call frame stack, but	*/
/* find the closest rel and use that as the name of the function that 	*/
/* wasn't installed.							*/
/* This is harder than it looks.  If you're looking for pain, try	*/
/* this task.								*/

static __inline__ int _my_esp (void)
{
   unsigned int result;
   __asm__ ("movl %%ebp, %0" : "=r" (result));
   return result;
}

void stone_badcall_default (void)
{
   stone_report ("An uninitialized function was called.  There are two\n"
              "reasons this could occur.  First, there could be a\n"
              "function that needs to be exported that was not.\n"
              "For example, printf or strcpy.  Second, there could be\n"
              "a module that needs to be loaded that was not.\n"
              "We will now cause a SIGSEGV.\n");

   raise (SIGSEGV);
   exit (255);
}

