/*  Example programs for BETATRON game library. 
 ** Copyright (C) 1997 Liouros Thanasis, liouros@hotmail.com
 **
 ** ex2.cc:     This file is part of the example programs for BETATRON game 
 **             library and can be used and/or distributed only under the terms 
 **             of the GNU General Public License. See doc/examples.txt for 
 **             details.
 */
		
#include <string.h>
#include "world.h"
#include "plkeys.h"
#include <stdlib.h>
#include <conio.h>

// my world
TOworld myworld;

// extend TOsprite to include a pointer to sign1
struct	TOsign2:public TOsprite
{
  TOobject *psign1;
};

char mytile[256];

void exitaction(TOobject *s)
{
 char ch;
 static char ddx=1,ddy=1;
 TOworld *w=s->owner;	    // get a pointer to myworld

      if (pl_testkey(mcESC)) w->exitbit=1;
    else
    {
      if (pl_testkey(mcA)) w->scrollR(-ddx);
 else if (pl_testkey(mcD)) w->scrollR(ddx);

     if (pl_testkey(mcW)) w->scrollD(-ddy);
 else if (pl_testkey(mcS)) w->scrollD(ddy);
    }

};


// this is the action function that moves the sign1 in the world

void sign1action(TOobject *s)
{

     if (pl_testkey(mcUARROW)) s->y--;
else if (pl_testkey(mcDARROW)) s->y++;
     if (pl_testkey(mcLARROW)) s->x--;
else if (pl_testkey(mcRARROW)) s->x++;


}

//  sign2 checks for collision with sign1
void sign2action(TOsign2 *s)
{
  TOworld *w=s->owner;

  if (w->collision(s,s->psign1) ) w->rgbset(0,34,0,0);
  else w->rgbset(0,0,0,0);
};



short loadpal(char *fname, TOworld *w)
{
  FILE *f;

  if ( !(f=fopen(fname,"rb")) ) return ERR_FOPEN;
  if ( fread(w->palette,768,1,f)!=1)
  {
   fclose(f);
   return ERR_FREAD;
  }
  fclose(f);
  return 0;
}


short loadraw(char *fname,char * &buf, unsigned short &l,unsigned short &h)
{
  FILE *f;

  if ( !(f=fopen(fname,"rb")) ) return ERR_FOPEN;
  fread(&l,1,2,f);
  fread(&h,1,2,f);

  if ( ! ( buf= (char *)malloc(l*h)) )  
  { 
   fclose(f);
   return ERR_OUTOFMEM;
  }
  fread(buf,l*h,1,f);

  fclose(f);
  return 0;
}




int main()
{
 int i,j;
 TOobject exitobj;
 TOsprite sign1;
 TOsign2  sign2;
 char *abitmap;
 char *bitmapnames[]={"dat\\sign1.bin", "dat\\sign2.bin"};
 unsigned short len,hei;


// Layers
 myworld.setdimensions(22,15);

 CHECK( myworld.makelayer(LAY_BACK) );
 // initialize the background layer
 for (i=0;i<22*15;i++) myworld.Pbacklayer[i]=0;
 CHECK( myworld.makelayer(LAY_FORE) );

// Tiles
 CHECK(myworld.maketiles(1) );

 memset(mytile,0,256);

 myworld.settile(0,mytile);

//////////// Bitmaps
 // make an array of 2 pointers to bitmaps
 CHECK (myworld.makebitmaps(2));


 for (i=0;i<2;i++)
 {
   if (loadraw(bitmapnames[i],abitmap,len,hei))
   { printf("Could not load %s\n",bitmapnames[i]); return 1; }

   myworld.setbitmap(i,abitmap,len,hei,DRFR_TRAW);
 }

//////////// Palette
 if (loadpal("dat\\sign.pal",&myworld))
 { printf("Could not load sign.pal\n"); return 2;
 }


//////// frame descriptors
// make an array of 2 pointers to frame descriptors
 myworld.makeframesdescrs(2);
 // reserve memory for the first descriptor which consists of a single
 // bitmap (bitmap number 0) and request collision mask
 myworld.make1bitmapdescr(0,0,1);

 // reserve memory for the second descriptor which consists of a single
 // bitmap (bitmap number 1: mybitmaps[1]) and request no collision mask
   myworld.make1bitmapdescr(1,1,0);
   // Request now the collision mask
   myworld.makeframecolidmask(1);

/////////////objects
 sign1.init(1,85,115,myworld.bitmaps[0].len,myworld.bitmaps[0].hei,0);
 sign1.nextaction=sign1action;    // active action function
 myworld.addobj(0,&sign1,0);
////
 sign2.init(2,55,115,myworld.bitmaps[1].len,myworld.bitmaps[1].hei,1);
 sign2.nextaction=(TPaction) sign2action;
 sign2.psign1=(TOobject *) &sign1;
 myworld.addobj(0,&sign2,0);

// exit object
 exitobj.init(0,0,0,0,0);
 exitobj.nextaction=exitaction;
 myworld.addobj(0,&exitobj,0);

 clrscr();
 printf("Example program 2. Copyright 1997 Liouros Thanasis\n");
 printf("--------------------------------------------------\n");
 printf("This program comes with NO WARRANTY.\n");
 printf("See doc/examples.txt for details.\n\n");
 printf("Use a,s,d,w to move the sign.\n");
 printf("Use the arrow keys to move the view window. ESC to exit.\n");
 printf("\nPress <ENTER> ...\n");
 getchar();


 CHECK( myworld.initmode(0) ); // initialize modeX 320x200
 myworld.setmode();
 myworld.jumpto(0,0);
 pl_installkeys();
 myworld.animate();
 pl_keysdone();
 pl_setvideomode(3);

}
