#include <stdio.h>
#include <stdlib.h>

#include "colour.h"
#include "config.h"
#include "error.h"

/*

	colour.c

		Colour stuff

		C-Desktop
		Copyright (C)1998, Brett Porter.

*/

/*
	STRUCTURE DEFINITIONS
*/

typedef struct	S_ColourInfo
{
	int			fID;
	T_ConfigVar	*fConfigVar;
	char			*fDescription;

	struct S_ColourInfo	*fPrevious, *fNext;
} T_ColourInfo;

/*
	FUNCTION	PROTOTYPES
*/

extern	void	Application_CustomRegisterColours( void );

/*
	DATA
*/

static	T_ColourInfo	*sColour_ListHead;

/*
	FUNCTION DEFINITIONS
*/

void	Colour_Initialise( void )
{
	sColour_ListHead = NULL;

	Colour_Register( COLOUR_BACKGROUND, "Desktop", 113 );
	Colour_Register( COLOUR_MENU_FRAME, "Menu frame", 112 );
	Colour_Register( COLOUR_MENU_TEXT, "Menu item", 112 );
	Colour_Register( COLOUR_MENU_SELECT, "Menu item (selected)", 32 );
	Colour_Register( COLOUR_MENU_DISABLED, "Menu item (disabled)", 120 );
	Colour_Register( COLOUR_MENU_HILITE, "Menu hot key", 116 );
	Colour_Register( COLOUR_MENU_HILITE_SEL, "Menu hot key (selected)", 36 );
	Colour_Register( COLOUR_MENU_KEYNAME, "Menu short-cut keys", 112 );
	Colour_Register( COLOUR_MENU_KEYNAME_SEL, "Menu short-cut keys (selected)", 32 );
	Colour_Register( COLOUR_DIALOG_FRAME, "Dialog box frame", 127 );
	Colour_Register( COLOUR_DIALOG_TEXT, "Dialog box text", 112 );
	Colour_Register( COLOUR_BUTTON_TEXT, "Button text", 32 );
	Colour_Register( COLOUR_BUTTON_DEFAULT, "Button text (default)", 43 );
	Colour_Register( COLOUR_BUTTON_FOCUSED, "Button text (selected)", 47 );
	Colour_Register( COLOUR_BUTTON_HILITE, "Button text (highlight)", 46 );
	Colour_Register( COLOUR_BUTTON_SHDW, "Button shadow", 112 );
	Colour_Register( COLOUR_LABEL_TEXT, "Label text", 112 );
	Colour_Register( COLOUR_LABEL_HILITE, "Label text (highlight)", 126 );
	Colour_Register( COLOUR_INPUT_TEXT, "Input field text", 31 );
	Colour_Register( COLOUR_INPUT_ARROW, "Input field arrow", 26 );
	Colour_Register( COLOUR_RADBUT_TEXT, "Radio button", 48 );
	Colour_Register( COLOUR_RADBUT_FOCUSED, "Radio button (selected)", 63 );
	Colour_Register( COLOUR_LISTBOX_TEXT, "List box item", 48 );
	Colour_Register( COLOUR_LISTBOX_SELECT, "List box item (selected)", 63 );
	Colour_Register( COLOUR_LISTBOX_FOCUS, "List box item (selection bar)", 47 );
	Colour_Register( COLOUR_SCROLL_BAR, "Scroll bar", 49 );

	Application_CustomRegisterColours();
}

void	Colour_Terminate( void )
{
	T_ColourInfo	*lCurrent =	sColour_ListHead, *lPrev;

	if ( lCurrent == NULL )
	{
		return;
	}

	while ( lCurrent->fNext != NULL )
	{
		lCurrent = lCurrent->fNext;
	}

	while ( lCurrent != NULL )
	{
		lPrev = lCurrent->fPrevious;
		free( lCurrent->fDescription );
		free( lCurrent );
		lCurrent = lPrev;
	}
	sColour_ListHead = NULL;
}

byte	Colour_GetAttribute( int aColour )
{
	T_ColourInfo	*lCurrent =	sColour_ListHead;

	while ( lCurrent != NULL )
	{
		if ( lCurrent->fID == aColour )
		{
			break;
		}
		lCurrent = lCurrent->fNext;
	}
	if ( lCurrent != NULL )
	{
		return lCurrent->fConfigVar->fValue.fInteger;
	}
	else
	{
		FatalError( "Invalid colour accessed" );
	}
}

void	Colour_SetAttribute( int aColour, byte aAttribute )
{
	T_ColourInfo	*lCurrent =	sColour_ListHead;

	while ( lCurrent != NULL )
	{
		if ( lCurrent->fID == aColour )
		{
			break;
		}
		lCurrent = lCurrent->fNext;
	}
	if ( lCurrent != NULL )
	{
		lCurrent->fConfigVar->fValue.fInteger = aAttribute;
		lCurrent->fConfigVar->fArchive = true;
	}
	else
	{
		FatalError( "Invalid colour accessed" );
	}
}

void	Colour_Register( int aColour, const char *aDescription, byte aDefaultAttribute )
{
	T_ColourInfo	*lPrevColour = sColour_ListHead, *lNewColour;
	char				lStr1[10], lStr2[10];

	if ( lPrevColour != NULL )
	{
		while ( lPrevColour->fNext != NULL )
		{
			if ( lPrevColour->fID == aColour )
			{
				FatalError( "Colour ID is already in use" );
			}
			lPrevColour = lPrevColour->fNext;
		}
		if ( lPrevColour->fID == aColour )
		{
			FatalError( "Colour ID is already in use" );
		}
	}

	P_InitVar( lNewColour, T_ColourInfo );

	lNewColour->fID = aColour;

	P_CreateStr( lNewColour->fDescription, aDescription );

	lNewColour->fNext = NULL;
	lNewColour->fPrevious = lPrevColour;

	if ( lPrevColour == NULL )
	{
		sColour_ListHead = lNewColour;
	}
	else
	{
		lPrevColour->fNext = lNewColour;
	}

	sprintf( lStr1, "C%d", aColour );
	itoa( aDefaultAttribute, lStr2, 10 );

	lNewColour->fConfigVar = Config_RegisterVar( lStr1, aColour+1000, "", CFGVAR_INT, lStr2, true );
}

void	Colour_Modify( void )
{
	Error( "Not yet implemented." );	/// do it!!! ///
}



