/*
 * Copyright (C) 1996-1998 Ilya Ryzhenkov (orangy@inetlab.com)
 */

#ifndef __include_dlm_symbol_h_
#define __include_dlm_symbol_h_

 #ifndef __include_dlmimage_h_
   #include "dlmimage.h"
 #endif

typedef struct tagExportSym {
 char *name;
 void *address;
 TDlm *dlm;
} TExportSym;

typedef struct tagImportDlmLst {
 TDlm *dlm;
 struct tagImportDlmLst *next;
 struct tagImportDlmLst *prev;
} TImportDlmLst;

typedef struct tagImportSym {
 char *name;
 TImportDlmLst *dlmlist;
} TImportSym;

int _sym_init_tables(void);
int _sym_add_export(char *name,void *address,TDlm *dlm);
int _sym_del_export(char *name,TDlm *dlm);
void *_sym_find_export(char *name,TDlm *dlm);
int _sym_add_import(char *name,TDlm *dlm);
int _sym_del_import(char *name,TDlm *dlm);
TImportDlmLst *_sym_find_import(char *name);
int _sym_add_dlm(char *name,TDlm *address);
int _sym_del_dlm(char *name);
TDlm *_sym_find_dlm(char *name);
TDlm *_sym_dlmnext(void);
int _sym_dlmsearch(void);


#endif

