/****************************************************************************/
/* CALLBACK                                                                 */
/*--------------------------------------------------------------------------*/
/* Fonctions de gestion des callbacks                                       */
/*--------------------------------------------------------------------------*/
/* Auteur     : DELPRAT Jean-Pierre                                         */
/* Cr le    : 06/09/95                                                    */
/****************************************************************************/

#include <stdlib.h>
#include <string.h>

#include "JPAppli.h"

#include "Callback.h"

void InitCallback(void (*&callback_action)(const char *),
                  const char *&callback_argument)
{
  callback_action=NULL;
  callback_argument=NULL;
}

void DestroyCallback(void (*&callback_action)(const char *), 
                     const char *&callback_argument)
{
  callback_action=NULL;
  if (callback_argument!=NULL)
    {
      delete[] callback_argument;
      callback_argument=NULL;
    }
}

void SetCallback(void (*&callback_action)(const char *), 
                 const char *&callback_argument,
                 void (*action)(const char *), const char *argument)
{
  callback_action=action;

  if (callback_argument!=NULL)
    delete[] callback_argument;

  char *tmp = new char[strlen(argument)+1]; strcpy(tmp, argument);
  callback_argument = tmp;
}

void CallCallback(void (*callback_action)(const char *), 
                  const char *callback_argument)
{
  if ((JPCallbacksEnabled()) && (callback_action!=NULL))
    callback_action(callback_argument);
}





void InitCallback(void (*&callback_action)(PObject, const char *), 
                  const char *&callback_argument)
{
  callback_action=NULL;
  callback_argument=NULL;
}

void DestroyCallback(void (*&callback_action)(PObject, const char *),
                     const char *&callback_argument)
{
  callback_action=NULL;
  if (callback_argument!=NULL)
    {
      delete[] callback_argument;
      callback_argument=NULL;
    }
}

void SetCallback(void (*&callback_action)(PObject, const char *),
                 const char *&callback_argument,
                 void (*action)(PObject, const char *), const char *argument)
{
  callback_action=action;

  if (callback_argument!=NULL)
    delete[] callback_argument;

  char *tmp = new char[strlen(argument)+1]; strcpy(tmp, argument);
  callback_argument = tmp;
}

void CallCallback(PObject object, void (*callback_action)(PObject, const char *),
                  const char *callback_argument)
{
  if ((JPCallbacksEnabled()) && (callback_action!=NULL))
    callback_action(object, callback_argument);
}



void InitCallback(void (*&callback_action)(PObject, int, const char *),
                  const char *&callback_argument)
{
  callback_action=NULL;
  callback_argument=NULL;
}

void DestroyCallback(void (*&callback_action)(PObject, int, const char *),
                     const char *&callback_argument)
{
  callback_action=NULL;
  if (callback_argument!=NULL)
    {
      delete[] callback_argument;
      callback_argument=NULL;
    }
}

void SetCallback(void (*&callback_action)(PObject, int, const char *),
                 const char *&callback_argument,
                 void (*action)(PObject, int, const char *), 
		 const char *argument)
{
  callback_action=action;

  if (callback_argument!=NULL)
    delete[] callback_argument;

  char *tmp = new char[strlen(argument)+1]; strcpy(tmp, argument);
  callback_argument = tmp;
}

void CallCallback(PObject object, void (*callback_action)(PObject, int, const char *),
                  int index, const char *callback_argument)
{
  if ((JPCallbacksEnabled()) && (callback_action!=NULL))
    callback_action(object, index, callback_argument);
}
