/****************************************************************************/
/* MOUSE                                                                    */
/*--------------------------------------------------------------------------*/
/* Fonctions de manipulation de la souris                                   */
/*--------------------------------------------------------------------------*/
/* Partie spcifique DJGPP          					    */
/****************************************************************************/


/****************************************************************************/
/* RestoreBackground                                                        */
/*--------------------------------------------------------------------------*/
/* Restaure les caractres situes sous le curseur de la souris             */
/* (rien n'a t stocke si s_text_x vaut -1)                           */
/****************************************************************************/

static void RestoreBackground()
{


  asm ("
	movl   _s_screen_ptr,%%ebx
	cmpl   $-1,%%ebx
	je     3f

	pushw  %%es
	movw   %0,%%es          # _dos_ds
	movl   $0xB8000,%%edi
	addl   %%ebx,%%edi

	movl   _s_mouse_pointer_aspect,%%ecx
	cmpl   %1,%%ecx         # MPA_GRAPHICAL
	jz     4f

#Text:
	movw   %%es:(%%edi),%%ax
	notb   %%ah
	movw   %%ax,%%es:(%%edi)
	jmp    2f

#Graphical:
4:
	movl   _s_text_y,%%edx
	movl   _s_text_x,%%ecx

	movl   $_s_pointer_background,%%esi

	movsb
	incl   %%edi

	cmpl   _s_last_col,%%ecx
	jae    1f

	# Le curseur prend 2 colonnes

	movsb

	cmpl   _s_last_line,%%edx
	jae    2f

	movl   _s_screen_width,%%eax
	shll   $1,%%eax
	subl   $3,%%eax      # 2*screen_width-3

	addl   %%eax,%%edi
	movsb
	incl   %%edi

	movsb
	jmp    2f



1:


	cmpl   _s_last_line,%%edx
	jae    2f

	incl   %%esi

	movl   _s_screen_width,%%eax
	shll   $1,%%eax
	subl   $2,%%eax      # 2*screen_width-2

	addl   %%eax,%%edi

	movsb

2:
	popw   %%es

3:
       "
       :
       : "m" (_dos_ds),       // 0
	 "g" (MPA_GRAPHICAL)   // 1
       : "%esi","%edi","%eax","%ebx","%ecx","%edx");

}

static END_OF_FUNCTION(RestoreBackground);

/****************************************************************************/
/* DisplayMousePointer                                                      */
/*--------------------------------------------------------------------------*/
/* Affiche le curseur souris graphique                                      */
/****************************************************************************/

static void DisplayMousePointer()
{
  word  old_ds;

  char  font[4*MAX_HEIGHT];
  char  *font_ptr=font;

  word  mouse_pointer[MAX_HEIGHT];
  word  mouse_mask[MAX_HEIGHT]; // Curseur dcal

  word  *mouse_pointer_ptr=mouse_pointer,
	*mouse_mask_ptr  =mouse_mask;

  int   screen_ptr;

  int   xo,yo;

  int last_col;
  int last_line;
  int screen_width;
  int gap_mh,gap_32;
  int pointer_height;

  asm ("
	movl  _s_mouse_pointer_aspect,%%ecx
	cmpl  %0,%%ecx  # MPA_GRAPHICAL
	jz   8f

#Text:

       "
       :
       :"g" (MPA_GRAPHICAL)
       :"%ecx");

  RestoreBackground();

  asm ("
	movl  _s_graph_y,%%eax
	movl  %%eax,_s_text_y

	movl  _s_graph_x,%%ecx
	movl  %%ecx,_s_text_x

	mull  _s_screen_width    # dx:ax = s_text_y*screen_width
	shll  $1,%%eax           # ax=s_text_y*2*screen_width

	movl  %%ecx,%%ebx        # bx=s_text_x
	shll  $1,%%ebx           # bx=s_text_x*2

	addl  %%ebx,%%eax        # ax=s_text_x*2+(s_text_y*screen_width)
	movl  %%eax,_s_screen_ptr

	pushw %%es

	movw  %0,%%es         # _dos_ds
	movl  $0xB8000,%%edi
	addl  %%eax,%%edi

	movw  %%es:(%%edi),%%ax
	notb  %%ah
	movw  %%ax,%%es:(%%edi)

	popw  %%es
	jmp   9f
      "
      :
      : "m" (_dos_ds)
      : "%edi","%eax","%ebx","%ecx");

  asm ("

#Graphical:
8:

	movl  _s_screen_width,%%eax
	movl  %%eax,%1      # screen_width
	decl  %%eax
	movl  %%eax,%2      # last_col
	movl  _s_last_line,%%eax
	movl  %%eax,%3      # last_line

	movl  _s_font_height,%%eax
	movl  %%eax,%4      # pointer_height

	movl  _s_gap_32,%%eax
	movl  %%eax,%5      # gap_32

	movl  _s_gap_max_height,%%ebx
	movl  %%ebx,%6      # gap_mh

	movw  %%ds,%0       # old_ds
       "
       : "=m" (old_ds),
	 "=m" (screen_width),  // 1
	 "=m" (last_col),      // 2
	 "=m" (last_line),     // 3
	 "=m" (pointer_height),// 4
	 "=m" (gap_32),        // 5
	 "=m" (gap_mh)         // 6
       : "g" (MAX_HEIGHT)
       :"%eax","%ebx");


  RestoreBackground();

  // Sauve le fond l o va tre affich le curseur

  asm ("
	movl  _s_graph_y,%%eax
	movl  _s_font_height,%%ecx
	divb  %%cl
	movb  $0,%%ah
	movl  %%eax,_s_text_y

	movl  %%eax,%%edx
	movl  _s_graph_x,%%ecx
	shrl  $3,%%ecx
	movl  %%ecx,_s_text_x

	mull  _s_screen_width
	shll  $1,%%eax

	movl  %%ecx,%%ebx    # bx=s_text_x
	shll  $1,%%ebx       # bx=s_text_x*2

	addl  %%ebx,%%eax    # ax=s_text_x*2+(s_text_y*screen_width)
	movl  %%eax,_s_screen_ptr

	movl  $0xB8000,%%esi
	addl  %%eax,%%esi

	movl  $_s_pointer_background,%%edi
	movw  %2,%%ds        # dos_ds



	movsb
	incl  %%esi

	cmpl  %3,%%ecx       # ecx=LAST_COL ?
	jae   1f

	movsb

	cmpl  %4,%%edx       # edx=LAST_LINE ?
	jae   2f

	movl  %6,%%eax       # screen_width
	shll  $1,%%eax
	subl  $3,%%eax       # 2*screen_width-3
	addl  %%eax,%%esi
	movsb
	incl  %%esi

	movsb
	jmp   2f



1:


	cmpl  %4,%%edx       # edx=LAST_LINE ?
	jae   2f

	incl  %%edi

	movl  %6,%%eax       # screen_width
	shll  $1,%%eax
	subl  $2,%%eax       # 2*screen_width-2

	addl  %%eax,%%esi
	movsb

2:
	movw  %5,%%ds       # old_ds

       "
       : "=m" (screen_ptr),         // 0
	 "=m" (s_pointer_background) // 1
       : "m" (_dos_ds),             // 2
	 "m" (last_col),            // 3
	 "m" (last_line),           // 4
	 "m" (old_ds),              // 5
	 "m" (screen_width)         // 6
       :"%esi","%edi","%eax","%ebx","%ecx","%edx","memory");

  // Accs linaire  la carte VGA

  outport(0x3c4,0x0402);
  outport(0x3c4,0x0704);
  outport(0x3ce,0x0204);
  outport(0x3ce,0x0005);
  outport(0x3ce,0x0406);

  // Lecture de la dfinition des caractres sous le curseur

  asm ("
	movl  %1,%%edi      # font_ptr
	movl  $0,%%ebx
	movl  %3,%%edx      # pointer_height
	shrl  $1,%%edx


0:



	movl  $0,%%eax
	movb  _s_pointer_background(%%ebx),%%al
	shll  $5,%%eax
	movw  %2,%%ds       # _dos_ds

	movl  $0xA0000,%%esi
	addl  %%eax,%%esi

	movl  %%edx,%%ecx
    rep;movsw
	addl  %4,%%edi      # gap_mh
	incl  %%ebx
	movw  %0,%%ds       # old_ds
	cmpl  $3,%%ebx
	jle   0b
       "
       :
       : "m" (old_ds),   // 0
	 "m" (font_ptr), // 1
	 "m" (_dos_ds),  // 2
	 "m" (pointer_height), //3
	 "m" (gap_mh)          // 4
       :"%esi","%edi","%eax","%ebx","%ecx","%edx");



// Construction du curseur

  asm ("
	movl  _s_graph_x,%%eax
	andl  $7,%%eax
	movl  %%eax,%0      # xo

	movl  _s_graph_y,%%eax
	movl  %2,%%ecx      # pointer_height
	divb  %%cl
	shrl  $8,%%eax
	movl  %%eax,%1      # yo

       "
       : "=m" (xo),         // 0
	 "=m" (yo)          // 1
       : "m" (pointer_height) // 2
       : "%eax","%ecx");


// Dcalage du curseur et du fond en x

  asm ("
	movl  %3,%%edi      # pointer_height
	decl  %%edi
	shll  $1,%%edi
	pushl %%edi
	movl  %1,%%edx      # mouse_pointer_ptr

	movl  $8,%%ecx
	subl  %0,%%ecx      # xo
	pushl %%ecx

	movl  _s_pointer_definition_ptr,%%esi
	incl  %%esi
	addl  %3,%%esi      # pointer_height


#Loop2_1:
1:
	movl  $0,%%eax
	movb  (%%esi),%%al
	decl  %%esi

	shll  %%cl,%%eax
	movw  %%ax,(%%edx,%%edi)
	subl  $2,%%edi
	jns   1b

	mov   %2,%%edx      # mouse_mask_ptr
	popl  %%ecx
	popl  %%edi

	addl  %%edi,%%esi   # 2*(pointer_height-1)
	addl  $2,%%esi

#Loop2_2:
2:

	movl  $0,%%eax
	movb  (%%esi),%%al
	decl  %%esi

	shll  %%cl,%%eax
	notl  %%eax
	movw  %%ax,(%%edx,%%edi)

	subl  $2,%%edi
	jns   2b
       "
       :
       : "m" (xo),                // 0
	 "m" (mouse_pointer_ptr),  // 1
	 "m" (mouse_mask_ptr),     // 2
	 "m" (pointer_height)      // 3
       : "%edi","%esi","%eax","%ecx","%edx","memory");

// Dcalage en y et fusion curseur,masque,fond

  asm ("
	movl  $0,%%esi
	movl  %3,%%edi      # yo

#Loop3_1:
3:
	movl  %2,%%edx      # mouse_mask_ptr
	movw  (%%edx,%%esi),%%bx
	movl  %1,%%edx      # mouse_pointer_ptr
	movw  (%%edx,%%esi),%%cx

	movl  %0,%%edx      # font_ptr

	addl  %5,%%edi      # MAX_HEIGHT
	movb  (%%edx,%%edi),%%al
	andb  %%bl,%%al
	orb   %%cl,%%al
	movb  %%al,(%%edx,%%edi)
	subl  %5,%%edi      # MAX_HEIGHT

	movb  (%%edx,%%edi),%%al
	andb  %%bh,%%al
	orb   %%ch,%%al
	movb  %%al,(%%edx,%%edi)

	incl  %%edi
	cmpl  %4,%%edi      # pointer_height
	jne   4f
	movl  %6,%%edi      # MAX_HEIGHT*2

#Loop3_2:
4:
	addl  $2,%%esi
	movl  %4,%%edx      # pointer_height
	shll  $1,%%edx
	cmpl  %%edx,%%esi      # MAX_HEIGHT*2
	jne   3b

       "
       :
       : "m" (font_ptr),           // 0
	 "m" (mouse_pointer_ptr),   // 1
	 "m" (mouse_mask_ptr),     // 2
	 "m" (yo),                  // 3
	 "m" (pointer_height),      // 4
	 "g" (MAX_HEIGHT),           // 5
	 "g" (MAX_HEIGHT << 1)
       : "%edi","%esi","%eax","%ebx","%ecx","%edx","memory");

// Modification de la dfinition des caractres reprsentant la souris

   asm("
	movw  %1,%%es         # _dos_ds
	movl  $0xA0000,%%edi
	movl  %3,%%eax        # GMOUSE_1ST_CHAR
	shll  $5,%%eax
	addl  %%eax,%%edi

	movl  %2,%%esi        # font_ptr
	movl  $4,%%ebx
	movl  %4,%%edx        # pointer_height
	shrl  $1,%%edx

#Loop4_1:
5:
	movl  %%edx,%%ecx
    rep;movsw

	addl  %5,%%edi        # gap_32
	addl  %6,%%esi        # gap_mh
	decl  %%ebx
	jnz   5b
	movw  %0,%%es         # old_ds
       "
       :
       : "m" (old_ds),         // 0
	 "m" (_dos_ds),        // 1
	 "m" (font_ptr),       // 2
	 "g" (GMOUSE_1ST_CHAR),// 3
	 "m" (pointer_height), // 4
	 "m" (gap_32),         // 5
	 "m" (gap_mh)          // 6
       : "%edi","%esi","%eax","%ebx","%ecx","memory");

  // Accs par plans  la carte VGA

  outport(0x3c4,0x0302);
  outport(0x3c4,0x0304);
  outport(0x3ce,0x0004);
  outport(0x3ce,0x1005);
  outport(0x3ce,0x0E06);

  // Affichage du curseur

  asm ("
	movl  _s_screen_ptr,%%edi
	movw  %2,%%es       # _dos_ds
	addl  $0xB8000,%%edi

	movl  _s_text_x,%%ecx
	movl  _s_text_y,%%edx

	movb  %3,%%al       # GMOUSE_1ST_CHAR
	movb  %%al,%%es:(%%edi)
	addl  $2,%%edi
	incb  %%al

	cmpl  %4,%%ecx      # LAST_COL
	jae   1f

	movb  %%al,%%es:(%%edi)
	incl  %%edi
	incb  %%al

	cmpl  %5,%%edx      # LAST_LINE
	jae   2f

	movl  %6,%%ebx       # screen_width
	shll  $1,%%ebx
	subl  $3,%%ebx       # 2*screen_width-3
	addl  %%ebx,%%edi

	movb  %%al,%%es:(%%edi)
	addl  $2,%%edi
	incb  %%al

	movb  %%al,%%es:(%%edi)
	jmp   2f


1:


	cmpl  %5,%%edx      # LAST_LINE
	jae   2f

	movl  %6,%%ebx       # screen_width
	shll  $1,%%ebx
	subl  $2,%%ebx       # 2*screen_width-2

	addl  %%ebx,%%edi
	incb  %%al
	movb  %%al,%%es:(%%edi)


2:
	movw  %0,%%es       # old_ds
9:
       "
       :
       : "m" (old_ds),              // 0
	 "m" (screen_ptr),          // 1
	 "m" (_dos_ds),             // 2
	 "g" (GMOUSE_1ST_CHAR),     // 3
	 "m" (last_col),            // 4
	 "m" (last_line),           // 5
	 "m" (screen_width)         // 6

       : "%edi","%eax","%ebx","%ecx","%edx");

}

static END_OF_FUNCTION(DisplayMousePointer);

/****************************************************************************/
/* MouseMoveEvent                                                           */
/*--------------------------------------------------------------------------*/
/* Evnement appel par le pilote souris en cas de mouvement de celle-ci    */
/****************************************************************************/

static void MouseMovedEvent(_go32_dpmi_registers *regs)
{
  static boolean s_in_event=FALSE;

  if (s_in_event)
    return;

  disable();

  s_in_event=TRUE;


  regs->x.cx >>= 3;
  regs->x.dx >>= 3;


  if ((regs->x.cx!=s_graph_x) || (regs->x.dx!=s_graph_y))
    {
      s_graph_x=regs->x.cx;
      s_graph_y=regs->x.dx;

      if (s_show_state>=0)
	DisplayMousePointer();
    }

  s_in_event=FALSE;

  enable();
}

static END_OF_FUNCTION(MouseMovedEvent);

