/****************************************************************************/
/* TAPPLICA                                                                 */
/*--------------------------------------------------------------------------*/
/* Objet TApplication (Application)                                         */
/*--------------------------------------------------------------------------*/
/* Auteur     : DELPRAT Jean-Pierre                                         */
/* Cr le    : 10/01/95                                                    */
/****************************************************************************/

#include <conio.h>
#include <signal.h>
#include <stdlib.h>
#include <sys\timeb.h>
#include <values.h>

#include "Settings.h"

#include "Compat.h"
#include "Const.h"
#include "JPDebug.h"

#include "Vocab.h"

#include "Errors.h"
#include "JPAppli.h"
#include "JPData.h"
#include "Mouse.h"
#include "Screen.h"
#include "Strings.h"

#include "TWindow.h"
#include "TApplica.h"



/*ͻ*/
/*                 INITIALISATION DES VARIABLES STATIQUES                 */
/*ͼ*/

/*
void TApplication::m_new_handler()
{
  char *text;

  switch (GetLanguage())
    {
      case FRENCH : text="Mmoire insuffisante !!!";break;
      case GERMAN : text="Speicherkapazitt zu gering !!!";break;
      case ITALIAN: text="Memoria insufficiente !!!";break;
      case SPANISH: text="No hay memoria suficiente!";break;
      case DUTCH  : text="Onvoldoende geheugen !";break;
      case GREEK  : text="    !!!";break;

      default     : text="Not enough memory !!!";
    }

  FatalError(text);
}
*/

void TApplication::m_ctrl_break_handler(int)
{
  signal(SIGINT,m_ctrl_break_handler);

   // En Turbo C, le CTRL-BREAK (mme dtourn) modifie l'affichage
   // (affichage de ^C)

  #ifdef __TCPLUSPLUS__
  JPApplication->m_add_zone_to_refresh(1,1,GetScreenWidth(),GetScreenHeight(),JPApplication->f_nb_open_windows);
  JPRefresh();
  #endif
}


PApplication TApplication::f_current_application=NULL;

/*ͻ*/
/*                           METHODES PUBLIQUES                           */
/*ͼ*/

/****************/
/* Constructeur */
/* ------------ */
/****************/

TApplication::TApplication(TLanguage language)
	:	noEventAction_(0),
		clipboardChangedAction_(0),
		keyCallback_(0)
{
  // Une application a dj t cre

  JPDEBUG_TEST(DEBUG_ERROR_9,f_current_application==NULL);
  f_current_application=this;

  // Installation d'un gestionnaire d'erreurs sur new

//  set_new_handler(m_new_handler);

  // Chargement du vocabulaire

  if (!LoadVocabulary(language))
    FatalError(GetInvalidDataFileMessage());

  // Dsactivation de CTRL-C en version non-debug

  NO_DEBUG(signal(SIGINT,m_ctrl_break_handler));

  // Nombre et liste des fentres que comprend l'application

  f_nb_windows=0;
  f_window_list=NULL;
  f_last_window=NULL;

  // Fenetre active

  f_active_window=NULL;

  // Nombre et liste des numros des fentres ouvertes,
  // par ordre de superposition

  f_nb_open_windows=0;
  f_open_window_list=NULL;
  f_last_open_window=NULL;

  // Etat de l'application

  f_state=STOPPED;
  f_nb_running_dialogs=0;

  // L'arrt de l'application a t demand

  f_stop_wanted=false;

  // Les callbacks sont activs

  f_callbacks_enabled=true;

  // Etat du double click

  f_double_click_state=SECOND_RELEASE;

  // Date du dernier clic de souris

  // f_last_button_click_time;

  // L'cran a besoin d'un rafrachissement

  f_need_refresh=false;
  f_zone_to_refresh.x1=0;
  f_zone_to_refresh.y1=0;
  f_zone_to_refresh.x2=0;
  f_zone_to_refresh.y2=0;
  f_upper_changed_window_height=-1;

  // Clipboard

  f_clipboard=new char [1];
  f_clipboard[0]=0;

}

/***************/
/* Destructeur */
/* ----------- */
/***************/

TApplication::~TApplication()
{
  // Destruction de l'objet normale ?

  JPDEBUG_TEST(DEBUG_ERROR_21,(f_state!=RUNNING) && (f_nb_running_dialogs==0));

  if (f_clipboard!=NULL)
    {
      delete []f_clipboard;
      f_clipboard=NULL;
    }

  // Toutes les fentres doivent avoir t supprimes et fermes

  JPDEBUG_TEST(DEBUG_ERROR_22,f_open_window_list==NULL);
  JPDEBUG_TEST(DEBUG_ERROR_22,f_window_list==NULL);

  // On efface le vocabulaire

  FreeVocabulary();

  // On restaure le handler de new standard

//  set_new_handler(0);
}

/********************************************/
/* m_init : Initialisation de l'application */
/* ------                                   */
/********************************************/

void TApplication::m_init()
{
  JPDEBUG_TEST(DEBUG_ERROR_23,(f_state==STOPPED));

  // Initialisation de l'cran et de la souris

  InitScreen();

  ClearScreen(SCREEN_BACKGROUND,' ');

  f_state=INITIALIZED;
}



/***********************************************/
/* m_run : Lancement de l'application.         */
/* -----   Boucle principale qui tourne tant   */
/*         que JPStop n'a pas t appel.      */
/***********************************************/

void TApplication::m_run()
{
  // Est-ce que l'application a bien t initialise

  JPDEBUG_TEST(DEBUG_ERROR_24,f_state==INITIALIZED);

  f_state=RUNNING;
  m_main_loop();
  f_state=STOPPED;

  m_close();
}

/****************************************************************/
/* m_run_dialog : Lance une bote de dialogue et revient       */
/* ------------   l'instruction suivante aprs l'appel  JPStop */
/****************************************************************/

void TApplication::m_run_dialog()
{
  // Est-ce que l'application a bien t initialise

  JPDEBUG_TEST(DEBUG_ERROR_25,f_state!=STOPPED);

  f_nb_running_dialogs++;
  m_main_loop();
  f_nb_running_dialogs--;

  f_stop_wanted=false;
}

/****************************************************************/
/* m_process_events : Traite les ventuels vnements (une fois)*/
/* ----------------   					        */
/****************************************************************/

void TApplication::m_process_events()
{
  bool event;            // Evnement survenu
  TKey    key;              // Touche frappe

  int     x,y,              // Etat courant de la souris
	  button_state;

  static int     s_last_x=-1,        // Dernire position de la souris
		 s_last_y=-1;


  struct  timeb new_time;  // Pour mesurer l'cart entre des clics successifs
  long    time_length_between_clicks;


  JPDEBUG_TEST(DEBUG_ERROR_32,f_state!=STOPPED);

  // Rafrachissement de l'cran

  m_refresh();

  // Affichage de la mmoire disponible

  DEBUG_DISPLAY_MEMORY();

  // Les vnements de la boucle prcdente ont t traits

  event=false;

  // Lecture de l'tat de la souris

  GetMouseState(x,y,button_state);

  // Bouton gauche enfonc -> analyse des clics et double-clics

  if (button_state==LEFT_BUTTON_PRESSED)
    {
      if (f_double_click_state==FIRST_RELEASE)
	{
	  // Si on a dj fait un clic

	  ftime(&new_time);

	  // Peut-tre un double clic

	  time_length_between_clicks=  (new_time.time - f_last_button_click_time.time)*1000
				  + (long)(new_time.millitm-f_last_button_click_time.millitm);

	  if (   (s_last_x==x) && (s_last_y==y)
	      && (time_length_between_clicks<MAX_DOUBLE_CLICK_DURATION))
	    {
	      event=m_left_button_double_click_event(x,y);
	      if (event)
		f_double_click_state=SECOND_PRESSION;
	    }

	  // S'il n'y a pas eu double-clic ou s'il n'a intress
	  // personne, le second clic est considr comme un clic simple

	  if (f_double_click_state!=SECOND_PRESSION)
	    f_double_click_state=SECOND_RELEASE;
	}

      // Si on en est  un premier clic

      if (f_double_click_state==SECOND_RELEASE)
	{
	  event=m_left_button_pressed_event(x,y);
	  if (event)
	    f_double_click_state=FIRST_PRESSION;
	}

    }

  // Bouton gauche non enfonc
  else
    {
      switch (f_double_click_state)
	{
	  case FIRST_PRESSION  : f_double_click_state=FIRST_RELEASE;
				 // Position de la souris et heure lors
				 // du relchement du premier clic
				 ftime(&f_last_button_click_time);
				 s_last_x=x;
				 s_last_y=y;
				 break;
	  case SECOND_PRESSION : f_double_click_state=SECOND_RELEASE;
				 break;
	  default	           : break;
	}

      // On n'analyse le clavier que si le bouton de la souris
      // n'est pas enfonc

    	  if (KeyPressed()) {
			GetKey(key);
			bool processed = false;
			if (keyCallback_ != 0) {
				processed = (*keyCallback_)(key);
			}
			if (!processed) {
				event=m_key_pressed_event(key);
			}
    	}
	}
	// On n'a pas eu d'vnements
	// on appelle donc le callback appropri
	noEventAction_();
}

/************************************************/
/* m_stop : Demande de l'arrt de l'application */
/* ------   -> arrt de la boucle principale    */
/************************************************/

void TApplication::m_stop()
{
  if ((f_state==RUNNING) || (f_nb_running_dialogs>0))
    f_stop_wanted=true;
  else
    {
      m_close();
      f_state=STOPPED;
    }
}

/****************************************************************************/
/* m_refresh                                                                */
/*--------------------------------------------------------------------------*/
/* Rafrachisement de l'cran aprs attente ventuelle du retour vertical du*/
/* rayon lectronique de l'cran                                            */
/****************************************************************************/

void TApplication::m_refresh()
{
  register int i;
  POpenWindowNode node;
  PWindow window;
  int tmp;

  /* Recherche de la zone  rafrachir */

  node=f_open_window_list;
  i=1;
  while (node!=NULL)
    {
      window=m_number_to_window(node->window_number);
      if (window->f_content_changed)
	{
	  m_add_zone_to_refresh(window->f_x+window->f_changed_zone.x1,
				window->f_y+window->f_changed_zone.y1,
                                window->f_x+window->f_changed_zone.x2,
                                window->f_y+window->f_changed_zone.y2,
				i);
	}
      node=node->next;
      i++;
    }

  // Rien  afficher

  if (!f_need_refresh)
    return;

  // Sinon

  if (f_zone_to_refresh.x1<1)
    f_zone_to_refresh.x1=1;

  if (f_zone_to_refresh.y1<1)
    f_zone_to_refresh.y1=1;

  tmp=GetScreenWidth();
  if (f_zone_to_refresh.x2>tmp)
    f_zone_to_refresh.x2=tmp;

  tmp=GetScreenHeight();
  if (f_zone_to_refresh.y2>tmp)
    f_zone_to_refresh.y2=tmp;


  HideMouse();

  WaitRetrace();

  m_refresh_window(f_nb_open_windows,
		   f_zone_to_refresh.x1,
		   f_zone_to_refresh.y1,
		   f_zone_to_refresh.x2,
		   f_zone_to_refresh.y2);
  ShowMouse();

  // Toutes les fentres ainsi que l'application ont t rafrachies

  f_need_refresh=false;

  node=f_open_window_list;
  while (node!=NULL)
    {
      (m_number_to_window(node->window_number))->f_content_changed=false;
      node=node->next;
    }
}

/****************************************************************************/
/* m_refresh_all                                                            */
/*--------------------------------------------------------------------------*/
/* Refreshes the whole screen 						    */
/****************************************************************************/

void TApplication::m_refresh_all()
{
  f_need_refresh=true;
  f_zone_to_refresh.x1=1;
  f_zone_to_refresh.y1=1;
  f_zone_to_refresh.x2=GetScreenWidth();
  f_zone_to_refresh.y2=GetScreenHeight();
  f_upper_changed_window_height=f_nb_open_windows;
  m_refresh();
}


/****************************************************************************/
/* m_redraw_windows                                                         */
/*--------------------------------------------------------------------------*/
/* Redraws the contents of windows					    */
/****************************************************************************/

void TApplication::m_redraw_windows()
{
  PWindowNode node;

  node=f_window_list;
  while (node!=NULL)
    {
      if (node->window->f_open)
	node->window->m_display();
      node=node->next;
    }

}

/****************************************************************************/
/* m_make_next_window_active                                                */
/*--------------------------------------------------------------------------*/
/* Rend la fentre suivante active. Retourne false si impossible            */
/****************************************************************************/

bool TApplication::m_make_next_window_active()
{
  POpenWindowNode node;
  int order=f_last_open_window->order;

  order++;
  if (order>f_nb_open_windows)
    order=1;

  node=f_open_window_list;

  while ((node->order)!=order)
    node=node->next;

  if (node->owner!=NULL)
    return false;

  return(m_set_active_window(node->window_number));
}


/****************************************************************************/
/* m_get_active_window                                                      */
/*--------------------------------------------------------------------------*/
/* Returns a pointer to the active window (NULL si none)		    */
/****************************************************************************/

PWindow TApplication::m_get_active_window()
{
  return(f_active_window);
}


/****************************************************************************/
/* m_set_clipboard                                                          */
/*--------------------------------------------------------------------------*/
/* Modifie le contenu du clipboard                                          */
/* Passer un texte o les lignes sont spares par un \n                    */
/****************************************************************************/

void TApplication::m_set_clipboard(const char *text)
{
  unsigned size=strlen(text)+1;

  if (f_clipboard!=NULL)
    delete []f_clipboard;

//  set_new_handler(0);
//  f_clipboard = new(nothrow) char [size];
	f_clipboard = new char[size];
//  set_new_handler(m_new_handler);
//
//  if (f_clipboard==NULL)
//    {
//      f_clipboard=new char [1];
//      f_clipboard[0]=0;
//      return;
//    }

  memcpy(f_clipboard,text,size);

	clipboardChangedAction_();
}

/*ͻ*/
/*                            METHODES PRIVEES                            */
/*ͼ*/

/****************************************************/
/* m_main_loop : Boucle principale de l'application */
/* -----------   Tourne tant que JPStop             */
/*               n'a pas t appel.                */
/****************************************************/

void TApplication::m_main_loop()
{
  // Boucle principale (tant que l'arrt n'est pas demande)

  f_stop_wanted=false;

  while (!f_stop_wanted)
    m_process_events();

  // Stop demand -> on quitte la main_loop
}

/***************************/
/* m_close : Fermeture de  */
/* -------   l'application */
/***************************/

void TApplication::m_close()
{
  // Fermeture de toutes les fentres

  while (f_last_open_window!=NULL)
    m_close_window(f_last_open_window->window_number);

  // Fermeture de l'cran
  CloseScreen();
}

/******************************************************************/
/* m_refresh_window : Rafrachit la partie de l'cran indique    */
/* ----------------   avec la fentre se trouvant  la hauteur    */
/*                    window_height dans l'ordre de superposition */
/*                    (0 pour le fond d'cran)                    */
/******************************************************************/

void TApplication::m_refresh_window(int window_height,int x1,int y1,int x2,int y2)
{
  int window_number;
  PWindow window;
  int x1_window,y1_window,x2_window,y2_window;
  int tmp1,tmp2;

  // Fond d'cran

  if (window_height==0)
    {
      ClearPartOfScreen(x1,y1,x2,y2,SCREEN_BACKGROUND,' ');
      return;
    }

  /* On rafraichit autour de la fentre avec les morceaux */
  /* de la fentre situe juste en dessous                */

  window_number=m_height_to_window_nb(window_height);
  window=m_number_to_window(window_number);

  // Fentre de taille nulle

  if ((window->f_width<=0) || (window->f_height<=0))
    {
      m_refresh_window(window_height-1,x1,y1,x2,y2);
      return;
    }

  // Sinon

  x1_window=window->f_x;
  y1_window=window->f_y;
  x2_window=window->f_width+x1_window-1;
  y2_window=window->f_height+y1_window-1;

  if (y1<y1_window)
    m_refresh_window(window_height-1,
		     x1,
		     y1,
		     x2,
		     MIN(y2,y1_window-1));

  if ((y1<=y2_window) && (y1_window<=y2))
    {
      tmp1=MAX(y1,y1_window);
      tmp2=MIN(y2,y2_window);

      if (x1<x1_window)
	m_refresh_window(window_height-1,
			 x1,
			 tmp1,
			 MIN(x2,x1_window-1),
			 tmp2);

      if (x2>x2_window)
	m_refresh_window(window_height-1,
			 MAX(x1,x2_window+1),
			 tmp1,
			 x2,
			 tmp2);
    }

  if (y2>y2_window)
    m_refresh_window(window_height-1,
		     x1,
		     MAX(y1,y2_window+1),
		     x2,
		     y2);

  // On affiche la partie de la fentre comprise dans les limites
  // (si celle-ci n'est pas au-dessus de la fentre modifie la plus
  // leve

  x1-=x1_window;
  y1-=y1_window;
  x2-=x1_window;
  y2-=y1_window;

  if (window_height<=f_upper_changed_window_height)
    window->m_part_to_screen(x1,y1,x2,y2);
  window->m_shadows_to_screen(x1,y1,x2,y2);

}


/*************************************************************/
/* m_add_window : Ajoute une fentre  l'application         */
/* ------------   et retourne le numro qui lui est attribu */
/*************************************************************/

int TApplication::m_add_window(PWindow window)
{
  PWindowNode new_node;
  int window_number;

  new_node=new TWindowNode;
  new_node->window=window;
  new_node->next=NULL;
  new_node->last=f_last_window;

  if (f_window_list==NULL)
    {
      window_number=1;
      f_window_list=new_node;
    }
  else
    {
      window_number=f_last_window->window->f_window_number+1;
      f_last_window->next=new_node;
    }

  f_last_window=new_node;
  f_nb_windows++;

  return (window_number);
};

/***************************************/
/* m_del_window : Supprime une fentre */
/* ------------   de l'application     */
/***************************************/

void TApplication::m_del_window(int window_number)
{
  PWindowNode node,node_before,node_after;

  // Suppression du noeud

  node=m_number_to_window_node(window_number);

  // La fentre doit tre ferme avant
  // d'arriver ici

  DEBUG_TEST(!(node->window->f_open));

  node_before=node->last;
  node_after=node->next;

  if (f_last_window==node)
    f_last_window=node_before;

  if (node_before!=NULL)
    node_before->next=node_after;
  else
    f_window_list=node_after;

  if (node_after!=NULL)
    node_after->last=node_before;

  delete node;

  f_nb_windows--;
};

/****************************************************************************/
/* m_open_window                                                            */
/*--------------------------------------------------------------------------*/
/* owner : objet qui possde la fentre (le plus souvent NULL).             */
/*         si non NULL, tous les vnements sont dtourns vers l'objet     */
/****************************************************************************/

void TApplication::m_open_window(int window_number,PObject owner)
{
  POpenWindowNode new_node;
  PWindow window;
  bool new_open_window=false;

  // L'application doit avoir t initialise

  JPDEBUG_TEST(DEBUG_ERROR_29,(f_state!=STOPPED));


  window=m_number_to_window(window_number);

  if (!window->f_open)
    {

      // Une fentre en plus

      f_nb_open_windows++;

      new_node=new TOpenWindowNode;
      new_node->window_number=window_number;
      new_node->order=f_nb_open_windows;
      new_node->owner=owner;
      new_node->next=NULL;
      new_node->last=f_last_open_window;

      if (f_open_window_list==NULL)
	f_open_window_list=new_node;
      else
	f_last_open_window->next=new_node;

      f_last_open_window=new_node;

      // On ouvre la fentre

      window->m_set_open(true);
      new_open_window=true;
    }

    m_set_active_window(window_number,new_open_window);
}

/****************************************************************************/
/* m_close_window 							    */
/*--------------------------------------------------------------------------*/
/* Ferme la fentre indique (si possible) 				    */
/* Si force vaut true, ferme la fentre mme si l'objet de la fentre       */
/* qui a le focus ne veut pas le laisser                                    */
/****************************************************************************/

void TApplication::m_close_window(int window_number)
{
  PWindow window;
  POpenWindowNode   node,
		    node_before,
		    node_after;

  int               order;

  bool           had_owner;

  window=m_number_to_window(window_number);

  if (!window->f_open)
    return;


  node=f_last_open_window;
  while ((node->window_number)!=window_number)
    node=node->last;

  if (node->owner==NULL)
    had_owner=false;
  else
    had_owner=true;

  // Suppression de cette fentre de la liste des fentres ouvertes

  order=node->order;

  node_before=node->last;
  node_after=node->next;

  if (f_last_open_window==node)
    f_last_open_window=node_before;

  if (node_before!=NULL)
    node_before->next=node_after;
  else
    f_open_window_list=node_after;

  if (node_after!=NULL)
    node_after->last=node_before;

  delete node;

  f_nb_open_windows--;


  node=f_last_open_window;
  while (node!=NULL)
    {
      if ((node->order)>order)
	node->order--;
      node=node->next;
    }

  // Fermeture de la fentre

  window->m_set_open(false);
  window->m_set_active(false);
  if (window->m_has_focus())
    window->m_lose_focus();

  if (!had_owner)
    {
      f_active_window=NULL;

      // S'il reste des fentres, la plus haute devient active

      if (f_nb_open_windows!=0)
	m_set_active_window(f_last_open_window->window_number);
    }
}

/****************************************************************************/
/* m_add_zone_to_refresh                                                    */
/*--------------------------------------------------------------------------*/
/* Ajoute une zone  la partie d'cran  rafrachir                         */
/****************************************************************************/

void TApplication::m_add_zone_to_refresh(int x1,int y1,int x2,int y2,int window_height)
{
  if (f_need_refresh)
    {
      f_zone_to_refresh.x1=MIN(f_zone_to_refresh.x1,x1);
      f_zone_to_refresh.y1=MIN(f_zone_to_refresh.y1,y1);
      f_zone_to_refresh.x2=MAX(f_zone_to_refresh.x2,x2);
      f_zone_to_refresh.y2=MAX(f_zone_to_refresh.y2,y2);
      f_upper_changed_window_height=MAX(f_upper_changed_window_height,window_height);
    }
  else
    {
      f_need_refresh=true;
      f_zone_to_refresh.x1=x1;
      f_zone_to_refresh.y1=y1;
      f_zone_to_refresh.x2=x2;
      f_zone_to_refresh.y2=y2;
      f_upper_changed_window_height=window_height;
    }
}

/****************************************************************************/
/* m_number_to_window                                                       */
/*--------------------------------------------------------------------------*/
/* Retourne une fentre  partir de son numro                              */
/****************************************************************************/

PWindow TApplication::m_number_to_window(int window_number)
{
  return(m_number_to_window_node(window_number)->window);
}

/****************************************************************************/
/* m_number_to_window_node                                                  */
/*--------------------------------------------------------------------------*/
/* Retourne un pointeur sur l'lment de la liste des fentres de numro    */
/* indiqu 								    */
/****************************************************************************/

PWindowNode TApplication::m_number_to_window_node(int window_number)
{
  register PWindowNode node;

  node=f_window_list;

  JPDEBUG_TEST(DEBUG_ERROR_26,node!=NULL);

  while ((node->window->f_window_number)!=window_number)
    node=node->next;

  return(node);
}

/****************************************************************************/
/* m_height_to_window_nb                                                    */
/*--------------------------------------------------------------------------*/
/* Retourne le numro de la fentre affiche  la hauteur indique          */
/****************************************************************************/

int TApplication::m_height_to_window_nb(int window_height)
{
  POpenWindowNode node;
  register int i;

  JPDEBUG_TEST(DEBUG_ERROR_27,(window_height>=1) && (window_height<=f_nb_open_windows));

  node=f_open_window_list;
  for (i=1;i<window_height;i++)
    node=node->next;

  return(node->window_number);
}

/****************************************************************************/
/* m_window_nb_to_height                                                    */
/*--------------------------------------------------------------------------*/
/* Retourne le numro de la fentre affiche  la hauteur indique          */
/****************************************************************************/

int TApplication::m_window_nb_to_height(int window_nb)
{
  bool done=false;

  int window_height=1;
  POpenWindowNode node=f_open_window_list;

  while (!done)
    {
      if (node==NULL)
	done=true;
      else
	{
	  if ((node->window_number)==window_nb)
	    done=true;
	  else
	    {
	      window_height++;
	      node=node->next;
	    }
	}
    }

  return(window_height);
}

/****************************************************************************/
/* m_set_active_window      						    */
/*--------------------------------------------------------------------------*/
/* Rend la fentre indique active (si possible)    			    */
/****************************************************************************/

bool TApplication::m_set_active_window(int window_number, bool even_if_current_modal)
{
  bool         owner;
  PWindow         new_active_window;
  POpenWindowNode node,
		  node_before,
		  node_after;

  // Fentre  activer dj active

  if (f_active_window!=NULL)
    {
      if (f_active_window->f_window_number==window_number)
	return false;
    }

  // Fentre  activer ferme

  new_active_window=m_number_to_window(window_number);
  if (!new_active_window->f_open)
    return false;

  // Recherche de la fenetre a rendre active

  node=f_last_open_window;
  while ((node->window_number)!=window_number)
    node=node->last;
  owner = node->owner != NULL;

  // Fentre active modale

  if (f_active_window!=NULL)
    {
      if ((f_active_window->f_modal) && (!owner) && (!even_if_current_modal))
	return false;
    }

  // Sinon, la fentre active devient inactive (sauf si la nouvelle a
  // un proprietaire */

  if ((f_active_window!=NULL) && (!owner))
    {
      f_active_window->m_set_active(false);
      f_active_window->m_display();
    }

  // La nouvelle fentre active prend le focus...

  if (!new_active_window->m_has_focus())
    new_active_window->m_set_focus();

  if (!owner)
    f_active_window=new_active_window;

  new_active_window->m_set_active(true);
  new_active_window->m_display();

  // et passe au-dessus

  if (f_last_open_window->window_number!=window_number)
  {
    node_before=node->last;
    node_after=node->next;

    f_last_open_window->next=node;
    node->next=NULL;
    node->last=f_last_open_window;
    f_last_open_window=node;

    DEBUG_TEST(node_after!=NULL);

    if (node_before!=NULL)
      node_before->next=node_after;
    else
      f_open_window_list=node_after;

    node_after->last=node_before;
  }
  return true;
}

/*********************************************************************/
/* m_left_button_pressed_event : L'utilisateur a cliqu dans l'objet */
/* ---------------------------   avec le bouton gauche               */
/*                               (l'objet tant activable).          */
/*                               Retourne true si l'objet est        */
/*                               intress par cet vnement.        */
/*********************************************************************/

bool TApplication::m_left_button_pressed_event(int x,int y)
{
  POpenWindowNode node;
  PObject owner;

  PWindow         window;

  int 		  x1,y1,x2,y2;

  // Si la fentre du haut a un propritaire, on lui passe l'vnement

  if (f_nb_open_windows!=0)
    {
      owner=f_last_open_window->owner;
      if (owner!=NULL)
	{
	  DEBUG_TEST(owner->m_is_enabled());
	  return(owner->m_left_button_pressed_event(x,y));
	}
    }

  // Sinon...

  node=f_last_open_window;

  while (node!=NULL)
    {
      window=m_number_to_window(node->window_number);
      x1=window->f_x;
      x2=x1+window->f_width-1;
      y1=window->f_y;
      y2=y1+window->f_height-1;

      if (   (x>=x1) && (x<=x2)
	  && (y>=y1) && (y<=y2))
	{
	  if (node->next==NULL)   // Fentre du haut
	    {
	      DEBUG_TEST(window->m_has_focus());
	      return(window->m_left_button_pressed_event(x,y));
	    }
	  else
	    {
	      // Clic dans une fentre non active (pas celle du haut)
	      // Elle devient la fentre active (si possible)

	      if (m_set_active_window(window->f_window_number))
		{
		  JPRefresh();
		  window->m_left_button_pressed_event(x,y);
		}
	      return true;
	    }
	}

      node=node->last;
    }
  return false;
}

/**************************************************************************/
/* m_left_button_double_click_event : L'utilisateur a double-cliqu dans  */
/* --------------------------------   l'objet avec le bouton gauche       */
/*                                    (l'objet tant activable et         */
/*                                    ayant dj subi l'vnement         */
/*                                    m_left_button_pressed_event)        */
/*                                    Retourne true si l'objet est        */
/*                                    intress par cet vnement.        */
/**************************************************************************/

bool TApplication::m_left_button_double_click_event(int x,int y)
{
  PWindow window;
  PObject owner;
  int x1,y1,x2,y2;

  // Si la fentre du haut a un propritaire, on lui passe l'vnement

  if (f_nb_open_windows!=0)
    {
      owner=f_last_open_window->owner;
      if (owner!=NULL)
	{
	  DEBUG_TEST(owner->m_is_enabled());
	  return(owner->m_left_button_double_click_event(x,y));
	}
    }

  // Sinon...

  if (f_last_open_window!=NULL)
    {
      window=m_number_to_window(f_last_open_window->window_number);

      DEBUG_TEST(window->m_has_focus());

      x1=window->f_x;
      x2=x1+window->f_width-1;
      y1=window->f_y;
      y2=y1+window->f_height-1;

      if (   (x>=x1) && (x<=x2)
	  && (y>=y1) && (y<=y2))
	return(window->m_left_button_double_click_event(x,y));
    }

  return false;
}

/************************************************************************/
/* m_key_pressed_event : L'utilisateur a appuy sur une touche          */
/* -------------------   qui est propose  l'objet (qui est activable).*/
/*                       Retourne true si l'objet est                   */
/*                       intress par cette touche.                    */
/************************************************************************/

bool TApplication::m_key_pressed_event(TKey key)
{
  PWindow window;
  PObject owner;

  // Si la fentre du haut a un propritaire, on lui passe l'vnement

  if (f_nb_open_windows!=0)
    {
      owner=f_last_open_window->owner;
      if (owner!=NULL)
	{
	  DEBUG_TEST(owner->m_is_enabled());
	  return(owner->m_key_pressed_event(key));
	}
    }

  // Sinon...

  if (f_last_open_window!=NULL)
    {
      window=m_number_to_window(f_last_open_window->window_number);

      DEBUG_TEST(window->m_has_focus());

      if (window->m_key_pressed_event(key))
	return true;
    }

  // Touche de changement de fentre active (ALT-F6)

  if (f_nb_open_windows>1)
    {
      if (key.character==ALT_F6)
	{
	  m_make_next_window_active();
	  return true;
	}
    }


  return false;
}

TApplication::KeyCallback*	TApplication::keyCallback() const
{
	return keyCallback_;
}

void	TApplication::setKeyCallback(KeyCallback* keyCallback)
{
	keyCallback_ = keyCallback;
}
