/****************************************************************************/
/* TLIST                                                                    */
/*--------------------------------------------------------------------------*/
/* Objet TList (objet gnrique pour les objets reposant sur une liste de   */
/*              chanes)                                                    */
/****************************************************************************/

#ifndef _TLIST_H_
#define _TLIST_H_

#include "Const.h"
#include "TObject.h"

/*ͻ*/
/*                               CONSTANTES                               */
/*ͼ*/

// Vitesse de dfilement dans la liste

#define LIST_FIRST_SCROLL_SPEED   150
#define LIST_SCROLL_SPEED         70

// Sparateur

#define SEPARATOR           ""

/*ͻ*/
/*                                 TYPES                                  */
/*ͼ*/

// Objet pour les informations complmentaires sur les lments de la liste

class TListItemProperties
{
  public:

	     TListItemProperties();
    virtual ~TListItemProperties();
};

typedef TListItemProperties    *PListItemProperties;

// Type Liste double-chane d'lments de la liste

typedef struct item_node
{
  char               *label;
  int      	      attribute;
  char                hot_key;

  PListItemProperties properties;  // Peut tre NULL

  struct item_node *next,*last;
} TItemNode,*PItemNode;

// Un lment de la liste :
// -> string : chane de caractres ou SEPARATOR pour un sparateur
// -> item_attribute : attribut de l'lment
//    (LI_CHECKED|LI_DISABLED...)
// -> la hot key de l'lment
// -> le shortcut de l'lment
// -> un message d'aide qui s'affiche dans la barre d'information
//    de la fentre quand l'lment est slectionn

/*ͻ*/
/*                         DEFINITION DE L'OBJET                          */
/*ͼ*/


class TList : public TObject, public jptui::Callback
{
  /*-----------------*/
  /* Champs protgs */
  /*-----------------*/

  protected:

    // Liste double-chane des chanes et son nombre d'lments

    PItemNode
	    f_item_list;
    int     f_nb_items;

    // Les lments de la liste sont tris par ordre alphabtique ou non

    bool f_sorted;

    // Attributs autoriss pour les lments de la liste

    int     f_allowed_item_attribute;

    // Si possible, il y a toujours un lment de slectionn

    bool f_always_one_item_selected;

    // Les hot-keys des lments de la liste sont actives

    bool f_item_hot_key_enabled;


    // Elments spciaux de la liste

    PItemNode
	    f_first_visible_item;       // Premier lment visible
    int     f_first_visible_item_index; // Son index (0 si aucun)

    PItemNode
	    f_last_item;                // Dernier lment de la liste
					// Son index vaut f_nb_strings

    int     f_selected_item_index;      // Elment de la liste slectionne
					// Son index (0 si aucun)

    PItemNode
            f_current_item;             // Un lment de la liste qui vient
    int     f_current_item_index;       // d'tre consult et son index
					// (sert pour acclerer la lecture
    // Position et hauteur de la liste (sans les bordures)

    int     f_list_rel_x,
	    f_list_rel_y;
    int     f_list_width,
	    f_list_height;

    // Ascenseur

    PScrollBar
	    f_scrollbar;

    // Chaine vide (affiche en cas d'absence d'lments)

    char     *f_empty_line;

    // Ligne sparatrice

    char     *f_separator_line;

  /*---------------*/
  /* Champs privs */
  /*---------------*/

    // Elment retourn par m_get_item

    char     *f_return_item;

  /*--------------------*/
  /* Mthodes publiques */
  /*--------------------*/

  public:

    // Constructeur / Destructeur

		    TList(PObject parent,
			  int type,
			  int rel_x,int rel_y,
			  int width,int height,
			  unsigned background,
			  const char *caption,
			  int  list_rel_x,int list_rel_y,
			  int  list_width,
			  int  list_height,
			  bool sorted,
			  int     allowed_item_attribute,
			  bool always_one_item_selected,
			  bool item_hot_key_enabled,
			  bool scrollbar,
			  int     scrollbar_x,
			  int     scrollbar_y,
			  int     scrollbar_height,
			  bool enabled);

    virtual         ~TList();

    // Mthodes d'accs

	    int     m_get_nb_items() { return (f_nb_items); };

	    char    *m_get_item(int  index);       // "" si index inexistant
	    int     m_get_item_index(const char *label); // 0 si inexistant

	    bool m_set_selected_item_index(int  index);
	    void    m_select_first_possible_item();
	    int     m_get_selected_item_index() { return (f_selected_item_index);};

	    void    m_set_first_visible_item_index(int  index);
	    int     m_get_first_visible_item_index() { return (f_first_visible_item_index);};

	    void    m_set_middle_visible_item_index(int  index);

	    void    m_set_last_visible_item_index(int  index);
	    int     m_get_last_visible_item_index();

	    int     m_get_list_height() {return(f_list_height);};
	    int     m_get_list_width()  {return(f_list_width);};
	    int     m_get_x_list()      {return(m_get_x()+f_list_rel_x);};
	    int     m_get_y_list()      {return(m_get_y()+f_list_rel_y);};

    // Callback : Fonction appele si l'lment slectionn change
    //            et son argument
	jptui::CallbackHolder	selectedItemChangedAction_;

    // Callback : Fonction appele si la partie visible de la liste
    //            change et son argument
	jptui::CallbackHolder	visiblePartChangedAction_;

    // Callback : Fonction appele si le nombre d'lments dans la liste
    //            change et son argument
	jptui::CallbackHolder	nbItemsChangedAction_;

    // Callback : Fonction appele si on coche un lment
    //            et son argument
	jptui::CallbackHolder	itemCheckChangedAction_;

    // Callback : Fonction appele si on a double-cliqu dans
    //            un lment de la liste et son argument
	jptui::CallbackHolder	itemDblClickAction_;

	    // Suppression d'lments de la liste

    virtual void    m_delete_item(int item_index);
    virtual void    m_clear_list();

    // Modification de l'attribut d'un item
    // (on peut fournir des combinaisons : LI_CHECKED|LI_DISABLED)

	    void    m_set_item_attribute(int item_index,int item_attribute);
	    void    m_unset_item_attribute(int item_index,int item_attribute);
	    bool m_item_attribute_is_set(int item_index,int item_attribute);

	    void    m_check_item(int item_index)      {m_set_item_attribute(item_index,LI_CHECKED);};
	    void    m_uncheck_item(int item_index)    {m_unset_item_attribute(item_index,LI_CHECKED);};
	    bool m_item_is_checked(int  item_index){return(m_item_attribute_is_set(item_index,LI_CHECKED));};

	    void    m_enable_item(int item_index)    {m_unset_item_attribute(item_index,LI_DISABLED);};
	    void    m_disable_item(int item_index)   {m_set_item_attribute(item_index,LI_DISABLED);};
	bool	m_item_is_enabled(int item_index) {
		return !m_item_attribute_is_set(item_index, LI_DISABLED);
	};

  /*--------------------*/
  /* Mthodes protges */
  /*--------------------*/

  protected:

    // Ajout d'lment  la liste
    // (retourne son index ou 0 s'il n'y a plus de place)

    virtual int     m_add_item_to_list(int index, const char *label, int attribute,PListItemProperties properties);

    // Affichage

    virtual void    m_display();
    virtual void    m_display_focus_depending_part();
    virtual void    m_display_list();
    virtual void    m_display_items(int first_index,int last_index);
    virtual void    m_display_item(int  item_index);

    // Modification de la taille de la liste

	    void    m_set_list_size(int list_width,int list_height);

	    int     m_get_list_needed_width();

    // Callbacks

    virtual void    m_selected_item_changed_callback();
    virtual void    m_visible_part_changed_callback();
    virtual void    m_nb_items_changed_callback();
    virtual void    m_item_dbl_clicked_callback(int index);

	void	operator()(TObject* who, what_type what, item_type item);

    virtual void    m_mouse_went_to_list_callback();

    // Evnements

    virtual bool m_left_button_pressed_event(int x,int y);
    virtual bool m_left_button_double_click_event(int x,int y);
    virtual bool m_key_pressed_event(TKey key);

    // Obtention d'un lment d'aprs son index

	    PItemNode
		    m_index_to_item(int index);


  /*------------------*/
  /* Mthodes prives */
  /*------------------*/

  private:

  // Affichage

    virtual void    m_display_item_node(PItemNode node,int index);
    virtual void    m_display_item_node_label(PItemNode node,bool show_hot_key);

	    void    m_change_item_attribute(PItemNode item_node,int item_index,int new_attribute);

  // Evnements

    virtual bool m_leave_event_if_mouse_leave_list(int x,int y);
    virtual void    m_item_hot_key_pressed_event(int item_index);


};


#endif
