/****************************************************************************/
/* SCREEN                                                                   */
/*--------------------------------------------------------------------------*/
/* Microsoft Windows-related functions                                      */
/*--------------------------------------------------------------------------*/
/* Author      : DELPRAT Jean-Pierre                                        */
/* Crated on   : 01/27/97                                                   */
/****************************************************************************/

#include "Compat.h"

#include "Mouse.h"
#include "Screen.h"

#include "Windows.h"


/*ͻ*/
/*                                 CONSTANTS                              */
/*ͼ*/

#define INT_MULTIPLEXER 0x2F

/*ͻ*/
/*                                 FONCTIONS                              */
/*ͼ*/

/****************************************************************************/
/* RunningUnderWindows                                            	    */
/*--------------------------------------------------------------------------*/
/* Is the program running under Windows ?				    */
/****************************************************************************/

bool RunningUnderWindows()
{
  // Fix: to determine Windows NT and Windows 2000
  __dpmi_regs regs;

  regs.x.ax = 0x160A; // MS Windows 3.1 - IDENTIFY WINDOWS VERSION AND TYPE
  __dpmi_int(0x2f, &regs);
  if (regs.x.ax==0) return true; // successfull call

  regs.x.ax = 0x3306; // DOS 5+ - GET true VERSION NUMBER
  __dpmi_int(0x21, &regs);
  unsigned char major = regs.h.bl;
  unsigned char minor = regs.h.bh;
  // OS/2 v2.1 will return BX=0A14h (version 20.10)
  // the Windows NT DOS box returns BX=3205h (version 5.50)
  // Windows95 and Windows95 SP1 return version 7.00; Windows95 OSR2 returns
  // version 7.10
  if (major==20 && minor==10) return true;  // OS/2
  if (major==5 && minor==50) return true;  // Windows NT DOS box (Windows 2000)
  // Do not test 7.00/7.10 - 0x160A works
  return false;
}

/****************************************************************************/
/* SetDosBoxMode                                                            */
/*--------------------------------------------------------------------------*/
/* Configures JPTUI to be ran in a DOS box under Windows                    */
/****************************************************************************/

void SetDosBoxMode()
{
  SetMousePointerAspect(MPA_MOUSE_DRIVER);
  SetFont(FONT_STANDARD);
}

/****************************************************************************/
/* SetFullScreenMode							    */
/*--------------------------------------------------------------------------*/
/* Configures JPTUI to be ran in full screen mode (under Windows or not)    */
/* If the application is running in a window, it is forced to full screen   */
/****************************************************************************/

void SetFullScreenMode()
{
  __dpmi_regs regs;

  // Passe en plein ecran

  if (RunningUnderWindows())
    {

      regs.x.ax = 0x168B;
      regs.x.bx = 0;
      __dpmi_int(INT_MULTIPLEXER, &regs);
    }


  // Configure JPTUI

  SetMousePointerAspect(MPA_GRAPHICAL);
  SetFont(FONT_JPTUI);
}
