// Copyright (C) 1996 Keith Whitwell.
// This file may only be copied under the terms of the GNU Library General
// Public License - see the file COPYING in the lib3d distribution.

#ifndef NewViewportClass
#define NewViewportClass

#include <Lib3d/Viewport.H>


struct edge_major_texture;
struct edge_major_flat;
struct edge_major_smooth;
struct edge_minor;
struct edge_minor_step;


class VpNew : public Viewport
{
public:
    void textureTriangleZb( TexturePipelineData *const[], const Texture & );
    void texturePolygonZb(uint, TexturePipelineData *const[], const Texture & );

    void flatPolygonZb(uint, PipelineData *const[], Colour );
    void flatTriangleZb(PipelineData *const[], Colour );

    void smoothPolygonZb(uint, SmoothPipelineData *const[], const ColourRamp& );
    void smoothTriangleZb(SmoothPipelineData *const[], const ColourRamp& );

    void setDirty( int xmin, int ymin, int xmax, int ymax );

protected:
    virtual void doTextureTriangleZb( edge_major_texture&, 
				      edge_minor_step&,
				      edge_minor_step&,
				      const Texture & ) = 0;

    virtual void doFlatTriangleZb( edge_major_flat&, 
				   edge_minor&,
				   edge_minor&,
				   Colour ) = 0;

    virtual void doSmoothTriangleZb( edge_major_smooth&, 
				     edge_minor_step&,
				     edge_minor_step&,
				     const ColourRamp & ) = 0;


protected:
    VpNew( Exemplar e, uint i ) : Viewport( e, i ) {}
    VpNew( Device * );
    ~VpNew();
};

//
//

#define LOG_UNITY 6
#define UNITY (1<<LOG_UNITY)
#define _UNITY (1.0/UNITY)

#define LOG_UNITY16 16
#define UNITY16 (1<<LOG_UNITY16)
#define _UNITY16 (1.0/UNITY16)

struct edge_major_texture {
    edge_major_texture(TexturePipelineData * const vertex[], 
		       int Top,
		       int Bottom );

    void invert();

    int area;
    int x, xStep;
    int yMin;
    int error, numerator, denominator;

    float dw_dx;            
    float duw_dx;           
    float dvw_dx;           
    int  dz_dx;    
        
    float w, wStep, wStepExtra;         
    float uw, uwStep, uwStepExtra;      
    float vw, vwStep, vwStepExtra;      
    uint z;
    int zStep, zStepExtra;
    int incr;
};

struct edge_major_flat {
    edge_major_flat(PipelineData *const[], int top, int mid, int bottom);

    void invert();

    int area;
    int x, xStep;		
    int   yMin;
    uint  z;
    int dz_dx;	
    int zStep;
    int incr;
};


struct edge_major_smooth {
    edge_major_smooth(SmoothPipelineData *const[], int, int, int);

    void invert();

    int area;
    int x, xStep;		
    int error, numerator, denominator;
    int   yMin;
    uint  z;
    int   dz_dx;	
    int   zStep;
    int   zStepExtra;
    int   i;
    int   di_dx;	

    int   iStep;
    int   iStepExtra;
    int incr;
};

struct edge_minor {
    edge_minor(const PipelineData &top,
               const PipelineData &bottom );

    void invert();

    int x, xStep;      
    int height;     
};


struct edge_minor_step {
    edge_minor_step(const PipelineData &top,
		    const PipelineData &bottom );

    void invert();

    int x, xStep;
    int height;
    int error, numerator, denominator;
};

#endif








