// Copyright (C) 1996 Keith Whitwell.
// This file may only be copied under the terms of the GNU Library General
// Public License - see the file COPYING in the lib3d distribution.

#include <Lib3d/Devices/XDevice.H>
#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <minmax.h>

class XImageDevice : public XDevice
{
public:
    XImageDevice( Exemplar );
    XImageDevice( uint width, uint height, uint depth );
    XImageDevice( Display *, Window );
    ~XImageDevice();
    
    const char *getName() const { return "XImageDevice"; } 
    void swapBuffers();

protected:
    int  estimateSpeed() const { return 5; }
    Device *clone( uint width, uint height, uint depth );
    XDevice *clone( Display *, Window );

    void createImage();

private:
    XImage *xImage;
};

XImageDevice::XImageDevice( uint width, uint height, uint depth )
    : XDevice( width, height, depth )
{
    if (isBad()) return;
    createImage();
}

XImageDevice::XImageDevice( Display *display, Window window )
    : XDevice( display, window )
{
    if (isBad()) return;
    createImage();
}
    
void
XImageDevice::createImage()
{
    if (   (frameBuf = (uchar *) malloc( width * height )) == 0
	|| (xImage = XCreateImage(display, 
				  DefaultVisual(display,screenNr), 
				  depth,
				  ZPixmap, 
				  0, 
				  (char *)frameBuf, 
				  width, height,
				  8,	
				  0)) == 0) {
	debug() << "Failed to create XImageDevice" << endlog;
	setBad();
    }
}

XImageDevice::XImageDevice( Exemplar e )
    : XDevice( e )
{
    Device::registerChildClass( this );
    XDevice::registerChildClass( this );
}

XImageDevice::~XImageDevice()
{
    if (isActive()) {
	if (xImage != 0) XDestroyImage( xImage );
    }
}

Device *
XImageDevice::clone( uint width, uint height, uint depth )
{
    return new XImageDevice( width, height, depth );
}

XDevice *
XImageDevice::clone( Display *display, Window window )
{
    return new XImageDevice( display, window );
}

void
XImageDevice::swapBuffers()
{
    uint xn = min(xmin, oldxmin);
    uint xx = max(xmax, oldxmax);
    uint yn = min(ymin, oldymin);
    uint yx = max(ymax, oldymax);

    if (xn < xx && yn < yx) {
	XPutImage(display, window, gc, xImage, xn, yn, xn, yn, xx-xn, yx-yn);
    }
    XSync(display, 0);
}

static XImageDevice advertisement( Device::exemplar );









