 
/*
 * Copyright (C) Yves Arrouye <Yves.Arrouye@marin.fdn.fr>, 1996.
 *
 * Use under the GPL version 2. You are not allowed to remove this
 * copyright notice.
 *
 */

#include <ctype.h>
#include <string.h>
#include <stdlib.h>

#include "dimen.h"

static struct {
    const char* name;
    float factor;
} units[] = {
    { "in",	1. },
    { "ft",	12. },
    { "pt",	1. / 72. },
    { "m", 	100. / 2.54 },
    { "dm",	10. / 2.54 },
    { "cm", 	1. / 2.54 },
    { "mm",	.1 / 2.54 },
    { 0 }
};

#if !defined(__STDC__)
float unitfactor(unit)
    char* unit;
#else
float unitfactor(const char* unit)
#endif
{
    int i;

    for (i = 0; units[i].name; ++i) {
	if (!strcasecmp(units[i].name, unit)) {
	    return units[i].factor;
	}
    }

    return 0;
}

#if !defined(__STDC__)
int psdimension(what, dim)
    char* what;
    int* dim;
#else
int psdimension(const char* what, int* dim)
#endif
{
    const char* unit;
    int dot = 0;

    if (!what || !*what) return -1;

    if (*(unit = what) == '-') ++unit;

    for (; isdigit(*unit) || (*unit == '.' && !dot++); ++unit);

    if (*unit && !isalpha(*unit)) {
	return -1;
    } else {
	double base = atof(what);
	double factor = unitfactor(unit);

	if (factor) {
	    *dim = base * factor * 72;
	    return 0;
	}

	return 1;
    }
}

