/*
 * Copyright (C) 1996, jack
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

/* $Id: mbprvt.h,v 1.6 1996/10/25 14:04:00 jack Exp $ */

#ifndef __mbprvt_h__
#define __mbprvt_h__

/* include for wchar_t */
#include <stddef.h>

/* follows private definition */
#ifdef __cplusplus
extern "C" {
#endif

#define _MBC_DIGIT_BEGIN (0x824fU)
#define _MBC_DIGIT_END (0x8258U)
#define _MBC_LOWER_BEGIN (0x8281U)
#define _MBC_LOWER_END (0x829aU)
#define _MBC_UPPER_BEGIN (0x8260U)
#define _MBC_UPPER_END (0x8279U)
#define _MBC_ALPHA_DIFF (_MBC_LOWER_BEGIN - _MBC_UPPER_BEGIN)

#define _MBC_HIRA_BEGIN (0x829fU)
#define _MBC_HIRA_END (0x82f1U)
#define _MBC_KATA_BEGIN (0x8340U)
#define _MBC_KATA_END (0x8396U)
#define _MBC_KATA_EXCEPT (0x837fU)
#define _MBC_KANA_DIFF (_MBC_KATA_BEGIN - _MBC_HIRA_BEGIN)
#define _MBC_HIRA_BOUND (_MBC_KATA_EXCEPT - _MBC_KATA_BEGIN + _MBC_HIRA_BEGIN)

#define _MBC_LEVEL0_BEGIN (0x8140U)
#define _MBC_LEVEL0_END (0x889eU)
#define _MBC_LEVEL1_BEGIN (0x889fU)
#define _MBC_LEVEL1_END (0x9872U)
#define _MBC_LEVEL2_BEGIN (0x989fU)
#define _MBC_LEVEL2_END (0xeaa4U)

#define _MBC_SPACE (0x8140U)
#define _MBC_PUNCT_BEGIN (0x8141U)
#define _MBC_PUNCT_END (0x81acU)
#define _MBC_PUNCT_EXCEPT (0x817fU)
#define _MBC_SYMBOL_BEGIN (0x8141U)
#define _MBC_SYMBOL_END (0x81acU)
#define _MBC_SYMBOL_EXCEPT (0x817fU)

#define _MBC_ERROR_CODE ((int) 0xffffffffU)
#define _MBC_ERROR_SJIS (0xffffU)
#define _MBC_ERROR_JIS (0xffffU)
#define _MBC_ERROR_UNICODE (0xffffU)
#define _MBC_ERROR_WCHAR ((wchar_t) 0xffffffffU)
#define _MBC_REPLACE_SINGLE (0x20) /* SPACE */
#define _MBC_REPLACE_SJIS (0x81a6U) /* REFERENCE MARK */
#define _MBC_REPLACE_JIS (0x2228U)
#define _MBC_REPLACE_UNICODE (0x203BU)
#define _MBC_REPLACE_WCHAR ((wchar_t) _MBC_REPLACE_UNICODE)

/* mapping table */
extern unsigned short __jis0201_to_unicode_mapping[];
extern unsigned short __jis0208_to_unicode_mapping[];
extern unsigned short __jis0212_to_unicode_mapping[];
extern unsigned short *__sjis_to_unicode_mapping;
extern unsigned short *__unicode_to_sjis_mapping;

/* mbctype table */
extern unsigned char __c_mbctype[];
extern unsigned char __sjis_mbctype[];

/* MB_CUR_MAX */
extern const int __mb_cur_max_ja_jp_sjis;

/* functions */
extern void __mbinit (int category, const char *locale);
extern void __mbmake_sjis_mapping_table (void);

extern wchar_t (*__string_single_to_wchar) (const char *s);
extern wchar_t (*__string_double_to_wchar) (const char *s);
extern int (*__wchar_to_mbc) (wchar_t wc);
extern wchar_t __string_single_to_wchar_c (const char *s);
extern wchar_t __string_double_to_wchar_c (const char *s);
extern int __wchar_to_mbc_c (wchar_t wc);
extern wchar_t __string_single_to_wchar_ja_jp_sjis (const char *s);
extern wchar_t __string_double_to_wchar_ja_jp_sjis (const char *s);
extern int __wchar_to_mbc_ja_jp_sjis (wchar_t wc);

extern unsigned short __sjis_to_unicode (unsigned short sjis);
extern unsigned short __string_sjis_single_to_unicode (const char *s);
extern unsigned short __string_sjis_double_to_unicode (const char *s);
extern unsigned short __string_sjis_to_unicode (const char *s);
extern unsigned short __unicode_to_sjis (unsigned short unicode);
extern unsigned short __string_unicode_to_sjis (unsigned short *usp);

/* inline functions */
extern inline unsigned short
__string_sjis_single_to_unicode (const char *s)
{
  const unsigned char *us = (const unsigned char *) s;
  unsigned short sjis;

  /* get sjis value */
  sjis = (unsigned short) us[0];

  /* check mapping table */
  if (__sjis_to_unicode_mapping == NULL)
    __mbmake_sjis_mapping_table ();

  /* convert to UNICODE */
  return __sjis_to_unicode_mapping[sjis];
}

extern inline unsigned short
__string_sjis_double_to_unicode (const char *s)
{
  const unsigned char *us = (const unsigned char *) s;
  unsigned short sjis;

  /* get sjis value */
  sjis = (unsigned short) ((us[0] << 8) + us[1]);

  /* check mapping table */
  if (__sjis_to_unicode_mapping == NULL)
    __mbmake_sjis_mapping_table ();

  /* convert to UNICODE */
  return __sjis_to_unicode_mapping[sjis];
}

extern inline unsigned short
__unicode_to_sjis (unsigned short unicode)
{
  /* check array size */
  if (unicode > 0xffff)
    return _MBC_ERROR_SJIS;

  /* check mapping table */
  if (__unicode_to_sjis_mapping == NULL)
    __mbmake_sjis_mapping_table ();

  /* convert to sjis */
  return __unicode_to_sjis_mapping[unicode];
}

#ifdef __cplusplus
}
#endif

#endif /* !__mbprvt_h__ */
